/*
 *  Graphical Turing Machine
 *
 *  Copyright (C) 2008 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef __GRAPHICALTM_H__
#define __GRAPHICALTM_H__

#include "SDL.h"
#include "SDL_ttf.h"

#include "tm.h"
#include "graphicalstateset.h"
#include "graphicalstate.h"

class GraphicalTM : public TM
{
  private:
  public:
    GraphicalTM(string tm_file, int tape_count);
    ~GraphicalTM();
    void loadTM(string filename);
    void loadInput(string filename);
    void loadInput(vector<string> filenames);
    void print();
    bool cycle();
    GraphicalState* getStateAtPos(int x, int y);
    bool isInFinalState() { return m_final_state_set[m_current_state->getName()] != NULL; }
    void draw(SDL_Surface* dest, TTF_Font* font);
};

#endif
