/*
 *  Graphical Turing Machine
 *
 *  Copyright (C) 2008 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef __GRAPHICALSTATE_H__
#define __GRAPHICALSTATE_H__

#include <cmath>
#include <cstdio>

#include "SDL.h"
#include "SDL_ttf.h"

#include "state.h"

class GraphicalState : public State
{
  protected:
    int m_x;
    int m_y;
    int m_size;
    SDL_Surface* m_image;
    SDL_Surface* m_image_lit;
  public:
    GraphicalState(string state_name);
    ~GraphicalState();
    string getName() { return m_name; }
    void draw(SDL_Surface* dest, TTF_Font* font);
    void drawLit(SDL_Surface* dest, TTF_Font* font);
    int getX() { return m_x; }
    int getY() { return m_y; }
    int getSize() { return m_size; }
    void moveTo(int x, int y);
};

#endif
