/*
 *  Graphical Turing Machine
 *
 *  Copyright (C) 2008 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "graphicalstate.h"

GraphicalState::GraphicalState(string state_name) : State(state_name)
{
  m_x = (int)(40.0 + ((double)rand() / (1.0 + RAND_MAX)) * 450);
  m_y = (int)(80.0 + ((double)rand() / (1.0 + RAND_MAX)) * 390);
  m_size = 20;
  m_image = SDL_CreateRGBSurface(SDL_HWSURFACE | SDL_SRCCOLORKEY,m_size,m_size,32,0,0,0,0);
  SDL_SetColorKey(m_image,SDL_SRCCOLORKEY,0x00FF00FF);
  SDL_FillRect(m_image, NULL, SDL_MapRGB(m_image->format, 255, 0, 255));
  for(int i = 0; i < m_size; i++)
  {
    double sin = (double)(m_size - i * 2) / (double)m_size;
    double cos = (double)sqrt(1.0 - sin * sin);
    for(int j = (int)(m_size / 2 - (m_size / 2) * cos); j < (int)(m_size / 2 - (m_size / 2) * cos) + (int)(m_size * cos); j++)
    {
      SDL_Rect rect = {j,i,1,1};
      double y = (double)(m_size / 2 - i) / (double)(m_size / 2);
      double x = (double)(j - m_size / 2 + 1) / (double)(m_size / 2);
      int intensity = (int)(255 * (y * y + x * x));
      if(intensity > 255) intensity = 255;
      intensity = 255 - intensity;
      intensity /= 2;
      SDL_FillRect(m_image, &rect, SDL_MapRGB(m_image->format, intensity, intensity, intensity));
    }
  }

  m_image_lit = SDL_CreateRGBSurface(SDL_HWSURFACE | SDL_SRCCOLORKEY,m_size,m_size,32,0,0,0,0);
  SDL_SetColorKey(m_image_lit,SDL_SRCCOLORKEY,0x00FF00FF);
  SDL_FillRect(m_image_lit, NULL, SDL_MapRGB(m_image->format, 255, 0, 255));
  for(int i = 0; i < m_size; i++)
  {
    double sin = (double)(m_size - i * 2) / (double)m_size;
    double cos = (double)sqrt(1.0 - sin * sin);
    for(int j = (int)(m_size / 2 - (m_size / 2) * cos); j < (int)(m_size / 2 - (m_size / 2) * cos) + (int)(m_size * cos); j++)
    {
      SDL_Rect rect = {j,i,1,1};
      double y = (double)(m_size / 2 - i) / (double)(m_size / 2);
      double x = (double)(j - m_size / 2 + 1) / (double)(m_size / 2);
      int intensity = (int)(255 * (y * y + x * x));
      if(intensity > 255) intensity = 255;
      intensity = 255 - intensity;
      SDL_FillRect(m_image_lit, &rect, SDL_MapRGB(m_image->format, intensity / 2, intensity, intensity / 2));
    }
  }
}

GraphicalState::~GraphicalState()
{
}

void GraphicalState::moveTo(int x, int y)
{
  m_x = x;
  m_y = y;
}

void GraphicalState::draw(SDL_Surface* dest, TTF_Font* font)
{
  SDL_Rect rDest = {m_x - m_size / 2,m_y - m_size / 2,0,0};
  SDL_BlitSurface(m_image, NULL, dest, &rDest);
  SDL_Color color = {0,0,0};
  SDL_Surface* label = TTF_RenderText_Blended(font, m_name.c_str(), color);
  if(label)
  {
    SDL_Rect rect = {m_x-10, m_y-35, 0, 0};
    SDL_BlitSurface(label, NULL, dest, &rect);
    SDL_FreeSurface(label);
  }
}

void GraphicalState::drawLit(SDL_Surface* dest, TTF_Font* font)
{
  SDL_Rect rDest = {m_x - m_size / 2,m_y - m_size / 2,0,0};
  SDL_BlitSurface(m_image_lit, NULL, dest, &rDest);
}

