/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.AbstractList;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternElement;

public class ProductionPatternAlternative {
    private ProductionPattern pattern;
    private ArrayList elements = new ArrayList();
    private LookAheadSet lookAhead = null;

    public boolean isLeftRecursive() {
        for (int i = 0; i < this.elements.size(); ++i) {
            ProductionPatternElement elem = (ProductionPatternElement)this.elements.get(i);
            if (elem.getId() == this.pattern.getId()) {
                return true;
            }
            if (elem.getMinCount() > 0) break;
        }
        return false;
    }

    public boolean isRightRecursive() {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            ProductionPatternElement elem = (ProductionPatternElement)this.elements.get(i);
            if (elem.getId() == this.pattern.getId()) {
                return true;
            }
            if (elem.getMinCount() > 0) break;
        }
        return false;
    }

    public boolean isMatchingEmpty() {
        return this.getMinElementCount() == 0;
    }

    public ProductionPattern getPattern() {
        return this.pattern;
    }

    void setPattern(ProductionPattern pattern) {
        this.pattern = pattern;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public int getMinElementCount() {
        int min = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            ProductionPatternElement elem = (ProductionPatternElement)this.elements.get(i);
            min += elem.getMinCount();
        }
        return min;
    }

    public int getMaxElementCount() {
        int max = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            ProductionPatternElement elem = (ProductionPatternElement)this.elements.get(i);
            if (elem.getMaxCount() >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            max += elem.getMaxCount();
        }
        return max;
    }

    public ProductionPatternElement getElement(int pos) {
        return (ProductionPatternElement)this.elements.get(pos);
    }

    public void addToken(int id, int min, int max) {
        this.addElement(new ProductionPatternElement(true, id, min, max));
    }

    public void addProduction(int id, int min, int max) {
        this.addElement(new ProductionPatternElement(false, id, min, max));
    }

    public void addElement(ProductionPatternElement elem) {
        this.elements.add(elem);
    }

    public void addElement(ProductionPatternElement elem, int min, int max) {
        if (elem.isToken()) {
            this.addToken(elem.getId(), min, max);
        } else {
            this.addProduction(elem.getId(), min, max);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProductionPatternAlternative) {
            ProductionPatternAlternative alt = (ProductionPatternAlternative)obj;
            return ((AbstractList)this.elements).equals(alt.elements);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(this.elements.get(i));
        }
        return buffer.toString();
    }

    LookAheadSet getLookAhead() {
        return this.lookAhead;
    }

    void setLookAhead(LookAheadSet lookAhead) {
        this.lookAhead = lookAhead;
    }
}

