/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaImport;
import net.percederberg.grammatica.code.java.JavaMethod;
import net.percederberg.grammatica.output.JavaConstantsFile;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class JavaAnalyzerFile {
    private static final String TYPE_COMMENT = "A class providing callback methods for the parser.";
    private static final String ENTER_COMMENT = "Called when entering a parse tree node.\n\n@param node           the node being entered\n\n@throws ParseException if the node analysis discovered errors";
    private static final String EXIT_COMMENT = "Called when exiting a parse tree node.\n\n@param node           the node being exited\n\n@return the node to add to the parse tree, or\n        null if no parse tree should be created\n\n@throws ParseException if the node analysis discovered errors";
    private static final String CHILD_COMMENT = "Called when adding a child to a parse tree node.\n\n@param node           the parent node\n@param child          the child node, or null\n\n@throws ParseException if the node analysis discovered errors";
    private JavaParserGenerator gen;
    private JavaFile file;
    private JavaClass cls;
    private JavaMethod enter;
    private JavaMethod exit;
    private JavaMethod child;

    public JavaAnalyzerFile(JavaParserGenerator gen) {
        this.gen = gen;
        this.file = gen.createJavaFile();
        int modifiers = gen.getPublicAccess() ? 8 : 10;
        this.cls = new JavaClass(modifiers, gen.getBaseName() + "Analyzer", "Analyzer");
        this.enter = new JavaMethod(1, "enter", "Node node", "void");
        this.exit = new JavaMethod(1, "exit", "Node node", "Node");
        this.child = new JavaMethod(1, "child", "Production node, Node child", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addClass(this.cls);
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new JavaComment(1, str));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Analyzer"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Node"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ParseException"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Production"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Token"));
        str = TYPE_COMMENT;
        if (this.gen.getClassComment() != null) {
            str = str + "\n\n" + this.gen.getClassComment();
        }
        this.cls.addComment(new JavaComment(str));
        this.enter.addComment(new JavaComment(ENTER_COMMENT));
        this.enter.addThrows("ParseException");
        this.enter.addCode("switch (node.getId()) {");
        this.cls.addMethod(this.enter);
        this.exit.addComment(new JavaComment(EXIT_COMMENT));
        this.exit.addThrows("ParseException");
        this.exit.addCode("switch (node.getId()) {");
        this.cls.addMethod(this.exit);
        this.child.addComment(new JavaComment(CHILD_COMMENT));
        this.child.addThrows("ParseException");
        this.child.addCode("switch (node.getId()) {");
        this.cls.addMethod(this.child);
    }

    public void addToken(TokenPattern pattern, JavaConstantsFile constants) {
        String constant = constants.getConstant(pattern.getId());
        if (!pattern.isIgnore()) {
            String name = this.gen.getCodeStyle().getMixedCase(pattern.getName(), true);
            this.addEnterCase(constant, name, "Token");
            this.addEnterMethod(name, "Token");
            this.addExitCase(constant, name, "Token");
            this.addExitMethod(name, "Token");
        }
    }

    public void addProduction(ProductionPattern pattern, JavaConstantsFile constants) {
        String constant = constants.getConstant(pattern.getId());
        if (!pattern.isSyntetic()) {
            String name = this.gen.getCodeStyle().getMixedCase(pattern.getName(), true);
            this.addEnterCase(constant, name, "Production");
            this.addEnterMethod(name, "Production");
            this.addExitCase(constant, name, "Production");
            this.addExitMethod(name, "Production");
            this.addChildCase(constant, name);
            this.addChildMethod(name);
        }
    }

    private void addEnterCase(String constant, String name, String type) {
        this.enter.addCode("case " + constant + ":");
        this.enter.addCode("    enter" + name + "((" + type + ") node);");
        this.enter.addCode("    break;");
    }

    private void addExitCase(String constant, String name, String type) {
        this.exit.addCode("case " + constant + ":");
        this.exit.addCode("    return exit" + name + "((" + type + ") node);");
    }

    private void addChildCase(String constant, String name) {
        this.child.addCode("case " + constant + ":");
        this.child.addCode("    child" + name + "(node, child);");
        this.child.addCode("    break;");
    }

    private void addEnterMethod(String name, String type) {
        JavaMethod m = new JavaMethod(1, "enter" + name, type + " node", "void");
        m.addComment(new JavaComment(ENTER_COMMENT));
        m.addThrows("ParseException");
        this.cls.addMethod(m);
    }

    private void addExitMethod(String name, String type) {
        JavaMethod m = new JavaMethod(1, "exit" + name, type + " node", "Node");
        m.addComment(new JavaComment(EXIT_COMMENT));
        m.addThrows("ParseException");
        m.addCode("return node;");
        this.cls.addMethod(m);
    }

    private void addChildMethod(String name) {
        JavaMethod m = new JavaMethod(1, "child" + name, "Production node, Node child", "void");
        m.addComment(new JavaComment(CHILD_COMMENT));
        m.addThrows("ParseException");
        m.addCode("node.addChild(child);");
        this.cls.addMethod(m);
    }

    public void writeCode() throws IOException {
        this.enter.addCode("}");
        this.exit.addCode("}");
        this.exit.addCode("return node;");
        this.child.addCode("}");
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

