/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class Grammatica {
    private static final String COMMAND_HELP = "Generates source code for a C# or Java parser from a grammar\nfile. This program comes with ABSOLUTELY NO WARRANTY; for\ndetails see the LICENSE.txt file.\n\nSyntax: Grammatica <grammarfile> <action> [<options>]\n\nActions:\n  --debug\n      Debugs the grammar by validating it and printing the\n      internal representation.\n  --tokenize <file>\n      Debugs the grammar by using it to tokenize the specified\n      file. No code has to be generated for this.\n  --parse <file>\n      Debugs the grammar by using it to parse the specified\n      file. No code has to be generated for this.\n  --profile <file>\n      Profiles the grammar by using it to parse the specified\n      file and printing a statistic summary.\n  --csoutput <dir>\n      Creates a C# parser for the grammar (in source code).\n      The specified directory will be used as output directory\n      for the source code files.\n  --javaoutput <dir>\n      Creates a Java parser for the grammar (in source code).\n      The specified directory will be used as the base output\n      directory for the source code files.\n\nC# Output Options:\n  --csnamespace <package>\n      Sets the C# namespace to use in generated source code\n      files. By default no namespace declaration is included.\n  --csclassname <name>\n      Sets the C# class name prefix to use in generated source\n      code files. By default the grammar file name is used.\n  --cspublic\n      Sets public access for all C# types generated. By default\n      type access is internal.\n\nJava Output Options:\n  --javapackage <package>\n      Sets the Java package to use in generated source code\n      files. By default no package declaration is included.\n  --javaclassname <name>\n      Sets the Java class name prefix to use in generated source\n      code files. By default the grammar file name is used.\n  --javapublic\n      Sets public access for all Java types. By default type\n      access is package local.";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error in Grammatica has been found.\n    Please report this error to the maintainers (see the web\n    site for instructions). Be sure to include the Grammatica\n    version number, as well as the information below:\n";

    public static void main(String[] args) {
        Grammar grammar = null;
        if (args.length == 1 && args[0].equals("--help")) {
            Grammatica.printHelp(null);
            System.exit(1);
        }
        if (args.length < 2) {
            Grammatica.printHelp("Missing grammar file and/or action");
            System.exit(1);
        }
        try {
            grammar = new Grammar(new File(args[0]));
        }
        catch (FileNotFoundException e) {
            Grammatica.printError(args[0], e);
            System.exit(1);
        }
        catch (ParserLogException e) {
            Grammatica.printError(args[0], e);
            System.exit(1);
        }
        catch (GrammarException e) {
            Grammatica.printError(e);
            System.exit(1);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        try {
            if (args[1].equals("--debug")) {
                Grammatica.debug(grammar);
            } else if (args.length < 3) {
                Grammatica.printHelp("missing action file parameter");
                System.exit(1);
            } else if (args[1].equals("--tokenize")) {
                Grammatica.tokenize(grammar, new File(args[2]));
            } else if (args[1].equals("--parse")) {
                Grammatica.parse(grammar, new File(args[2]));
            } else if (args[1].equals("--profile")) {
                Grammatica.profile(grammar, new File(args[2]));
            } else if (args[1].equals("--javaoutput")) {
                Grammatica.writeJavaCode(args, grammar);
            } else if (args[1].equals("--csoutput")) {
                Grammatica.writeCSharpCode(args, grammar);
            } else {
                Grammatica.printHelp("unrecognized option: " + args[1]);
                System.exit(1);
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printError(Exception e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: ");
        buffer.append(e.getMessage());
        System.err.println(buffer.toString());
    }

    private static void printError(String file, FileNotFoundException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open file:");
        buffer.append("\n    ");
        buffer.append(file);
        System.err.println(buffer.toString());
    }

    private static void printError(String file, ParseException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: in ");
        buffer.append(file);
        if (e.getLine() > 0) {
            buffer.append(": line ");
            buffer.append(e.getLine());
        }
        buffer.append(":\n");
        buffer.append(Grammatica.linebreakString(e.getErrorMessage(), "    ", 70));
        String line = Grammatica.readLines(file, e.getLine(), e.getLine());
        if (line != null) {
            buffer.append("\n\n");
            buffer.append(line);
            int i = 1;
            while (i < e.getColumn()) {
                if (line.charAt(i - 1) == '\t') {
                    buffer.append("\t");
                } else {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append("^");
        }
        System.err.println(buffer.toString());
    }

    private static void printError(String file, ParserLogException e) {
        int i = 0;
        while (i < e.getErrorCount()) {
            Grammatica.printError(file, e.getError(i));
            ++i;
        }
    }

    private static void printError(GrammarException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: in ");
        buffer.append(e.getFile());
        if (e.getStartLine() > 0) {
            if (e.getStartLine() == e.getEndLine()) {
                buffer.append(": line ");
                buffer.append(e.getStartLine());
            } else {
                buffer.append(": lines ");
                buffer.append(e.getStartLine());
                buffer.append("-");
                buffer.append(e.getEndLine());
            }
        }
        buffer.append(":\n");
        buffer.append(Grammatica.linebreakString(e.getErrorMessage(), "    ", 70));
        String lines = Grammatica.readLines(e.getFile(), e.getStartLine(), e.getEndLine());
        if (lines != null) {
            buffer.append("\n\n");
            buffer.append(lines);
        }
        System.err.println(buffer.toString());
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static String linebreakString(String str, String prefix, int length) {
        StringBuffer buffer = new StringBuffer();
        while (str.length() + prefix.length() > length) {
            int pos = str.lastIndexOf(32, length - prefix.length());
            if (pos < 0 && (pos = str.indexOf(32)) < 0) break;
            buffer.append(prefix);
            buffer.append(str.substring(0, pos));
            str = str.substring(pos + 1);
            buffer.append("\n");
        }
        buffer.append(prefix);
        buffer.append(str);
        return buffer.toString();
    }

    private static String readLines(String file, int start, int end) {
        StringBuffer buffer = new StringBuffer();
        if (start < 1 || end < start) {
            return null;
        }
        try {
            BufferedReader input = new BufferedReader(new FileReader(file));
            int i = 0;
            while (i < end) {
                String str = input.readLine();
                if (str == null) {
                    input.close();
                    return null;
                }
                if (start <= i + 1) {
                    buffer.append(str);
                    buffer.append("\n");
                }
                ++i;
            }
            input.close();
        }
        catch (IOException e) {
            return null;
        }
        return buffer.toString();
    }

    private static void debug(Grammar grammar) {
        Tokenizer tokenizer = null;
        Parser parser = null;
        try {
            tokenizer = grammar.createTokenizer(null);
            parser = grammar.createParser(tokenizer);
        }
        catch (GrammarException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        System.out.println("Contents of " + grammar.getFileName() + ":");
        System.out.println();
        System.out.println("Token Declarations:");
        System.out.println("-------------------");
        System.out.print(tokenizer);
        System.out.println("Production Declarations:");
        System.out.println("------------------------");
        System.out.print(parser);
    }

    /*
     * WARNING - void declaration
     */
    private static void tokenize(Grammar grammar, File file) {
        try {
            Token token;
            Tokenizer tokenizer = grammar.createTokenizer(new FileReader(file));
            System.out.println("Tokens from " + file + ":");
            while ((token = tokenizer.next()) != null) {
                void var3_3;
                System.out.println(var3_3);
            }
        }
        catch (FileNotFoundException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
        catch (GrammarException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParseException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
    }

    private static void parse(Grammar grammar, File file) {
        try {
            Tokenizer tokenizer = grammar.createTokenizer(new FileReader(file));
            TreePrinter analyzer = new TreePrinter(new PrintWriter(System.out));
            Parser parser = grammar.createParser(tokenizer, analyzer);
            System.out.println("Parse tree from " + file + ":");
            parser.parse();
        }
        catch (FileNotFoundException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
        catch (GrammarException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParserCreationException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParserLogException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
    }

    private static void profile(Grammar grammar, File file) {
        int counter;
        long time;
        Tokenizer tokenizer;
        try {
            tokenizer = grammar.createTokenizer(new FileReader(file));
            System.out.println("Tokenizing " + file);
            time = System.currentTimeMillis();
            counter = 0;
            while (tokenizer.next() != null) {
                ++counter;
            }
            time = System.currentTimeMillis() - time;
            System.out.println("  Time elapsed:  " + time + " millisec");
            System.out.println("  Tokens found:  " + counter);
            System.out.println("  Average speed: " + (long)counter / time + " tokens/millisec");
            System.out.println();
        }
        catch (FileNotFoundException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
        catch (GrammarException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParseException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
        try {
            tokenizer = grammar.createTokenizer(new FileReader(file));
            Parser parser = grammar.createParser(tokenizer);
            System.out.println("Parsing " + file);
            time = System.currentTimeMillis();
            Node node = parser.parse();
            time = System.currentTimeMillis() - time;
            counter = 1 + node.getDescendantCount();
            System.out.println("  Time elapsed:  " + time + " millisec");
            System.out.println("  Nodes found:   " + counter);
            System.out.println("  Average speed: " + (long)counter / time + " nodes/millisec");
            System.out.println();
        }
        catch (FileNotFoundException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
        catch (GrammarException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParserCreationException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParserLogException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
    }

    private static void writeJavaCode(String[] args, Grammar grammar) {
        JavaParserGenerator gen = new JavaParserGenerator(grammar);
        int i = 1;
        while (i < args.length) {
            if (args[i].equals("--javaoutput")) {
                gen.setBaseDir(new File(args[++i]));
            } else if (args[i].equals("--javapackage")) {
                gen.setBasePackage(args[++i]);
            } else if (args[i].equals("--javaclassname")) {
                gen.setBaseName(args[++i]);
            } else if (args[i].equals("--javapublic")) {
                gen.setPublicAccess(true);
            } else {
                Grammatica.printHelp("unrecognized option: " + args[i]);
                System.exit(1);
            }
            ++i;
        }
        try {
            System.out.println("Writing Java parser source code...");
            gen.write();
            System.out.println("Done.");
        }
        catch (IOException e) {
            Grammatica.printError(e);
            System.exit(1);
        }
    }

    private static void writeCSharpCode(String[] args, Grammar grammar) {
        CSharpParserGenerator gen = new CSharpParserGenerator(grammar);
        int i = 1;
        while (i < args.length) {
            if (args[i].equals("--csoutput")) {
                gen.setBaseDir(new File(args[++i]));
            } else if (args[i].equals("--csnamespace")) {
                gen.setNamespace(args[++i]);
            } else if (args[i].equals("--csclassname")) {
                gen.setBaseName(args[++i]);
            } else if (args[i].equals("--cspublic")) {
                gen.setPublicAccess(true);
            } else {
                Grammatica.printHelp("unrecognized option: " + args[i]);
                System.exit(1);
            }
            ++i;
        }
        try {
            System.out.println("Writing C# parser source code...");
            gen.write();
            System.out.println("Done.");
        }
        catch (IOException e) {
            Grammatica.printError(e);
            System.exit(1);
        }
    }

    private static class TreePrinter
    extends Analyzer {
        private int indentation = 0;
        private PrintWriter output;

        public TreePrinter(PrintWriter output) {
            this.output = output;
        }

        protected void enter(Node node) {
            int i = 0;
            while (i < this.indentation) {
                this.output.print("  ");
                ++i;
            }
            this.output.println(node.toString());
            this.output.flush();
            ++this.indentation;
        }

        protected Node exit(Node node) {
            --this.indentation;
            return null;
        }
    }
}

