/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.csharp;

import java.io.PrintWriter;
import java.util.Vector;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.csharp.CSharpClass;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpModifier;

public class CSharpConstructor
extends CodeElement {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_INTERNAL = 2;
    public static final int PROTECTED = 3;
    public static final int INTERNAL = 4;
    public static final int PRIVATE = 5;
    public static final int EXTERN = 512;
    private int modifiers;
    private CSharpClass cls;
    private String args;
    private String initializer;
    private Vector code;
    private CSharpComment comment;

    public CSharpConstructor() {
        this("");
    }

    public CSharpConstructor(String args) {
        this(1, args);
    }

    public CSharpConstructor(int modifiers, String args) {
        this.modifiers = modifiers;
        this.cls = null;
        this.args = args;
        this.initializer = null;
        this.code = new Vector();
        this.comment = null;
    }

    public CSharpClass getCSharpClass() {
        return this.cls;
    }

    void setCSharpClass(CSharpClass cls) {
        this.cls = cls;
    }

    public void addInitializer(String initializer) {
        this.initializer = initializer;
    }

    public void addCode(String codeLines) {
        int pos = codeLines.indexOf(10);
        while (pos >= 0) {
            this.code.add(codeLines.substring(0, pos));
            codeLines = codeLines.substring(pos + 1);
            pos = codeLines.indexOf(10);
        }
        this.code.add(codeLines);
    }

    public void addComment(CSharpComment comment) {
        this.comment = comment;
    }

    public int category() {
        return 7;
    }

    public void print(PrintWriter out, CodeStyle style, int indent) {
        String indentStr = style.getIndent(indent);
        String codeIndentStr = style.getIndent(indent + 1);
        StringBuffer res = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        res.append(indentStr);
        res.append(CSharpModifier.createModifierDecl(this.modifiers));
        res.append(this.cls.toString());
        res.append("(");
        res.append(this.args);
        res.append(")");
        if (this.initializer != null) {
            res.append("\n");
            res.append(codeIndentStr);
            res.append(": ");
            res.append(this.initializer);
        }
        res.append(" {\n");
        if (this.initializer != null && this.code.size() > 0) {
            res.append("\n");
        }
        int i = 0;
        while (i < this.code.size()) {
            if (this.code.elementAt(i).toString().length() > 0) {
                res.append(codeIndentStr);
                res.append(this.code.elementAt(i).toString());
                res.append("\n");
            } else {
                res.append("\n");
            }
            ++i;
        }
        res.append(indentStr);
        res.append("}");
        out.println(res.toString());
    }
}

