/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.AbstractList;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.Token;

class LookAheadSet {
    private ArrayList elements = new ArrayList();
    private int maxLength;

    public LookAheadSet(int maxLength) {
        this.maxLength = maxLength;
    }

    public LookAheadSet(int maxLength, LookAheadSet set) {
        this(maxLength);
        this.addAll(set);
    }

    public int size() {
        return this.elements.size();
    }

    public int getMinLength() {
        int min = -1;
        int i = 0;
        while (i < this.elements.size()) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (min < 0 || seq.length() < min) {
                min = seq.length();
            }
            ++i;
        }
        return min < 0 ? 0 : min;
    }

    public int getMaxLength() {
        int max = 0;
        int i = 0;
        while (i < this.elements.size()) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (seq.length() > max) {
                max = seq.length();
            }
            ++i;
        }
        return max;
    }

    public int[] getInitialTokens() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < this.elements.size()) {
            Integer token = ((Sequence)this.elements.get(i)).getToken(0);
            if (token != null && !list.contains(token)) {
                list.add(token);
            }
            ++i;
        }
        int[] result = new int[list.size()];
        i = 0;
        while (i < list.size()) {
            result[i] = (Integer)list.get(i);
            ++i;
        }
        return result;
    }

    public boolean isRepetitive() {
        int i = 0;
        while (i < this.elements.size()) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (seq.isRepetitive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isNext(Parser parser) throws ParseException {
        int i = 0;
        while (i < this.elements.size()) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (seq.isNext(parser)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isNext(Parser parser, int length) throws ParseException {
        int i = 0;
        while (i < this.elements.size()) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (seq.isNext(parser, length)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(Sequence elem) {
        return this.findSequence(elem) != null;
    }

    public boolean intersects(LookAheadSet set) {
        int i = 0;
        while (i < this.elements.size()) {
            if (set.contains((Sequence)this.elements.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Sequence findSequence(Sequence elem) {
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.get(i).equals(elem)) {
                return (Sequence)this.elements.get(i);
            }
            ++i;
        }
        return null;
    }

    private void add(Sequence seq) {
        if (seq.length() > this.maxLength) {
            seq = new Sequence(this.maxLength, seq);
        }
        if (!this.contains(seq)) {
            this.elements.add(seq);
        }
    }

    public void add(int token) {
        this.add(new Sequence(false, token));
    }

    public void addAll(LookAheadSet set) {
        int i = 0;
        while (i < set.elements.size()) {
            this.add((Sequence)set.elements.get(i));
            ++i;
        }
    }

    public void addEmpty() {
        this.add(new Sequence());
    }

    public LookAheadSet createNextSet(int token) {
        LookAheadSet result = new LookAheadSet(this.maxLength - 1);
        int i = 0;
        while (i < this.elements.size()) {
            Sequence seq = (Sequence)this.elements.get(i);
            Integer value = seq.getToken(0);
            if (value != null && value == token) {
                result.add(seq.subsequence(1));
            }
            ++i;
        }
        return result;
    }

    public LookAheadSet createIntersection(LookAheadSet set) {
        LookAheadSet result = new LookAheadSet(this.maxLength);
        int i = 0;
        while (i < this.elements.size()) {
            Sequence seq1 = (Sequence)this.elements.get(i);
            Sequence seq2 = set.findSequence(seq1);
            if (seq2 != null && seq1.isRepetitive()) {
                result.add(seq2);
            } else if (seq2 != null) {
                result.add(seq1);
            }
            ++i;
        }
        return result;
    }

    public LookAheadSet createCombination(LookAheadSet set) {
        LookAheadSet result = new LookAheadSet(this.maxLength);
        if (this.size() <= 0) {
            return set;
        }
        if (set.size() <= 0) {
            return this;
        }
        int i = 0;
        while (i < this.elements.size()) {
            Sequence first = (Sequence)this.elements.get(i);
            if (first.length() >= this.maxLength) {
                result.add(first);
            } else if (first.length() <= 0) {
                result.addAll(set);
            } else {
                int j = 0;
                while (j < set.elements.size()) {
                    Sequence second = (Sequence)set.elements.get(j);
                    result.add(first.concat(this.maxLength, second));
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public LookAheadSet createRepetitive() {
        LookAheadSet result = new LookAheadSet(this.maxLength);
        int i = 0;
        while (i < this.elements.size()) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (seq.isRepetitive()) {
                result.add(seq);
            } else {
                result.add(new Sequence(true, seq));
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        int i = 0;
        while (i < this.elements.size()) {
            buffer.append("\n  ");
            buffer.append(this.elements.get(i));
            ++i;
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    private class Sequence {
        private boolean repeat = false;
        private ArrayList tokens = null;

        public Sequence() {
            this.repeat = false;
            this.tokens = new ArrayList(0);
        }

        public Sequence(boolean repeat, int token) {
            this.repeat = false;
            this.tokens = new ArrayList(1);
            this.tokens.add(new Integer(token));
        }

        public Sequence(int length, Sequence seq) {
            this.repeat = seq.repeat;
            this.tokens = new ArrayList(length);
            if (seq.length() < length) {
                length = seq.length();
            }
            int i = 0;
            while (i < length) {
                this.tokens.add(seq.tokens.get(i));
                ++i;
            }
        }

        public Sequence(boolean repeat, Sequence seq) {
            this.repeat = repeat;
            this.tokens = seq.tokens;
        }

        public int length() {
            return this.tokens.size();
        }

        public Integer getToken(int pos) {
            if (pos >= 0 && pos < this.tokens.size()) {
                return (Integer)this.tokens.get(pos);
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Sequence) {
                return ((AbstractList)this.tokens).equals(((Sequence)obj).tokens);
            }
            return false;
        }

        public boolean isRepetitive() {
            return this.repeat;
        }

        public boolean isNext(Parser parser) throws ParseException {
            int i = 0;
            while (i < this.tokens.size()) {
                Integer id = (Integer)this.tokens.get(i);
                Token token = parser.peekToken(i);
                if (token == null || token.getId() != id.intValue()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean isNext(Parser parser, int length) throws ParseException {
            if (length > this.tokens.size()) {
                length = this.tokens.size();
            }
            int i = 0;
            while (i < length) {
                Integer id = (Integer)this.tokens.get(i);
                Token token = parser.peekToken(i);
                if (token == null || token.getId() != id.intValue()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.tokens.toString());
            if (this.repeat) {
                buffer.append(" *");
            }
            return buffer.toString();
        }

        public Sequence concat(int length, Sequence seq) {
            Sequence res = new Sequence(length, this);
            if (seq.repeat) {
                res.repeat = true;
            }
            if ((length -= this.length()) > seq.length()) {
                res.tokens.addAll(seq.tokens);
            } else {
                int i = 0;
                while (i < length) {
                    res.tokens.add(seq.tokens.get(i));
                    ++i;
                }
            }
            return res;
        }

        public Sequence subsequence(int start) {
            Sequence res = new Sequence(this.length(), this);
            while (start > 0 && res.tokens.size() > 0) {
                res.tokens.remove(0);
                --start;
            }
            return res;
        }
    }
}

