/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

abstract class JavaModifier {
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE_LOCAL = 2;
    public static final int PRIVATE = 3;
    public static final int STATIC = 4;
    public static final int ABSTRACT = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int NATIVE = 64;
    public static final int TRANSIENT = 128;
    public static final int VOLATILE = 256;
    public static final int STRICTFP = 512;

    JavaModifier() {
    }

    public static String createModifierDecl(int modifiers) {
        StringBuffer res = new StringBuffer();
        switch (modifiers % 4) {
            case 0: {
                res.append("public ");
                break;
            }
            case 1: {
                res.append("protected ");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                res.append("private ");
            }
        }
        if ((modifiers & 4) > 0) {
            res.append("static ");
        }
        if ((modifiers & 8) > 0) {
            res.append("abstract ");
        }
        if ((modifiers & 0x10) > 0) {
            res.append("final ");
        }
        if ((modifiers & 0x20) > 0) {
            res.append("synchronized ");
        }
        if ((modifiers & 0x40) > 0) {
            res.append("native ");
        }
        if ((modifiers & 0x80) > 0) {
            res.append("transient ");
        }
        if ((modifiers & 0x100) > 0) {
            res.append("volatile ");
        }
        if ((modifiers & 0x200) > 0) {
            res.append("strictfp ");
        }
        return res.toString();
    }
}

