/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.csharp;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeElementContainer;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpModifier;

abstract class CSharpType
extends CodeElementContainer {
    private int modifiers;
    private String name;
    private String[] extendTypes;
    private CSharpComment comment = null;

    protected CSharpType(int modifiers, String name, String extendType) {
        this.modifiers = modifiers;
        this.name = name;
        if (extendType == null || extendType.equals("")) {
            this.extendTypes = new String[0];
        } else {
            this.extendTypes = new String[1];
            this.extendTypes[0] = extendType;
        }
    }

    protected CSharpType(int modifiers, String name, String[] extendTypes) {
        this.modifiers = modifiers;
        this.name = name;
        this.extendTypes = extendTypes;
    }

    public String toString() {
        return this.name;
    }

    public void addComment(CSharpComment comment) {
        this.comment = comment;
    }

    protected void print(PrintWriter out, CodeStyle style, int indent, String type) {
        StringBuffer buf = new StringBuffer();
        String indentStr = style.getIndent(indent);
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        buf.append(indentStr);
        buf.append(CSharpModifier.createModifierDecl(this.modifiers));
        buf.append(type);
        buf.append(" ");
        buf.append(this.name);
        int i = 0;
        while (i < this.extendTypes.length) {
            if (i == 0) {
                buf.append(" : ");
            } else {
                buf.append(", ");
            }
            buf.append(this.extendTypes[i]);
            ++i;
        }
        buf.append(" {");
        out.println(buf.toString());
        this.printContents(out, style, indent + 1);
        out.println(indentStr + "}");
    }

    protected void printSeparator(PrintWriter out, CodeStyle style, CodeElement prev, CodeElement next) {
        if (prev != null && next != null) {
            out.println();
        }
    }
}

