/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.io.Reader;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.Tokenizer;

class GrammarTokenizer
extends Tokenizer {
    public GrammarTokenizer(Reader input) throws ParserCreationException {
        super(input);
        this.createPatterns();
    }

    private void createPatterns() throws ParserCreationException {
        TokenPattern pattern = new TokenPattern(1001, "HEADER", 1, "%header%");
        this.addPattern(pattern);
        pattern = new TokenPattern(1002, "TOKENS", 1, "%tokens%");
        this.addPattern(pattern);
        pattern = new TokenPattern(1003, "PRODUCTIONS", 1, "%productions%");
        this.addPattern(pattern);
        pattern = new TokenPattern(1004, "IGNORE", 2, "%ignore([^%]*)%");
        this.addPattern(pattern);
        pattern = new TokenPattern(1005, "ERROR", 2, "%error([^%]*)%");
        this.addPattern(pattern);
        pattern = new TokenPattern(1006, "EQUALS", 1, "=");
        this.addPattern(pattern);
        pattern = new TokenPattern(1007, "LEFT_PAREN", 1, "(");
        this.addPattern(pattern);
        pattern = new TokenPattern(1008, "RIGHT_PAREN", 1, ")");
        this.addPattern(pattern);
        pattern = new TokenPattern(1009, "LEFT_BRACE", 1, "{");
        this.addPattern(pattern);
        pattern = new TokenPattern(1010, "RIGHT_BRACE", 1, "}");
        this.addPattern(pattern);
        pattern = new TokenPattern(1011, "LEFT_BRACKET", 1, "[");
        this.addPattern(pattern);
        pattern = new TokenPattern(1012, "RIGHT_BRACKET", 1, "]");
        this.addPattern(pattern);
        pattern = new TokenPattern(1013, "QUESTION_MARK", 1, "?");
        this.addPattern(pattern);
        pattern = new TokenPattern(1014, "PLUS_SIGN", 1, "+");
        this.addPattern(pattern);
        pattern = new TokenPattern(1015, "ASTERISK", 1, "*");
        this.addPattern(pattern);
        pattern = new TokenPattern(1016, "VERTICAL_BAR", 1, "|");
        this.addPattern(pattern);
        pattern = new TokenPattern(1017, "SEMICOLON", 1, ";");
        this.addPattern(pattern);
        pattern = new TokenPattern(1018, "IDENTIFIER", 2, "[A-Za-z][A-Za-z0-9_]*");
        this.addPattern(pattern);
        pattern = new TokenPattern(1019, "QUOTED_STRING", 2, "(\"[^\"]*\")|('[^']*')");
        this.addPattern(pattern);
        pattern = new TokenPattern(1020, "REGEXP", 2, "<<([^\\\\>]|(\\\\.)|(>[^>]))*>>");
        this.addPattern(pattern);
        pattern = new TokenPattern(1021, "SINGLE_LINE_COMMENT", 2, "//.*");
        pattern.setIgnore();
        this.addPattern(pattern);
        pattern = new TokenPattern(1022, "MULTI_LINE_COMMENT", 2, "/\\*([^*]|\\*[^/])*\\*/");
        pattern.setIgnore();
        this.addPattern(pattern);
        pattern = new TokenPattern(1023, "WHITESPACE", 2, "[ \\t\\n\\r]+");
        pattern.setIgnore();
        this.addPattern(pattern);
    }
}

