/*
 * RegexpAnalyzer.java
 * 
 * THIS FILE HAS BEEN GENERATED AUTOMATICALLY. DO NOT EDIT!
 * 
 * This work is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This work is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * As a special exception, the copyright holders of this library give
 * you permission to link this library with independent modules to
 * produce an executable, regardless of the license terms of these
 * independent modules, and to copy and distribute the resulting
 * executable under terms of your choice, provided that you also meet,
 * for each linked independent module, the terms and conditions of the
 * license of that module. An independent module is a module which is
 * not derived from or based on this library. If you modify this
 * library, you may extend this exception to your version of the
 * library, but you are not obligated to do so. If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.grammatica.test;

import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;

/**
 * A class providing callback methods for the parser.
 * 
 * @author   Per Cederberg, <per at percederberg dot net>
 * @version  1.0
 */
abstract class RegexpAnalyzer extends Analyzer {

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enter(Node node) throws ParseException {
        switch (node.getId()) {
        case RegexpConstants.LEFT_PAREN:
            enterLeftParen((Token) node);
            break;
        case RegexpConstants.RIGHT_PAREN:
            enterRightParen((Token) node);
            break;
        case RegexpConstants.LEFT_BRACKET:
            enterLeftBracket((Token) node);
            break;
        case RegexpConstants.RIGHT_BRACKET:
            enterRightBracket((Token) node);
            break;
        case RegexpConstants.LEFT_BRACE:
            enterLeftBrace((Token) node);
            break;
        case RegexpConstants.RIGHT_BRACE:
            enterRightBrace((Token) node);
            break;
        case RegexpConstants.QUESTION:
            enterQuestion((Token) node);
            break;
        case RegexpConstants.ASTERISK:
            enterAsterisk((Token) node);
            break;
        case RegexpConstants.PLUS:
            enterPlus((Token) node);
            break;
        case RegexpConstants.VERTICAL_BAR:
            enterVerticalBar((Token) node);
            break;
        case RegexpConstants.DOT:
            enterDot((Token) node);
            break;
        case RegexpConstants.COMMA:
            enterComma((Token) node);
            break;
        case RegexpConstants.NUMBER:
            enterNumber((Token) node);
            break;
        case RegexpConstants.CHAR:
            enterChar((Token) node);
            break;
        case RegexpConstants.EXPR:
            enterExpr((Production) node);
            break;
        case RegexpConstants.TERM:
            enterTerm((Production) node);
            break;
        case RegexpConstants.FACT:
            enterFact((Production) node);
            break;
        case RegexpConstants.ATOM:
            enterAtom((Production) node);
            break;
        case RegexpConstants.ATOM_MODIFIER:
            enterAtomModifier((Production) node);
            break;
        case RegexpConstants.CHARACTER_SET:
            enterCharacterSet((Production) node);
            break;
        case RegexpConstants.CHARACTER:
            enterCharacter((Production) node);
            break;
        }
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exit(Node node) throws ParseException {
        switch (node.getId()) {
        case RegexpConstants.LEFT_PAREN:
            return exitLeftParen((Token) node);
        case RegexpConstants.RIGHT_PAREN:
            return exitRightParen((Token) node);
        case RegexpConstants.LEFT_BRACKET:
            return exitLeftBracket((Token) node);
        case RegexpConstants.RIGHT_BRACKET:
            return exitRightBracket((Token) node);
        case RegexpConstants.LEFT_BRACE:
            return exitLeftBrace((Token) node);
        case RegexpConstants.RIGHT_BRACE:
            return exitRightBrace((Token) node);
        case RegexpConstants.QUESTION:
            return exitQuestion((Token) node);
        case RegexpConstants.ASTERISK:
            return exitAsterisk((Token) node);
        case RegexpConstants.PLUS:
            return exitPlus((Token) node);
        case RegexpConstants.VERTICAL_BAR:
            return exitVerticalBar((Token) node);
        case RegexpConstants.DOT:
            return exitDot((Token) node);
        case RegexpConstants.COMMA:
            return exitComma((Token) node);
        case RegexpConstants.NUMBER:
            return exitNumber((Token) node);
        case RegexpConstants.CHAR:
            return exitChar((Token) node);
        case RegexpConstants.EXPR:
            return exitExpr((Production) node);
        case RegexpConstants.TERM:
            return exitTerm((Production) node);
        case RegexpConstants.FACT:
            return exitFact((Production) node);
        case RegexpConstants.ATOM:
            return exitAtom((Production) node);
        case RegexpConstants.ATOM_MODIFIER:
            return exitAtomModifier((Production) node);
        case RegexpConstants.CHARACTER_SET:
            return exitCharacterSet((Production) node);
        case RegexpConstants.CHARACTER:
            return exitCharacter((Production) node);
        }
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void child(Production node, Node child)
        throws ParseException {

        switch (node.getId()) {
        case RegexpConstants.EXPR:
            childExpr(node, child);
            break;
        case RegexpConstants.TERM:
            childTerm(node, child);
            break;
        case RegexpConstants.FACT:
            childFact(node, child);
            break;
        case RegexpConstants.ATOM:
            childAtom(node, child);
            break;
        case RegexpConstants.ATOM_MODIFIER:
            childAtomModifier(node, child);
            break;
        case RegexpConstants.CHARACTER_SET:
            childCharacterSet(node, child);
            break;
        case RegexpConstants.CHARACTER:
            childCharacter(node, child);
            break;
        }
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftParen(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftParen(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightParen(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightParen(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftBracket(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftBracket(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightBracket(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightBracket(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftBrace(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftBrace(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightBrace(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightBrace(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterQuestion(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitQuestion(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAsterisk(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAsterisk(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterPlus(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitPlus(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterVerticalBar(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitVerticalBar(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDot(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDot(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComma(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComma(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNumber(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNumber(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterChar(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitChar(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterExpr(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitExpr(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childExpr(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTerm(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTerm(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTerm(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterFact(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitFact(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childFact(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAtom(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAtom(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childAtom(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAtomModifier(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAtomModifier(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childAtomModifier(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterCharacterSet(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitCharacterSet(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childCharacterSet(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterCharacter(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitCharacter(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childCharacter(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }
}
