/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.StringElement;

class CharacterSetElement
extends Element {
    public static final CharacterSetElement DOT = new CharacterSetElement(false);
    public static final CharacterSetElement DIGIT = new CharacterSetElement(false);
    public static final CharacterSetElement NON_DIGIT = new CharacterSetElement(true);
    public static final CharacterSetElement WHITESPACE = new CharacterSetElement(false);
    public static final CharacterSetElement NON_WHITESPACE = new CharacterSetElement(true);
    public static final CharacterSetElement WORD = new CharacterSetElement(false);
    public static final CharacterSetElement NON_WORD = new CharacterSetElement(true);
    private boolean inverted;
    private ArrayList contents = new ArrayList();

    public CharacterSetElement(boolean inverted) {
        this.inverted = inverted;
    }

    public void addCharacter(char c) {
        this.contents.add(new Character(c));
    }

    public void addCharacters(String str) {
        int i = 0;
        while (i < str.length()) {
            this.addCharacter(str.charAt(i));
            ++i;
        }
    }

    public void addCharacters(StringElement elem) {
        this.addCharacters(elem.getString());
    }

    public void addRange(char min, char max) {
        this.contents.add(new Range(min, max));
    }

    public void addCharacterSet(CharacterSetElement elem) {
        this.contents.add(elem);
    }

    public Object clone() {
        return this;
    }

    public int match(Matcher m, CharBuffer str, int start, int skip) {
        if (skip != 0) {
            return -1;
        }
        if (start >= str.length()) {
            m.setReadEndOfString();
            return -1;
        }
        char c = str.charAt(start);
        return this.inSet(c) ? 1 : -1;
    }

    private boolean inSet(char value) {
        if (this == DOT) {
            return this.inDotSet(value);
        }
        if (this == DIGIT || this == NON_DIGIT) {
            return this.inDigitSet(value) != this.inverted;
        }
        if (this == WHITESPACE || this == NON_WHITESPACE) {
            return this.inWhitespaceSet(value) != this.inverted;
        }
        if (this == WORD || this == NON_WORD) {
            return this.inWordSet(value) != this.inverted;
        }
        return this.inUserSet(value) != this.inverted;
    }

    private boolean inDotSet(char value) {
        switch (value) {
            case '\n': 
            case '\r': 
            case '\u0085': 
            case '\u2028': 
            case '\u2029': {
                return false;
            }
        }
        return true;
    }

    private boolean inDigitSet(char value) {
        return '0' <= value && value <= '9';
    }

    private boolean inWhitespaceSet(char value) {
        switch (value) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private boolean inWordSet(char value) {
        return 'a' <= value && value <= 'z' || 'A' <= value && value <= 'Z' || '0' <= value && value <= '9' || value == '_';
    }

    private boolean inUserSet(char value) {
        int i = 0;
        while (i < this.contents.size()) {
            CharacterSetElement e;
            Range r;
            Character c;
            Object obj = this.contents.get(i);
            if (obj instanceof Character ? (c = (Character)obj).charValue() == value : (obj instanceof Range ? (r = (Range)obj).inside(value) : obj instanceof CharacterSetElement && (e = (CharacterSetElement)obj).inSet(value))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void printTo(PrintWriter output, String indent) {
        output.println(indent + this.toString());
    }

    public String toString() {
        if (this == DOT) {
            return ".";
        }
        if (this == DIGIT) {
            return "\\d";
        }
        if (this == NON_DIGIT) {
            return "\\D";
        }
        if (this == WHITESPACE) {
            return "\\s";
        }
        if (this == NON_WHITESPACE) {
            return "\\S";
        }
        if (this == WORD) {
            return "\\w";
        }
        if (this == NON_WORD) {
            return "\\W";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.inverted) {
            buffer.append("^[");
        } else {
            buffer.append("[");
        }
        int i = 0;
        while (i < this.contents.size()) {
            buffer.append(this.contents.get(i));
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    private class Range {
        private char min;
        private char max;

        public Range(char min, char max) {
            this.min = min;
            this.max = max;
        }

        public boolean inside(char c) {
            return c >= this.min && c <= this.max;
        }

        public String toString() {
            return this.min + "-" + this.max;
        }
    }
}

