/*
 * GrammarAnalyzer.java
 * 
 * THIS FILE HAS BEEN GENERATED AUTOMATICALLY. DO NOT EDIT!
 * 
 * This work is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This work is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * As a special exception, the copyright holders of this library give
 * you permission to link this library with independent modules to
 * produce an executable, regardless of the license terms of these
 * independent modules, and to copy and distribute the resulting
 * executable under terms of your choice, provided that you also meet,
 * for each linked independent module, the terms and conditions of the
 * license of that module. An independent module is a module which is
 * not derived from or based on this library. If you modify this
 * library, you may extend this exception to your version of the
 * library, but you are not obligated to do so. If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.grammatica;

import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;

/**
 * A class providing callback methods for the parser.
 * 
 * @author   Per Cederberg, <per at percederberg dot net>
 * @version  1.0
 */
abstract class GrammarAnalyzer extends Analyzer {

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enter(Node node) throws ParseException {
        switch (node.getId()) {
        case GrammarConstants.HEADER:
            enterHeader((Token) node);
            break;
        case GrammarConstants.TOKENS:
            enterTokens((Token) node);
            break;
        case GrammarConstants.PRODUCTIONS:
            enterProductions((Token) node);
            break;
        case GrammarConstants.IGNORE:
            enterIgnore((Token) node);
            break;
        case GrammarConstants.ERROR:
            enterError((Token) node);
            break;
        case GrammarConstants.EQUALS:
            enterEquals((Token) node);
            break;
        case GrammarConstants.LEFT_PAREN:
            enterLeftParen((Token) node);
            break;
        case GrammarConstants.RIGHT_PAREN:
            enterRightParen((Token) node);
            break;
        case GrammarConstants.LEFT_BRACE:
            enterLeftBrace((Token) node);
            break;
        case GrammarConstants.RIGHT_BRACE:
            enterRightBrace((Token) node);
            break;
        case GrammarConstants.LEFT_BRACKET:
            enterLeftBracket((Token) node);
            break;
        case GrammarConstants.RIGHT_BRACKET:
            enterRightBracket((Token) node);
            break;
        case GrammarConstants.PLUS_SIGN:
            enterPlusSign((Token) node);
            break;
        case GrammarConstants.ASTERISK:
            enterAsterisk((Token) node);
            break;
        case GrammarConstants.VERTICAL_BAR:
            enterVerticalBar((Token) node);
            break;
        case GrammarConstants.SEMICOLON:
            enterSemicolon((Token) node);
            break;
        case GrammarConstants.IDENTIFIER:
            enterIdentifier((Token) node);
            break;
        case GrammarConstants.QUOTED_STRING:
            enterQuotedString((Token) node);
            break;
        case GrammarConstants.REGEXP:
            enterRegexp((Token) node);
            break;
        case GrammarConstants.GRAMMAR:
            enterGrammar((Production) node);
            break;
        case GrammarConstants.HEADER_PART:
            enterHeaderPart((Production) node);
            break;
        case GrammarConstants.HEADER_DECLARATION:
            enterHeaderDeclaration((Production) node);
            break;
        case GrammarConstants.TOKEN_PART:
            enterTokenPart((Production) node);
            break;
        case GrammarConstants.TOKEN_DECLARATION:
            enterTokenDeclaration((Production) node);
            break;
        case GrammarConstants.TOKEN_VALUE:
            enterTokenValue((Production) node);
            break;
        case GrammarConstants.TOKEN_HANDLING:
            enterTokenHandling((Production) node);
            break;
        case GrammarConstants.PRODUCTION_PART:
            enterProductionPart((Production) node);
            break;
        case GrammarConstants.PRODUCTION_DECLARATION:
            enterProductionDeclaration((Production) node);
            break;
        case GrammarConstants.PRODUCTION:
            enterProduction((Production) node);
            break;
        case GrammarConstants.PRODUCTION_ATOM:
            enterProductionAtom((Production) node);
            break;
        }
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exit(Node node) throws ParseException {
        switch (node.getId()) {
        case GrammarConstants.HEADER:
            return exitHeader((Token) node);
        case GrammarConstants.TOKENS:
            return exitTokens((Token) node);
        case GrammarConstants.PRODUCTIONS:
            return exitProductions((Token) node);
        case GrammarConstants.IGNORE:
            return exitIgnore((Token) node);
        case GrammarConstants.ERROR:
            return exitError((Token) node);
        case GrammarConstants.EQUALS:
            return exitEquals((Token) node);
        case GrammarConstants.LEFT_PAREN:
            return exitLeftParen((Token) node);
        case GrammarConstants.RIGHT_PAREN:
            return exitRightParen((Token) node);
        case GrammarConstants.LEFT_BRACE:
            return exitLeftBrace((Token) node);
        case GrammarConstants.RIGHT_BRACE:
            return exitRightBrace((Token) node);
        case GrammarConstants.LEFT_BRACKET:
            return exitLeftBracket((Token) node);
        case GrammarConstants.RIGHT_BRACKET:
            return exitRightBracket((Token) node);
        case GrammarConstants.PLUS_SIGN:
            return exitPlusSign((Token) node);
        case GrammarConstants.ASTERISK:
            return exitAsterisk((Token) node);
        case GrammarConstants.VERTICAL_BAR:
            return exitVerticalBar((Token) node);
        case GrammarConstants.SEMICOLON:
            return exitSemicolon((Token) node);
        case GrammarConstants.IDENTIFIER:
            return exitIdentifier((Token) node);
        case GrammarConstants.QUOTED_STRING:
            return exitQuotedString((Token) node);
        case GrammarConstants.REGEXP:
            return exitRegexp((Token) node);
        case GrammarConstants.GRAMMAR:
            return exitGrammar((Production) node);
        case GrammarConstants.HEADER_PART:
            return exitHeaderPart((Production) node);
        case GrammarConstants.HEADER_DECLARATION:
            return exitHeaderDeclaration((Production) node);
        case GrammarConstants.TOKEN_PART:
            return exitTokenPart((Production) node);
        case GrammarConstants.TOKEN_DECLARATION:
            return exitTokenDeclaration((Production) node);
        case GrammarConstants.TOKEN_VALUE:
            return exitTokenValue((Production) node);
        case GrammarConstants.TOKEN_HANDLING:
            return exitTokenHandling((Production) node);
        case GrammarConstants.PRODUCTION_PART:
            return exitProductionPart((Production) node);
        case GrammarConstants.PRODUCTION_DECLARATION:
            return exitProductionDeclaration((Production) node);
        case GrammarConstants.PRODUCTION:
            return exitProduction((Production) node);
        case GrammarConstants.PRODUCTION_ATOM:
            return exitProductionAtom((Production) node);
        }
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void child(Production node, Node child)
        throws ParseException {

        switch (node.getId()) {
        case GrammarConstants.GRAMMAR:
            childGrammar(node, child);
            break;
        case GrammarConstants.HEADER_PART:
            childHeaderPart(node, child);
            break;
        case GrammarConstants.HEADER_DECLARATION:
            childHeaderDeclaration(node, child);
            break;
        case GrammarConstants.TOKEN_PART:
            childTokenPart(node, child);
            break;
        case GrammarConstants.TOKEN_DECLARATION:
            childTokenDeclaration(node, child);
            break;
        case GrammarConstants.TOKEN_VALUE:
            childTokenValue(node, child);
            break;
        case GrammarConstants.TOKEN_HANDLING:
            childTokenHandling(node, child);
            break;
        case GrammarConstants.PRODUCTION_PART:
            childProductionPart(node, child);
            break;
        case GrammarConstants.PRODUCTION_DECLARATION:
            childProductionDeclaration(node, child);
            break;
        case GrammarConstants.PRODUCTION:
            childProduction(node, child);
            break;
        case GrammarConstants.PRODUCTION_ATOM:
            childProductionAtom(node, child);
            break;
        }
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterHeader(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitHeader(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTokens(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTokens(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterProductions(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitProductions(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIgnore(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIgnore(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterError(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitError(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterEquals(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitEquals(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftParen(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftParen(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightParen(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightParen(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftBrace(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftBrace(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightBrace(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightBrace(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftBracket(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftBracket(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightBracket(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightBracket(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterPlusSign(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitPlusSign(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAsterisk(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAsterisk(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterVerticalBar(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitVerticalBar(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSemicolon(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSemicolon(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIdentifier(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIdentifier(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterQuotedString(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitQuotedString(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRegexp(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRegexp(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterGrammar(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitGrammar(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childGrammar(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterHeaderPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitHeaderPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childHeaderPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterHeaderDeclaration(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitHeaderDeclaration(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childHeaderDeclaration(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTokenPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTokenPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTokenPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTokenDeclaration(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTokenDeclaration(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTokenDeclaration(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTokenValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTokenValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTokenValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTokenHandling(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTokenHandling(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTokenHandling(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterProductionPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitProductionPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childProductionPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterProductionDeclaration(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitProductionDeclaration(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childProductionDeclaration(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterProduction(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitProduction(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childProduction(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterProductionAtom(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitProductionAtom(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childProductionAtom(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }
}
