/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class RecursiveDescentParser
extends Parser {
    private boolean initialized = false;
    private HashMap lookAheads = new HashMap();

    public RecursiveDescentParser(Tokenizer tokenizer) {
        super(tokenizer);
    }

    public RecursiveDescentParser(Tokenizer tokenizer, Analyzer analyzer) {
        super(tokenizer, analyzer);
    }

    public void addPattern(ProductionPattern pattern) throws ParserCreationException {
        if (pattern.isMatchingEmpty()) {
            throw new ParserCreationException("couldn't add production pattern " + pattern.getName() + " , as it can match zero elements (minimum is one)");
        }
        if (pattern.isLeftRecursive()) {
            throw new ParserCreationException("couldn't add production pattern " + pattern.getName() + " , as it is left recursive");
        }
        super.addPattern(pattern);
        this.initialized = false;
    }

    public void prepare() throws ParserCreationException {
        super.prepare();
        Iterator iter = this.getPatterns().iterator();
        while (iter.hasNext()) {
            this.calculateLookAhead((ProductionPattern)iter.next());
        }
        this.initialized = true;
    }

    public Node parse() throws ParserCreationException, ParseException {
        if (!this.initialized) {
            this.prepare();
        }
        Node node = this.parsePattern(this.getStartPattern());
        Token token = this.peekToken(0);
        if (token != null) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add("<EOF>");
            throw new ParseException(4, token.toShortString(), list, token.getStartLine(), token.getStartColumn());
        }
        return node;
    }

    private Node parsePattern(ProductionPattern pattern) throws ParseException {
        Token token = this.peekToken(0);
        ProductionPatternAlternative defaultAlt = pattern.getDefaultAlternative();
        int i = 0;
        while (i < pattern.getAlternativeCount()) {
            ProductionPatternAlternative alt = pattern.getAlternative(i);
            if (defaultAlt != alt && this.isNext(alt)) {
                return this.parseAlternative(alt);
            }
            ++i;
        }
        if (defaultAlt != null) {
            return this.parseAlternative(defaultAlt);
        }
        throw this.createParseException(this.findUnion(pattern));
    }

    private Node parseAlternative(ProductionPatternAlternative alt) throws ParseException {
        Production node = new Production(alt.getPattern());
        this.enterNode(node);
        int i = 0;
        while (i < alt.getElementCount()) {
            this.parseElement(node, alt.getElement(i));
            ++i;
        }
        return this.exitNode(node);
    }

    private void parseElement(Production node, ProductionPatternElement elem) throws ParseException {
        int i = 0;
        while (i < elem.getMaxCount()) {
            Node child;
            if (i >= elem.getMinCount() && !this.isNext(elem)) break;
            if (elem.isToken()) {
                child = this.nextToken(elem.getId());
                this.enterNode(child);
                this.addNode(node, this.exitNode(child));
            } else {
                child = this.parsePattern(this.getPattern(elem.getId()));
                this.addNode(node, child);
            }
            ++i;
        }
    }

    private boolean isNext(ProductionPattern pattern) throws ParseException {
        LookAheadSet set = pattern.getLookAhead();
        if (set == null) {
            return false;
        }
        return set.isNext(this);
    }

    private boolean isNext(ProductionPatternAlternative alt) throws ParseException {
        LookAheadSet set = alt.getLookAhead();
        if (set == null) {
            return false;
        }
        return set.isNext(this);
    }

    private boolean isNext(ProductionPatternElement elem) throws ParseException {
        LookAheadSet set = elem.getLookAhead();
        if (set != null) {
            return set.isNext(this);
        }
        if (elem.isToken()) {
            return elem.isMatch(this.peekToken(0));
        }
        return this.isNext(this.getPattern(elem.getId()));
    }

    private ParseException createParseException(LookAheadSet set) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        while (set.isNext(this, 1)) {
            set = set.createNextSet(this.nextToken().getId());
        }
        int[] initials = set.getInitialTokens();
        int i = 0;
        while (i < initials.length) {
            list.add(this.getTokenDescription(initials[i]));
            ++i;
        }
        Token token = this.peekToken(0);
        return new ParseException(4, token.toShortString(), list, token.getStartLine(), token.getStartColumn());
    }

    private void calculateLookAhead(ProductionPattern pattern) throws ParserCreationException {
        int length = 1;
        CallStack stack = new CallStack();
        stack.push(pattern.getName(), 1);
        LookAheadSet result = new LookAheadSet(1);
        LookAheadSet[] alternatives = new LookAheadSet[pattern.getAlternativeCount()];
        int i = 0;
        while (i < pattern.getAlternativeCount()) {
            alternatives[i] = this.findLookAhead(pattern.getAlternative(i), 1, stack);
            result.addAll(alternatives[i]);
            ++i;
        }
        if (pattern.getLookAhead() == null) {
            pattern.setLookAhead(result);
        }
        LookAheadSet conflicts = this.findConflicts(pattern, 1);
        while (conflicts.size() > 0) {
            stack.clear();
            stack.push(pattern.getName(), ++length);
            i = 0;
            while (i < pattern.getAlternativeCount()) {
                ProductionPatternAlternative alt = pattern.getAlternative(i);
                if (alternatives[i].intersects(conflicts)) {
                    alternatives[i] = this.findLookAhead(alt, length, stack);
                    alt.setLookAhead(alternatives[i]);
                }
                if (alternatives[i].intersects(conflicts)) {
                    if (pattern.getDefaultAlternative() == null) {
                        pattern.setDefaultAlternative(i);
                    } else if (pattern.getDefaultAlternative() != alt) {
                        throw new ParserCreationException("inherent ambiguity in " + pattern.getName());
                    }
                }
                ++i;
            }
            conflicts = this.findConflicts(pattern, length);
        }
        i = 0;
        while (i < pattern.getAlternativeCount()) {
            this.calculateLookAhead(pattern.getAlternative(i), 0);
            ++i;
        }
    }

    private void calculateLookAhead(ProductionPatternAlternative alt, int pos) throws ParserCreationException {
        int length = 1;
        if (pos >= alt.getElementCount()) {
            return;
        }
        ProductionPattern pattern = alt.getPattern();
        ProductionPatternElement elem = alt.getElement(pos);
        if (elem.getMinCount() == elem.getMaxCount()) {
            this.calculateLookAhead(alt, pos + 1);
            return;
        }
        LookAheadSet first = this.findLookAhead(elem, 1, new CallStack());
        LookAheadSet follow = this.findLookAhead(alt, 1, pos + 1, new CallStack());
        String location = pattern.getName() + " in element " + (pos + 1);
        LookAheadSet conflicts = this.findConflicts(location, first, follow);
        while (conflicts.size() > 0) {
            first = this.findLookAhead(elem, ++length, new CallStack());
            follow = this.findLookAhead(alt, length, pos + 1, new CallStack());
            first = first.createCombination(follow);
            elem.setLookAhead(first);
            if (first.intersects(conflicts)) {
                throw new ParserCreationException("inherent ambiguity in " + location);
            }
            conflicts = this.findConflicts(location, first, follow);
        }
        this.calculateLookAhead(alt, pos + 1);
    }

    private LookAheadSet findLookAhead(ProductionPattern pattern, int length, CallStack stack) throws ParserCreationException {
        if (stack.contains(pattern.getName(), length)) {
            throw new ParserCreationException("infinite grammar loop in '" + pattern.getName() + "'");
        }
        LookAheadSet result = pattern.getLookAhead();
        if (result != null) {
            if (length == result.getMaxLength()) {
                return result;
            }
            if (length < result.getMaxLength()) {
                return new LookAheadSet(length, result);
            }
        }
        stack.push(pattern.getName(), length);
        result = new LookAheadSet(length);
        int i = 0;
        while (i < pattern.getAlternativeCount()) {
            LookAheadSet temp = this.findLookAhead(pattern.getAlternative(i), length, stack);
            result.addAll(temp);
            ++i;
        }
        if (pattern.getLookAhead() == null) {
            pattern.setLookAhead(result);
        }
        stack.pop();
        return result;
    }

    private LookAheadSet findLookAhead(ProductionPatternAlternative alt, int length, CallStack stack) throws ParserCreationException {
        LookAheadSet result = alt.getLookAhead();
        if (result != null) {
            if (length == result.getMaxLength()) {
                return result;
            }
            if (length < result.getMaxLength()) {
                return new LookAheadSet(length, result);
            }
        }
        result = this.findLookAhead(alt, length, 0, stack);
        if (alt.getLookAhead() == null) {
            alt.setLookAhead(result);
        }
        return result;
    }

    private LookAheadSet findLookAhead(ProductionPatternAlternative alt, int length, int pos, CallStack stack) throws ParserCreationException {
        if (length <= 0 || pos >= alt.getElementCount()) {
            return new LookAheadSet(0);
        }
        LookAheadSet first = this.findLookAhead(alt.getElement(pos), length, stack);
        if (alt.getElement(pos).getMinCount() == 0) {
            first.addEmpty();
        }
        if ((length -= first.getMinLength()) <= 0) {
            return first;
        }
        LookAheadSet follow = this.findLookAhead(alt, length, pos + 1, stack);
        return first.createCombination(follow);
    }

    private LookAheadSet findLookAhead(ProductionPatternElement elem, int length, CallStack stack) throws ParserCreationException {
        LookAheadSet base;
        if (elem.isToken()) {
            base = new LookAheadSet(length);
            base.add(elem.getId());
        } else {
            ProductionPattern pattern = this.getPattern(elem.getId());
            base = this.findLookAhead(pattern, length, stack);
            if (stack.contains(pattern.getName())) {
                base = base.createRepetitive();
            }
        }
        LookAheadSet result = new LookAheadSet(length);
        result.addAll(base);
        if (elem.getMaxCount() == Integer.MAX_VALUE) {
            base = base.createRepetitive();
        }
        int max = Math.min(length, elem.getMaxCount());
        int i = 1;
        while (i < max) {
            base = base.createCombination(base);
            result.addAll(base);
            ++i;
        }
        return result;
    }

    private LookAheadSet findConflicts(ProductionPattern pattern, int maxLength) throws ParserCreationException {
        LookAheadSet result = new LookAheadSet(maxLength);
        int i = 0;
        while (i < pattern.getAlternativeCount()) {
            LookAheadSet set1 = pattern.getAlternative(i).getLookAhead();
            int j = 0;
            while (j < i) {
                LookAheadSet set2 = pattern.getAlternative(j).getLookAhead();
                result.addAll(set1.createIntersection(set2));
                ++j;
            }
            ++i;
        }
        if (result.isRepetitive()) {
            throw new ParserCreationException("inherent ambiguity in " + pattern.getName());
        }
        return result;
    }

    private LookAheadSet findConflicts(String location, LookAheadSet set1, LookAheadSet set2) throws ParserCreationException {
        LookAheadSet result = set1.createIntersection(set2);
        if (result.isRepetitive()) {
            throw new ParserCreationException("inherent ambiguity in " + location);
        }
        return result;
    }

    private LookAheadSet findUnion(ProductionPattern pattern) {
        LookAheadSet result;
        int length = 0;
        int i = 0;
        while (i < pattern.getAlternativeCount()) {
            result = pattern.getAlternative(i).getLookAhead();
            if (result.getMaxLength() > length) {
                length = result.getMaxLength();
            }
            ++i;
        }
        result = new LookAheadSet(length);
        i = 0;
        while (i < pattern.getAlternativeCount()) {
            result.addAll(pattern.getAlternative(i).getLookAhead());
            ++i;
        }
        return result;
    }

    private class CallStack {
        private ArrayList nameStack = new ArrayList();
        private ArrayList valueStack = new ArrayList();

        private CallStack() {
        }

        public boolean contains(String name) {
            return this.nameStack.contains(name);
        }

        public boolean contains(String name, int value) {
            Integer obj = new Integer(value);
            int i = 0;
            while (i < this.nameStack.size()) {
                if (this.nameStack.get(i).equals(name) && this.valueStack.get(i).equals(obj)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void clear() {
            this.nameStack.clear();
            this.valueStack.clear();
        }

        public void push(String name, int value) {
            this.nameStack.add(name);
            this.valueStack.add(new Integer(value));
        }

        public void pop() {
            if (this.nameStack.size() > 0) {
                this.nameStack.remove(this.nameStack.size() - 1);
                this.valueStack.remove(this.valueStack.size() - 1);
            }
        }
    }
}

