/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import net.percederberg.grammatica.FirstPassAnalyzer;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.GrammarParser;
import net.percederberg.grammatica.SecondPassAnalyzer;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.RecursiveDescentParser;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.Tokenizer;

public class Grammar {
    public static final String AUTHOR_DECLARATION = "AUTHOR";
    public static final String COPYRIGHT_DECLARATION = "COPYRIGHT";
    public static final String DATE_DECLARATION = "DATE";
    public static final String DESCRIPTION_DECLARATION = "DESCRIPTION";
    public static final String GRAMMAR_TYPE_DECLARATION = "GRAMMARTYPE";
    public static final String LICENSE_DECLARATION = "LICENSE";
    public static final String VERSION_DECLARATION = "VERSION";
    private String fileName = "";
    private HashMap declarations = new HashMap();
    private Vector tokens = new Vector();
    private HashMap tokenNames = new HashMap();
    private HashMap tokenPatterns = new HashMap();
    private Vector productions = new Vector();
    private HashMap productionNames = new HashMap();

    public Grammar(File file) throws FileNotFoundException, GrammarException {
        FirstPassAnalyzer first = new FirstPassAnalyzer(this);
        SecondPassAnalyzer second = new SecondPassAnalyzer(this);
        this.fileName = file.getName();
        try {
            GrammarParser parser = new GrammarParser(new FileReader(file), (Analyzer)first);
            second.analyze(parser.parse());
        }
        catch (ParserCreationException e) {
            throw new GrammarException("couldn't create grammar parser: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new GrammarException("couldn't parse grammar: " + e.getMessage());
        }
        this.verify();
    }

    private void verify() throws GrammarException {
        String type = (String)this.declarations.get(GRAMMAR_TYPE_DECLARATION);
        if (type == null) {
            throw new GrammarException("grammar header missing GRAMMARTYPE declaration");
        }
        if (!type.equals("LL")) {
            throw new GrammarException("unrecognized GRAMMARTYPE value: '" + type + "', currently only 'LL' is supported");
        }
        if (this.productions.size() > 0) {
            try {
                this.createParser(this.createTokenizer(null));
            }
            catch (ParserCreationException e) {
                throw new GrammarException(e.getMessage());
            }
        }
    }

    public Tokenizer createTokenizer(Reader in) throws ParserCreationException {
        Tokenizer tokenizer = new Tokenizer(in);
        int i = 0;
        while (i < this.tokens.size()) {
            tokenizer.addPattern((TokenPattern)this.tokens.get(i));
            ++i;
        }
        return tokenizer;
    }

    public Parser createParser(Tokenizer tokenizer) throws ParserCreationException {
        RecursiveDescentParser parser = new RecursiveDescentParser(tokenizer);
        int i = 0;
        while (i < this.productions.size()) {
            ((Parser)parser).addPattern((ProductionPattern)this.productions.get(i));
            ++i;
        }
        ((Parser)parser).prepare();
        return parser;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDeclaration(String name) {
        return (String)this.declarations.get(name);
    }

    public int getTokenPatternCount() {
        return this.tokens.size();
    }

    public TokenPattern getTokenPattern(int pos) {
        return (TokenPattern)this.tokens.get(pos);
    }

    public TokenPattern getTokenPattern(String name) {
        return (TokenPattern)this.tokenNames.get(name);
    }

    TokenPattern getTokenPatternByImage(String image) {
        return (TokenPattern)this.tokenPatterns.get(image);
    }

    public int getProductionPatternCount() {
        return this.productions.size();
    }

    public ProductionPattern getProductionPattern(int pos) {
        return (ProductionPattern)this.productions.get(pos);
    }

    public ProductionPattern getProductionPattern(String name) {
        return (ProductionPattern)this.productionNames.get(name);
    }

    void addDeclarations(String name, String value) {
        this.declarations.put(name, value);
    }

    void addToken(TokenPattern token) {
        this.tokens.add(token);
        this.tokenNames.put(token.getName(), token);
        if (token.getType() == 1) {
            this.tokenPatterns.put(token.getPattern(), token);
        }
    }

    void addProduction(ProductionPattern production) {
        this.productions.add(production);
        this.productionNames.put(production.getName(), production);
    }
}

