/*
 * GrammarParser.java
 * 
 * THIS FILE HAS BEEN GENERATED AUTOMATICALLY. DO NOT EDIT!
 * 
 * This work is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This work is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * As a special exception, the copyright holders of this library give
 * you permission to link this library with independent modules to
 * produce an executable, regardless of the license terms of these
 * independent modules, and to copy and distribute the resulting
 * executable under terms of your choice, provided that you also meet,
 * for each linked independent module, the terms and conditions of the
 * license of that module. An independent module is a module which is
 * not derived from or based on this library. If you modify this
 * library, you may extend this exception to your version of the
 * library, but you are not obligated to do so. If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.grammatica;

import java.io.Reader;

import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternRule;
import net.percederberg.grammatica.parser.RecursiveDescentParser;

/**
 * A token stream parser.
 * 
 * @author   Per Cederberg, <per at percederberg dot net>
 * @version  1.0
 */
class GrammarParser extends RecursiveDescentParser {

    /**
     * A generated production node identity constant.
     */
    private static final int SUBPRODUCTION_1 = 3001;

    /**
     * A generated production node identity constant.
     */
    private static final int SUBPRODUCTION_2 = 3002;

    /**
     * A generated production node identity constant.
     */
    private static final int SUBPRODUCTION_3 = 3003;

    /**
     * Creates a new parser.
     * 
     * @param in             the input stream to read from
     * 
     * @throws ParserCreationException if the parser couldn't be
     *             initialized correctly
     */
    public GrammarParser(Reader in) throws ParserCreationException {
        super(new GrammarTokenizer(in));
        createPatterns();
    }

    /**
     * Creates a new parser.
     * 
     * @param in             the input stream to read from
     * @param analyzer       the analyzer to use while parsing
     * 
     * @throws ParserCreationException if the parser couldn't be
     *             initialized correctly
     */
    public GrammarParser(Reader in, Analyzer analyzer)
        throws ParserCreationException {

        super(new GrammarTokenizer(in), analyzer);
        createPatterns();
    }

    /**
     * Initializes the parser by creating all the production patterns.
     * 
     * @throws ParserCreationException if the parser couldn't be
     *             initialized correctly
     */
    private void createPatterns() throws ParserCreationException {
        ProductionPattern      pattern;
        ProductionPatternRule  rule;

        pattern = new ProductionPattern(GrammarConstants.GRAMMAR,
                                        "Grammar");
        rule = new ProductionPatternRule();
        rule.addProduction(GrammarConstants.HEADER_PART, 0, 1);
        rule.addProduction(GrammarConstants.TOKEN_PART, 1, 1);
        rule.addProduction(GrammarConstants.PRODUCTION_PART, 0, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.HEADER_PART,
                                        "HeaderPart");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.HEADER, 1, 1);
        rule.addProduction(GrammarConstants.HEADER_DECLARATION, 0, -1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.HEADER_DECLARATION,
                                        "HeaderDeclaration");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.IDENTIFIER, 1, 1);
        rule.addToken(GrammarConstants.EQUALS, 1, 1);
        rule.addToken(GrammarConstants.QUOTED_STRING, 1, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.TOKEN_PART,
                                        "TokenPart");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.TOKENS, 1, 1);
        rule.addProduction(GrammarConstants.TOKEN_DECLARATION, 0, -1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.TOKEN_DECLARATION,
                                        "TokenDeclaration");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.IDENTIFIER, 1, 1);
        rule.addToken(GrammarConstants.EQUALS, 1, 1);
        rule.addProduction(GrammarConstants.TOKEN_VALUE, 1, 1);
        rule.addProduction(GrammarConstants.TOKEN_HANDLING, 0, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.TOKEN_VALUE,
                                        "TokenValue");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.QUOTED_STRING, 1, 1);
        pattern.addRule(rule);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.REGEXP, 1, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.TOKEN_HANDLING,
                                        "TokenHandling");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.IGNORE, 1, 1);
        pattern.addRule(rule);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.ERROR, 1, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.PRODUCTION_PART,
                                        "ProductionPart");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.PRODUCTIONS, 1, 1);
        rule.addProduction(GrammarConstants.PRODUCTION_DECLARATION, 0, -1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.PRODUCTION_DECLARATION,
                                        "ProductionDeclaration");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.IDENTIFIER, 1, 1);
        rule.addToken(GrammarConstants.EQUALS, 1, 1);
        rule.addProduction(GrammarConstants.PRODUCTION, 1, 1);
        rule.addToken(GrammarConstants.SEMICOLON, 1, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.PRODUCTION,
                                        "Production");
        rule = new ProductionPatternRule();
        rule.addProduction(GrammarConstants.PRODUCTION_ATOM, 1, -1);
        rule.addProduction(SUBPRODUCTION_1, 0, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(GrammarConstants.PRODUCTION_ATOM,
                                        "ProductionAtom");
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.IDENTIFIER, 1, 1);
        rule.addProduction(SUBPRODUCTION_2, 0, 1);
        pattern.addRule(rule);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.QUOTED_STRING, 1, 1);
        pattern.addRule(rule);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.LEFT_PAREN, 1, 1);
        rule.addProduction(GrammarConstants.PRODUCTION, 1, 1);
        rule.addToken(GrammarConstants.RIGHT_PAREN, 1, 1);
        rule.addProduction(SUBPRODUCTION_3, 0, 1);
        pattern.addRule(rule);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.LEFT_BRACE, 1, 1);
        rule.addProduction(GrammarConstants.PRODUCTION, 1, 1);
        rule.addToken(GrammarConstants.RIGHT_BRACE, 1, 1);
        pattern.addRule(rule);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.LEFT_BRACKET, 1, 1);
        rule.addProduction(GrammarConstants.PRODUCTION, 1, 1);
        rule.addToken(GrammarConstants.RIGHT_BRACKET, 1, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(SUBPRODUCTION_1,
                                        "Subproduction1");
        pattern.setSyntetic(true);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.VERTICAL_BAR, 1, 1);
        rule.addProduction(GrammarConstants.PRODUCTION, 1, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(SUBPRODUCTION_2,
                                        "Subproduction2");
        pattern.setSyntetic(true);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.ASTERISK, 1, 1);
        pattern.addRule(rule);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.PLUS_SIGN, 1, 1);
        pattern.addRule(rule);
        addPattern(pattern);

        pattern = new ProductionPattern(SUBPRODUCTION_3,
                                        "Subproduction3");
        pattern.setSyntetic(true);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.ASTERISK, 1, 1);
        pattern.addRule(rule);
        rule = new ProductionPatternRule();
        rule.addToken(GrammarConstants.PLUS_SIGN, 1, 1);
        pattern.addRule(rule);
        addPattern(pattern);
    }
}
