/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.ProductionPatternRule;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public abstract class Parser {
    private Tokenizer tokenizer;
    private Analyzer analyzer;
    private int start = 0;
    private HashMap patterns = new HashMap();
    private ArrayList tokens = new ArrayList();

    protected Parser(Tokenizer tokenizer) {
        this(tokenizer, new Analyzer());
    }

    protected Parser(Tokenizer tokenizer, Analyzer analyzer) {
        this.tokenizer = tokenizer;
        this.analyzer = analyzer;
    }

    public void addPattern(ProductionPattern pattern) throws ParserCreationException {
        Integer id = new Integer(pattern.getId());
        if (pattern.getRuleCount() <= 0) {
            throw new ParserCreationException("cannot add production pattern '" + pattern.getName() + "' as it doesn't contain any production rules");
        }
        if (this.patterns.size() == 0) {
            this.start = pattern.getId();
        }
        if (this.patterns.containsKey(id)) {
            throw new ParserCreationException("cannot add production pattern '" + pattern.getName() + "' as another pattern with id " + id + " has already " + "been added");
        }
        this.patterns.put(id, pattern);
    }

    public void prepare() throws ParserCreationException {
        if (this.patterns.size() == 0) {
            throw new ParserCreationException("no production patterns have been added");
        }
        Iterator iter = this.patterns.values().iterator();
        while (iter.hasNext()) {
            this.checkPattern((ProductionPattern)iter.next());
        }
    }

    private void checkPattern(ProductionPattern pattern) throws ParserCreationException {
        int i = 0;
        while (i < pattern.getRuleCount()) {
            this.checkRule(pattern.getName(), pattern.getRule(i));
            ++i;
        }
    }

    private void checkRule(String name, ProductionPatternRule rule) throws ParserCreationException {
        int i = 0;
        while (i < rule.getElementCount()) {
            this.checkElement(name, rule.getElement(i));
            ++i;
        }
    }

    private void checkElement(String name, ProductionPatternElement elem) throws ParserCreationException {
        if (elem.isProduction() && this.getPattern(elem.getId()) == null) {
            throw new ParserCreationException("production pattern " + name + " refers to an " + "undefined production pattern: " + elem.getId());
        }
    }

    public abstract Node parse() throws ParserCreationException, ParseException;

    protected ProductionPattern getPattern(int id) {
        Integer value = new Integer(id);
        return (ProductionPattern)this.patterns.get(value);
    }

    protected ProductionPattern getStartPattern() {
        return this.getPattern(this.start);
    }

    protected Collection getPatterns() {
        return this.patterns.values();
    }

    protected void enterNode(Node node) throws ParseException {
        if (!node.isHidden()) {
            this.analyzer.enter(node);
        }
    }

    protected Node exitNode(Node node) throws ParseException {
        if (node.isHidden()) {
            return node;
        }
        return this.analyzer.exit(node);
    }

    protected void addNode(Production node, Node child) throws ParseException {
        if (node.isHidden()) {
            node.addChild(child);
        } else if (child != null && child.isHidden()) {
            int i = 0;
            while (i < child.getChildCount()) {
                this.addNode(node, child.getChildAt(i));
                ++i;
            }
        } else {
            this.analyzer.child(node, child);
        }
    }

    protected Token nextToken() throws ParseException {
        Token token = this.peekToken(0);
        if (token != null) {
            this.tokens.remove(0);
            return token;
        }
        throw new ParseException(2, null, this.tokenizer.getCurrentLine(), this.tokenizer.getCurrentColumn());
    }

    protected Token nextToken(int id) throws ParseException {
        Token token = this.nextToken();
        if (token.getId() == id) {
            return token;
        }
        throw new ParseException(4, token.getImage(), token.getStartLine(), token.getStartColumn());
    }

    protected Token peekToken(int steps) throws ParseException {
        while (steps >= this.tokens.size()) {
            Token token = this.tokenizer.next();
            if (token == null) {
                return null;
            }
            this.tokens.add(token);
        }
        return (Token)this.tokens.get(steps);
    }
}

