/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

public class ParseException
extends Exception {
    public static final int INTERNAL_ERROR = 0;
    public static final int IO_ERROR = 1;
    public static final int UNEXPECTED_EOF_ERROR = 2;
    public static final int UNEXPECTED_CHAR_ERROR = 3;
    public static final int UNEXPECTED_TOKEN_ERROR = 4;
    public static final int INVALID_TOKEN_ERROR = 5;
    public static final int ANALYSIS_ERROR = 6;
    private int type;
    private String info;
    private int line;
    private int column;

    public ParseException(int type, String info, int line, int column) {
        this.type = type;
        this.info = info;
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        switch (this.type) {
            case 1: {
                buffer.append("I/O error: ");
                buffer.append(this.info);
                break;
            }
            case 2: {
                buffer.append("unexpected end of file");
                break;
            }
            case 3: {
                buffer.append("unexpected character: '");
                buffer.append(this.info);
                buffer.append("'");
                break;
            }
            case 4: {
                buffer.append("unexpected token: '");
                buffer.append(this.info);
                buffer.append("'");
                break;
            }
            case 5: {
                buffer.append(this.info);
                break;
            }
            case 6: {
                buffer.append(this.info);
                break;
            }
            default: {
                buffer.append("internal error");
            }
        }
        if (this.line > 0 && this.column > 0) {
            buffer.append(", on line: ");
            buffer.append(this.line);
            buffer.append(" column: ");
            buffer.append(this.column);
        }
        return buffer.toString();
    }
}

