/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaConstructor;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaImport;
import net.percederberg.grammatica.code.java.JavaMethod;
import net.percederberg.grammatica.output.JavaConstantsFile;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.parser.TokenPattern;

class JavaTokenizerFile {
    private static final String CLASS_COMMENT = "A character stream tokenizer.";
    private static final String CONSTRUCTOR_COMMENT = "Creates a new tokenizer for the specified input stream.\n\n@param in             the input stream to read\n\n@throws ParserCreationException if the tokenizer couldn't be\n            initialized correctly";
    private static final String INIT_METHOD_COMMENT = "Initializes the tokenizer by creating all the token patterns.\n\n@throws ParserCreationException if the tokenizer couldn't be\n            initialized correctly";
    private JavaParserGenerator gen;
    private JavaFile file;
    private JavaClass cls;
    private JavaMethod initMethod;

    public JavaTokenizerFile(JavaParserGenerator gen) {
        this.gen = gen;
        this.file = gen.createJavaFile();
        int modifiers = gen.getPublicAccess() ? 0 : 2;
        this.cls = new JavaClass(modifiers, gen.getBaseName() + "Tokenizer", "Tokenizer");
        this.initMethod = new JavaMethod(3, "createPatterns", "", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addImport(new JavaImport("java.io", "Reader"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ParserCreationException"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "TokenPattern"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Tokenizer"));
        this.file.addClass(this.cls);
        String str = CLASS_COMMENT;
        if (this.gen.getClassComment() != null) {
            str = str + "\n\n" + this.gen.getClassComment();
        }
        this.cls.addComment(new JavaComment(str));
        str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new JavaComment(1, str));
        JavaConstructor constr = new JavaConstructor("Reader in");
        this.cls.addConstructor(constr);
        constr.addComment(new JavaComment(CONSTRUCTOR_COMMENT));
        constr.addThrows("ParserCreationException");
        constr.addCode("super(in);");
        constr.addCode("createPatterns();");
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new JavaComment(INIT_METHOD_COMMENT));
        this.initMethod.addThrows("ParserCreationException");
        this.initMethod.addCode("TokenPattern  pattern;");
    }

    public void addToken(TokenPattern pattern, JavaConstantsFile constants) {
        StringBuffer code = new StringBuffer();
        code.append("pattern = new TokenPattern(");
        code.append(constants.getConstant(pattern.getId()));
        code.append(",\n");
        code.append("                           \"");
        code.append(pattern.getName());
        code.append("\",\n");
        code.append("                           TokenPattern.");
        switch (pattern.getType()) {
            case 1: {
                code.append("STRING_TYPE");
                break;
            }
            case 2: {
                code.append("REGEXP_TYPE");
            }
        }
        code.append(",\n");
        code.append("                           ");
        String str = pattern.getPattern();
        code.append(this.gen.getCodeStyle().getStringConstant(str));
        code.append(");\n");
        if (pattern.isError()) {
            code.append("pattern.setError(");
            if (pattern.getErrorMessage() != null) {
                str = pattern.getErrorMessage();
                code.append(this.gen.getCodeStyle().getStringConstant(str));
            }
            code.append(");\n");
        }
        if (pattern.isIgnore()) {
            code.append("pattern.setIgnore(");
            if (pattern.getIgnoreMessage() != null) {
                str = pattern.getIgnoreMessage();
                code.append(this.gen.getCodeStyle().getStringConstant(str));
            }
            code.append(");\n");
        }
        code.append("addPattern(pattern);");
        this.initMethod.addCode("");
        this.initMethod.addCode(code.toString());
    }

    protected String getConstructorCall(String param) {
        return "new " + this.gen.getBaseName() + "Tokenizer(" + param + ")";
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

