/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaConstructor;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaImport;
import net.percederberg.grammatica.code.java.JavaMethod;
import net.percederberg.grammatica.code.java.JavaVariable;
import net.percederberg.grammatica.output.JavaConstantsFile;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.output.JavaTokenizerFile;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.ProductionPatternRule;

class JavaParserFile {
    private static final String CLASS_COMMENT = "A token stream parser.";
    private static final String PRODUCTION_COMMENT = "A generated production node identity constant.";
    private static final String CONSTRUCTOR1_COMMENT = "Creates a new parser.\n\n@param in             the input stream to read from\n\n@throws ParserCreationException if the parser couldn't be\n            initialized correctly";
    private static final String CONSTRUCTOR2_COMMENT = "Creates a new parser.\n\n@param in             the input stream to read from\n@param analyzer       the analyzer to use while parsing\n\n@throws ParserCreationException if the parser couldn't be\n            initialized correctly";
    private static final String INIT_METHOD_COMMENT = "Initializes the parser by creating all the production patterns.\n\n@throws ParserCreationException if the parser couldn't be\n            initialized correctly";
    private JavaParserGenerator gen;
    private JavaTokenizerFile tokenizer;
    private JavaFile file;
    private JavaClass cls;
    private JavaMethod initMethod;
    private HashMap constantNames = new HashMap();
    private int constantId = 1;

    public JavaParserFile(JavaParserGenerator gen, JavaTokenizerFile tokenizer) {
        this.gen = gen;
        this.tokenizer = tokenizer;
        this.file = gen.createJavaFile();
        int modifiers = gen.getPublicAccess() ? 0 : 2;
        this.cls = new JavaClass(modifiers, gen.getBaseName() + "Parser", "RecursiveDescentParser");
        this.initMethod = new JavaMethod(3, "createPatterns", "", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addImport(new JavaImport("java.io", "Reader"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Analyzer"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ParserCreationException"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ProductionPattern"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ProductionPatternRule"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "RecursiveDescentParser"));
        this.file.addClass(this.cls);
        String str = CLASS_COMMENT;
        if (this.gen.getClassComment() != null) {
            str = str + "\n\n" + this.gen.getClassComment();
        }
        this.cls.addComment(new JavaComment(str));
        str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new JavaComment(1, str));
        JavaConstructor constr = new JavaConstructor("Reader in");
        this.cls.addConstructor(constr);
        constr.addComment(new JavaComment(CONSTRUCTOR1_COMMENT));
        constr.addThrows("ParserCreationException");
        constr.addCode("super(" + this.tokenizer.getConstructorCall("in") + ");");
        constr.addCode("createPatterns();");
        constr = new JavaConstructor("Reader in, Analyzer analyzer");
        this.cls.addConstructor(constr);
        constr.addComment(new JavaComment(CONSTRUCTOR2_COMMENT));
        constr.addThrows("ParserCreationException");
        constr.addCode("super(" + this.tokenizer.getConstructorCall("in") + ", analyzer);");
        constr.addCode("createPatterns();");
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new JavaComment(INIT_METHOD_COMMENT));
        this.initMethod.addThrows("ParserCreationException");
        this.initMethod.addCode("ProductionPattern      pattern;");
        this.initMethod.addCode("ProductionPatternRule  rule;");
    }

    public void addProductionConstant(ProductionPattern pattern) {
        Integer id = new Integer(pattern.getId());
        if (pattern.isSyntetic()) {
            String constant = "SUBPRODUCTION_" + this.constantId;
            int modifiers = 23;
            JavaVariable var = new JavaVariable(modifiers, "int", constant, String.valueOf(this.constantId + 3000));
            var.addComment(new JavaComment(PRODUCTION_COMMENT));
            this.cls.addVariable(var);
            this.constantNames.put(new Integer(pattern.getId()), constant);
            ++this.constantId;
        }
    }

    public void addProduction(ProductionPattern pattern, JavaConstantsFile constants) {
        StringBuffer code = new StringBuffer();
        code.append("pattern = new ProductionPattern(");
        code.append(this.getConstant(constants, pattern.getId()));
        code.append(",\n");
        code.append("                                \"");
        if (pattern.isSyntetic()) {
            String str = this.getConstant(constants, pattern.getId());
            code.append(this.gen.getCodeStyle().getMixedCase(str, true));
        } else {
            code.append(pattern.getName());
        }
        code.append("\");");
        this.initMethod.addCode("");
        this.initMethod.addCode(code.toString());
        if (pattern.isSyntetic()) {
            this.initMethod.addCode("pattern.setSyntetic(true);");
        }
        int i = 0;
        while (i < pattern.getRuleCount()) {
            this.addProductionRule(pattern.getRule(i), constants);
            ++i;
        }
        this.initMethod.addCode("addPattern(pattern);");
    }

    private void addProductionRule(ProductionPatternRule rule, JavaConstantsFile constants) {
        this.initMethod.addCode("rule = new ProductionPatternRule();");
        int i = 0;
        while (i < rule.getElementCount()) {
            ProductionPatternElement elem = rule.getElement(i);
            StringBuffer code = new StringBuffer();
            code.append("rule.");
            if (elem.isToken()) {
                code.append("addToken(");
            } else {
                code.append("addProduction(");
            }
            code.append(this.getConstant(constants, elem.getId()));
            code.append(", ");
            code.append(elem.getMinCount());
            code.append(", ");
            if (elem.getMaxCount() == Integer.MAX_VALUE) {
                code.append("-1");
            } else {
                code.append(elem.getMaxCount());
            }
            code.append(");");
            this.initMethod.addCode(code.toString());
            ++i;
        }
        this.initMethod.addCode("pattern.addRule(rule);");
    }

    private String getConstant(JavaConstantsFile constants, int id) {
        Integer value = new Integer(id);
        if (this.constantNames.containsKey(value)) {
            return (String)this.constantNames.get(value);
        }
        return constants.getConstant(id);
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

