/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.ParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

public class CSharpParserGenerator
extends ParserGenerator {
    private String baseName = null;
    private String namespace = null;

    public CSharpParserGenerator(Grammar grammar) {
        super(grammar);
        this.initialize();
    }

    private void initialize() {
        String str = this.getGrammar().getFileName();
        if (str.indexOf(46) > 0) {
            str = str.substring(0, str.indexOf(46));
        }
        if (Character.isLowerCase(str.charAt(0))) {
            str = Character.toUpperCase(str.charAt(0)) + str.substring(1);
        }
        this.baseName = str;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name) {
        this.baseName = name;
    }

    public CodeStyle getCodeStyle() {
        return CodeStyle.CSHARP;
    }

    public void write() throws IOException {
        Grammar grammar = this.getGrammar();
        CSharpConstantsFile constants = new CSharpConstantsFile(this);
        int i = 0;
        while (i < grammar.getTokenPatternCount()) {
            TokenPattern token = grammar.getTokenPattern(i);
            constants.addToken(token);
            ++i;
        }
        i = 0;
        while (i < grammar.getProductionPatternCount()) {
            ProductionPattern production = grammar.getProductionPattern(i);
            constants.addProduction(production);
            ++i;
        }
        constants.writeCode();
    }
}

