/* spopen.h - this file is part of the gpg-secml package.
   Copyright (C) 2007 Moritz Schulte <moritz@gnu.org>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#ifndef SECML_SPOPEN_H
#define SECML_SPOPEN_H

typedef struct
{
  FILE *readfp;
  pid_t pid;
  char *pgm;
} spopen_read_t;

int secure_popen_read (const char *pgmname,
		       const char *argv[],
		       spopen_read_t *spopen_obj);

int secure_pclose_read (spopen_read_t spopen_obj);

#endif
