/* stringlist.c - this file is part of the gpg-secml package.
   Copyright (C) 2007 Moritz Schulte <moritz@gnu.org>

   gpg-secml is  free software; you can redistribute  it and/or modify
   it under the  terms of the GNU General  Public License as published
   by the Free  Software Foundation; either version 2  of the License,
   or (at your option) any later version.

   gpg-secml is  distributed in the hope  that it will  be useful, but
   WITHOUT  ANY  WARRANTY;  without   even  the  implied  warranty  of
   MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU
   General Public License for more details.

   You should have  received a copy of the  GNU General Public License
   along  with   gpg-secml;  if  not,  write  to   the  Free  Software
   Foundation,  Inc.,   51  Franklin  St,  Fifth   Floor,  Boston,  MA
   02110-1301 USA  */

#include <config.h>

#include <stdlib.h>
#include <string.h>

#include "stringlist.h"
#include "myassert.h"

/* Return the number of elements in SLIST.  This does NOT include the
   terminating NULL element.  */
int
slist_count (char **slist)
{
  int i;

  for (i = 0; slist[i]; i++)
    ;

  return i;
}

/* Return a new, empty slist.  */
char **
slist_create (void)
{
  char **slist;

  slist = malloc (sizeof (char *));
  MYASSERT (slist, "Failed to allocate new slist");
  slist[0] = NULL;

  return slist;
}

/* Deallocate resources associated with SLIST.  SLIST may be NULL.  */
void
slist_destroy (char **slist)
{
  int i;

  if (! slist)
    return;

  for (i = 0; slist[i]; i++)
    free (slist[i]);
  free (slist);
}

char **
slist_append (char **slist, const char *elem)
{
  int slist_n;

  /* Make bigger.  */
  slist_n = slist_count (slist);
  slist = realloc (slist, sizeof (char *) * (slist_n + 2));
  MYASSERT (slist, "Failed to grow slist");

  slist[slist_n] = strdup (elem);
  MYASSERT (slist[slist_n], "Failed to strdup string for appending to slist");
  slist[slist_n+1] = NULL;

  return slist;
}

char **
slist_empty (char **slist)
{
  int i;

  for (i = 0; slist[i]; i++)
    free (slist[i]);

  slist = realloc (slist, sizeof (char *));
  MYASSERT (slist, "Failed to shrink slist");

  slist[0] = NULL;

  return slist;
}

char **
slist_concat (char **slist_a, char **slist_b)
{
  char **slist_c;
  int i;

  slist_c = slist_create ();

  for (i = 0; slist_a[i]; i++)
    slist_c = slist_append (slist_c, slist_a[i]);
  for (i = 0; slist_b[i]; i++)
    slist_c = slist_append (slist_c, slist_b[i]);

  return slist_c;
}

int
slist_disjunct_p (char **slist_a, char **slist_b)
{
  int disjunct_p = 1;		/* Empty sets are disjunct. ;-) */
  int i, j;

  for (i = 0; slist_a[i]; i++)
    for (j = 0; slist_b[j]; j++)
      if (strcmp (slist_a[i], slist_b[j]) == 0)
	{
	  /* Match. */
	  disjunct_p = 0;
	  break;
	}

  return disjunct_p;
}
