/* stringhelp.h
 * Copyright (C) 1998, 1999, 2000, 2001, 2003,
 *               2006, 2007  Free Software Foundation, Inc.
 *
 * This file is part of JNLIB.
 *
 * JNLIB is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 3 of
 * the License, or (at your option) any later version.
 *
 * JNLIB is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBJNLIB_STRINGHELP_H
#define LIBJNLIB_STRINGHELP_H

#include "types.h"

char *make_basename(const char *filepath, const char *inputpath);
char *make_dirname(const char *filepath);
char *make_filename( const char *first_part, ... );

#ifdef HAVE_W32_SYSTEM
const char *w32_strerror (int ec);
#endif


#ifndef HAVE_STPCPY
char *stpcpy(char *a,const char *b);
#endif
#ifndef HAVE_STRSEP
char *strsep (char **stringp, const char *delim);
#endif


#ifndef STR
#  define STR(v) #v
#endif
#define STR2(v) STR(v)

/****************
 * remove leading and trailing white spaces
 */
char *trim_spaces (char *str);

#endif /*LIBJNLIB_STRINGHELP_H*/
