#!/usr/bin/perl -w  # -*- cperl -*- #
#
#  info.pm - Show information about a song file.
#
#  GNU MP3D - A portable(ish) MP3 server.
#
# Homepage:
#   http://www.gnump3d.org/
#
# Author:
#  Steve Kemp <steve@steve.org.uk>
#
# Version:
#  $Id: info.pm,v 1.6 2005/05/01 21:39:21 skx Exp $
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  Steve Kemp
#  ---
#  http://www.steve.org.uk/
#
#



#
#  Return the author of this plugin.
#
sub getAuthor()
{
    return( 'Steve Kemp <steve@steve.org.uk>' );
}


#
#  Return the version of this plugin.
#
sub getVersion()
{
    my $REVISION      = '$Id: info.pm,v 1.6 2005/05/01 21:39:21 skx Exp $';
    my $VERSION       = "";
    $VERSION = join (' ', (split (' ', $REVISION))[1..3]);
    $VERSION =~ s/,v\b//;
    $VERSION =~ s/(\S+)$/($1)/;

    return( $VERSION );
}



#
#  Handle requests to this plugin.
#
sub handlePath( )
{
    my ( $uri ) = (@_);

    my $header   = &getHTTPHeader( 200, "text/html" );
    &sendData($data, $header );

    my $track = undef;

    #
    # Get the filename of the song to display information of.
    #
    if ( $uri =~ /\/info(.*)/ )
    {
	$track = $1;
    }

    #
    #  Make sure we got something.
    #
    if ( ( ! defined( $track ) ) ||
	 ( length( $track ) < 1 ) )
    {
	my $error = &getErrorPage( $ARGUMENTS{'theme'},
				   "No track specified." );
	&sendData( $data, $error );
	close( $data );
	exit 1;
    }

    # Preserve the song.
    my $play = $track;

    #
    # Get the local page.
    #
    $track = $ROOT . "/" . $track;

#    print "TRACK : 1 -> $track\n";

    # Remove duplicate slashes
    while ( $track =~ /(.*)\/\/(.*)/ )
    {
	$track = $1 . "/" . $2;
    }
    # Remove ..'s
    while( $track =~ /(.*)\/\.\.(.*)/ )
    {
	$track = $1 . $2;
    }

#    print "TRACK : 2 -> $track\n";

    if ( -d $track )
    {
        my $file = substr( $track, length( $ROOT ) );
        my $error = &getErrorPage( $ARGUMENTS{'theme'},
				 "Error '$file' is a directory." );
	&sendData( $data, $error );
	close( $data );
	exit 1;
    }

    if ( ! -e $track )
    {
	my $file = substr( $track, length( $ROOT ) );
	my $error = &getErrorPage( $ARGUMENTS{'theme'},
				   "The specified file ($file) does not exist." );
	&sendData( $data, $error );
	close( $data );
	exit 1;
    }

    my %TAGS = &infoGetFileTags( $track );

    my $output = "";
    $output .= "<table>\n";

    foreach my $key ( sort keys( %TAGS ) )
    {
	$output .= "<tr><td><b>$key</b></td><td>" . $TAGS{$key} . "</td></tr>\n";
    }
    $output .= "</table>\n";


    # Link to the parent directory.
    my $dir = "/";
    if ( $play =~ /(.*)\/(.*)/ )
    {
      $dir = $1 . "/";
    }

    # Link to the song.
    if ( getConfig( "always_stream", 1 ) )
    {
      $play .= ".m3u";
    }

    # Escape the filename and directory names correctly.
    $play = &urlEncode( $play );
    $dir  = &urlEncode( $dir );

    #
    # Now add some links to the bottom of the info.
    #
    $output .= "<p align='center'>[ <a href='$dir'>Visit Directory</a> | <a href='$play'>Play Track</a> ]</p>";

    my $text = "";


    my @template = &getThemeFile( $ARGUMENTS{'theme'}, "info.html" );
    foreach my $line (@template )
    {
	#
	# Make global substitutions.
	#
        $line =~ s/\$HEADER//g;
	$line =~ s/\$HOSTNAME/$host/g;
	$line =~ s/\$VERSION/$VERSION/g;
	$line =~ s/\$RELEASE/$RELEASE/g;
	$line =~ s/\$DIRECTORY/\/bug\//g;
	$line =~ s/\$HEADING/File Information/g;
	$line =~ s/\$TITLE/File Information/g;
	$line =~ s/\$META/$meta_tags/g;

	#
	# Now handle the special sections.
	#
	if ( $line =~ /(.*)\$BANNER(.*)/ )
	{
	    # Insert banner;
	    my $pre  = $1;
	    my $post = $2;

	    $text .= $pre;
	    $text .= &getBanner( "/info/" );
	    $text .= $post;
	}
	elsif ( $line =~ /(.*)\$TEXT(.*)/ )
	{
	    $text .= $1 . $output . $2;
	}
	else
	{
	    $text .= $line;
	}
    }

    &sendData($data, $text );
    close( $data );
    return 1;
}

#
#  Read the song tags
#
sub infoGetFileTags( $ )
{
    my ( $file ) = ( @_ );

    print "Finding info for '$file'\n";
    #
    # We read all our information from the tag cache file.
    #
    open( FILY, "<$tag_cache" )
      or die "Cannot read cache file $tag_cache - $!";
    my @LINES = <FILY>;
    close( FILY );


    # The tags we're going to return.
    my %TAGS;

    foreach my $line ( @LINES )
    {
	# Strip the newline.
	chomp( $line );

	#
	# If the line starts with the file we are interested in.
	#
	if ( ( $line =~ /^([^\t]+)\t(.*)/ ) and
	     ( $1 eq $file ) )
	{
	    my $data = $2;

	    my @NAMES = split( /\t/, $data );
	    foreach my $pair ( @NAMES )
	    {
		if ( ( $pair =~ /([A-Z]+)=(.*)/ ) &&
		     ( length( $2 ) ) )
		{
		    $TAGS{ $1 } = $2;
		}
	    }
	    return( %TAGS );
	}
    }

    # We've not found a match; so we'll return the empty
    # hash.
    return( %TAGS );
}

