# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'
# Contributor: "Rajiv Nair" <nair331@gmail.com>


def datatypes( type ):
    datatypes = []
    if type == 'all':
        datatypes = [ 
						[ 'int8',              '' ],
						[ 'bit',               '' ],
						[ 'varbit',            '' ],
						[ 'boolean',           '' ],
						[ 'box',               '' ],
						[ 'bytea',             '' ],
						[ 'varchar',           '' ],
						[ 'char',              '' ],
						[ 'cidr',              '' ],
						[ 'circle',            '' ],
						[ 'date',              '' ],
						[ 'float8',            '' ],
						[ 'inet',              '' ],
						[ 'int4',              '' ],
						[ 'interval',          '' ],
						[ 'line',              '' ],
						[ 'lseg',              '' ],
						[ 'macaddr',           '' ],
						[ 'money',             '' ],
						[ 'numeric',           '' ],
						[ 'path',              '' ],
						[ 'point',             '' ],
						[ 'polygon',           '' ],
						[ 'float4',            '' ],
						[ 'int2',              '' ],
						[ 'text',              '' ],
						[ 'time',              '' ],
						[ 'timestamptz',       '' ],
						[ 'abstime',           '' ],
						[ 'aclitem',           '' ],
						[ 'bpchar',            '' ],
						[ 'cid',               '' ],
						[ 'oid',               '' ],
						[ 'refcursor',         '' ],
						[ 'regclass',          '' ],
						[ 'regoper',           '' ],
						[ 'regoperator',       '' ],
						[ 'regproc',           '' ],
						[ 'regprocedure',      '' ],
						[ 'regtype',           '' ],
						[ 'reltime',           '' ],
						[ 'smgr',              '' ],
						[ 'tid',               '' ],
						[ 'timetz',            '' ],
						[ 'tinterval',         '' ],
						[ 'unknown',           '' ],
						[ 'xid',               '' ],
						[ 'int2vector',        '' ],
						[ 'name',              '' ],
						[ 'oidvector',         '' ],
						[ 'serial',            '' ],
						[ 'serial8',         '' ],
                                                [ 'int8[]',              '' ],
						[ 'bit[]',               '' ],
						[ 'varbit[]',            '' ],
						[ 'boolean[]',           '' ],
						[ 'box[]',               '' ],
						[ 'bytea[]',             '' ],
						[ 'varchar[]',           '' ],
						[ 'char[]',              '' ],
						[ 'cidr[]',              '' ],
						[ 'circle[]',            '' ],
						[ 'date[]',              '' ],
						[ 'float8[]',            '' ],
						[ 'inet[]',              '' ],
						[ 'int4[]',              '' ],
						[ 'interval[]',          '' ],
						[ 'line[]',              '' ],
						[ 'lseg[]',              '' ],
						[ 'macaddr[]',           '' ],
						[ 'money[]',             '' ],
						[ 'numeric[]',           '' ],
						[ 'path[]',              '' ],
						[ 'point[]',             '' ],
						[ 'polygon[]',           '' ],
						[ 'float4[]',            '' ],
						[ 'int2[]',              '' ],
						[ 'text[]',              '' ],
						[ 'time[]',              '' ],
						[ 'timestamptz[]',       '' ],
						[ 'abstime[]',           '' ],
						[ 'aclitem[]',           '' ],
						[ 'bpchar[]',            '' ],
						[ 'cid[]',               '' ],
						[ 'oid[]',               '' ],
						[ 'refcursor[]',         '' ],
						[ 'regclass[]',          '' ],
						[ 'regoper[]',           '' ],
						[ 'regoperator[]',       '' ],
						[ 'regproc[]',           '' ],
						[ 'regprocedure[]',      '' ],
						[ 'regtype[]',           '' ],
						[ 'reltime[]',           '' ],
						[ 'smgr[]',              '' ],
						[ 'tid[]',               '' ],
						[ 'timetz[]',            '' ],
						[ 'tinterval[]',         '' ],
						[ 'unknown[]',           '' ],
						[ 'xid[]',               '' ],
						[ 'int2vector[]',        '' ],
						[ 'name[]',              '' ],
						[ 'oidvector[]',         '' ],
						[ 'serial[]',            '' ],
						[ 'serial8[]',         '' ]
					]

    if type == 'array':
        datatypes = [ 
						[ 'int8[]',              '' ],
						[ 'bit[]',               '' ],
						[ 'varbit[]',            '' ],
						[ 'boolean[]',           '' ],
						[ 'box[]',               '' ],
						[ 'bytea[]',             '' ],
						[ 'varchar[]',           '' ],
						[ 'char[]',              '' ],
						[ 'cidr[]',              '' ],
						[ 'circle[]',            '' ],
						[ 'date[]',              '' ],
						[ 'float8[]',            '' ],
						[ 'inet[]',              '' ],
						[ 'int4[]',              '' ],
						[ 'interval[]',          '' ],
						[ 'line[]',              '' ],
						[ 'lseg[]',              '' ],
						[ 'macaddr[]',           '' ],
						[ 'money[]',             '' ],
						[ 'numeric[]',           '' ],
						[ 'path[]',              '' ],
						[ 'point[]',             '' ],
						[ 'polygon[]',           '' ],
						[ 'float4[]',            '' ],
						[ 'int2[]',              '' ],
						[ 'text[]',              '' ],
						[ 'time[]',              '' ],
						[ 'timestamptz[]',       '' ],
						[ 'abstime[]',           '' ],
						[ 'aclitem[]',           '' ],
						[ 'bpchar[]',            '' ],
						[ 'cid[]',               '' ],
						[ 'oid[]',               '' ],
						[ 'refcursor[]',         '' ],
						[ 'regclass[]',          '' ],
						[ 'regoper[]',           '' ],
						[ 'regoperator[]',       '' ],
						[ 'regproc[]',           '' ],
						[ 'regprocedure[]',      '' ],
						[ 'regtype[]',           '' ],
						[ 'reltime[]',           '' ],
						[ 'smgr[]',              '' ],
						[ 'tid[]',               '' ],
						[ 'timetz[]',            '' ],
						[ 'tinterval[]',         '' ],
						[ 'unknown[]',           '' ],
						[ 'xid[]',               '' ],
						[ 'int2vector[]',        '' ],
						[ 'name[]',              '' ],
						[ 'oidvector[]',         '' ],
						[ 'serial[]',            '' ],
						[ 'serial8[]',         '' ]
					]
        
	
    return datatypes

if __name__ == '__main__':
    print datatypes()
    

