# -*- coding: utf-8 -*- 

#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################



__author__ = """Jay Mehta <jay87.mehta@gmail.com>"""
__author__ = """Rajiv Nair <rajivnair@gnu.org>"""
__docformat__ = 'plaintext'



import psycopg2
import random
from GeneralMethods import *
from GetMethods import *

class SetMethods:
      def __init__(self , conString , userid ):
            self.constring = conString
            self.conn = psycopg2.connect( conString )   
            self.curs = self.conn.cursor() 
            self.uid = userid


      def checkmandatory(self,temp_dic):
                                       
          """
          this function checks if input dictionary has all necessary mandatory fields that the subjects classof or supertypeof specifies mandatory.
          """
          ssid_list=[]
          if temp_dic.has_key('instanceof'):
                ssid_list = temp_dic['instanceof'] 
         
          if temp_dic.has_key('subtypeof'):
                ssid_list = ssid_list + temp_dic['subtypeof']
          
          #print "input ssid_list",ssid_list
          if ssid_list==[]:
                return 1

          GetMethodsObj= GetMethods(self.constring)
          dic = GetMethodsObj.getNeighbourhood(ssid_list,'rendered_nbh')  

          req_mandatoryprops=[]

          values_list = dic.values()
          #print values_list
          for rendernbh_dic in values_list:
                if rendernbh_dic <> None:  
                      if rendernbh_dic.has_key('attributes'):
                            #print "rendernbh_dic---->",rendernbh_dic  
                            if rendernbh_dic['attributes'].has_key('mandatoryflds'):   
                                  req_mandatoryprops = req_mandatoryprops + rendernbh_dic['attributes']['mandatoryflds'][1]  
          #print "req_mandatoryprops",req_mandatoryprops              

          if req_mandatoryprops==[]:
                #print "req mandatory props  is null."
                return 1

          r_inid_list=[]
          if temp_dic.has_key('relation'):
             relntypenid_list=[]              
             for tuple in temp_dic['relation']:
                 relntypenid_list.append(tuple[0])
             r_inid_list = get_inid_from_nid(relntypenid_list,self.curs)
          #print "r_inid_list  ",r_inid_list  
             
          a_inid_list=[]
          if temp_dic.has_key('attributes'):
             attrssid_list=[]
             for tuple in temp_dic['attributes']:
                 attrssid_list.append(tuple[0])
             a_inid_list = get_inid_from_ssid(attrssid_list,self.curs)
          #print "a_inid_list  ",a_inid_list  

          if set( req_mandatoryprops )<= set(a_inid_list + r_inid_list):
                return 1
          else:
                return -1

      def set_relation(self,input):    
                #mandatory in input dictionary---'nodetype1_list and set_relation
                from Relation import relations
                obj = relations( self.constring , self.uid)
                input['uid'] = self.uid
                relntype_ssid = obj.start_checks(input['subject1'],input['subject2'],input['relationtypes'])
                if relntype_ssid!=-1:
                    subject2_inid_list = get_inid_from_ssid(input['subject2'],self.curs)       

                    if input.has_key('fatherList_of_subj1'):
                        final_dic = obj.startchecks_n_callwrite(input,relntype_ssid,input['subject1'],input['subject2'],subject2_inid_list,
                                                                                                          0,input['fatherList_of_subj1'])
                    else:
                        final_dic = obj.startchecks_n_callwrite(input,relntype_ssid,input['subject1'],input['subject2'],subject2_inid_list,0,0)
                        
                    if final_dic!=-1:
                        nodetype1_list = input ['nodetype1_list']  
                        nodetype2_list = final_dic['nodetype2_list']   
                        flag_inherit = final_dic['flag_inherit']
    
                        subj1ssid_relnssidlist_dic = final_dic['subj1ssid_relnssidlist_dic']
                        #print "subj1ssid_relnssidlist_dic",subj1ssid_relnssidlist_dic
                        subj2ssid_relnssidlist_dic = final_dic['subj2ssid_relnssidlist_dic']
                        #print "subj2ssid_relnssidlist_dic",subj2ssid_relnssidlist_dic

                        newRelnssidList_4_subj1List=[]             
                        for element_no in range(len(input['subject1'])):
                              newRelnssidList_4_subj1List.append(subj1ssid_relnssidlist_dic[input['subject1'][element_no]])

                        newRelnssidList_4_subj2List=[]
                        for element_no in range(len(input['subject2'])):
                              newRelnssidList_4_subj2List.append(subj2ssid_relnssidlist_dic[input['subject2'][element_no]])

                        #print " revising fields of  subject1 "
                        #making input['relationtypes']into a list as req 4 type_nid_list in revise_fields
                        rendernbhData_list = input['subject2']
                        # inheritance logic ---start                                             
                        if flag_inherit == 1:
                              from Inherit import *
                              inherit_obj = Inherit(self.constring,self.uid)
                              inherit_rendernbh_dic=inherit_obj.inherit(input['subject1'],input['subject1_inid_list'],nodetype1_list[0],input['subject2'])
                              rendernbhData_list.append("rightroles")
                              rendernbhData_list.insert(0,inherit_rendernbh_dic)
                        # end---
                        else:
                              rendernbhData_list.append("rightroles")
                              rendernbhData_list.insert(0,{})

                        revise_fields("relations",nodetype1_list,input['uid'],input['subject1'],[input['relationtypes']],newRelnssidList_4_subj1List,rendernbhData_list,self.curs)
                        #print " revising fields of  subject2 "
                        rendernbhData_list=[]
                        rendernbhData_list=input['subject1']
                        rendernbhData_list.append("leftroles")
                        rendernbhData_list.insert(0,{})
                        revise_fields("relations",nodetype2_list,input['uid'],input['subject2'],[input['relationtypes']],newRelnssidList_4_subj2List,rendernbhData_list,self.curs)
                        commitclose(self.curs,self.conn)
                        try:
                              commitclose( inherit_obj.curs, inherit_obj.conn)   
                        except:
                              #print "no inherit for objecttype"
                              pass

                        return 1


      def setnode(self , dictionary):
            
            if 'nodetype' not in dictionary.keys():
                  return ' NODETYPE NOT SPECIFIED '
            else:
                  if 'nid' not in dictionary.keys():
                        nid = 'nid' + str(random.randrange(0, 10000000))
                        nid = str( nid )
                        dictionary.update({'nid':nid})

                  nodetype = dictionary['nodetype'].lower()
                  # setting some mandatory fields for its instances. and handling unicode for nids and attributes.
                  dictionary = modify_inputdic(dictionary)   

                  if nodetype.endswith('type'):
                        # checking if this objecttype requires some mandatry fields in input dictionary
                        if dictionary.has_key('subtypeof') or dictionary.has_key('instanceof'):
                           if self.checkmandatory(dictionary)==-1:
                              return "mandatory fields not given."

                  else:
                        if nodetype!='attribute' :
                           if self.checkmandatory(dictionary)==-1:
                              return "mandatory fields not given."
                        
                        
                  if nodetype == 'attribute' :

                        from Attribute import attribute
                        obj = attribute( self.constring , self.uid)

                        input = dictionary
                        input['uid'] = self.uid
                        nodetype_list=obj.startchecks(input['uid'],input['subject'])
                        #print "---------------",nodetype_list
                        if nodetype_list!=-1:
                           nid_inid_list= get_nidinid_from_ssid(input['subject'],obj.curs)
                           subject_nid= nid_inid_list[0][0]
                           subject_inid= str(nid_inid_list[0][1])
                           input['subject_inid']=subject_inid
                           input['nodetype']=nodetype_list[0]
                           
                           if input.has_key('no_new_snapshot'):
                              new_subject_ssid = input['subject']
                           else:   
                                 new_subject_ssid = get_next_sequence_value('ssid_seq',obj.curs)

                           #print " new_subject_ssid=",new_subject_ssid
                           #print "INPUT===",input
                           attrtype_nid_attrvalue_list=obj.create_newattr(input,new_subject_ssid,0,0,1,0)
                           
                           if attrtype_nid_attrvalue_list!=-1:
                              attrtype_nid_list =attrtype_nid_attrvalue_list [0]
                              attrvalue_list=attrtype_nid_attrvalue_list[1]
                              attr_ssid_list_4_snapshot = attrtype_nid_attrvalue_list[2]
                              #print "attrtype_nid_list",attrtype_nid_list
                              #print "attrvalue_list",attrvalue_list
                              if input.has_key('no_new_snapshot'):
                                 """   
                                 GetMethodsObj= GetMethods(self.constring)                                    
                                 print input['subject']
                                 rnbh_dic = GetMethodsObj.getNeighbourhood([input['subject']],'rendered_nbh')  
                                 nbh_dic = GetMethodsObj.getNeighbourhood([input['subject']],'nbh')  
                                 print rnbh_dic
                                 print nbh_dic
                                 new_rnbh = handle_renderednbh4_attr( rnbh_dic[ input['subject'] ], attrtype_nid_list, attrvalue_list, new_attr_ssid_list,0)
                                 print "NEW RENDEREDNBH-----",new_rnbh
                                 nbh = nbh_dic[ input['subject'] ]
                                 if nbh.has_key('relations'):
                                           nbh['relations'] = nbh['relations'] + new_attr_ssid_list
                                 else:
                                           nbh['relations'] = new_attr_ssid_list
                                           
                                 update_nbh_rnbh(nbh, new_rnbh, input['nodetype'],input['subject'],self.curs)
                                 """
                                 revise_fields("attributes",nodetype_list,input['uid'],[input['subject']],attrtype_nid_list,[attr_ssid_list_4_snapshot],attrvalue_list,self.curs)
                              else:      
                                 #print "create new snapshot of the subject and pass the new ssid of the subject to gbattributes and datatypes_* table"
                                 create_newsnapshot("attributes",nodetype_list,input['uid'],[input['subject']],[new_subject_ssid],attrtype_nid_list,[attr_ssid_list_4_snapshot],attrvalue_list,self.curs)   
                                 #print"updating old_ssid_of_subject=",input['subject']," to new_subject_ssid=",new_subject_ssid
                                 reset_ssid_2_latestssid(new_subject_ssid,subject_nid,self.curs)#update subject's ssid
                                 bind_nidssid(new_subject_ssid,subject_nid,subject_inid,nodetype_list[0],self.curs)#for new snapshot of subject                    
                                 
                              commitclose(self.curs,self.conn)
                              commitclose(obj.curs,obj.conn)
                              final_list=[]
                              final_list.append([new_subject_ssid])
                              final_list.append(attr_ssid_list_4_snapshot)
                              return final_list
                              

                  elif nodetype == 'relationtype' :

                        from RelationType import setRelationType
                        set_relationtype = setRelationType( self , dictionary , self.uid)
                        return set_relationtype
                  
                  elif nodetype == 'attributetype' :
                       
                        from AttributeType import setAttributeType
                        set_attributetype = setAttributeType( self ,  dictionary , self.uid )
                        return set_attributetype

                  elif nodetype == 'metatype':

                        from MetaType import metatypes
                        obj=metatypes( self.constring , self.uid)
                        return  obj.create_metatype( dictionary)


                  elif nodetype == 'usertype':

                        from UserType import usertype
                        obj=usertype( self.constring , self.uid)
                        return obj.create_usertype( dictionary )

                  elif nodetype == 'user' :

                        from User import User
                        obj= User( self.constring , self.uid)
                        input= dictionary
                        if input.has_key('instanceof'):
                              if input.has_key('relation'):
                                    inputrelation=input['relation']
                                    for tuple in inputrelation:
                                          if tuple[0].lower()=='subtypeof':
                                                return "Cant accept subtypeof as relntypeid in input['relation']."
                              return obj.create_User(input)
                        else:
                              return "cant create USER without giving its instanceof."


                  elif nodetype == 'function':
                        from Functions import Function
                        obj=Function(self.constring ,self.uid)
                        return obj.create_Function(dictionary)

                  elif nodetype == 'objecttype':
                        from ObjectType import objecttype
                        obj=objecttype( self.constring , self.uid)
                        return obj.create_objecttype( dictionary )

                  elif nodetype == 'object' :
                        from Object import Objects
                        obj = Objects( self.constring , self.uid)
                        input = dictionary
                        input['uid'] = self.uid
                        if input.has_key('instanceof'):
                                     if input.has_key('relation'):
                                           inputrelation=input['relation']
                                           for tuple in inputrelation:
                                               if tuple[0].lower()=='subtypeof':
                                                  return  "Cant accept subtypeof as relntypeid in input['relation']."
                                     return obj.create_object(input)
                        else:
                              return "cant create objects without giving its instanceof."

                                  
                  elif nodetype == 'processtype':
                          from ProcessType import processtype
                          ptypeObj=processtype(self.constring,self.uid)
                          input = dictionary
                          if ( input.has_key('priorstatedef') ) and (input.has_key('poststatedef') ):
                                combined_ssid_list=input['priorstatedef']+input['poststatedef']
                                sql="SELECT nodetype FROM gbnidssid WHERE ssid in %s;"%(list2string( combined_ssid_list ) )
                                execute_query(sql,ptypeObj.curs)
                                nodetype_list=query_fetchall(ptypeObj.curs)
                                for ntype in nodetype_list:
                                      if ntype[0].endswith('types'):
                                            pass
                                      else:
                                            return "nodetype of given ssid list in input['priorstate/poststate'] cannot be token."
                          else:
                                return "cant create process without input['priorstate']."
                          if input.has_key('attributes'):
                             if (input.has_key('subtypeof') ) or (input.has_key('instanceof')):    
                                 return ptypeObj.create_processtype(input)
                             else:
                                 return " input dictionary has no subtypeof or instanceof . Cant begin creating usertype without them."
                          return ptypeObj.create_processtype(input)


                  elif nodetype == 'process':
                            from Process import Process
                            pObj = Process(self.constring,self.uid)
                            input = dictionary
                            if input.has_key('instanceof'):
                                  if input.has_key('relation'):
                                        inputrelation=input['relation']
                                        for tuple in inputrelation:
                                              if tuple[0].lower()=='subtypeof':
                                                    return "Cant accept subtypeof as relntypeid in input['relation']."
                                  if (input.has_key('priorstate')) and (input.has_key('poststate') ):
                                        combined_ssid_list=input['priorstate']+input['poststate']
                                        sql="SELECT nodetype FROM gbnidssid WHERE ssid in %s;"%(list2string( combined_ssid_list ) )
                                        execute_query(sql,pObj.curs)
                                        nodetype_list=query_fetchall(pObj.curs)
                                        for ntype in nodetype_list:
                                              if ntype[0].endswith('types'):
                                                    print "nodetype of given ssid list in input['priorstate/poststate'] cannot be type."
                                                    return "nodetype of given ssid list in input['priorstate/poststate'] cannot be type."
                                  else:
                                        return "cant create process without input['priorstate']."
                                  return pObj.create_process(input)
                            else:
                                  return  "cant create process without giving its instanceof."
                                  #print  "cant create process without giving its instanceof."

   
                  elif nodetype == 'relation' :
                        from Relation import relations
                        obj = relations( self.constring , self.uid)
                        input = dictionary
                        input['uid'] = self.uid
                        relntype_ssid=obj.start_checks(input['subject1'],input['subject2'],input['relationtypes'])
                        if relntype_ssid!=-1:
                              newsubject1_ssid_list=[]
                              newsubject2_ssid_list=[]
                              for s1 in range(len(input['subject1'])):
                                    newsubject1_ssid_list.append(get_next_sequence_value('ssid_seq',obj.curs))
                              for s2 in range(len(input['subject2'])):
                                    newsubject2_ssid_list.append(get_next_sequence_value('ssid_seq',obj.curs))
                              subject2_inid_list=get_inid_from_ssid(input['subject2'],obj.curs)       
                              final_dic=obj.startchecks_n_callwrite(input,relntype_ssid,newsubject1_ssid_list,newsubject2_ssid_list,subject2_inid_list,1,0)
                              if final_dic!=-1:
                                    commitclose(obj.curs,obj.conn)
                                    try:
                                          if final_dic.has_key('inherit_obj'):
                                                commitclose(final_dic['inherit_obj'].curs, final_dic['inherit_obj'].conn)   
                                    except:
                                          #print "no inherit for objecttype"
                                          pass

                                    final_list = []
                                    final_list.append(newsubject1_ssid_list)
                                    final_list.append(newsubject2_ssid_list)
                                    return final_list

                                    
if __name__=="__main__":
      constring="dbname=<postgres_databasename> user=<postgres_username> password=<postgres_password> host=localhost"

      uid=1
      obj=SetMethods(constring,uid)

      input = {'status': 'public', 'instanceof': ['5'], 'nodetype': 'user', 'attributes': [('username', 'somnath'), ('password', 'e88fbd35e7a0a4692b4e588597eb2202'), ('email', 'nair331@gmail.com'), ('fullname', 'somnath ')]}
      print obj.setnode(input)
      input = {
      'nodetype':'objecttype',
      'nid':'GNOWSYS',
      'uid':'1',
      'status':'public',
      'subtypeof':['43'],
      'attributes':[('Grade','8'),('Subject','Geography')],
      'language':'english'
      }
      #print obj.setnode(input)


      input = {
      'nid':'Ontology',
      'status':'public',
      'nodetype':'metatype',
      'uid':'1',
      }
      #print obj.setnode( input )


      input = {
      'nid':'ontology1',
      'status':'public',
      'nodetype':'objecttype',
      'instanceof':['331'],
      'uid':'1'
      }
      #print obj.setnode( input )


      input = {
      'nodetype':'object',
      'nid':'OBJ2',
      'uid':'1',
      'status':'public',
      'instanceof':['4'],
      'attributes':[('title','english is the language'),('description','english is the description'),('content','content')],
      'language':'english'
      
       }
      #print obj.setnode(input)

      input = {
            'uid':'1',
            'status':'Public',
            'instanceof':[('title','Object2 '),('description','this is first object,an instanceof second objecttype. testing new attr file where checks r using rendered_nbh')],
            'subject':'456',
            'language':'english',
            'nodetype':'attribute'
            }
      #obj.setnode(input)
      input = {
            'nodetype':'attribute',
            'status':'Public',
            'instanceof':[('content',"The God Delusion")],
            'subject':'75',
            'language':'english',
            'nodetype':'attribute'
            }
      #print obj.setnode(input)

      input = {
            'nodetype':'attribute',
            'status':'Public',
            'instanceof':[('hasTitle',["The God Delusion","Test data"])],
            'subject':'75',
            'language':'english'
            }
      #print obj.setnode(input)
      input = {
            'nodetype':'attribute',
            'status':'Public',
            'instanceof':[('hasName',["Richard Dawkins"])],
            'subject':'71',
            'language':'english'
            }
      #print obj.setnode(input)

      input = {
      'nodetype':'user',
      'status':'public',
      'instanceof':['5'],
      'attributes':[('username','gnowsysuser'),('password','gnowsysuser'),('email','nair331@gmail.com')]
       }

      input = {
      'nid':'USErajiv',
      'uid':'1',
      'status':'public',
      'instanceof':['5'],
      'structure':['2','3','4'],
      'nodetype':'user'
      }

      
      input = {
      'nid':'processtype2',
      'uid':'1',
      'status':'public',
      'subtypeof':['74892'],
      'priorstatedef':['11','19','28'],
      'poststatedef':['144','149','153'],
      'nodetype':'processtype'
      }
      


      #obj.setnode(dictionary)

      dictionary = {
      'nodetype':'object',
      'nid':'gnowsys019',
      'uid':'1',
      'status':'public',
      'instanceof':['19']
       }
      #obj.setnode(dictionary)

      dictionary = {
      'nodetype':'user',
      'nid':'gnowsys020',
      'uid':'1',
      'status':'public',
      'instanceof':['20']
       }
      #obj.setnode(dictionary)
      
      input = {
         'nodetype':'relation',
         'uid':'1',
         'status':'Public',
         'subject1':['74866'],
         'subject2':['233'],
         'relationtypes':'dependson'
         }
      #obj.setnode(input)


      input = {
      'nodetype':'object',
      'nid':'nidtest',
      'uid':'1',
      'status':'public',
      'instanceof':['74831','74838']
         }
      #obj.setnode( input )

      input = {
      'nodetype':'process',
      'nid':'process1',
      'uid':'1',
      'status':'public',
      'priorstate':['221','225','229'],
      'poststate':['233','237','241'],
      'instanceof':['74897']
         }
      #obj.setnode( input )


      
      input = {
      'nid':'OT1',
      'uid':'1',
      'status':'public',
      'subtypeof':['74892'],
      'priorstatedef':['11','19','28'],
      'poststatedef':['144','149','153'],
      'nodetype':'processtype'
      }


      input = {
      'nodetype':'object',
      'nid':'OBJECT1',
      'uid':'1',
      'status':'public',
      'instanceof':['31']
       }

      input = {
      'nodetype':'object',
      'nid':'OBJECT2',
      'uid':'1',
      'status':'public',
      'instanceof':['17']
       }
      
      input = {
         'nodetype':'relation',
         'uid':'1',
         'status':'Public',
         'subject1':['35'],
         'subject2':['38'],
         'relationtypes':'FOUNDER'
         }

      input = {
      'nodetype':'object',
      'nid':'OBJECT2',
      'uid':'1',
      'status':'public',
      'instanceof':['82']
       }

      input = {
      'nodetype':'object',
      'nid':'TRUSTY',
      'uid':'1',
      'status':'public',
      'instanceof':['16'],
      'relation':[('FOUNDER',['20'])]
       }
      
      input = {
      'nodetype':'object',
      'nid':"VESIT's sole owner",
      'uid':'1',
      'status':'public',
      'instanceof':['17']
       }

      input = {
      'nid':'F1',
      'status':'public',
      'nodetype':'function'
      }

      input = {
      'nid':'subtypeof-F1',
      'status':'public',
      'nodetype':'function',
      'subtypeof':['49']
      }

      input = {
      'nid':'F2',
      'status':'public',
      'nodetype':'function',
      'language':'en',
      'mandatoryfields':['11','12']#list of inids
      }

      input = {
      'nid':'subtypeof-F2',
      'status':'public',
      'nodetype':'function',
      'subtypeof':['53']
      }

      input = {   'nodetype':'relationtype',
                  'nid':'Depends-ON', 
                  'status':'Public',
                  'inversename':'Required for',
                  'subjecttype1':['49'],
                  'subjecttype2':['53'],
                  'applicablenodetypes':'types'
                  }

      input =  {
                'nid':'arg_list',# [mandatory field]
                'uid':'1', # [mandatory field]
                'status':'public',
                'subjecttypes':['49','53'],#  (list of ssids of types)    [mandatory field] 
                'restrictiontype':1, #    (1 indicates valuerestriction) [mandatory field]
                'datatype':'text[]' , #   (selected from a list of datatypes) [mandatory field]
                'nodetype':'attributetype',
                'regex':'',
                'applicablenodetypes':'types'
                 }

      input =  {
                'nid':'returntype_list',# [mandatory field]
                'uid':'1', # [mandatory field]
                'status':'public',
                'subjecttypes':['53','49'],#  (list of ssids of types)    [mandatory field] 
                'restrictiontype':1, #    (1 indicates valuerestriction) [mandatory field]
                'datatype':'text[]' , #   (selected from a list of datatypes) [mandatory field]
                'nodetype':'attributetype',
                'regex':'',
                'applicablenodetypes':'types'
                 }

      input = {
         'nodetype':'relation',
         'uid':'1',
         'status':'Public',
         'subject1':['49'],
         'subject2':['53'],
         'relationtypes':'Depends-ON'
         }




      input = {
      'nodetype':'object',
      'nid':'testot4ins',
      'status':'public',
      'instanceof':['24'],
      'relation':[('testot4_testot5',['29']),('testot4_testot6',['32'])]
       }

      input = {
      'nodetype':'object',
      'nid':'o01',
      'uid':'1',
      'status':'public',
      'instanceof':['31']
       }

      #print obj.setnode(input)

      input = {
      'nodetype':'object',
      'nid':'o02',
      'uid':'1',
      'status':'public',
      'instanceof':['17']
       }
      #print obj.setnode(input)
      
      input = {
         'nodetype1_list':['gbobjects']   ,
         'nodetype':'relation',
         'uid':'1',
         'status':'Public',
         'subject1':['127'],
         'subject2':['130'],
         'relationtypes':'FOUNDER',
         'set_relation':'1' #compulsory .  req 4 relations file.
         }
      #print obj.set_relation(input)


      input = {
      'nid':'header',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1'
      }
      input = {
      'nid':'header-subtype1',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1',
      'subtypeof':['162']
      }
      #print obj.setnode(input)


      input = {
      'nid':'header-subtype2',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1',
      'subtypeof':['162']
      }
      #print obj.setnode(input)

      input = {   'nodetype':'relationtype',
                  'nid':'D-ON', 
                  'status':'Public',
                  'inversename':'Required for',
                  'subjecttype1':['162'],
                  'subjecttype2':['162'],
                  'applicablenodetypes':'types'
                  }

      #print obj.setnode(input)

      input = {
         'nodetype1_list':['gbobjecttypes']   ,
         'nodetype':'relation',
         'uid':'1',
         'status':'Public',
         'subject1':['172'],
         'subject2':['175'],
         'relationtypes':'D-ON',
         'set_relation':'1'
         }
      #print obj.set_relation(input)

      input = {
      'nid':'stypeof-OT1',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1',
      'subtypeof':['21'],
      'mandatoryfields':['20'],#list of inids
      'language':'en' #mandatory
      }




      input = {
      'nid':'OT1',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1'
      }

      input = {
      'nid':'OT2',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1'
      }

      input = {   'nodetype':'relationtype',
                  'nid':'FOUNDER', 
                  'status':'Public',
                  'inversename':'WAS FOUNDED BY',
                  'subjecttype1':['16'],
                  'subjecttype2':['17'],
                  'applicablenodetypes':'types'
                  }

      input = {
      'nid':'OT4',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1'
      }

      input = {
         'nodetype':'relation',
         'uid':'1',
         'status':'Public',
         'subject1':['35'],
         'subject2':['32'],
         'relationtypes':'FOUNDER',
         'nodetype1_list':['gbobjecttypes'],
         'set_relation':'1'
         }
      #print obj.set_relation(input)

      input = {
      'nid':'subtypeof-OT2',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1',
      'subtypeof':['17']
      }


      input = {
      'nid':'subtypeof-OT1',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1',
      'subtypeof':['16'],
      'relation':[('FOUNDER',['23'])]
      }

      input = {
      'nid':'stypeof-OT2',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1',
      'subtypeof':['17']
      }

      input = {
      'nid':'stypeof-OT1',
      'status':'public',
      'nodetype':'objecttype',
      'uid':'1',
      'subtypeof':['16']
      }


      input =  {
                'nid':'arg_list',# [mandatory field]
                'uid':'1', # [mandatory field]
                'status':'public',
                'subjecttypes':['27'],#  (list of ssids of types)    [mandatory field] 
                'restrictiontype':1, #    (1 indicates valuerestriction) [mandatory field]
                'datatype':'text[]' , #   (selected from a list of datatypes) [mandatory field]
                'nodetype':'attributetype',
                'regex':'',
                'applicablenodetypes':'types'
                 }
      

      input={
            'uid':'1',
            'status':'public',
            'instanceof':[('13','no description'),('58','void returntype')],
            'subject':'92',
            'language':'en',
            'nodetype':'attribute',
            'no_new_snapshot':'1'
            }

      #print obj.setnode(input)
