# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__author__ = """Jay Mehta <jay87.mehta@gmail.com>"""
__docformat__ = 'plaintext'




from GeneralMethods import *
import psycopg2
import cPickle
import  psycopg2
from base64 import b64encode, b64decode

class relations:

  def __init__(self , constring , uid):
          self.conn = psycopg2.connect( constring )   
          self.curs = self.conn.cursor() 
          #self.fatherlist_dic={}
          #self.subtypeoflist_dic={}
          self.uid = uid
          self.constring = constring
          self.flag_inherit = 0


  def relntype_exists(self,relntype):
      #print relntype
      sql="SELECT inid FROM gbnidssid WHERE nid='%s';"%relntype
      #print sql
      execute_query(sql,self.curs)
      relntype_inid = query_fetchall(self.curs)[0][0]
      if relntype_inid ==None:
         #print "No such relationtype found."
         return -1
      else:
         return relntype_inid  

  def start_checks(self,subject1_ssid_list,subject2_ssid_list,relntype):#pass relntype_ssid if all validation successfull else -1
      #print " in startchecks",relntype
      ssid_list=[]
      ssid_list=list( set(subject1_ssid_list)|set(subject2_ssid_list))
      #print "ssid_list",ssid_list
      if ssid_exists(ssid_list,'gbnidssid',self.curs)==0:#subject_ssid exists
         #print "subject_ssid not found"
         return -1
      #print "subject ssids exists"
      #print relntype
      relntype_inid= self.relntype_exists(relntype)#both subject_ssid list validated
      if relntype_inid!=-1: 
            #print"reln type exists."
            return relntype_inid #relationtypeid exists
      else:
            #print"relationtypeid does not exists"
            return -1

  def get_roletypeData(self,relntype_ssid):
      
      sql="SELECT roletypeid FROM gbcatalogrelationtypes WHERE relationtypeid=%s;"%relntype_ssid
      #print sql
      execute_query(sql,self.curs)
      rtid=query_fetchall(self.curs) 

      if len(rtid)==1:
         #print "length =1"
         sql="SELECT subjecttype1,subjecttype2,applicablenodetypes1,applicablenodetypes2 FROM gbroletypes WHERE rtid=%s;"%(rtid[0][0])
      else:
        rtid_sql="("
        for tuple in rtid:
            rtid_sql=rtid_sql+ str( tuple[0] )+","
        rtid_sql = rtid_sql.rstrip(",")+")"    
        sql="SELECT subjecttype1,subjecttype2,applicablenodetypes1,applicablenodetypes2 FROM gbroletypes WHERE rtid in %s;"%(rtid_sql)
      #print sql
      execute_query(sql,self.curs)
      data_list = query_fetchall(self.curs) #returns a list of tuples each tuple with 4 values
      final_list=[]
      for tuple in data_list:
          final_list.append(( str(tuple[0]),str(tuple[1]),tuple[2],tuple[3] ))
      return final_list

  def get_subject2_from_gbrelations(self,subject_inid_list,relationtype_id):
      #relationtype_id=2 for instanceof and =3 for subtypeof
      
      sql="SELECT subject1,subject2 FROM gbrelations WHERE subject1 in %s AND relationtype=%s;"%(list2string(subject_inid_list),relationtype_id)
      #print sql
      execute_query(sql,self.curs)
      data_list=query_fetchall(self.curs)#[(s1,s2),(s1,s2),(), ....]
      data_dic={}
      for tuple in data_list:
          key= str ( tuple[0] )
          value= str( tuple[1] )
          if data_dic.has_key( key ):
             data_dic[key].append(value)
          else:
             data_dic[key]=[value]
      return data_dic

  def get_father_of_unmatched_subject(self,unfound_subject_list):
      #print "unfound_subject_list):",unfound_subject_list
      father_list=[]#list of list of fathers for every subject in unfound_subject_list
      fatherlist_dic=self.get_subject2_from_gbrelations(unfound_subject_list,'2')
      for subject in unfound_subject_list:
          if fatherlist_dic.has_key(subject):
             father_list.append(fatherlist_dic[subject])
          else:
             father_list.append( [] )
      return father_list


  def get_supertypeof_unmatched_subject(self,unfound_subject_list):#[list of ssids(types only)]
      supertypeof_list=[]#list of list of supertypeof for every subject in unfound_subject_list
      supertypeoflist_dic = self.get_subject2_from_gbrelations(unfound_subject_list,'3')
      for subject in unfound_subject_list:
          if supertypeoflist_dic.has_key(subject):
             supertypeof_list.append( supertypeoflist_dic[subject] ) 
          else:
             supertypeof_list.append( [] ) # no supertypeof for this subject
      return supertypeof_list

  def get_supertypeof_4_TTchecks(self,unfound_subject_list):#[list of ssids(types only)]

      supertypeoflist_dic = self.get_subject2_from_gbrelations(unfound_subject_list,'3')
      for subject in unfound_subject_list:
          if supertypeoflist_dic.has_key(subject):
             pass
          else:
             supertypeoflist_dic[subject]=[[]]

      return supertypeoflist_dic

  def get_father_of_4_TTchecks(self,unfound_subject_list):

      fatherlist_dic=self.get_subject2_from_gbrelations(unfound_subject_list,'2')
      for subject in unfound_subject_list:
          if fatherlist_dic.has_key(subject):
             pass
          else:
             fatherlist_dic[subject]=[[]]

      return fatherlist_dic



  def check_T_T(self,subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List):

      #print "TT invoked-----------------------------------"
      #s1_father_dic={} key:s1_ssid, value:[fathers ssid]
      #s1_supertype_dic= {} key:s1_ssid, value:[supertype ssid]


      #step1: compare supertypeof_s1 with supertypeof_s2
      flag_skip_check_1n4=0
      flag_skip_check_2n3 = 0


      if supertypeof_subj1_List == 0:
         if fatherList_of_subj1 == 0:
            #this is case when this file is executed and not invoked from type/token file.
            s1_supertype_dic = self.get_supertypeof_4_TTchecks(subject1_list)
            #print "s1_supertype_dic",s1_supertype_dic
            s2_supertype_dic =  self.get_supertypeof_4_TTchecks(subject2_list)
            #print "s2_supertype_dic",s2_supertype_dic

         else:
           # this is case when instanceof subject(type/token)are passed while its creation
           s1_father_dic={}
           s1_father_dic[ subject1_list[0] ] =  fatherList_of_subj1[0]
           flag_skip_check_1n4=1
      else:
           s1_supertype_dic={}
           s1_supertype_dic[ subject1_list[0] ] = supertypeof_subj1_List[0]
           #print  "s1_supertype_dic",s1_supertype_dic

           s2_supertype_dic =  self.get_supertypeof_4_TTchecks(subject2_list)
           #print "s2_supertype_dic",s2_supertype_dic

           if fatherList_of_subj1 == 0:
              # this is case when supertypeof subject(type/token)are passed while its creation
              flag_skip_check_2n3 = 1
           else:
             # this is case when both supertypeof and instanceof subject(type/token)are passed while its creation.
             s1_father_dic={}
             s1_father_dic[ subject1_list[0] ] =  fatherList_of_subj1[0]
             
              
      #check1:compare supertypeof s1 with supertypeof s2
      s1_unmatchedS2_dic={}#key: s1_ssid, value:[s2_ssid]      
      s2_list_4_check2=[]# this holds ssids of s2 whose fathers is to be fetched for check2.

      if flag_skip_check_1n4 == 0:
        #print "Entered checks 1"
        for s1 in s1_supertype_dic:
          # s1_supertype_list = s1_supertype_dic[ s1 ] = [supertype of a ssid of subject1] 
          for s2 in s2_supertype_dic:
              #s2_supertype_dic[ s2 ] = s2_supertype_list =  [supertype of a ssid of subject2] 
              match_found=0
              for s1_supertypessid in s1_supertype_dic[ s1 ]:
                  for s2_supertypessid in s2_supertype_dic[ s2 ]:
                      if (s1_supertypessid,s2_supertypessid,'types','types') in roletypeData:
                         #print "roletype data",roletypeData
                         match_found=1
                         break
                  if match_found==1:
                     break
              if match_found ==0:
                 #print"s1_unmatchedS2_dic",s1_unmatchedS2_dic
                 s2_list_4_check2 = s2_list_4_check2 + [s2]
                 if s1_unmatchedS2_dic.has_key( s1 ):
                    s1_unmatchedS2_dic[ s1 ].append( s2 )
                 else:
                    s1_unmatchedS2_dic[ s1 ] = [s2]

        if s1_unmatchedS2_dic=={}:
           #print "All checks satisfied at step 1" 
           return 1
      else:
        s1_unmatchedS2_dic[ subject1_list[0] ] = subject2_list
        s2_list_4_check2 = subject2_list

      # the following 4 lines are req 4 check4.  
      #get father list of only unmatched subject
      s2_list_4_check2 = list( set (s2_list_4_check2))
      s2_father_dic =self.get_father_of_4_TTchecks(s2_list_4_check2)       
      c3_s1_fatherdic={}
      
      if flag_skip_check_2n3 == 0:
        #print "Entered check2 "
        #check2:compare father of s1 with father of unmatched s2
        if flag_skip_check_1n4 ==0:
           # both flag zero indicates that this file is executed and not called during by any other type/token creation time.
           s1_father_dic = self.get_father_of_4_TTchecks(s1_unmatchedS2_dic.keys())
        #print "s1_father_dic",s1_father_dic
        #print  "s2_father_dic",s2_father_dic
        #print "roletypeData",roletypeData
        c2_s1_unmatchedS2_dic={}
        for s1 in s1_father_dic:
          for s2 in s1_unmatchedS2_dic[s1]:
              c2_match_found = 0
              for s1fatherssid in s1_father_dic[s1]:
                  for s2fatherssid in s2_father_dic[s2]:
                      if (s1fatherssid,s2fatherssid,'metatypes','metatypes') in roletypeData:
                         #print"match FOUND"
                         c2_match_found=1
                         break
                  if c2_match_found==1:
                     break
      
              if c2_match_found ==0:
                 if c2_s1_unmatchedS2_dic.has_key( s1 ):
                    c2_s1_unmatchedS2_dic[ s1 ].append( s2 )
                 else:
                    c2_s1_unmatchedS2_dic[ s1 ] = [s2]

        if c2_s1_unmatchedS2_dic=={}:
           #print "All checks satisfied at step 2" 
           return 1

        #check3 : compare father's list of each s1 from s1_unmatchedS2_dic with its corr s2's supertypeof lists
        #print "Entered check3 "
        for keys in c2_s1_unmatchedS2_dic.keys():
            c3_s1_fatherdic[keys] = s1_father_dic[keys]
        #print 
        c3_s1_unmatchedS2_dic={}

        for s1 in c3_s1_fatherdic:
          for s2 in c2_s1_unmatchedS2_dic[s1]:
              c3_match_found=0
              for s1fatherssid in c3_s1_fatherdic[s1]:
                  for s2supssid in s2_supertype_dic[s2]:
                      if (s1fatherssid,s2supssid,'metatypes','types') in roletypeData:
                          c3_match_found=1
                  if c3_match_found==1:
                     break
              if c3_match_found==0:
                 if c3_s1_unmatchedS2_dic.has_key(s1):
                    c3_s1_unmatchedS2_dic[s1].append(s2)
                 else:
                    c3_s1_unmatchedS2_dic[s1] = [s2]

        if c3_s1_unmatchedS2_dic=={}:
           #print "All checks satisfied at step 3" 
           return 1

      else:
        c3_s1_unmatchedS2_dic = s1_unmatchedS2_dic
        
      if flag_skip_check_1n4 ==  0:
        #check4 : compare supertype list of each s1 from c3_s1_unmatchedS2_dic with its corr s2's father lists
        c4_s1_supertypedic={}
        for keys in c3_s1_unmatchedS2_dic.keys():
            c4_s1_supertypedic[keys] = s1_supertype_dic[keys]
      
        for s1 in c4_s1_supertypedic:
          for s2 in c3_s1_unmatchedS2_dic[s1]:
              c4_match_found=0
              for s1supssid in c4_s1_supertypedic[s1]:
                  for s2fatherssid in s2_father_dic[s2]:
                      if (s1supssid,s2fatherssid,'types','metatypes') in roletypeData:
                          c4_match_found=1
                  if c4_match_found==1:
                     break
              if c4_match_found==0:
                 #print "checks failed. Could not create relation"
                 return -1
        #print"all checks satisfied at step4."
        return 1
      else:
         if c3_s1_unmatchedS2_dic != {}:
           #print "all checks not satisfied. Cant create relation."
           return -1

  def check_M_M(self,S1LIST,S2LIST,roletypeData,app_ndtype1,app_ndtype2):
      # S1LIST and S2LIST are either supertypeof or classof list of s1 or s2.
      # S1LIST=[ [list of supertypeof first subject from subject1 list],[list of supertypeof first subject from subject1 list],[]]
      for s1_list in S1LIST:
          for s2_list in S2LIST:
              match_found=0
              for s1 in s1_list:
                  for s2 in s2_list:
                      if (s1,s2,app_ndtype1,app_ndtype2) in roletypeData:
                          match_found=1
                          break
                  if match_found==1:
                     break
                  else:
                     return -1
      return 1

  def check_M_T(self,subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List):
      #print "=======================supertypeof_subj1_List",supertypeof_subj1_List
      if supertypeof_subj1_List == 0:
            s1_supertype_list = self.get_supertypeof_unmatched_subject(subject1_list)
      else:
            s1_supertype_list = supertypeof_subj1_List
      #print "s1_supertype_list ===",s1_supertype_list 
      if [] in s1_supertype_list:
         return "no supertypeof for a metatype. Cant create relations."
        
      
      s2_supertype_list = self.get_supertypeof_unmatched_subject(subject2_list)
      #print "s2_supertype_list",s2_supertype_list

      getfathers_4_s2=[]
      s1_list_4_check2=[]
      #check 1: match supertype of MT and Types.
      if s2_supertype_list.count([]) != len( s2_supertype_list ):
         s2index=0         
         for s2_list in s2_supertype_list:
             if s2_list!=[]:
                temp_s1_list=[]
                for s1_list in s1_supertype_list:
                    match_found=0
                    for s1 in s1_list:
                        for s2 in s2_list:
                            if (s1,s2,'types','types') in roletypeData:
                               match_found=1
                               break
                        if match_found==1:
                           break
                    if match_found==0:
                       temp_s1_list.append(s1_list)
                if temp_s1_list!=[]:
                   s1_list_4_check2.append(temp_s1_list)
                   getfathers_4_s2=[ subject2_list[s2index] ]    
             else:
                   s1_list_4_check2.append( s1_supertype_list )
                   getfathers_4_s2=[ subject2_list[s2index] ]    
               
             s2index = s2index +1
         if getfathers_4_s2==[]:
            #print "all relations can be created. checks validated at step1"
            return 1

      else:
           getfathers_4_s2 = subject2_list
           s1_list_4_check2 = []
           for s2len in range(len(subject2_list)):
               s1_list_4_check2.append(s1_supertype_list)

      #check 2 : match unmatched subject2's (types)father with supertype of MT 
      father_s2_list = self.get_father_of_unmatched_subject(getfathers_4_s2)      
      #print "father_s2_list",father_s2_list
      #print "s1_list_4_check2",s1_list_4_check2
      if [] in father_s2_list:
         return " No classof for a type. Cant create relations."
      for s2_list in father_s2_list:
          for s1_multi_list in s1_list_4_check2:
              #s1_multi_list=[[ids of all supertypeof s1 'types'],[ids of all supertypeof s2 types ], ...]
              for s1_list in s1_multi_list:
                  match_found=0
                  for s2 in s2_list:
                      for s1 in s1_list:
                          if (s1,s2,'types','metatypes') in roletypeData:
                             match_found=1
                             break
                      if match_found==1:
                         break
                  if match_found==0:
                     #print "checks condition failed."
                     return -1
      #print "all relations can be created. checks validated at step2"
      return 1

  def check_T_M(self,subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List):

      if supertypeof_subj1_List == 0:
         if fatherList_of_subj1 == 0:
            s1_supertype_list = self.get_supertypeof_unmatched_subject(subject1_list)
         else:
           s1_supertype_list = [[]]
      else:
            s1_supertype_list = supertypeof_subj1_List
        
      
      s2_supertype_list = self.get_supertypeof_unmatched_subject(subject2_list)
      #print "s2_supertype_list",s2_supertype_list
      if [] in s2_supertype_list:
         return "no supertypeof for a metatype. Cant create relations."


      getfathers_4_s1=[]
      s2_list_4_check2=[]
      #check 1: match supertype of MT and Types.
      if s1_supertype_list.count([]) != len( s1_supertype_list ):
         #atleast some s1 have supertype.
         s1index=0         
         for s1_list in s1_supertype_list:
             temp_s2_list=[]
             if s1_list != []:
                for s2_list in s2_supertype_list:
                    match_found=0
                    for s1 in s1_list:
                        for s2 in s2_list:
                            if (s1,s2,'types','types') in roletypeData:
                               match_found=1
                               break
                        if match_found==1:
                           break
                    if match_found==0:
                       temp_s2_list.append(s2_list)
                if temp_s2_list!=[]:
                   s2_list_4_check2.append(temp_s2_list)
                   getfathers_4_s1=[ subject1_list[s1index] ]    
             else:
                   s2_list_4_check2.append( s2_supertype_list )
                   getfathers_4_s1=[ subject1_list[s1index] ]    
             s1index = s1index +1
         if getfathers_4_s1==[]:
            #print "all relations can be created. checks validated at step1"
            return 1

      else:
           #none s1 had supertypeof
           getfathers_4_s1 = subject1_list
           s2_list_4_check2 = []
           for s1len in range(len(subject1_list)):
               s2_list_4_check2.append(s2_supertype_list)

      #check 2 : compare unmatched subject1's (types)father with supertype of MT 
      father_s1_list = self.get_father_of_unmatched_subject(getfathers_4_s1)      
      #print "father_s1_list",father_s1_list
      #print "s2_list_4_check2",s2_list_4_check2
      if [] in father_s1_list:
         return " No classof for a type. Cant create relations."
      for s1_list in father_s1_list:
          for s2_multi_list in s2_list_4_check2:
              #s2_multi_list=[[ids of all supertypeof s2 'types'],[ids of all supertypeof next s2 types ], ...]
              for s2_list in s2_multi_list:
                  match_found=0
                  for s2 in s2_list:
                      for s1 in s1_list:
                          if (s1,s2,'metatypes','types') in roletypeData:
                             match_found=1
                             break
                      if match_found==1:
                         break
                  if match_found==0:
                     #print "checks condition failed."
                     return -1
      #print "all relations can be created. checks validated at step2"
      return 1

  def check_T_t(self,subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List):
    
      s2_fatherlist = self.get_father_of_unmatched_subject(subject2_list)      
      #print "s2_fatherlist",s2_fatherlist
      if [] in s2_fatherlist:
         return "no classof for a token. Cant create relations."

      if supertypeof_subj1_List==0:
         if fatherList_of_subj1==0:
            s1_supertype_list = self.get_supertypeof_unmatched_subject(subject1_list)
            #print "s1_supertype_list ===",s1_supertype_list 
         else:
           s1_supertype_list = [[]]
      else:
        s1_supertype_list = supertypeof_subj1_List

      getfathers_4_s1=[]
      s2_list_4_check2=[]
      #check 1: match supertype of types with class of tokens.
      if s1_supertype_list.count([]) != len( s1_supertype_list ):
         s1index=0         
         for s1_list in s1_supertype_list:
             if s1_list !=[]:
                temp_s2_list=[]
                for s2_list in s2_fatherlist:
                    match_found=0
                    for s1 in s1_list:
                        for s2 in s2_list:
                            if (s1,s2,'types','tokens') in roletypeData:
                               match_found=1
                               break
                        if match_found==1:
                           break
                    if match_found==0:
                       temp_s2_list.append(s2_list)
                if temp_s2_list!=[]:
                   s2_list_4_check2.append(temp_s2_list)
                   getfathers_4_s1=[ subject1_list[s1index] ]    
             else:
                 s2_list_4_check2.append( s2_fatherlist )
                 getfathers_4_s1=[ subject1_list[s1index] ]    
               
             s1index = s1index +1
         if getfathers_4_s1==[]:
            #print "all relations can be created. checks validated at step1"
            return 1

      else:
           getfathers_4_s1 = subject1_list
           s2_list_4_check2 = []
           for s1len in range(len(subject1_list)): 
               s2_list_4_check2.append( s2_fatherlist )

      #check 2 : match unmatched subject2's father with father of s1.
      s1_fatherlist = self.get_father_of_unmatched_subject(getfathers_4_s1)      
      #print "s1_fatherlist",s1_fatherlist
      #print "s2_list_4_check2",s2_list_4_check2
      if [] in s1_fatherlist:
         return " No classof for a type. Cant create relations."
      for s1_list in s1_fatherlist:
          for s2_multi_list in s2_list_4_check2:
              #s2_multi_list=[[ids of all classof s2 'tokens'],[ids of all classof s2 tokens ], ...]
              for s2_list in s2_multi_list:
                  match_found=0
                  for s2 in s2_list:
                      for s1 in s1_list:
                          if (s1,s2,'metatypes','tokens') in roletypeData:
                             match_found=1
                             break
                      if match_found==1:
                         break
                  if match_found==0:
                     #print "checks condition failed."
                     return -1
      #print "all relations can be created. checks validated at step2"
      return 1

  def check_t_T(self,subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List):
      # here supertypeof_subj1_List==0 always.

    
      if fatherList_of_subj1==0:
         s1_fatherlist = self.get_father_of_unmatched_subject(subject1_list)      
      else:
         s1_fatherlist = fatherList_of_subj1

      if [] in s1_fatherlist:
         return "no classof for a token. Cant create relations."

      s2_supertype_list = self.get_supertypeof_unmatched_subject(subject2_list)

      getfathers_4_s2=[]
      s1_list_4_check2=[]
      #check 1: match supertype of types with class of tokens.
      if s2_supertype_list.count([]) != len( s2_supertype_list ):
         s2index=0         
         for s2_list in s2_supertype_list:
             if s2_list != []:
                temp_s1_list=[]
                for s1_list in s1_fatherlist:
                    match_found=0
                    for s1 in s1_list:
                        for s2 in s2_list:
                            if (s1,s2,'tokens','types') in roletypeData:
                               match_found=1
                               break
                        if match_found==1:
                           break
                    if match_found==0:
                       temp_s1_list.append(s1_list)
                if temp_s1_list!=[]:
                   s1_list_4_check2.append(temp_s1_list)
                   getfathers_4_s2=[ subject2_list[s2index] ]    
             else:
                   s1_list_4_check2.append( s1_fatherlist )
                   getfathers_4_s2=[ subject2_list[s2index] ]    

             s2index = s2index +1
         if getfathers_4_s2==[]:
            #print "all relations can be created. checks validated at step1"
            return 1

      else:
           getfathers_4_s2 = subject2_list
           s1_list_4_check2 = []
           for s2len in range(len(subject2_list)): 
               s1_list_4_check2.append( s1_fatherlist )

      #check 2 : match unmatched subject2's father with father of s1.
      s2_fatherlist = self.get_father_of_unmatched_subject(getfathers_4_s2)      
      #print "s2_fatherlist",s2_fatherlist
      #print "s1_list_4_check2",s1_list_4_check2
      if [] in s2_fatherlist:
         return " No classof for a type. Cant create relations."
      for s2_list in s2_fatherlist:
          for s1_multi_list in s1_list_4_check2:
              #s1_multi_list=[[ids of all classof s1 'tokens'],[ids of all classof s1 tokens ], ...]
              for s1_list in s1_multi_list:
                  match_found=0
                  for s1 in s1_list:
                      for s2 in s2_list:
                          if (s1,s2,'tokens','metatypes') in roletypeData:
                             match_found=1
                             break
                      if match_found==1:
                         break
                  if match_found==0:
                     #print "checks condition failed."
                     return -1
      #print "all relations can be created. checks validated at step2"
      return 1


  def create_newReln_checks(self,input,relntypeid,nodetype1_list,nodetype2_list,subject1_list,subject2_list,fatherList_of_subj1=0,supertypeof_subj1_List=0):
      #fatherList_of_subj1=[[fathers inid]],a list of all father inid of subj1.this is passed only from file when type/token is created and its entry is
      #  not in db.
      #supertypeof_subj1_List = [[supertypeof subj1 inid]]. This is passed only from types file when type is created and its entry is not in db.

      #return 1 if all ops successful else -1

      relntype=input['relationtypes']
      #subject1_list is list of inid all of same nodetype
      #subject2_list is list of inid all of same nodetype

      if relntype=="instanceof":#get the nodetype of both subjectlist
         if len(subject1_list)==1: #subject1_list has to be a single value list.subject2_list is multivaluelist
            nodetype2 = nodetype2_list[0]
            for nd2 in nodetype2_list:
                #print nodetype2
                #print nodetype1_list
                if nd2 in nodetype1_list:#it means relationtype=subtypeof and not instanceof 
                    return -1
                elif nodetype2 != nd2:
                     print "Expected nodetype of all ssids of subject2 to be same."
                     return -1

            #for nodetype1=gbfunctions nodetype2 will always be gbmetatypes.
            if nodetype2=="gbmetatypes":
                   if istype(nodetype1_list[0]):  #checking nodetype of subj1 if it ends with 'types'and if subj2nodetype='metatype'.
                      ##print "relation can be created" 
                      # inherit all attributetypes and relationtypes of subject2
                      self.flag_inherit = 1
                   else:
                     ##print "condition not satisfied. Expecting subject1_nodetype to be type and not token when subj2_token='gbmetatypes'"
                     return "condition not satisfied. Expecting subject1_nodetype to be type and not token when subj2_token='gbmetatypes'"

            elif istype(nodetype2):# subject1="token" and subject2="type",with same nodetype(tblname)prefix
                     if nodetype1_list[0]=='gbprocess':
                       #if nodetype1_list[0]==(str(nodetype2_list[0]).split("types"))[0]:
                       if nodetype2_list[0] == 'gbprocesstypes':
                          #print "check for other ssid from subject2_list for instanceof relation "
                          pass
                       else:
                         #print 'instanceof condition not satisfied. Cant create instanceof relation.'
                         return -1
                     elif nodetype1_list[0]==(str(nodetype2_list[0]).split("types"))[0] +"s" :
                          ##print "check for other ssid from subject2_list for instanceof relation "
                          pass
                     else:
                        #print 'instanceof condition not satisfied. Cant create instanceof relation.'
                        return -1 
            else:
                     #print"invalid subj2 nodetype which is 'token' for relation 'instanceof'"
                     return -1
            
            return 1
         else:
             #print "length of subject1 exceeds more than one for relntype='instanceof'.Invalid . "
             return -1
      elif relntype=="subtypeof": #nodetype1 is a single value list  
           if len(nodetype2_list)== nodetype2_list.count(nodetype1_list[0] ):#all nodetype of subject2==nodetype of subject1
              #print "relation can be created"
              self.flag_inherit=1              
              return 1
           else:
              #print "conditions for relation subtypeof not satisfied. ssubtypeof cant be created"
              return -1
      elif relntype=="dependson":
           return 1
      elif relntype=="partof":
           return 1
      else:

        #relationtype can be some other type. both subject1_list and subject2_list can be multi value list.

        #getting all data from gbroletypes at once for the given relntypeid
        #print relntypeid
        if nodetype1_list[0]=='gbmetatypes':
           ndtype1='metatypes'
        elif istype(nodetype1_list[0]):
           ndtype1='types'
        else:
           ndtype1='tokens'

        if nodetype2_list[0]=='gbmetatypes':
           ndtype2='metatypes'
        elif istype(nodetype2_list[0]):
           ndtype2='types'
        else:
           ndtype2='tokens'
        
        if ndtype1=='metatypes' and ndtype2=='types':
           roletypeData=self.get_roletypeData(relntypeid)
           #roletypeData_from_db=[(subjectype1,subjecttype2,applicablenodetypes1,applicablenodetypes2),(),(), ...]only for roletypeid=rtid
           #roletypeData_from_db=[(subjectype1,subjecttype2,'types','types'),(subjectype11,subjecttype22,None,None),(), ...]only for roletypeid=trid
           #print roletypeData

           #print "invoking check_M_T:======="
           return self.check_M_T(subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List)

        elif ndtype1=='types' and ndtype2=='metatypes':
             roletypeData=self.get_roletypeData(relntypeid)
             #roletypeData_from_db=[(subjectype1,subjecttype2,applicablenodetypes1,applicablenodetypes2),(),(), ...]only for roletypeid=rtid
             #roletypeData_from_db=[(subjectype1,subjecttype2,'types','types'),(subjectype11,subjecttype22,None,None),(), ...]only for roletypeid=trid
             #print roletypeData

             #print "invoking check_T_M:======="
             return self.check_T_M(subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List)

        elif ndtype1=='types' and ndtype2=='types':
             roletypeData=self.get_roletypeData(relntypeid)
             return self.check_T_T(subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List)

        elif ndtype1=='tokens' and ndtype2=='tokens':
             #supertypeof_subj1_List ==0 always.
             roletypeData=self.get_roletypeData(relntypeid)
             if fatherList_of_subj1 == 0 :
                s1_fatherlist = self.get_father_of_unmatched_subject(subject1_list)      
             else:
                s1_fatherlist = fatherList_of_subj1

             #print "s1_fatherlist",s1_fatherlist
             if [] in s1_fatherlist:
                return "no classof for a token. Cant create relations."

             s2_supertype_list = self.get_supertypeof_unmatched_subject(subject2_list)
             #print "s2_supertype_list ===",s2_supertype_list 
             if [] in s2_supertype_list:
                return "no supertypeof for a metatype. Cant create relations."
      
             return self.check_M_M(s1_fatherlist,s2_supertype_list,roletypeData,'tokens','tokens')

        elif ndtype1=='metatypes' and ndtype2=='tokens':
             #here fatherList_of_subj1=0  always.
             roletypeData=self.get_roletypeData(relntypeid)

             if supertypeof_subj1_List == 0:
                s1_supertype_list = self.get_supertypeof_unmatched_subject(subject1_list)
             else:
                s1_supertype_list = supertypeof_subj1_List

             #print "s1_supertype_list ===",s1_supertype_list 
             if [] in s1_supertype_list:
                return "no supertypeof for a metatype. Cant create relations."
             
             s2_fatherlist = self.get_father_of_unmatched_subject(subject2_list)      
             #print "s2_fatherlist",s2_fatherlist
             if [] in s2_fatherlist:
                return "no classof for a token. Cant create relations."
      
             return self.check_M_M(s1_supertype_list,s2_fatherlist,roletypeData,'types','tokens')

        elif ndtype1=='tokens' and ndtype2=='metatypes':
             #supertypeof_subj1_List ==0 always.
             roletypeData=self.get_roletypeData(relntypeid)
             if fatherList_of_subj1 == 0 :
                s1_fatherlist = self.get_father_of_unmatched_subject(subject1_list)      
             else:
                s1_fatherlist = fatherList_of_subj1

             #print "s1_fatherlist",s1_fatherlist
             if [] in s1_fatherlist:
                return "no classof for a token. Cant create relations."

             s2_supertype_list = self.get_supertypeof_unmatched_subject(subject2_list)
             #print "s2_supertype_list ===",s2_supertype_list 
             if [] in s2_supertype_list:
                return "no supertypeof for a metatype. Cant create relations."
      
             return self.check_M_M(s1_fatherlist,s2_supertype_list,roletypeData,'tokens','types')


        elif ndtype1=='metatypes' and ndtype2=='metatypes':
             #here fatherList_of_subj1=0  always.
             roletypeData=self.get_roletypeData(relntypeid)

             if supertypeof_subj1_List == 0:
                s1_supertype_list = self.get_supertypeof_unmatched_subject(subject1_list)
             else:
                s1_supertype_list = supertypeof_subj1_List

             #print "s1_supertype_list ===",s1_supertype_list 
             if [] in s1_supertype_list:
                return "no supertypeof for a metatype. Cant create relations."
             
             s2_supertype_list = self.get_supertypeof_unmatched_subject(subject2_list)
             #print "s2_supertype_list ===",s2_supertype_list 
             if [] in s2_supertype_list:
                return "no supertypeof for a metatype. Cant create relations."
      
             return self.check_M_M(s1_supertype_list,s2_supertype_list,roletypeData,'types','types')

        elif ndtype1=='types' and ndtype2=='tokens':
             roletypeData=self.get_roletypeData(relntypeid)
             #roletypeData_from_db=[(subjectype1,subjecttype2,applicablenodetypes1,applicablenodetypes2),(),(), ...]only for roletypeid=rtid
             #roletypeData_from_db=[(subjectype1,subjecttype2,'types','types'),(subjectype11,subjecttype22,None,None),(), ...]only for roletypeid=trid
             #print roletypeData
             
             #print "invoking check_T_t:======="
             return self.check_T_t(subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List)

        elif ndtype1=='tokens' and ndtype2=='types':
             roletypeData=self.get_roletypeData(relntypeid)
             #roletypeData_from_db=[(subjectype1,subjecttype2,applicablenodetypes1,applicablenodetypes2),(),(), ...]only for roletypeid=rtid
             #roletypeData_from_db=[(subjectype1,subjecttype2,'types','types'),(subjectype11,subjecttype22,None,None),(), ...]only for roletypeid=trid
             #print roletypeData
             
             return self.check_t_T(subject1_list,subject2_list,roletypeData,fatherList_of_subj1,supertypeof_subj1_List)




  def getData_from_gbrelations(self,nid_list,relntype_inid):
      reln_ssid=0
      sql="SELECT ssid,nid FROM gbrelations WHERE nid in %s and relationtype=%s;"%(listofcharacter_2string(nid_list),relntype_inid)
      #print sql
      execute_query(sql,self.curs)
      return query_fetchall(self.curs)#[(ssid,nid),(ssid,nid), ...]

  def generate_nid_relnssid_dic(self,all_nids_list,gbDatalist):#gbdatalist=list of ssid,nid which were found in gbrelations table.
      existing_nid_relnssid_dic={}
      unfound_nid_relnssid_dic={}
      for elements in gbDatalist:
          existing_nid_relnssid_dic[elements[1]]=elements[0]
      # upto this point existingnid_relnssid_dic={'nid':'ssid', ...} that were found in gbrelations table.
      #all_nids_list=['inid1_inid2', ...]
      #now we add remaining nids' ie unfound nids to unfound_nid_relnssid_dic={}
      for nids in all_nids_list:
          if existing_nid_relnssid_dic.has_key(nids):
             pass# nid found in gbrelations table
          else:
            new_reln_ssid=get_next_sequence_value('ssid_seq',self.curs)                     
            #print "heheheheheheheheheheh new reln ssid created=",new_reln_ssid
            unfound_nid_relnssid_dic[nids]=new_reln_ssid#adding unfound nid with new relnssid 
      gbnid_relnssid_dic={}
      gbnid_relnssid_dic['unfound']=existing_nid_relnssid_dic
      if unfound_nid_relnssid_dic!={}:
         gbnid_relnssid_dic['new_reln_ssid']=unfound_nid_relnssid_dic
      #at this point gbnid_relnssid_dic, we have all nid with their corresponding relnssid.
      return gbnid_relnssid_dic

  def create_data4newsnapshot(self,subject1_inid_list,subject2_inid_list,old_subject1ssid_list,old_subject2ssid_list,combined_dic): 
      gbnid_relnssid_dic=combined_dic['unfound']
      if combined_dic.has_key('new_reln_ssid'):
         unfound_nid_relnssid_dic=combined_dic['new_reln_ssid']
         gbnid_relnssid_dic.update(unfound_nid_relnssid_dic)#merging both dics into a single
      #print "gbnid_relnssid_dic  ",gbnid_relnssid_dic  
      subj1ssid_relnssidlist_dic={}      
      for i1 in range(len(subject1_inid_list)):
          all_reln_ssid_list=[]
          for i2 in range(len(subject2_inid_list)):
              all_nid=str(subject1_inid_list[i1])+"_"+str(subject2_inid_list[i2])
              all_reln_ssid_list.append(gbnid_relnssid_dic[all_nid])
          subj1ssid_relnssidlist_dic[old_subject1ssid_list[i1]]=all_reln_ssid_list

      subj2ssid_relnssidlist_dic={}
      for i2 in range(len(subject2_inid_list)):
          all_reln_ssid_list=[]
          for i1 in range(len(subject1_inid_list)):
              all_nid=str(subject1_inid_list[i1])+"_"+str(subject2_inid_list[i2])
              all_reln_ssid_list.append(gbnid_relnssid_dic[all_nid])
          subj2ssid_relnssidlist_dic[old_subject2ssid_list[i2]]=all_reln_ssid_list
      final_dic={}
      final_dic['subj1ssid_relnssidlist_dic']=subj1ssid_relnssidlist_dic
      final_dic['subj2ssid_relnssidlist_dic']=subj2ssid_relnssidlist_dic
      return final_dic


  def write_in_gbrelations(self,uid,status,relntype_inid,subj1_inid_list,subj2_inid_list,subj1_ssid_list,subj2_ssid_list):
    #subj1_ssid_list is list of old_subj1_ssid's
    #print "relntype_ssid",relntype_inid
    nid_list=[]
    value_sql=""
    #print "subj1_inid_list:",subj1_inid_list
    #print "subj2_inid_list:",subj2_inid_list

    for subj1_inid in subj1_inid_list:
        for subj2_inid in subj2_inid_list:
            single_nid=str(subj1_inid)+"_"+str(subj2_inid)  
            nid_list.append(single_nid)#all possible reln pair nid_list
    #print "in write_in_gbrelations, nid_list=",nid_list      

    gbDatalist=self.getData_from_gbrelations(nid_list,relntype_inid)#gbdatalist=list of ssid,nid which were found in gbrelations table.

    gbnid_relnssid_dic=self.generate_nid_relnssid_dic(nid_list,gbDatalist)#dic with key='nid' and value='relnssid'. all values

    #print "gbnid_relnssid_dic",gbnid_relnssid_dic
    if gbnid_relnssid_dic.has_key('new_reln_ssid'):
       unfound_dic=gbnid_relnssid_dic['new_reln_ssid']
       unfound_tuples=unfound_dic.items()
       for tuple in unfound_tuples:
           nid=tuple[0]
           ssid=inid=tuple[1]
           bind_nidssid(ssid,nid,inid,"gbrelations",self.curs)#for all new relation that are if created
           bind_nidlatestssid(ssid,nid,self.curs)#for all new relations that are if created
           splitted_nid=nid.split("_")
           #print splitted_nid
           subj1_inid=splitted_nid[0]
           subj2_inid=splitted_nid[1]
           #print relntype_inid
           value_sql=value_sql+"(%s,'%s',%s,%s,'%s',4,'{status,relationtype,subject1,subject2}','{1,1,1,1}',0,0,'{0}',%s,%s,%s),"%(ssid,nid,inid,uid,status,str(relntype_inid),str(subj1_inid),str(subj2_inid))
           #print value_sql
       value_sql = value_sql[:-1]
       sql="INSERT INTO gbrelations(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,relationtype,subject1,subject2) values %s;"%value_sql
       #print sql
       
       execute_query(sql,self.curs)

    else:
         #print "no new reln to create. Just create new snapshot of the subjects."
         pass

    return gbnid_relnssid_dic

  def startchecks_n_callwrite(self,input,relntype_inid,newsubject1_ssid_list,newsubject2_ssid_list,subject2_inid_list,make_newsnapshot_of_subj2=1,fatherList_of_subj1=0,supertypeof_subj1_List=0):

      #supertypeof_subj1_List is passed from types file where subject is not in db and possible its supertypeof is known.
      #fatherList_of_subj1 

      if input.has_key('nodetype1_list'):#

         nodetype1_list=input['nodetype1_list']
         subject1_inid_list=input['subject1']#here input['subject1']=subject1_ssid_list==subject1_inid_list.
         make_newsnapshot_of_subj1=0
      else:
          nodetype1_list= get_nodetype_from_gbnidssid(input['subject1'],"ssid",self.curs)#id is ssid and id_list is a list cooresponding to ssid 
          subject1_inid_list=get_inid_from_ssid(input['subject1'],self.curs)
          make_newsnapshot_of_subj1=1

      nodetype2_list= get_nodetype_from_gbnidssid(input['subject2'],"ssid",self.curs)#id is ssid and id_list is a list cooresponding to ssid 
      #print nodetype1_list
      #print nodetype2_list

      if self.create_newReln_checks(input,relntype_inid,nodetype1_list,nodetype2_list,subject1_inid_list,subject2_inid_list,fatherList_of_subj1,supertypeof_subj1_List)==-1:
           #print "errrorr"  
           return -1
      else: 
             #relations can be created. Now if relations already exists dont recreate.
             redundantFree_subject2_inid_Set=set(subject2_inid_list)
             redundantFree_subject2_inid_list=list(redundantFree_subject2_inid_Set)
             redundantFree_subject1_inid_Set=set(subject1_inid_list)
             redundantFree_subject1_inid_list=list(redundantFree_subject1_inid_Set)
             #print "subject1_inid_list",subject1_inid_list
             #print"redundantFree_subject1_inid_list",redundantFree_subject1_inid_list
             #print "subject2_inid_list",subject2_inid_list
             #print "redundantFree_subject2_inid_list",redundantFree_subject2_inid_list
             #print
             #print "calling write_in_gbrelations"

             gbnid_relnssid_dic=self.write_in_gbrelations(input['uid'],input['status'],relntype_inid,redundantFree_subject1_inid_list,redundantFree_subject2_inid_list,input['subject1'],input['subject2'])
             #print gbnid_relnssid_dic
             final_dic=self.create_data4newsnapshot(subject1_inid_list,subject2_inid_list,input['subject1'],input['subject2'],gbnid_relnssid_dic) 

             subj1ssid_relnssidlist_dic=final_dic['subj1ssid_relnssidlist_dic']
             #print "subj1ssid_relnssidlist_dic",subj1ssid_relnssidlist_dic
             subj2ssid_relnssidlist_dic=final_dic['subj2ssid_relnssidlist_dic']
             #print "subj2ssid_relnssidlist_dic",subj2ssid_relnssidlist_dic

             newRelnssidList_4_subj1List=[]             
             for element_no in range(len(input['subject1'])):
                 newRelnssidList_4_subj1List.append(subj1ssid_relnssidlist_dic[input['subject1'][element_no]])
             newRelnssidList_4_subj2List=[]
             for element_no in range(len(input['subject2'])):
                 newRelnssidList_4_subj2List.append(subj2ssid_relnssidlist_dic[input['subject2'][element_no]])
             #print "newRelnssidList_4_subj2List",newRelnssidList_4_subj2List

             final_return_dic={}
             if make_newsnapshot_of_subj1==1:
                #creating new snapshot of the ssids of subject1.--->rendernbh has only rightrole. 
                #making input['relationtypes']into a list as req 4 type_nid_list in create new snapshot.
                rendernbhData_list=newsubject2_ssid_list

                # inheritance logic ---start
                if self.flag_inherit == 1:
                      from Inherit import *
                      inherit_obj = Inherit(self.constring,self.uid)
                      inherit_rendernbh_dic = inherit_obj.inherit( newsubject1_ssid_list ,subject1_inid_list, nodetype1_list[0], input['subject2'])
                      rendernbhData_list.append("rightroles")
                      rendernbhData_list.insert(0,inherit_rendernbh_dic)
                      final_return_dic['inherit_obj'] = inherit_obj
                # end---
                else:      
                      rendernbhData_list.append("rightroles")
                      rendernbhData_list.insert(0,{})
                create_newsnapshot("relations",nodetype1_list,input['uid'],input['subject1'],newsubject1_ssid_list,[input['relationtypes']],newRelnssidList_4_subj1List,rendernbhData_list,self.curs)

                #print "updating ssid of subject 1"
                subject1_nid_list=get_nid_from_ssid(input['subject1'],self.curs)
                for ssid_no in range(len(subject1_nid_list)):
                    #writing and updating ssid of the subject involved in relation
                    reset_ssid_2_latestssid(newsubject1_ssid_list[ssid_no],subject1_nid_list[ssid_no],self.curs)
                    #bind_nidlatestssid(newsubject1_ssid_list[ssid_no],subject1_nid_list[ssid_no],self.curs)
                    bind_nidssid(newsubject1_ssid_list[ssid_no],subject1_nid_list[ssid_no],subject1_inid_list[ssid_no],nodetype1_list[ssid_no],self.curs)

             subj2_snapshot_dic={}       

             if make_newsnapshot_of_subj2==1: #this is satisfied only when nodetype='relation'
                #creating new snapshot of the ssids of subject2.--->rendernbh has only leftrole. 
                rendernbhData_list=newsubject1_ssid_list
                rendernbhData_list.append("leftroles")
                rendernbhData_list.insert(0,{}) # for inherit logic.
                print rendernbhData_list
                create_newsnapshot("relations",nodetype2_list,input['uid'],input['subject2'],newsubject2_ssid_list,[input['relationtypes']],newRelnssidList_4_subj2List,rendernbhData_list,self.curs)
                subject2_nid_list=get_nid_from_ssid(input['subject2'],self.curs)
                #print "subject2_nid_list",subject2_nid_list
                for ssid_no in range(len(subject2_nid_list)):
                    #writing and updating all ssid of the subject2 involved in relation
                    reset_ssid_2_latestssid(newsubject2_ssid_list[ssid_no],subject2_nid_list[ssid_no],self.curs)
                    #bind_nidlatestssid(newsubject2_ssid_list[ssid_no],subject2_nid_list[ssid_no],self.curs)
                    bind_nidssid(newsubject2_ssid_list[ssid_no],subject2_nid_list[ssid_no],subject2_inid_list[ssid_no],nodetype2_list[ssid_no],self.curs)
             else:
                subj2_snapshot_dic['nodetype2_list'] = nodetype2_list 
                subj2_snapshot_dic['newRelnssidList_4_subj2List'] =  newRelnssidList_4_subj2List
                final_return_dic['subj2_snapshot_dic'] = subj2_snapshot_dic
                
             #creating instanceof relation between all new relation and the common relation type. no of relation= number of subject1 * no of subject2.
             reln_instanceof_relntype_value_sql=""
             #print 'newRelnssidList_4_subj1List ------------------',newRelnssidList_4_subj1List
             #print 'newRelnssidList_4_subj2List -------------------',newRelnssidList_4_subj2List
             for reln_ssid_between_subj1subj2 in newRelnssidList_4_subj1List:
                 reln_instanceof_relntype_ssid = get_next_sequence_value('ssid_seq',self.curs)   #creating new reln_ssid for instanceof.
                 
                 #print  '-----reln_ssid_between_subj1subj2[0]-----',reln_ssid_between_subj1subj2[0] 
              
                 bind_nidssid( reln_instanceof_relntype_ssid, str( reln_ssid_between_subj1subj2[0] )+"_"+str( relntype_inid ) , reln_instanceof_relntype_ssid,'gbrelations',self.curs )
                 bind_nidlatestssid(reln_instanceof_relntype_ssid,str( reln_ssid_between_subj1subj2[0] )+"_"+str( relntype_inid ),self.curs)

                 reln_instanceof_relntype_value_sql=reln_instanceof_relntype_value_sql+"(%s,'%s',%s,%s,'%s',4,'{status,instanceof,subject1,subject2}','{1,1,1,1}',0,0,'{0}',%s,%s,%s)"%( reln_instanceof_relntype_ssid, str( reln_ssid_between_subj1subj2[0] ) +"_"+ str( relntype_inid) , reln_instanceof_relntype_ssid ,input['uid'],input['status'],'2',str( reln_ssid_between_subj1subj2[0] ), str( relntype_inid ))+","
             #print  reln_instanceof_relntype_value_sql

             reln_instanceof_relntype_sql="INSERT INTO gbrelations (ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,relationtype,subject1,subject2) values %s;"%reln_instanceof_relntype_value_sql.rstrip(",")
             execute_query(reln_instanceof_relntype_sql,self.curs)
             #end 

             if input.has_key('set_relation'): #this will be invoked only from set_relation
                temp_return_dic = final_dic
                temp_return_dic['nodetype2_list'] = nodetype2_list
                temp_return_dic['flag_inherit'] = self.flag_inherit
                ##print "returning ", temp_return_dic
                return temp_return_dic
             else:
                final_return_dic['subj1ssid_relnssidlist_dic']= final_dic['subj1ssid_relnssidlist_dic']
                final_return_dic['flag_inherit'] = self.flag_inherit
                #print final_return_dic
                return  final_return_dic

if __name__=="__main__":
  #dont pass nodetype1 when running relations.py. It is req for files like user.py as it is flag for creating or not new snapshot.. 
  constring="dbname=<postgres_databasename> user=<postgres_username> password=<postgres_password> host=localhost"

  uid=1
  obj=relations(constring,uid)
  """
  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['41'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['36'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'haspart' #[mandatory field]
                 }                                              
                 

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['64'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['56'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'mtRTmt' #[mandatory field]
                 }                                              



  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['57'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['90'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'T_RT_T' #[mandatory field]
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['95'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['99'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'TT1' #[mandatory field]
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['30'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['25'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'instanceof' #[mandatory field]
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['85'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['60'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'instanceof' #[mandatory field]
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['110'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['114'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'TT2' #[mandatory field]
                 }                                              


  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['125'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['106'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'TT3' #[mandatory field]
                 }                                              
  
  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['105'],  #(list of ssid tokens)  #[mandatory field]
                 'subject2':['126'], #(list of ssids tokens) #[mandatory field]
                 'relationtypes':'TT4' #[mandatory field]
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['28','35'], 
                 'subject2':['42','45'], 
                 'relationtypes':'Tt1' 
                 }                                              


  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['59','64'], 
                 'subject2':['50','51'], 
                 'relationtypes':'Tt2' 
                 }                                              



  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['82','83'], 
                 'subject2':['48','49'], 
                 'relationtypes':'tT1' 
                 }                                              


  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['90','91'], 
                 'subject2':['70','69'], 
                 'relationtypes':'tT2' 
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['130','125'], 
                 'subject2':['114','115'], 
                 'relationtypes':'rt_MT1' 
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['144','145'], 
                 'subject2':['92','93'], 
                 'relationtypes':'rt_MT2' 
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['147','146'], 
                 'subject2':['155','156'], 
                 'relationtypes':'rt_TM1' 
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['208','209'], 
                 'subject2':['218','219'], 
                 'relationtypes':'rt_TM2' 
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['216','217'], 
                 'subject2':['265','270'], 
                 'relationtypes':'type_rt_type' 
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['216','217'], 
                 'subject2':['265','270'], 
                 'relationtypes':'type_rt_type_2' 
                 }                                              

  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['275','276'], 
                 'subject2':['278','277'], 
                 'relationtypes':'rt_TT1' 
                 }                                              
  """
  input = {      'uid':'1',      
                 'status':'Public',
                 'subject1':['228'], 
                 'subject2':['119'], 
                 'relationtypes':'instanceof' 
                 }                                              

  relntype_inid = obj.start_checks(input['subject1'],input['subject2'],input['relationtypes'])
  if relntype_inid!=-1:
        newsubject1_ssid_list=[]
        newsubject2_ssid_list=[]
        for s1 in range(len(input['subject1'])):
            newsubject1_ssid_list.append(get_next_sequence_value('ssid_seq',obj.curs))
        for s2 in range(len(input['subject2'])):
            newsubject2_ssid_list.append(get_next_sequence_value('ssid_seq',obj.curs))

        subject2_inid_list=get_inid_from_ssid(input['subject2'],obj.curs) 
        final_dic=obj.startchecks_n_callwrite(input,relntype_inid,newsubject1_ssid_list,newsubject2_ssid_list,subject2_inid_list,1,0,0)
        if final_dic!=-1:
           commitclose(obj.curs,obj.conn)



