# -*- coding: utf-8 -*- 
 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__author__ = """Rajiv Nair <rajivnair@gnu.org>"""

import psycopg2
from GeneralMethods import *
from UpdateMethods import *
import cPickle
import os,sys
from datetime import datetime
from base64 import b64encode,b64decode


class GetMethods:
	def __init__(self , conString):
		self.constring = conString
		self.conn = psycopg2.connect( conString )   
		self.curs = self.conn.cursor() 
		self.subtypes = []
		self.instances = []

        def getsnapshots_history_n_version(self,nodetype,ssid):

                sql="select inid from %s where ssid=%s;"%(nodetype,ssid)
                self.curs.execute( sql )
                fetched_result = self.curs.fetchall()
                if fetched_result==[]:
                        return "Incorrect data."
                else:
                        inid = fetched_result[0][0]

                sql="select ssid,history,noofcommits,noofchangesaftercommit from %s where inid = %s;"%(nodetype,inid)
                self.curs.execute(sql)
                data = self.curs.fetchall() #[(ssid,history,noofcommits,noofchangesaftercommit), ...]                                                        
                d={}
                for tuple in data:
                        len1 = len(tuple[1])
			version=str(tuple[2])+"."+str(tuple[3])
                        d[str(tuple[0])]=[str( tuple[1][len1-1] ),version]
                return d


		

	def getlatestVersion(self, nid):
		query = "select ssid from gbnid_latestssid where nid='%s';" % ( nid )
		self.curs.execute( query )	
		result = self.curs.fetchall()
		return str( result[0][0] )


	def searchfs( self, querystr, userid, path):
		"""
		"""
		datapath = path + '/searchfolder' 
		l = self.getAll('gbobjects')
		a = self.getAllnbh(l.values())
		m = {}
		for elem in a:
			filepath = datapath +'/' + str(elem['ssid'])
			os.system('touch  '+filepath)
			filept = open(filepath,'w')
			filept.write( str(elem['rendered_nbh']['attributes']) )
			filept.close()
		return 'done'


	def make_string_safe( self, value ):
		"""
		"""
		if isinstance( value, str ):
			value = value.replace("  ","")
			value = value.replace(" ","&")
			value = value.replace( "'", "''" )

		return value



	def searchNodes( self, searchstr, tblname, userid = '0', searchtype = '0'):
		"""
		searches for nids given the table name
		"""


		newsearchstr = self.make_string_safe( searchstr )
	 	
		queryResult = None
		language = 'english'

		dot = '.'
		star = '*'
		percent = '%'

		
		#query = "select max(ssid),nid from %s where nid ~* '%s%s%s%s%s'  group by nid;" %(tblname,dot,star,newsearchstr,dot,star)
		if searchtype == '0':
		   query = "select max(ssid),nid from %s where to_tsvector('%s',nid) @@ to_tsquery('%s','%s')  group by nid;" %(tblname,language,language,newsearchstr)
		if searchtype == '1':	
		   query = "select max(ssid),nid from %s where nid LIKE '%s%s'  group by nid;" %(tblname,newsearchstr,percent)

		result = self.curs.execute( query )
		queryResult = self.curs.fetchall()
		if queryResult == None:
			return []
		else:
			return queryResult
	

	def search(self,querystr,tblnames,userid='0'):
		"""
		"""
		
		
		finalresults = []
		for tbl in tblnames:
			searchresult = self.searchNodes( querystr, tbl, userid)
			if searchresult <> []:
				for value in searchresult:
					finalresults.append( {'ssid':str(value[0]),'nid':value[1],'nodetype':tbl,'type':['nid']} )
		return finalresults
		
	
	# def search (self, querystr, userid):
	# 	"""
	# 	"""
		
	# 	query = "select * from searchby_nid('%s');" %( querystr )
		
	# 	execute_query(query,self.curs)
	# 	values = query_fetchall(self.curs)
	# 	searchresults = []
	# 	unique_ssidlist = []

	# 	uniqueidlist = []

	# 	if values == []:
	# 		pass 
	# 	else:
			
	# 		for elem in values:
	# 			searchresults_dict = {}
	# 			uniqueidlist.append( str( elem[2] ) )
	# 			searchresults_dict.update({'ssid':str(elem[2])})
	# 			searchresults_dict.update({'nid' : str(elem[0])})
	# 			searchresults_dict.update({'nodetype' : str(elem[1])})
	# 			searchresults_dict.update({'type' : ['nid']})
	# 			searchresults.append( searchresults_dict )
	# 	#print	"searchresults ",searchresults				
		
	# 	query = "select * from search_gnowsys('%s');" %( querystr )
	# 	execute_query(query,self.curs)
	# 	values = query_fetchall(self.curs)
		
	# 	if values == []:
	# 		return searchresults
	# 	else:
	# 		for elem in values:

	# 			if str(elem[5]) not in uniqueidlist:
	# 				 uniqueidlist.append( str(elem[5]) )


	# 			for dic in searchresults :
	# 				flag_dic_exists=0
	# 				if dic['ssid'] == str(elem[5]):
	# 					if str(elem[1]) in dic['type']:
	# 						pass
	# 					else:
	# 						dic['type'].append( str(elem[1]) )
	# 					flag_dic_exists=1
	# 					break

	# 			if flag_dic_exists == 0:
	# 				searchresults_dict={}    
	# 				searchresults_dict.update({'ssid':str(elem[5])})
	# 				searchresults_dict.update({'nid' : str(elem[0])})
	# 				searchresults_dict.update({'nodetype' : str(elem[4])})
	# 				searchresults_dict.update({'type' : [ str(elem[1])]  })
	# 				searchresults.append( searchresults_dict )
	        
					
	# 	latestids = self.getlatestssids( uniqueidlist , 'inid', userid)

	# 	for dictionary in searchresults:
	# 		try:
	# 			dictionary['ssid'] = latestids[ dictionary['ssid'] ]
	# 		except:
	# 			searchresults.remove( dictionary )

	# 	return searchresults


	def get_uid(self,nodetype,ssid_list):
		sql="select uid,ssid from %s where ssid in %s;"%(nodetype,list2string(ssid_list))
                execute_query(sql,self.curs)
                multivalue_list = query_fetchall(self.curs)
                if len(multivalue_list) != len(ssid_list):
                        return 0
                else:
                        return rearrange_list(ssid_list,multivalue_list)

        def getUsernamefromUserId_list(self,uid_list,flag_dic=0):
		uid_list = list(set(uid_list))
                sql="select nid,ssid from gbusers where ssid in %s;"%(list2string(uid_list))
                execute_query(sql,self.curs)
                multivalue_list = query_fetchall(self.curs)
                if len(multivalue_list) != len(uid_list):
			return 0
                else:
                        if flag_dic ==0:
                                return rearrange_list(uid_list,multivalue_list)
                        else:
                                dic ={}
                                for tuple in multivalue_list:
                                        dic[ str(tuple[1]) ] = tuple[0]
                                return dic

		
		
	def getAll(self,nodetype,userid = '0'):
		sql="select nid,max(ssid) from %s where (uid=%s or status='public' or status='Public') group by nid;"%(nodetype,userid)
		execute_query(sql,self.curs)
                nid_latestssid=query_fetchall(self.curs)#[(,),(,), ...]
		final_dic={}
		ssidlist = []
		for tuple in nid_latestssid:
			ssidlist.append( str(tuple[1]) )

		if  ssidlist <> []:
			for tuple in nid_latestssid:
				final_dic[ str( tuple[0] ) ] = str(tuple[1])
		return final_dic
	        
#               sql="select ssid from %s ;"%(nodetype)
# 		execute_query(sql,self.curs)
#               tuple_ssids = query_fetchall(self.curs)#[(,),(,), ...]
		
# 		list_ssids = []
# 		for tuple in tuple_ssids :
# 			list_ssids.append( str(tuple[0]) )
	
# 		finaldict = self.getinfoFromSSID( list_ssids )
# 		return finaldict

	def get_inid_from_nid(self,nid_list):
		return get_inid_from_nid(nid_list,self.curs)

	def replaceStructure( self, ssid ,nodetype , structure , old_rnbh=0):
		
		if old_rnbh==0: # while calling this function rnbh was not present whose structure 
			rnbh_query = "select rendered_nbh from %s where ssid=%s;"%(nodetype,ssid)
			execute_query(rnbh_query,self.curs)
			value = query_fetchall(self.curs)
			print value
			try:
				rnbh_dic =  cPickle.loads(b64decode( value[0][0] ))
			except:
				rnbh_dic={}
		else:
			rnbh_dic = old_rnbh

		print rnbh_dic
		rnbh_dic['structure']=structure
		query="Update %s set rendered_nbh='%s' where ssid=%s;"%(nodetype,b64encode(cPickle.dumps(rnbh_dic)),ssid)
		print query
		execute_query(query,self.curs)
		commitclose(self.curs,self.conn)
		

	def updateStructure( self, ssid ,nodetype , structure_to_append ):
		rnbh_query = "select rendered_nbh from %s where ssid=%s;"%(nodetype,ssid)
		execute_query(rnbh_query,self.curs)
		value = query_fetchall(self.curs)
		print value
		try:
			rnbh_dic =  cPickle.loads(b64decode( value[0][0] ))
		except:
			rnbh_dic={}

		if rnbh_dic.has_key('structure'):
			structure = rnbh_dic['structure']
		else:
			structure = []
			
		structure = structure + structure_to_append 
		rnbh_dic['structure'] = structure
		print rnbh_dic
		query="Update %s set rendered_nbh='%s' where ssid=%s;"%(nodetype,b64encode(cPickle.dumps(rnbh_dic)),ssid)
		print query
		execute_query(query,self.curs)
		commitclose(self.curs,self.conn)
	        
	def getUsernamefromUserId(self,uid):
	        sql="select nid from gbusers where ssid=%s;"%(uid)
		execute_query(sql,self.curs)
		return query_fetchall(self.curs)[0][0]
	        
	def getUserIdfromUsername(self,username):
		"""
		sql="select inid from gbattributetypes where nid='username';"
		execute_query(sql,self.curs)
		attributetype_ssid=query_fetchall(self.curs)[0][0]
		
		sql="select subject_inid from datatypes_varchar where value='%s' and attributetype_inid=%s;"%(username,attributetype_ssid)
		execute_query(sql,self.curs)
		
		subject_inid=query_fetchall(self.curs)[0][0]
		
		sql="select uid from gbusers where inid=%s;"%(subject_inid)
		execute_query(sql,self.curs)
		return query_fetchall(self.curs)[0][0]
		"""
		sql="select uid from gbusers where nid='%s';"%(username)
		execute_query(sql,self.curs)
		return query_fetchall(self.curs)[0][0]
			

	def getNeighbourhood(self,ssid_list,getwhat,nodetypes=[]):
		"""
		"""
		
		nodetype_ssid = {}

		if nodetypes <> []:
			for nodetype in nodetypes:
				nodetype_ssid.update( { nodetype: ssid_list} )
		else:
			ssid_nodetype= self.getNodetypes(ssid_list)
			for ssid in ssid_nodetype:
				nt = ssid_nodetype[ssid]
				if not nodetype_ssid.has_key( nt ):
					nodetype_ssid.update( { nt: [ssid] } )
				else:
					l = nodetype_ssid[nt]
					l.append(ssid)
					nodetype_ssid.update( { nt: l } )
		
                
		rnbh_dic={}
		
		for nt in nodetype_ssid:  
		    sql="SELECT ssid,%s FROM %s WHERE ssid in %s;"%(getwhat,nt,list2string(nodetype_ssid[nt]))
		    execute_query(sql,self.curs)
		    value = query_fetchall(self.curs)
		    print value
		    if value != []:
			    for elem in value:
				    try:
					    rnbh_dic[str(elem[0])] = cPickle.loads(b64decode( elem[1] ))
				    except:
					    rnbh_dic[str(elem[0])] = None
		    else:
			    pass

		return rnbh_dic


	def getAllnbh(self,ssid_list):
		nodetype_list=get_nodetype_from_gbnidssid(ssid_list,'ssid',self.curs)
		
		final_list=[]
		
		for index in range(len(ssid_list)):  
		    final_dic={}
		    selectsql= get_schema_sql(nodetype_list[index])
		    sql="select %s from %s where ssid=%s" %( selectsql, nodetype_list[index], ssid_list[index])
		    #sql	="select * from %s where ssid=%s ;"%(nodetype_list[index],ssid_list[index])
		    execute_query(sql,self.curs)
		    fetched_value = query_fetchall(self.curs)#check output format.[, , , ]
		    schema_list = get_schema(nodetype_list[index])
		    for s in range(len(schema_list)):
			if (schema_list[s]=='gbtimestamp'):    
			   str1=str(fetched_value[0][s]).strip("datetime.datetime(")
			   #print "str1",str1
			   final_dic[schema_list[s]]=str1
			elif (schema_list[s]=='nbh') or (schema_list[s]=='rendered_nbh'):   
				if fetched_value[0][s] != None :
					try:
						final_dic[schema_list[s]] = cPickle.loads(b64decode ( fetched_value[0][s] ) )
					except:
						final_dic[schema_list[s]] = None
				else:
					final_dic[schema_list[s]] = fetched_value[0][s]
			else:
				final_dic[schema_list[s]] = fetched_value[0][s]
				
		    final_list.append(final_dic)
		 
		return final_list
		    

	def getAllSnapshots(self,variable_query,variable_value,userid='0'):#variable_query=ssid/inid/nid 
		variable_value=variable_value.replace("'","''")
		#print variable_value
                sql="select nodetype from gbnidssid where %s='%s';"%(variable_query,variable_value)
		##print sql
                execute_query(sql,self.curs)
                try:
			nodetype=query_fetchall(self.curs)[0][0]
		except:
			return []
                if variable_query=='ssid':
                        sql="select ssid from %s where inid=(select inid from %s where ssid=%s) and (uid=%s or status='public' or status='Public');"%(nodetype,nodetype,variable_value,userid)
                elif variable_query=='nid':
			#print variable_value
                        sql="select ssid from %s where %s='%s' and (uid=%s or status='public' or status='Public');"%(nodetype,variable_query,variable_value,userid)
			#print sql
		else:#this is inid                       
                        sql="select ssid from %s where %s=%s and (uid=%s or status='public' or status='Public') ;"%(nodetype,variable_query,variable_value,userid)
		execute_query(sql,self.curs)
		fetched_value = query_fetchall(self.curs)#check output format.
		snapshot_list=[]

		for value in fetched_value:
			snapshot_list.append(str(value[0]))

		return  snapshot_list

	def getDatatype(self, attrtype_ssid_list):
		
		
		sql="select ssid,restrictiontype,restrictionref from gbattributetypes where ssid in %s;" %( list2string(attrtype_ssid_list) )
		execute_query(sql,self.curs)
		fetched_value_list=query_fetchall(self.curs)#[(,,),(,,) , ...]

		final_dic={}
		for tuples in fetched_value_list:
		    if tuples[1]==0:
			sql="select datatype from gbselectionlist where selid =%s; " %tuples[2]   
			execute_query(sql,self.curs)
			final_dic[ str(tuples[0]) ]=query_fetchall(self.curs)[0][0]
		    else:
			sql="select datatype from gbvaluerestrictions where restrictionid =%s; " %tuples[2]   
			execute_query(sql,self.curs)
			final_dic[ str(tuples[0]) ]=query_fetchall(self.curs)[0][0]
		return final_dic



        def getlatestssidsFromNids( self , nidlist ):
		"""
		"""
		temp_list=[]
		for nid in nidlist:
			temp_list.append(nid.replace("'","''"))
		nidstring = listofcharacter_2string( temp_list )
		query = "select nid,ssid from gbnid_latestssid where nid in %s;" % ( nidstring )
		
		self.curs.execute( query )	
		result = self.curs.fetchall()
		nidssid_dict = {}
		for nid_ssid in result: 
			nidssid_dict[ str(nid_ssid[0]) ] = str( nid_ssid[1] )
		return nidssid_dict
			

	def getlatestssids( self , idlist , idtype , nodetypes=[], userid = '0'):
		"""
		idype may be ssid or inid or nid
		"""

		
		nodetype_id = {}

		if nodetypes <> [] and idtype <> 'nid':
			for nodetype in nodetypes:
				nodetype_id.update( { nodetype: idlist} )
		else:
			idstring = listofcharacter_2string( idlist )
			if idtype == 'nid':
				sql = "select ssid,nodetype from gbnidssid where %s in %s" %( idtype,idstring )
			else:
				sql = "select ssid,nodetype from gbnidssid where %s in %s" %( 'ssid',idstring )
			execute_query(sql,self.curs)
			id_nodetype_list = query_fetchall(self.curs)
			
			for elem in id_nodetype_list:
				nt = elem[1]
				nodeid =  str(elem[0])
				if not nodetype_id.has_key( nt ):
					nodetype_id.update( { nt: [nodeid] } )
					nodetypes.append( nt )
				else:
					l = nodetype_id[nt]
					l.append(nodeid)
					nodetype_id.update( { nt: l } )
		
		
		finaldict = {}

		for nodetype in nodetype_id:
			query = "select max(ssid),%s from %s where %s in %s and (uid=%s or status='public' or status='Public') group by %s;" % (idtype, nodetype, 'ssid', listofcharacter_2string( nodetype_id[nodetype]), userid,idtype)
		        self.curs.execute( query )	
			result = self.curs.fetchall()
			if result <> []:
				for elem in result:
					finaldict.update( {str(elem[1]): str(elem[0])} )
					
		return finaldict			
		

	def getnids( self, lstssids , nodetypes=[], userid = '0'):
		"""
		"""
		
		nodetype_id = {}
		if nodetypes <> []:
			for nodetype in nodetypes:
				nodetype_id.update( { nodetype: lstssids} )
					
		finaldict = {}

		for nodetype in nodetype_id:
			query = "select ssid,nid from %s where ssid in %s;" % ( nodetype, listofcharacter_2string(nodetype_id[nodetype]))
			self.curs.execute( query )	
			result = self.curs.fetchall()
			if result <> []:
				for elem in result:
					finaldict.update( {str(elem[0]): str(elem[1])} )
			return finaldict		

		ssid_string = listofcharacter_2string( lstssids )
		query = "select ssid,nid from gbnidssid where ssid in %s" %( ssid_string )
		self.curs.execute( query )
		values = self.curs.fetchall()
		
		results_dict = {}
		
		if values == []:
			return values 
		else:
						
			for elem in values:
				results_dict.update({str(elem[0]):str(elem[1])})
			return results_dict


	def getinids( self, lstssids , nodetypes=[], userid = '0'):
		"""
		"""
		nodetype_id = {}
		if nodetypes <> []:
			for nodetype in nodetypes:
				nodetype_id.update( { nodetype: lstssids} )
					
		finaldict = {}

		for nodetype in nodetype_id:
			query = "select ssid,inid from %s where ssid in %s;" % ( nodetype, listofcharacter_2string(nodetype_id[nodetype]))
			self.curs.execute( query )	
			result = self.curs.fetchall()
			if result <> []:
				for elem in result:
					finaldict.update( {str(elem[0]): str(elem[1])} )
			return finaldict		

		ssid_string = listofcharacter_2string( lstssids )
		query = "select ssid,inid from gbnidssid where ssid in %s" %( ssid_string )
		self.curs.execute( query )
		values = self.curs.fetchall()
		
		results_dict = {}
		
		if values == []:
			return values 
		else:
			for elem in values:
				results_dict.update({str(elem[0]):str(elem[1])})
			return 	results_dict


	def getnidslatest( self, lstssids):
		"""
		"""
		ssid_string = listofcharacter_2string( lstssids )
		query = "select nid,max(ssid) from gbnidssid where ssid in %s group by nid" %( ssid_string )
		self.curs.execute( query )
		values = self.curs.fetchall()
		
		results_dict = {}
		
		if values == []:
			return values 
		else:
			for elem in values:
				results_dict.update({str(elem[0]):str(elem[1])})
			return 	results_dict
				
			

		
	def getRoles( self, RTnid):

		"""
		
		STEPS:
		1) Get inid from the given relationtype nid
		2) Query gbcatalogrelationtypes to get the roletypeids.
		3) using the roletypeids from the gbcatalogrelationtypes query the gbroletypes table to get subjecttype1, subjecttype2, cardinality1, cardinality2, applicablenodetypes1 and applicablenodetypes2 from gbroletypes table.
    
		"""

		#IMPLEMENTING STEP 1 AND 2:

		get_rtids_query = "SELECT roletypeid from gbcatalogrelationtypes WHERE relationtypeid = (SELECT distinct(inid) FROM gbrelationtypes WHERE nid = '%s')" % ( RTnid )
		self.curs.execute( get_rtids_query )	
		rtids = self.curs.fetchall()
		
		if rtids == []:
			return []


		#IMPLEMENTING STEP 3:
		rtids_list = []
		for rt in rtids :
			rtids_list.append( rt[0] )
		
		rtids_string = list2string( rtids_list) 

		get_rtidinfo_query = "SELECT * from gbroletypes where rtid in %s" %( rtids_string )
		self.curs.execute( get_rtidinfo_query )	
		rtid_info = self.curs.fetchall()


		rtid_list = []
		for info in rtid_info :
			temp_dict = {}
			temp_dict [ 'rtid' ] = info[ 0 ]
			temp_dict [ 'subjecttype1' ] = info[ 1 ]
			temp_dict [ 'subjecttype2' ] = info[ 2 ]
			temp_dict [ 'cardinality1' ] = info[ 3 ]
			temp_dict [ 'cardinality2' ] = info[ 4 ]
			temp_dict [ 'applicablenodetypes1' ] = info[ 5 ]
			temp_dict [ 'applicablenodetypes2' ] = info[ 6 ]
			rtid_list.append( temp_dict )	

		return rtid_list
			
			
	def getSubjecttypes( self , ATnid ):
		"""
		STEPS:
		1) Get inid from the given attributetype nid
		2) Query gbcatalogsubjecttypes using this inid to get the subjecttypeids and applicablenodetypes 
		
		"""
	
		
		self.curs.execute( "SELECT subjecttypeid,applicablenodetypes from gbcatalogsubjecttypes WHERE attributetypeid = (SELECT distinct(inid) FROM gbattributetypes WHERE nid = '%s')" % ( ATnid ) )	
		subjecttypes = self.curs.fetchall()

		if subjecttypes == [] :
			return []

		finallist = []
		for tuple in subjecttypes : 
			temp_dict = {}
			temp_dict[ 'stid' ] = str(tuple[0])
			temp_dict[ 'applicablenodetypes' ] = tuple[1]
			finallist.append( temp_dict )
		
		return finallist

		
		
	def getSelectionlist( self ):
		"""
		"""

		query = ( "select ssid,nid,rendered_nbh from gbobjects where inid in (select subject1 from gbrelations where subject2 = 4 and relationtype = 2 )" )
		
		self.curs.execute(query)
		nid_nbh_tuple = self.curs.fetchall()

		if nid_nbh_tuple == []:
			return 'No selectionlists found'
		
		
		finallist = []
		for tuple in nid_nbh_tuple : 
			temp_dict = {}
			temp_dict[ 'listid'] = str(tuple[0])
			temp_dict[ 'nid' ] = tuple[1]
			try:
				temp_dict[ 'value' ] = cPickle.loads(b64decode( tuple[2] ))['structure']
			except:
				return tuple 
			finallist.append( temp_dict )

		return  finallist 

		
	def getRegex( self ):
		"""
		"""

		self.curs.execute( "SELECT regexid,expression,description from gbregularexpressions;" )
		regex_tuple = self.curs.fetchall()

		if regex_tuple == []:
			return 'No regular expressions found'

		finallist = []
		for tuple in regex_tuple:
			temp_dict = {}
			temp_dict[ 'id' ] = str(tuple[0])
			temp_dict[ 'exp' ] = str(tuple[1])
			temp_dict[ 'desc' ] = str(tuple[2])
			finallist.append( temp_dict )
	
		return finallist
			

	def getRestrictions( self , ATlist):
		"""
		
		"""

		sql="select ssid,restrictiontype,restrictionref from gbattributetypes where ssid in %s;" %( list2string( ATlist ) )
		execute_query(sql,self.curs)
		fetched_value_list = query_fetchall(self.curs)#[(,,),(,,) , ...]

		if fetched_value_list == []:
			return []

		final_dic={}
		for tuples in fetched_value_list:
		    if tuples[1]==0:
			sql="select selectiontype,datatype,listid from gbselectionlist where selid =%s; " %tuples[2]   
			execute_query(sql,self.curs)
			tuple  = query_fetchall(self.curs)[0]
			dict = {}
			dict[ 'type' ] = '0'
			dict[ 'selectiontype' ] = str( tuple[0] )
			dict[ 'datatype' ] = tuple[1]
			dict[ 'listid' ] = tuple[2]
			final_dic[ str(tuples[0]) ] = dict
		    else:
			sql="select datatype,regexid,length,range,precision from gbvaluerestrictions where restrictionid =%s; " %tuples[2]   
			execute_query(sql,self.curs)
			tuple  = query_fetchall(self.curs)[0]
			final_dic[ str(tuples[0]) ] = tuple
			dict = {}
			dict[ 'type' ] = '1'
			dict[ 'datatype' ] = tuple[0]
			dict[ 'regexid' ] = str( tuple[1] )
			dict[ 'length' ] = tuple[2]
			dict[ 'range' ] = tuple[3]
			dict[ 'precision' ] = tuple[4]
			final_dic[ str(tuples[0]) ] = dict
			
		return final_dic



	def getAttributetypes( self , STlist ):
		"""
		"""
		sql="select subjecttypeid,attributetypeid from gbcatalogsubjecttypes where subjecttypeid in %s;" %( list2string( STlist ) )
		execute_query(sql,self.curs)
		fetched_value_list = query_fetchall(self.curs)
		
		ATdict = {}
		for tuple in fetched_value_list :
			if str( tuple[0] ) not in ATdict.keys():
				ATdict[ str( tuple[0] ) ] = []
				ATdict[ str( tuple[0] ) ].append( str(tuple[1]) )
			else:  
				ATdict[ str( tuple[0] ) ].append( str(tuple[1]) )
		return  ATdict



	def getRelationtypes( self , RTlist ):
		"""
		"""
		
		RT_string = list2string( RTlist )

		sql="select subjecttype1,rtid from gbroletypes where subjecttype1 in %s;" %(  RT_string )
		execute_query(sql,self.curs)
		subject1_list = query_fetchall(self.curs)

		sql="select subjecttype2,rtid from gbroletypes where subjecttype2 in %s;" %( RT_string )
		execute_query(sql,self.curs)
		subject2_list = query_fetchall(self.curs)

		totallist = subject1_list + subject2_list 
		
		finaldict = {}
		roles = []
		if totallist <> [] :
			for tuple in totallist:
				if tuple not in finaldict.keys() :
					finaldict[ str(tuple[0]) ] = []
					finaldict[ str(tuple[0]) ].append( str(tuple[1]) )
				else:
					finaldict[ str(tuple[0]) ].append( str(tuple[1]) )
				roles.append(str(tuple[1]))
		else:
			return []
					
					
		#print roles				     
		string_roles = list2string( roles )
		
		get_rts_query = "select roletypeid,relationtypeid from gbcatalogrelationtypes where roletypeid in %s;"%( string_roles )
		execute_query( get_rts_query ,self.curs)
		roletype_rt_list = query_fetchall(self.curs)

		rt_dict = {}
		for tuple in roletype_rt_list : 
			rt_dict[ str(tuple[0]) ] = str( tuple[1] ) 

		st_rt_dict  = {}
		for key in  finaldict.keys():
                        st_rt_dict[ key ] = []
			for role in finaldict[ key ]: 
				st_rt_dict[ key ] .append( rt_dict [ role ]  )


		return st_rt_dict

	
	def getAttributeValues( self , Attrssidlist):
		"""
		Given a list of attributessids returns their values.

		Format :
		{'173':'Richard Dawkins','174':'The God Delusion','176':['121','122','123']}
		"""

		sql = "SELECT ssid,datatype from gbattributes where ssid in %s" %( list2string( Attrssidlist ) )
		execute_query( sql , self.curs )
		id_value_list = query_fetchall(self.curs)
		id_table_list = []

		for id_value in id_value_list : 
			tablename = 'datatypes_'+id_value[1]
			id_table_list.append( [ id_value [0] , tablename.replace('[]','') ] )

			
		values_list = []
		values_dict = {}
		for id_table in id_table_list : 
			query = "SELECT attribute_ssid,value from %s where attribute_ssid = %s" %( id_table[1] , id_table[0] )
			execute_query( query , self.curs )
			value = query_fetchall(self.curs)
                        if len( value ) == 1:
                                values_dict[ str(value[0][0]) ] = value[0][1]
			if len( value ) > 1:
				for tuple in value:
					if str( tuple[0] ) in values_dict.keys():
						values_dict[ str(tuple[0]) ].append( tuple[1] )
					else:
						values_dict[ str(tuple[0]) ] = []
						values_dict[ str(tuple[0]) ].append( tuple[1] )
				
		return values_dict
			
	
		
		
	def nidExists( self , nid):
		"""
		Checks if a node exists in the database
		"""
		nid = nid.replace("'","''")
		sql="select nid from gbnidssid where nid = '%s';" %(  nid  )
		execute_query(sql,self.curs)
		nidexists = query_fetchall(self.curs)
		if nidexists == []:
			return 0
		else:
			return 1


	def getNodetype( self , ssid):
		"""
		Gets the nodetype of the given node
		"""
		sql = "select nodetype from gbnidssid where ssid = %s" %( ssid )
		execute_query(sql,self.curs)
		nodetype = query_fetchall(self.curs)
		if nodetype == []:
			return []
		else:
			return nodetype[0][0]


	def getNodetypes( self , idlist):
		"""
		Gets the nodetypes of a given list of ids
		"""
		sql = "select ssid,nodetype from gbnidssid where ssid in %s" %( list2string( idlist ) )
		execute_query(sql,self.curs)
		ssid_nodetype_list = query_fetchall(self.curs)
		ssid_nodetype_dict = {}

		if ssid_nodetype_list == []:
			return {}
		else:
			for elem in ssid_nodetype_list:
				ssid_nodetype_dict.update({ str(elem[0]):elem[1] })
			return ssid_nodetype_dict
			


	def getSubtypes( self, nodeid ):
		"""
		Gets the subtypes of the given node
		"""
		get_inid_query = "select inid from gbnidssid where ssid = %s;" %( nodeid )
		execute_query( get_inid_query , self.curs )
		inid = query_fetchall( self.curs )
		if inid == []:
			return 'node does not exist'
		else:
			get_subtypes_query = "select subject1 from gbrelations where subject2 = %s  and relationtype = 3;" %( nodeid )
			execute_query( get_subtypes_query , self.curs )
			subtypes = query_fetchall( self.curs )
			if subtypes == []:
				return []
			else:
				return [ str( inid[0] ) for inid in subtypes ]


	def getInstances( self , nodeid , type, userid='0'):
		"""
		Gets the instances of the given node
		"""

		get_inid_query = "select inid from gbnidssid where ssid = %s;" %( nodeid )
		execute_query( get_inid_query , self.curs )
		inid = query_fetchall( self.curs )
		if inid == []:
			return []
		else:
			
			get_instances_query = "select subject1 from gbrelations where subject2 = %s  and relationtype = 2 and status != 'deleted';" %( nodeid )
			execute_query( get_instances_query , self.curs )
			instances = query_fetchall( self.curs )
			if instances  == []:
				return []
			else:
				nid_instances = [ str( inid[0] ) for inid in instances ]
				if type == 'inid':
					return nid_instances
				if type == 'ssid':
					ssid_instances = self.getlatestssids( nid_instances , 'inid', userid)
					return ssid_instances
		

	
	def getInstancesCnt( self , ssid, nodetype='gbobjecttypes'):
		"""
		Gets the count of the instances of the given node
		"""

		get_inid_query = "select inid from %s where ssid = %s;" %( nodetype, ssid)
		execute_query( get_inid_query , self.curs )
		inid = query_fetchall( self.curs )
		if inid == []:
			return 0
		else:
			
			get_instancescnt_query = "select count(subject1) from gbrelations where subject2 = %s  and relationtype = 2 and status != 'deleted';" %( ssid )
			execute_query( get_instancescnt_query , self.curs )
			instances = query_fetchall( self.curs )
			if instances  == []:
				return 0
			else:
				return instances[0][0]
			


		
	def getSubtypesCnt( self , ssid, nodetype='gbobjecttypes'):
		"""
		Gets the count of the subtypes of the given node
		"""

		get_inid_query = "select inid from %s where ssid = %s;" %( nodetype, ssid)
		execute_query( get_inid_query , self.curs )
		inid = query_fetchall( self.curs )
		if inid == []:
			return 0
		else:
			
			get_instancescnt_query = "select count(subject1) from gbrelations where subject2 = %s  and relationtype = 3 and status != 'deleted';" %( ssid )
			execute_query( get_instancescnt_query , self.curs )
			instances = query_fetchall( self.curs )
			if instances  == []:
				return 0
			else:
				return instances[0][0]

	
	def getOntologies( self ):
		"""
		"""
		get_inid_ontology = "select inid from gbmetatypes where nid = '%s';" %( 'ONTOLOGY' )
		execute_query( get_inid_ontology , self.curs )
		inid_ontology = query_fetchall( self.curs )
		if inid_ontology == []:
			return {}
		else:
			get_instances_query = "select subject1 from gbrelations where subject2 = %s  and relationtype = 2 and status != 'deleted';" %( str(inid_ontology[0][0]) )
			execute_query( get_instances_query , self.curs )
			instances = query_fetchall( self.curs )
			if instances == []:
				return {}
			else:
				l = []
				for elem in instances:
					l.append(str(elem[0]))
				if l == []:
					return {}
				else:
					sql = "select max(ssid),nid from gbobjecttypes where inid in %s group by nid" %( list2string(l) )
					execute_query( sql , self.curs )
					result = query_fetchall( self.curs )
					if result <> []:
						m = {}
						for value in result:
							m.update( { value[1]: str(value[0]) } )
						return m
					else:
						return {}
						
						

	def getAllSubtypes( self , nodeid_list , val=0):
		"""
		"""
		temp_subtypes = []

		if val == 0:
			get_inid_query = "select inid from gbnidssid where ssid = %s;" %( nodeid_list[0] )
			execute_query( get_inid_query , self.curs )
			inid = query_fetchall(self.curs)
			if inid == []:
				return 'node does not exist'			
			else:
				self.getAllSubtypes ( [inid[0][0]] , 1 )
				
		else:
			
			get_subtypes_query = "select subject1 from gbrelations where subject2 in  %s  and  relationtype = 3 ;" %( list2string( nodeid_list ) )
			execute_query( get_subtypes_query , self.curs )
			subtypes_tuple = query_fetchall(self.curs)
			
			
			if subtypes_tuple == []:
				return []
			else:
				subtypes = [ str( inid[0] ) for inid in subtypes_tuple ]
				self.subtypes = self.subtypes + subtypes
				self.getAllSubtypes ( subtypes , 1 )
	
		return  self.subtypes

	

	def getAllInstances( self , nodeid ):
		"""
		"""
		subtypes = self.getAllSubtypes( [nodeid] , val=0)
		if subtypes == []:
			subtypes = [nodeid] 
		else:
			subtypes.append( nodeid )
		
		
		get_instances_query = "select subject1 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( subtypes ) )
		execute_query( get_instances_query , self.curs )
		instances_tuple = query_fetchall(self.curs)
		if instances_tuple == []:
			return []
		else:
			return [ str(inid[0]) for inid in instances_tuple ]
	

	def getRelationids( self , ids):
		"""
		The ids are of the form:
		[['17','16'],['17','15']]

		output = {'19': [17L, 16L], '18': [17L, 15L]}
		"""

		unique_ids = []
		for list in ids:
			if list[0] not in unique_ids:
				unique_ids.append( list[0] )
			if list[1] not in unique_ids:
				unique_ids.append( list[1] )
				
		
		sqlquery = "select ssid,inid from %s where ssid in %s;" %( 'gbnidssid' , list2string( unique_ids  ) )
		execute_query( sqlquery , self.curs )
		fetched_value = query_fetchall( self.curs )


		ssid_inid_dict = {}
		for ssid_inid in fetched_value : 
                        ssid_inid_dict[ str(ssid_inid[0]) ] =  ssid_inid[1]
		
		inid_ids = ids
                
		for value in inid_ids:
			value[0] = ssid_inid_dict[value[0]]
			value[1] = ssid_inid_dict[value[1]]

		
		reliddict = {}
		for inidlst in inid_ids:
			query = "select ssid from gbrelations where subject1=%s and subject2=%s;" %( inidlst[0],inidlst[1] )
			execute_query( query , self.curs )
			relnid = query_fetchall( self.curs )
			if relnid <> []:
				reliddict[ str(relnid[0][0]) ] =  ids[inid_ids.index(inidlst)]

		return reliddict



	def updateStatus( self , ssid , status):
		"""
		"""
		nodetype_list = get_nodetype_from_gbnidssid([ssid],'ssid',self.curs)
		query = "update %s set status='%s' where ssid=%s;" %( nodetype_list[0] , status , ssid)
		execute_query( query , self.curs )
		commitclose( self.curs, self.conn)
		
		

	def gettimestamp(self,nodetype,ssid_list):
		"""
		"""
		sql="select gbtimestamp,ssid from %s where ssid in %s" %( nodetype, list2string(ssid_list) )
		execute_query(sql,self.curs)
		multivalue_list = query_fetchall(self.curs)#check output format.[(timestamp,ssid), ... ]
                #final_list = rearrange_list(ssid_list,multivalue_list)
		final_dic={}
		for tuple in multivalue_list:
			final_dic[str(tuple[1])]=str ( tuple[0] ).strip("datetime.datetime(")
		return final_dic
	

	def getPublicIds( self, lstids , uid):
		"""
		"""
		query = "select inid,nodetype from gbnidssid where ssid in %s" %( list2string( lstids ) )
		execute_query( query , self.curs )
		ssid_nodetype_list = query_fetchall(self.curs)
		

		nodetype_ssid_dict = {}
		for ssid_nodetype in ssid_nodetype_list:
			if ssid_nodetype[1] not in nodetype_ssid_dict.keys():
				nodetype_ssid_dict[ ssid_nodetype[1] ] = [ str( ssid_nodetype[0] ) ]
			else:
				nodetype_ssid_dict[ ssid_nodetype[1] ].append( str( ssid_nodetype[0] ) )

		publicidlist = []
		finallist = []
		
		for nodetype in nodetype_ssid_dict:
			node = nodetype_ssid_dict[nodetype]
			query = "select max(ssid) from %s where inid in %s and (uid=%s or status='public' or status='Public');" %( nodetype ,list2string( node ),uid)
			execute_query( query , self.curs )
			ssidlist = query_fetchall(self.curs)
			publicidlist = publicidlist + ssidlist

		if publicidlist <> []:
			publiclist = []
			for elem in publicidlist:
				if str(elem[0]) not in publiclist:
					publiclist.append( str(elem[0]) )
			return publiclist
		else:
			return []
			

	def genTriples( self , ssid ):
		"""
		Generates RDF Triples
		"""
		
		execute_query( 'select nid,nodetype from gbnidssid where ssid = %s;' %( ssid ) , self.curs)
		nodetype = query_fetchall(self.curs)
		
		if nodetype <> []:
			nid = nodetype[0][0]
			execute_query( 'select rendered_nbh from %s where ssid = %s;' %( nodetype[0][1] ,ssid ) , self.curs)
			nbh = query_fetchall(self.curs)
			if nbh <> []:
				try:
					nbh = cPickle.loads(b64decode( nbh[0][0] ))
				except:
  					return 'nbh DOES NOT HAVE ANY VALUE'
	        
				triples = []

				firsttriple = (nid , 'isa', nodetype[0][1].replace('gb','').replace('s',''))
				triples.append( firsttriple )
				
				if nbh.has_key('attributes'):
					atnids = nbh['attributes'].keys()
					for atnid in atnids:
						triple = ( nid , atnid , nbh['attributes'][atnid][1])
						triples.append( triple )

				if nbh.has_key('relations'):
					ssidlist = []
					nidlist = []

					rtnids = nbh['relations'].keys()
					for rtnid in rtnids:
						if nbh['relations'][rtnid].has_key('leftroles'):
							leftroles = nbh['relations'][rtnid]['leftroles']
							if  leftroles <> []:
								for ssid in leftroles:
									if str( ssid ) not in ssidlist:
										ssidlist.append( str( ssid ) )
						if nbh['relations'][rtnid].has_key('rightroles'):
							leftroles = nbh['relations'][rtnid]['rightroles']
							if  leftroles <> []:
								for ssid in leftroles:
									if str( ssid ) not in ssidlist:
										ssidlist.append( str( ssid ) )
					
					if ssidlist <> []:
						ssid_nid_dict = self.getnids( ssidlist )
						for rtnid in rtnids:
							if nbh['relations'][rtnid].has_key('leftroles'):
								leftroles = nbh['relations'][rtnid]['leftroles']
								if  leftroles <> []:
									for ssid in leftroles:
										triple = ( ssid_nid_dict[str(ssid)] , rtnid , nid)
										triples.append( triple )
							if nbh['relations'][rtnid].has_key('rightroles'):
								leftroles = nbh['relations'][rtnid]['rightroles']
								if  leftroles <> []:
									for ssid in leftroles:
										triple = ( nid, rtnid, ssid_nid_dict[str(ssid)])
										triples.append( triple )
									
				if nbh.has_key('attributetypes'):
					atids =  nbh['attributetypes']
					ssid_nid_dict = self.getnids( atids )
					for nodeid in ssid_nid_dict.values():
						triple = (nid , 'hasattributetype' , nodeid)
						triples.append( triple )

				if nbh.has_key('relationtypes'):
					rtids =  nbh['relationtypes']
					ssid_nid_dict = self.getnids( rtids )
					for nodeid in ssid_nid_dict.values():
						triple = (nid , 'hasrelationtype' , nodeid)
						triples.append( triple )
				
				return  triples
			else:
				return 'THE NODE HAS NO NEIGHBOURHOOD'
				
		else:
			return 'SSID DOES NOT EXIST'

	        
	def getCount( self , nodetype):
		"""
		"""
		
		execute_query( 'select count(*) from %s;' %( nodetype ) , self.curs)
		no = query_fetchall(self.curs)
		if no <> []:
			return no[0][0]
		else:
			return no


		
	def getSpecificnbh( self, ssid , nbhprops ):
		"""

		nbhprops = ['attributes','relations']
		
		output:
		{'attributes': ['description', 'title'], 'relations': ['instanceof', 'hasWritten']}

		
                ( or )


		nbhprops = {'attributes':['title'],'relations':['hasWritten']}
		
		output:
		{'attributes': {'title': ('143', 'writer3 instance updated')}, 'relations': {'hasWritten': {'rightroles': ['147']}}}

		
		"""

		execute_query( 'select nid,nodetype from gbnidssid where ssid = %s;' %( ssid ) , self.curs)
		nodetype = query_fetchall(self.curs)
		
		nbh = {}

		if nodetype <> []:
			nid = nodetype[0][0]
			execute_query( 'select rendered_nbh from %s where ssid = %s;' %( nodetype[0][1] ,ssid ) , self.curs)
			nbh = query_fetchall(self.curs)
			if nbh <> []:
				try:
					nbh = cPickle.loads(b64decode( nbh[0][0] ))
				except:
					return 'nbh DOES NOT HAVE ANY VALUE'
		
		
		dictionary = {}

		if isinstance( nbhprops , list):
			for nbhprop in nbhprops: 
				if nbh.has_key( nbhprop ):
					values = nbh[ nbhprop ].keys()
					dictionary.update( { nbhprop : values })
			
		if isinstance( nbhprops , dict):
			for nbhprop in nbhprops:
				tempdict = {}
				if nbh.has_key( nbhprop ):
					for prop in nbhprops[nbhprop]:
						try:
							tempdict.update({ prop: nbh[nbhprop][prop] })
						except:
							pass
				
				dictionary.update( { nbhprop : tempdict } )
				
		return dictionary



	def getAuthor( self , nodeid ):
		"""
		"""
		execute_query( 'select nodetype from gbnidssid where ssid = %s;' %( nodeid ) , self.curs)
		nodetype = query_fetchall(self.curs)

		if nodetype <> []:
			query = 'select uid from %s where ssid = %s' %( nodetype[0][0] , nodeid )
			execute_query( query , self.curs)
			userid = query_fetchall(self.curs)
			return userid[0][0]



	def updatePasswd( self , username , passwd , uid):
		"""
		"""
		execute_query( "select max(ssid) from gbusers where nid = '%s';" %( username ) , self.curs)
		nodetype = query_fetchall(self.curs)
		
		if nodetype <> []:
			userid = str( nodetype[0][0] )
			obj = Update( self.constring , uid )
			   
			m=md5.new()
			m.update( passwd )
			password = m.hexdigest()


			dictionary = {
				'status':'public',
				'subject':userid,
				'language':'en',
				'commit':'1',
				'instanceof':[('password',passwd)]
				}

			obj.Update( dictionary )
			

			update_query = "update auth_schema.users set password = '%s' where username = '%s'" %( password , username)
			execute_query( update_query , self.curs)
			commitclose( self.curs , self.conn )
			
		
			return 'updated'
			

	def getStructure( self , ssid ):
		"""
		"""
		execute_query( 'select nid,nodetype from gbnidssid where ssid = %s;' %( ssid ) , self.curs)
		nodetype = query_fetchall(self.curs)
		
		if nodetype <> []:
			nid = nodetype[0][0]
			execute_query( 'select rendered_nbh from %s where ssid = %s;' %( nodetype[0][1] ,ssid ) , self.curs)
			nbh = query_fetchall(self.curs)
			#print nbh
			if nbh <> []:
				try:
					nbh = cPickle.loads(b64decode( nbh[0][0] ))
					if nbh.has_key('structure'):
						return nbh['structure']
					else:
						return []
				except:
  					return []
	        


	def getPossibleRel( self, RTnid ):
		"""
		"""
		get_rtids_query = "SELECT roletypeid from gbcatalogrelationtypes WHERE relationtypeid = (SELECT inid FROM gbrelationtypes WHERE nid = '%s')" % ( RTnid )
		self.curs.execute( get_rtids_query )	
		rtids = self.curs.fetchall()
		
		if rtids == []:
			return []



		rtids_list = []
		for rt in rtids :
			rtids_list.append( rt[0] )
		
		rtids_string = list2string( rtids_list) 

		get_rtidinfo_query = "SELECT * from gbroletypes where rtid in %s" %( rtids_string )
		self.curs.execute( get_rtidinfo_query )	
		rtid_info = self.curs.fetchall()

		
		possible_subjecttype1_list = []
		possible_subjecttype2_list = []
		unique_subjecttypes_list = []
		

		for value in rtid_info:
			if str(value[1]) not in possible_subjecttype1_list:
				possible_subjecttype1_list.append( str(value[1]) )
			if str(value[2]) not in possible_subjecttype2_list:
				possible_subjecttype2_list.append( str(value[2]) )
			if str(value[1]) not in unique_subjecttypes_list:
				unique_subjecttypes_list.append( str(value[1]) )
			if str(value[2]) not in unique_subjecttypes_list:
				unique_subjecttypes_list.append( str(value[2]) )
		
			
		type = rtid_info[0][5]

		possible_relations_list = []
		possible_subject1_list = []
		possible_subject2_list = []
		possible_relations = []
		

		instances = []

		if (type == None) or (type == 'tokens') or (type == 'metatypes'):
			get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( unique_subjecttypes_list )  )
			execute_query( get_instances_query , self.curs )
			instances = query_fetchall( self.curs )
		else:
			get_subtypes_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 3;" %( list2string( unique_subjecttypes_list ))
			execute_query( get_subtypes_query , self.curs )
			instances = query_fetchall( self.curs )
			
		
		if instances <> []:
				for elem in instances:
					if str(elem[1]) in possible_subjecttype1_list:
						possible_subject1_list.append(str(elem[0]))
					if str(elem[1]) in possible_subjecttype2_list:
						possible_subject2_list.append(str(elem[0]))
				
				
				
				

				if possible_subject1_list <> []:
					possible_subject1_dict = self.getnidslatest(possible_subject1_list)
					#possible_relations.append( dict(zip(possible_subject1_dict.values(), possible_subject1_dict.keys())) )
					possible_relations.append( possible_subject1_dict )
				else:
					possible_relations.append({})
				if possible_subject2_list <> []:
					possible_subject2_dict = self.getnidslatest(possible_subject2_list)
					#possible_relations.append( dict(zip(possible_subject1_dict.values(), possible_subject2_dict.keys())) )
					possible_relations.append( possible_subject2_dict )
				else:
					possible_relations.append({})
			
		return possible_relations




	def searchPossibleRel( self, searchstr, RTnid, role, userid = '0' ):
		"""
		"""
		
		if RTnid == 'isa':
			if role == 'left':
				return []
			if role == 'right':
				totallist = [['0','objecttype'],['0','object']]
			return totallist

		if RTnid == 'instanceof':
			totallist = []
			objecttypes = self.searchNodes( searchstr , 'gbobjecttypes', searchtype = '1')
			if role == 'left':
				objects = self.searchNodes( searchstr , 'gbobjects', searchtype = '1')
				totallist = objecttypes + objects
			if role == 'right':
				metatypes = self.searchNodes( searchstr , 'gbmetatypes', searchtype = '1')
				totallist = objecttypes + metatypes
			return totallist


		if RTnid == 'subtypeof':
			totallist = []
			objecttypes = self.searchNodes( searchstr , 'gbobjecttypes', searchtype = '1')
			return objecttypes

		if RTnid in ['dependson','partof']:
			totallist = []
			ots = self.searchNodes( searchstr , 'gbobjecttypes', searchtype = '1')
			rts = self.searchNodes( searchstr , 'gbrelationtypes', searchtype = '1')
			ats = self.searchNodes( searchstr , 'gbattributetypes', searchtype = '1')
			totallist = ots+rts+ats
			return totallist

				
				
		
		get_rtids_query = "SELECT roletypeid from gbcatalogrelationtypes WHERE relationtypeid = (SELECT distinct(inid) FROM gbrelationtypes WHERE nid = '%s')" % ( RTnid )
		self.curs.execute( get_rtids_query )	
		rtids = self.curs.fetchall()
		
		if rtids == []:
			return []



		rtids_list = []
		for rt in rtids :
			rtids_list.append( rt[0] )
		
		rtids_string = list2string( rtids_list) 

		get_rtidinfo_query = "SELECT * from gbroletypes where rtid in %s" %( rtids_string )
		self.curs.execute( get_rtidinfo_query )	
		rtid_info = self.curs.fetchall()

		
		possible_subjecttype1_list = []
		possible_subjecttype2_list = []
		unique_subjecttypes_list = []
		
		get_instances = []
		get_subtypes = []

		tblname = ''
		for value in rtid_info:
			if role == 'left':
				if str(value[1]) not in possible_subjecttype1_list:
					unique_subjecttypes_list.append( str(value[1]) )
					if value[5] in ['metatypes','tokens',None]:
						get_instances.append(str(value[1]))
					elif value[5] in ['types']:
						get_subtypes.append(str(value[1]))
						
			if role == 'right':	
				if str(value[2]) not in possible_subjecttype2_list:
					unique_subjecttypes_list.append( str(value[2]) )
					if value[5] in ['metatypes','tokens',None]:
						get_instances.append(str(value[2]))
					elif value[5] in ['types']:
						get_subtypes.append(str(value[2]))
				
		
		
		
		instances = []
		subtypes = []
		if get_instances <> []:
			get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( get_instances )  )
			execute_query( get_instances_query , self.curs )
			instances = query_fetchall( self.curs )
		if get_subtypes <> []:
			get_subtypes_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 3;" %( list2string( get_subtypes ))
			execute_query( get_subtypes_query , self.curs )
			subtypes =  query_fetchall( self.curs )
		
		
		total = instances + subtypes
		
		possible_subject_list = []
		

		if total <> []:
				for elem in total:
					if role == 'left':
						if str(elem[1]) not in possible_subject_list:
							possible_subject_list.append(str(elem[0]))
					if role == 'right':		
						if str(elem[1]) not in possible_subject_list:
							possible_subject_list.append(str(elem[0]))
		


		
		if possible_subject_list <> []:
			string_subject_list = list2string(possible_subject_list)
			newsearchstr = searchstr.lower()
			newsearchstr1 = newsearchstr.replace(' ','|')
			newsearchstr1 = self.make_string_safe( newsearchstr1 )
			
			newsearchstr2 = newsearchstr.replace(' ','%')
			newsearchstr2 = self.make_string_safe( newsearchstr2 )

			percent = "%"
			bracket1 = "("
			bracket2 = ")"


			cur = self.curs

			queryResult = None

			langcode = 'english'



			tblname = 'gbobjecttypes'
			query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' ))  group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
			result = cur.execute( query )
			queryResult1 = cur.fetchall()

			tblname = 'gbobjects'
			query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' ))  group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
			result = cur.execute( query )
			queryResult2 = cur.fetchall()

			queryResult = queryResult1 + queryResult2

			
			if queryResult == None:
				return []
			else:
				return queryResult

			return queryResult 

		"""				
		type = rtid_info[0][5]

		possible_relations_list = []
		possible_subject_list = []
		possible_relations = []
		

		instances = []
		tbl = '' 

		if type == None:
			
			get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( unique_subjecttypes_list )  )
			execute_query( get_instances_query , self.curs )
			final = query_fetchall( self.curs )
			if final <> []:
				tbl = 'objects'
		else:

			get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( unique_subjecttypes_list )  )
			execute_query( get_instances_query , self.curs )
			instances = query_fetchall( self.curs )
			if instances <> []:
				tbl = 'objects'
			
			get_subtypes_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 3;" %( list2string( unique_subjecttypes_list ))
			execute_query( get_subtypes_query , self.curs )
			subtypes =  query_fetchall( self.curs )
			if subtypes <> []:
				tbl = 'objecttypes'

			if (instances <> []) and (subtypes <> []):
				tbl = 'both'
				
			final = instances + subtypes
		
		if final <> []:
				for elem in final:
					if role == 'left':
						if str(elem[1]) in possible_subjecttype1_list:
							possible_subject_list.append(str(elem[0]))
					if role == 'right':		
						if str(elem[1]) in possible_subjecttype2_list:
							possible_subject_list.append(str(elem[0]))
				
		
		if possible_subject_list <> []:
			string_subject_list = list2string(possible_subject_list)
			newsearchstr = searchstr.lower()
			newsearchstr1 = newsearchstr.replace(' ','|')
			newsearchstr1 = self.make_string_safe( newsearchstr1 )
			
			newsearchstr2 = newsearchstr.replace(' ','%')
			newsearchstr2 = self.make_string_safe( newsearchstr2 )

			percent = "%"
			bracket1 = "("
			bracket2 = ")"


			cur = self.curs

			queryResult = None

			langcode = 'english'

			if tbl == 'objects':
				tblname = 'gbobjects'
				query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' ))  group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
				result = cur.execute( query )
				queryResult = cur.fetchall()
				print queryResult
			if tbl == 'objecttypes':
				tblname = 'gbobjecttypes'
				query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' )) group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
				result = cur.execute( query )
				queryResult = cur.fetchall()
			if tbl == 'both':
				tblname = 'gbobjecttypes'
				query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' )) group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
				result1 = cur.execute( query )
				queryResult1 = cur.fetchall()
				tblname = 'gbobjects'
				query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' )) group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
				result2 = cur.execute( query )
				queryResult2 = cur.fetchall()
				queryResult = queryResult1 + queryResult2
	
			

			if queryResult == None:
				return []
			else:
				return queryResult

			return queryResult 

		"""	

	def searchPossibleAttr(self, searchstr, ATnid , userid = '0'):
	        """
		"""


		if ATnid in ['title','description','content']:
			objecttypes = self.searchNodes(searchstr,'gbobjecttypes')
			objects = self.searchNodes(searchstr,'gbobjects')
                        total = objecttypes + objects
			return total
			
		sql="select distinct(inid) from gbattributetypes where nid='%s';"%(ATnid)
		execute_query(sql,self.curs)
		inid =  query_fetchall(self.curs)[0][0]

		self.curs.execute( "SELECT attributetypeid,subjecttypeid,applicablenodetypes from gbcatalogsubjecttypes WHERE attributetypeid=%s" % (inid) )
		tuples = self.curs.fetchall()
		
		unique_subjecttypes_list = []
		for elem in tuples:
			if elem[1] not in unique_subjecttypes_list:
				unique_subjecttypes_list.append( elem[1] )
		
		tbl = '' 

		if (tuples[0][2] == None) or (tuples[0][2] == 'tokens') or (tuples[0][2] == 'metatypes'):
			
			get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( unique_subjecttypes_list )  )
			execute_query( get_instances_query , self.curs )
			final = query_fetchall( self.curs )
			if final <> []:
				tbl = 'objects'
		else:

			get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( unique_subjecttypes_list )  )
			execute_query( get_instances_query , self.curs )
			instances = query_fetchall( self.curs )
			if instances <> []:
				tbl = 'objects'
			
			get_subtypes_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 3;" %( list2string( unique_subjecttypes_list ))
			execute_query( get_subtypes_query , self.curs )
			subtypes =  query_fetchall( self.curs )
			if subtypes <> []:
				tbl = 'objecttypes'

			if (instances <> []) and (subtypes <> []):
				tbl = 'both'
				
			final = instances + subtypes


		if final <> []:
			possible_subject_list = []
			for elem in final:
				if str(elem[1]) not in possible_subject_list:
					possible_subject_list.append(str(elem[0]))
				
			string_subject_list = list2string(possible_subject_list)
			newsearchstr = searchstr.lower()
			newsearchstr1 = newsearchstr.replace(' ','|')
			newsearchstr1 = self.make_string_safe( newsearchstr1 )
			
			newsearchstr2 = newsearchstr.replace(' ','%')
			newsearchstr2 = self.make_string_safe( newsearchstr2 )

			percent = "%"
			bracket1 = "("
			bracket2 = ")"


			cur = self.curs

			queryResult = None

			langcode = 'english'

			if tbl == 'objects':
				tblname = 'gbobjects'
				query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' ))  group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
				result = cur.execute( query )
				queryResult = cur.fetchall()
				print queryResult
			if tbl == 'objecttypes':
				tblname = 'gbobjecttypes'
				query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' )) group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
				result = cur.execute( query )
				queryResult = cur.fetchall()
			if tbl == 'both':
				tblname = 'gbobjecttypes'
				query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' )) group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
				result1 = cur.execute( query )
				queryResult1 = cur.fetchall()
				tblname = 'gbobjects'
				query = "select max(ssid), nid  from %s where (inid in %s) and ((uid=%s or status='public' or status='Public') and (to_tsvector( '%s', lower(nid) ) @@ to_tsquery( '%s','%s' )) or (lower(nid) similar to '%s%s%s%s%s' )) group by nid;" % (tblname, string_subject_list, userid ,str(langcode), str(langcode), newsearchstr2,percent, bracket1, newsearchstr1, bracket2, percent)
				result2 = cur.execute( query )
				queryResult2 = cur.fetchall()
				queryResult = queryResult1 + queryResult2
	
			

			if queryResult == None:
				return []
			else:
				return queryResult

			return queryResult 

		
		

	def getPossibleAttr( self , objid ):
		"""
		"""
		execute_query( 'select nodetype from gbnidssid where ssid = %s;' %( objid ) , self.curs)
		nodetype = query_fetchall(self.curs)


		if nodetype <> []:
			nid = nodetype[0]
			execute_query( 'select rendered_nbh from %s where ssid = %s;' %( nodetype[0][0] ,objid ) , self.curs)
			nbh = query_fetchall(self.curs)
			nt = nodetype[0][0]
			if nbh <> []:
				try:
					nbh = cPickle.loads(b64decode( nbh[0][0] ))
					
					if nbh.has_key('relations'):
						atidlist = []
						

						if (nbh['relations'].has_key('instanceof')) and (not nt.endswith('types')):
							
							instanceof  =  nbh['relations']['instanceof']['rightroles']
							self.curs.execute( "SELECT attributetypeid,subjecttypeid from gbcatalogsubjecttypes WHERE subjecttypeid in %s" % ( list2string(instanceof) ) )	
							ats_instanceof = self.curs.fetchall()

							if ats_instanceof <> []:
								for tuple in ats_instanceof:
									if str(tuple[0] ) not in atidlist:
										atidlist.append( str(tuple[0] ))
							
							
							
						if (nbh['relations'].has_key('subtypeof')) and (nt.endswith('types')):
							subtypeof =  nbh['relations']['subtypeof']['rightroles']
							self.curs.execute( "SELECT attributetypeid,subjecttypeid,applicablenodetypes from gbcatalogsubjecttypes WHERE subjecttypeid in %s" % ( list2string(subtypeof) ) )	
							ats_subtypeof = self.curs.fetchall()

							if ats_subtypeof <> []:
								for tuple in ats_subtypeof:
									if tuple[2] == None:
										pass
									else:
										if str(tuple[0] ) not in atidlist:
											atidlist.append( str(tuple[0] ))

						
						atidlist = ['11','12','13'] + atidlist					
						if atidlist <> []:
							atniddict = self.getnidslatest( atidlist )
							return atniddict
						else:
							return []
				except:
  					return []

		



	def getInstancesList( self , idlist):
		"""
		Gets the instances of the given list of ids
		"""

		get_inid_query = "select inid from gbnidssid where ssid in %s;" %( list2string( idlist )  )
		execute_query( get_inid_query , self.curs )
		inid = query_fetchall( self.curs )
		if inid == []:
			return []
		else:
			inids = [str(elem[0]) for elem in inid]
			get_instances_query = "select subject1 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( inids ) )
			execute_query( get_instances_query , self.curs )
			instances = query_fetchall( self.curs )
			if instances  == []:
				return []
			else:
				nid_instances = [ str( inid[0] ) for inid in instances ]
				nid_instances_dict = self.getnidslatest( nid_instances )
				return nid_instances_dict
				



	def getPriorstates( self, PTlist ):
		"""
		"""
		execute_query( 'select priorstatedef from gbcatalogpriorstatedef where ssid in %s;' %( list2string( PTlist ) ) , self.curs)
		priorstatedef = query_fetchall(self.curs)
		
		if priorstatedef <> []:
			priorstatedef = [ str(elem[0]) for elem in priorstatedef]
			priorstates = self.getInstancesList( priorstatedef )
			return priorstates
		else:
			return []


	def getPoststates( self, PTlist ):
		"""
		"""
		execute_query( 'select poststatedef from gbcatalogpoststatedef where ssid in %s;' %( list2string( PTlist ) ) , self.curs)
		poststatedef = query_fetchall(self.curs)
		
		if poststatedef <> []:
			poststatedef = [ str(elem[0]) for elem in poststatedef]
			poststates = self.getInstancesList( poststatedef )
			return poststates
		else:
			return []
		


	def getFrame( self, nodetype, param, type):
		"""
		Algorithm:
		1) if nodetype is a token:
		   :RELATIONS:
		   -- get instanceof from param and then get their inids.
		   -- search for these types in subjecttype1 field of gbroletypes and get the rtids.
		   -- using these rtids get the relationtypes
		   :Attributes:
		   -- get instanceof from param and then get their inids.
		   -- get the Attributetypes attached to the types.

		2) if nodetype is a type or nodetype is metatype:
		   :RELATIONS:
		   -- get  subtypeof from param and then get their inids.
		   -- search for these types in subjecttype1 field of gbroletypes and get the rtids and also check if applicablenodetypes1 is types.
		   -- using these rtids get the relationstypes
		   :Attributes:
		   -- get subtypeof from param and then get their inids.
		   -- check in gbcatalogsubjecttypes table if subjectypeid is types and accordingly return the attributetypeid

		"""
		
		dictionary = {}
		rtidslist = []
		atidlist = []

		## FOR RELATIONS AND ATTRIBUTES IF TYPE IS A TOKEN
		if not nodetype.endswith('types'):
			nt = 'tokens'
			if param.has_key('instanceof'):
				instanceof = param['instanceof']
				inids = self.getinids( instanceof )
				inids = inids.values()
				string_inids_instanceof = list2string( inids )

				if type == '0' or type == '1':
					get_rtids_query = "SELECT rtid from gbroletypes WHERE subjecttype1 in %s" % ( string_inids_instanceof  )
					execute_query( get_rtids_query , self.curs)
					gbroletypesinfo = query_fetchall( self.curs )
					if gbroletypesinfo <> []:
						rtidslist = [str(elem[0]) for elem in gbroletypesinfo]
					else:
						pass

				if type == '0' or type == '2':
					self.curs.execute( "SELECT attributetypeid from gbcatalogsubjecttypes WHERE subjecttypeid in %s" % ( string_inids_instanceof ))	
					ats_instanceof = self.curs.fetchall()

					if ats_instanceof <> []:
						for tuple in ats_instanceof:
							if str(tuple[0] ) not in atidlist:
								atidlist.append( str(tuple[0]))
			else:
				pass

			
		## FOR RELATIONS AND ATTRIBUTES IF TYPE IS A TYPE
		if nodetype.endswith('types'):
			nt = 'types'
			if param.has_key('subtypeof'):
				subtypeof = param['subtypeof']
				inids = self.getinids( subtypeof )
				inids = inids.values()
				string_inids_subtypeof = list2string( inids )

				if type == '0' or type == '1':
					get_rtids_query = "SELECT rtid,applicablenodetypes1 from gbroletypes WHERE subjecttype1 in %s" % ( string_inids_subtypeof )
					execute_query( get_rtids_query , self.curs)
					gbroletypesinfo = query_fetchall( self.curs )
					if gbroletypesinfo <> []:
						for tuple in gbroletypesinfo:
							if tuple[1] <> None:
								rtidslist.append( str(tuple[0]) )

				
				if type == '0' or type == '2':
					self.curs.execute( "SELECT attributetypeid,subjecttypeid,applicablenodetypes from gbcatalogsubjecttypes WHERE subjecttypeid in %s" % ( list2string(subtypeof) ) )	
					ats_subtypeof = self.curs.fetchall()

					if ats_subtypeof <> []:
						for tuple in ats_subtypeof:
							if tuple[2] == None:
								pass
							else:
								if str(tuple[0] ) not in atidlist:
									atidlist.append( str(tuple[0] ))
					else:
						pass
			else:
				pass


		## GETTING RELATIONTYPES AND ATTRIBUTETYPES
		if rtidslist <> []:
				get_rtid_query = "SELECT relationtypeid from gbcatalogrelationtypes where roletypeid in %s" % (list2string(rtidslist) )
				execute_query( get_rtid_query , self.curs)
				rtid = query_fetchall( self.curs )
				unique_rtid = []
				if rtid <> []:
					for rt in rtid:
						if str(rt[0]) not in unique_rtid:
							unique_rtid.append( str(rt[0]) )
				
				rt_nid_query = "SELECT nid from gbrelationtypes where ssid in %s" % (list2string(unique_rtid) )
				execute_query( rt_nid_query , self.curs)
				rt_nid = query_fetchall( self.curs )
				rtnidlist = [elem[0] for elem in rt_nid]
				dictionary['relations'] = rtnidlist
		else:
			pass

		
		if nt == 'types':
			try:
				dictionary['relations'] = ['instanceof','subtypeof'] + dictionary['relations']
			except:
				dictionary['relations'] = ['instanceof','subtypeof'] 
		if nt == 'tokens':
			try:
				dictionary['relations'] = ['instanceof'] + dictionary['relations']
			except:
				dictionary['relations'] = ['instanceof'] 
		

		if atidlist <> []:
			atniddict = self.getnidslatest( atidlist )
			dictionary['attributes'] =  atniddict.keys()

		try:
			dictionary['attributes'] = ['title','description','content'] + dictionary['attributes']
		except:
			dictionary['attributes'] = ['title','description','content'] 

		
		if type == '1':
			dictionary.pop('attributes')
		if type == '2':
			dictionary.pop('relations')

		return dictionary

		


	def getRelFrame( self, nodetype , RTnid , ssid):
		"""
		"""
		get_rtids_query = "SELECT roletypeid from gbcatalogrelationtypes WHERE relationtypeid = (SELECT inid FROM gbrelationtypes WHERE nid = '%s')" % ( RTnid )
		self.curs.execute( get_rtids_query )	
		rtids = self.curs.fetchall()
		
		if rtids == []:
			return []



		rtids_list = []
		for rt in rtids :
			rtids_list.append( rt[0] )
		
		rtids_string = list2string( rtids_list)
		values = []

		if ssid <> '0':
			nbh = self.getNeighbourhood([ssid],'rendered_nbh')[ssid]
			
			inid = self.getinids([ssid])[ssid]
			if not nodetype.endswith('types'):
				if nbh.has_key('relations'):
					param = nbh['relations']
					if param.has_key('instanceof'):
						instanceof = param['instanceof']['rightroles']
						inids = self.getinids( instanceof )
						inids = inids.values()
						string_inids_instanceof = list2string( inids )
				
						get_rtidinfo_query = "SELECT * from gbroletypes where rtid in %s and subjecttype1 in %s" %( rtids_string, string_inids_instanceof)
						self.curs.execute( get_rtidinfo_query )	
						rtid_info = self.curs.fetchall()
						
						subjecttypes = []
						if rtid_info <> []:
							for value in rtid_info:
								if str(value[2]) not in subjecttypes:
									subjecttypes.append(str(value[2]))
						
						get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted' and subject2 != %s;" %( list2string( subjecttypes ),inid  )
						execute_query( get_instances_query , self.curs )
						values = query_fetchall( self.curs )
						

			if nodetype.endswith('types'):
				if nbh.has_key('relations'):
					param = nbh['relations']
					if param.has_key('subtypeof'):
						instanceof = param['subtypeof']['rightroles']
						inids = self.getinids( instanceof )
						inids = inids.values()
						string_inids_instanceof = list2string( inids )
				
						get_rtidinfo_query = "SELECT * from gbroletypes where rtid in %s and subjecttype1 in %s" %( rtids_string, string_inids_instanceof)
						self.curs.execute( get_rtidinfo_query )	
						rtid_info = self.curs.fetchall()

						subjecttypes = []
						if rtid_info <> []:
							for value in rtid_info:
								if str(value[3]) <> None:
									if str(value[2]) not in subjecttypes:
										subjecttypes.append(str(value[2]))

						get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 3 and status != 'deleted' and subject2 != %s;" %( list2string( subjecttypes ),inid  )
						execute_query( get_instances_query , self.curs )
						values = query_fetchall( self.curs )

		else:
			get_rtidinfo_query = "SELECT * from gbroletypes where rtid in %s" %( rtids_string )
			self.curs.execute( get_rtidinfo_query )	
			rtid_info = self.curs.fetchall()
			if not nodetype.endswith('types'):
				subjecttypes = []
				if rtid_info <> []:
					for value in rtid_info:
						if str(value[2]) not in subjecttypes:
							subjecttypes.append(str(value[2]))
				get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 2 and status != 'deleted';" %( list2string( subjecttypes ) )
				execute_query( get_instances_query , self.curs )
				values = query_fetchall( self.curs )
			if nodetype.endswith('types'):
				subjecttypes = []
				for value in rtid_info:
					if str(value[3]) <> None:
						if str(value[2]) not in subjecttypes:
							subjecttypes.append(str(value[2]))
				get_instances_query = "select subject1,subject2 from gbrelations where subject2 in %s  and relationtype = 3 and status != 'deleted';" %( list2string( subjecttypes ) )
				execute_query( get_instances_query , self.curs )
				values = query_fetchall( self.curs )
				
		

		if values <> []:
			possible_subject2_list = []
			for elem in values:
				if str(elem[0]) not in possible_subject2_list:
					possible_subject2_list.append(str(elem[0]))
			if possible_subject2_list <> []:
				possible_subject2_dict = self.getnidslatest(possible_subject2_list)
				return possible_subject2_dict
			else:
				return {}

				

	def getInverseName( self , nid ):
                """          
		Returns the inversename of the given ssid of relationtypes
		example : reverse_name = obj.getInverseName('sybtypeof')
		output : 'supertypeof'
                """
		
                query = "select inversename from gbrelationtypes where nid = '%s';" % ( str(nid) ) 

                self.curs.execute( query )
                result = self.curs.fetchall()
		inversename = ''
		for i in result:
			inversename = i[0]
                
                return  inversename



	def getInverseNames( self , nids ):
                """          
		Returns the inversenames of the given nids of relationtypes
		example : reverse_name = obj.getInverseNames(['sybtypeof','dependson'])
		output : {'subtypeof':'types','dependson':'requiredfor'}
                """
		
                query = "select nid,inversename from gbrelationtypes where nid in %s;" % ( listofcharacter_2string(nids) ) 
		self.curs.execute( query )
                result = self.curs.fetchall()
		inversename = {}
		for i in result:
			inversename[i[0]] = i[1] 
                
                return  inversename

			
	def getContributors( self , ssid):
		"""
		"""
		execute_query( 'select nodetype from gbnidssid where ssid = %s;' %( ssid ) , self.curs)
		nodetype = query_fetchall(self.curs)[0][0]

		query = "select history,gbtimestamp from %s where ssid = %s;" % ( nodetype, ssid ) 
		self.curs.execute( query )
                result = self.curs.fetchall()
		history = result[0][0]
		time = result[0][1].strftime( "%d %B %Y %I:%M:%S %p %Z" )
		
		history = history[1:] + [ssid]
		history_string = list2string( history )
		users_query = "select ssid,uid from %s where ssid in %s;" % ( nodetype, history_string )  
			
		self.curs.execute( users_query )
		id_uid = self.curs.fetchall()
		id_uid_dict = {}
		uidlist = []
		for id_uid in id_uid:
			id_uid_dict[ str(id_uid[0]) ] = str( id_uid[1] )
			if str(id_uid[1]) not in uidlist:
				uidlist.append( str(id_uid[1]) )
		
		uid_uname_dict = {}
		
		uidstring = list2string( uidlist )
		uname_query = "select distinct nid,ssid from gbusers where ssid in %s;" % ( uidstring )  
		self.curs.execute( uname_query )
		unames = self.curs.fetchall()
		
		

		for elem in unames:
			uid_uname_dict[ str(elem[1]) ] = elem[0]

		dict = {}
		for key in id_uid_dict:
			dict[key] = uid_uname_dict[ id_uid_dict[key]]

		return dict

	
	def getModDate( self, ssid ):
		"""
		"""
		execute_query( 'select nodetype from gbnidssid where ssid = %s;' %( ssid ) , self.curs)
		nodetype = query_fetchall(self.curs)[0][0]

		query = "select gbtimestamp from %s where ssid = %s;" % ( nodetype, ssid ) 
		self.curs.execute( query )
                result = self.curs.fetchall()
		time = result[0][0].strftime( "%d %B %Y %I:%M:%S %p %Z" )
		
		return time
			

	def triplesKB( self ):
		"""
		"""
		execute_query( 'select count(*) from gbrelations;' , self.curs)
		cnt_relations = query_fetchall(self.curs)[0][0]

		execute_query( 'select count(*) from gbattributes;' , self.curs)
		cnt_attributes = query_fetchall(self.curs)[0][0]

		execute_query( 'select count(*) from gbroletypes;' , self.curs)
		cnt_rts = query_fetchall(self.curs)[0][0]

		execute_query( 'select count(*) from gbcatalogsubjecttypes;' , self.curs)
		cnt_ats = query_fetchall(self.curs)[0][0]

		total_triples = cnt_relations + cnt_attributes + cnt_rts + cnt_ats

		return  total_triples




		
if __name__=="__main__":
      constring="dbname=experimental user=rajiv password=rajiv host=localhost"
      obj=GetMethods(constring)
      #print obj.getNeighbourhood(['2392151','4552393','5611826','4687112','1118366','1090622','1124093','157655','203','205','206','208','588','592','591','594'],'rendered_nbh',[])
      #print obj.getNeighbourhood(['5332627'],'rendered_nbh',[])
      #print obj.getNeighbourhood(['2392151','4552393','5611826','4687112','1118366','1090622','1124093','157655','203','205','206','208','588','592','591','594'],'rendered_nbh',['gbobjects','gbobjecttypes'])
      #print obj.getlatestssids(['2392151','4552393','5611826','4687112','1118366','1090622','1124093','157655','203','205','206','208','588','592','591','594'],'ssid',[])
      print obj.getlatestssids(['Mohanlal','Robert_De_Niro'],'nid')
      #print obj.getnids(['2392151','4552393','5611826','4687112','1118366','1090622','1124093','157655','203','205','206','208','588','592','591','594'],['gbobjects'])
      #print obj.getAllnbh(['2392151','4552393','5611826','4687112','1118366','1090622','1124093','157655','203','205','206','208','588','592','591','594'])
      #print obj.getInstancesCnt('763746324786328')
      #print obj.search('gandhi')
      #print obj.searchPossibleRel('vijay', 'viceChancellor', 'right')
      #print obj.searchNodes('Historic','gbobjecttypes')
      #print obj.triplesKB()
      #print obj.search('gnowsys','1')
      #print obj.getContributors('149')
      #print obj.getModDate('149')
      ##print obj.getAllInstances( '152' )
      ##print obj.getSubtypes( '152' )
      #print obj.getInstances( '331','ssid' )
      ##print obj.getAllSubtypes( ['152'] )
      ##print obj.getRelationids ([['17','15'],['17','16']])
      #Attrssidlist = ['130','131','123']
      ##print obj.getAttributeValues( Attrssidlist )
      ##print obj.getNodetype( '12345' )
      ##print obj.getRelationtypes(['11','38026'])
      ##print obj.getAttributetypes(['5','19'])
      ##print obj.getRoles('instanceof')
      ##print obj.getDatatype(['6','7','8','9'])
      ##print obj.getSelectionlist()
      ##print obj.isnidExists('colors')
      ##print obj.getRegex()
      ##print obj.getSubjecttypes('Languages')
      #ssid_list=['7']
      ##print obj.getinfoFromSSID(ssid_list)
      ##print obj.getlatestssids(['writer1','book2'],'nid')
      #obj.getlatestssids(['instanceof','subtypeof'],'nid')
      ##print obj.getUserIdfromUsername('')
      ##print obj.getRestrictions(['10','50','51'])
      ##print obj.getNeighbourhood(['263'],'rendered_nbh')
      ##print obj.getAllSnapshots('nid',"Vesit's OWner")
      ##print obj.getlatestssidsFromNids(["Vesit's OWner"])
      ##print obj.getPublicIds(['3','4','11','12'],1)
      ##print obj.search( 'Writer' )
      #print obj.getnids(['113'],userid='1')
      ##print obj.getCount('gbusers')
      ##print obj.getSpecificnbh('142',['attributes','relations'])
      ##print obj.getSpecificnbh('142',{'attributes':['title'],'relations':['hasWritten']})
      ##print obj.getAuthor('88')
      ##print obj.updateStatus( '133' , 'deleted')
      ##print obj.updateStatus( '142' , 'deleted')
      ##print obj.getlatestssids(['writer4','book2'],'nid')
      ##print obj.getStructure('142')
      ##print obj.updatePasswd('gnowsysuser8','abc','1')
      #print obj.getPossibleRel( 'hasWritten' )
      #print obj.getPossibleAttr( '1429' )
      #print obj.getPriorstates(['123'])
      #print obj.getPoststates(['123'])      
      #print obj.getNodetypes(['6','40','331'])      
      #params = {'instanceof':['199']}
      #print obj.getFrame('gbobjects',params)
      #print obj.getRelFrame('gbobjects','reads','1035')
      #print obj.getFrame('gbobjects', {'instanceof': ['21']},'0')





