# -*- coding: utf-8 -*- 
 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################


__author__ = """Ganesh Gajre <ginovation@gmail.com>"""
__docformat__ = 'plaintext'


import  xmlrpclib
import pydot
import os
from GetMethods import *

color = ['black', 'green', 'magenta', 'orange', 'red', 'gold', 'indigo', 'navy', 'peru', ]

gnowsys_graph = {'o_shape':'box', 'o_style':'filled', 'o_color':'#ff8080', 'ot_shape':"box", 'ot_style':'', 'ot_color':'', 'r_shape':'oval', 'r_s\
tyle':'filled', 'r_color':'#aaaaff', 'rt_shape':'oval', 'rt_style':'', 'rt_color':'', 'a_shape':'box', 'a_style':'filled', 'a_color':'#ffccaa', 'at_s\
hape':'oval', 'at_style':'', 'at_color':'', 'u_shape':'oval', 'u_style':'filled', 'u_color':'#ffe4b5', 'm_color':'#cdde87', 'v_shape':'box', 'v_style':'fi\
lled', 'v_color':'#ffccaa'}


class GenGraph:
    
    def __init__(self , conString , path, url):
        self.constring = conString
        #self.db_con = xmlrpclib.Server('http://admin:ganesh@localhost:8080/latestgnowsys')
        self.change_dict={}
        self.path = path
        self.url = url


    def SpecificGraph( self, ssid, rt):
        """
        """
        image_name = ssid +'_'+'depmap'
        dot_path = self.path + '/nbhimages/' + image_name +'.xdot' # dot path for xdot file
        img_path = self.path + '/nbhimages/' + image_name +'.svg' # image path for svg image

        dot = pydot.Dot()

        dependson = []

        obj = GetMethods( self.constring )
        nbh = obj.getNeighbourhood([ssid],'rendered_nbh')[ssid]

        if nbh.has_key('relations'):
            if nbh['relations'].has_key(rt):
                dependson = nbh['relations'][rt]['rightroles']


        ssid_nid = obj.getnids( [ssid] + dependson )
        
        nid = ssid_nid[ssid]

        
        node_shape = "rectangle"
        node_url= '"'+self.url+'/gnowql/gendep?id=%s"'%(ssid)
        node = pydot.Node(nid, label=nid, shape=node_shape, URL=node_url)
        dot.add_node(node)
        

        
        for id in dependson:
            nid_dependson = ssid_nid[id]
            node_shape = "rectangle"
            node_url= '"'+self.url+'/gnowql/gendep?id=%s"'%(id)
            node = pydot.Node(nid_dependson, label=nid_dependson ,shape=node_shape, URL=node_url)
            dot.add_node(node)
            edge = pydot.Edge( nid_dependson, nid, color="blue")
            dot.add_edge(edge)

            
        dot.write_xdot(dot_path, prog='dot')
        dot.write_svg(img_path, prog='dot')
        return 'done'
        
        
                
        
        
    def genGraph(self,lstssid,redirect_cond = 0):
        
        dot_path = self.path + '/nbhimages/' + str(lstssid[0])+'.xdot' # dot path for xdot file
        #dot_path = self.path + str(lstssid[0])+'.xdot' # dot path for xdot file
        img_path = self.path + '/nbhimages/' + str(lstssid[0])+'.svg' # image path for svg image
        #img_path = self.path + str(lstssid[0])+'.svg' # image path for svg image

        redirect_url = '"'+self.url+'/gnowql/genimage?id=%s&purl=%s"'


        # if os.path.exists( img_path ):
        #     return 'redirect'

        if redirect_cond == 1:
            redirect_url = '"'+self.url+'/redirect?objid=%s&purl=%s"'

        

 
        obj = GetMethods( self.constring )
        print lstssid
        node_type=obj.getNodetype(str(lstssid[0]))
        print node_type 
        #if node_type == 'gbrelations':
        #    pass
        nid = obj.getnids([str(lstssid[0])], [node_type])[str(lstssid[0])]  ### function call changed by rajiv
        nodenetwork=obj.getNeighbourhood(lstssid,'rendered_nbh', [node_type])[lstssid[0]] ### function call changed by rajiv
        print nodenetwork
        nodeinfo = obj.getAllnbh(lstssid)
        print nodeinfo
        user_ssid = nodeinfo[0]['uid']
        user_name = obj.getnids([str(user_ssid)],['gbusers'])[str(user_ssid)] ### function call changed by rajiv
        print user_name
        
        inid = obj.getinids(lstssid, [node_type])[lstssid[0]] ### function call changed by rajiv
        print " inids is ",inid
        
        instances_node_count = obj.getInstancesCnt(str(lstssid[0]))
        
        subtypes_node = obj.getSubtypes(str(lstssid[0]))
        print "Node subtypes are ", subtypes_node 
        
        #self.change_dict={}
        
        

        
        self.change_dict['nid']=obj.getnids(lstssid,[node_type])[lstssid[0]]
        self.change_dict['type']=node_type
        #self.change_dict['ssid'] = obj.getlatestssids([self.change_dict['nid']],'nid')[self.change_dict['nid']]
        self.change_dict['ssid'] = lstssid[0]
        print self.change_dict['nid']
        if  nodenetwork.has_key('attributes'):
            val_attributes=nodenetwork['attributes']
            if val_attributes.has_key('content'):
                self.change_dict['content']=val_attributes['content']
            if val_attributes.has_key('title'):
               self.change_dict['title']=val_attributes['title'][1]
            if val_attributes.has_key('description'):
                self.change_dict['description']=val_attributes['description']

        if node_type in ['gbobjecttypes','gbattributetypes','gbrelationtypes','gbusertypes']:
            print " Inside gbobjecttypes"

            if nodenetwork.has_key('relations'):
                if nodenetwork['relations'].has_key('subtypeof'):
                    self.change_dict['relationtype'] = 'subtypeof'
                    subtypeofssid=nodenetwork['relations']['subtypeof']['rightroles']
                    self.change_dict['subtypeof']=obj.getnids(subtypeofssid,[node_type])[subtypeofssid[0]]
                    print "subtypeofssid is ",subtypeofssid
                    
        elif node_type in ['gbobjects','gbrelations','gbattributes']:
            print " Inside gbobjects"
            """
            if nodenetwork.has_key('relations'):
                print " Inside GBO relations"
                print '---------------------------nodenetwork----------------------',nodenetwork
                if nodenetwork['relations'].has_key('instanceof'):
                    print " Inside GBO relatons Instanceof"
                    self.change_dict['relationtypes'] = 'instanceof'
                    instanceofssid = nodenetwork['relations']['instanceof']['rightroles']
                    self.change_dict['instanceof']=obj.getnids(instanceofssid)[instanceofssid[0]]
                    #print 'instance of ssid is', instanceofssid
            #if nodenetwork['relations']['subtypeof'].has_key('rightroles') =='rightroles' or nodenetwork['relations']['subtypeof'].has_key('leftroles') =='leftroles':
            """
            
            
        
        #if nodenetwork.has_key('relationtypes'):
         #   r_type = nodenetwork['relationtypes']
          #  for i in r_type:
                
        print self.change_dict    
        nodeT=node_type
        dotschema = pydot.Dot(size='100,100')
        if self.change_dict.has_key('title'):
            #if self.change_dict.has_key('instanceof'):
            
            #    node_name=self.change_dict['instanceof']+'| '+str(self.change_dict['title'])
            #    node_tooltip=self.change_dict['instanceof']+'| '+str(self.change_dict['title'])
            #    node_label=self.change_dict['instanceof']+'| '+str(self.change_dict['title'])
            #    center=self.change_dict['instanceof']+'| '+str(self.change_dict['title'])
            #else:
            node_name = str(self.change_dict['title'])
            node_tooltip=str(self.change_dict['title'])
            node_label=str(self.change_dict['title'])
            center=str(self.change_dict['title'])
        else:
            #if self.change_dict.has_key('instanceof'):

             #   node_name=self.change_dict['instanceof']+'>'+self.change_dict['nid']
             #   node_tooltip=self.change_dict['instanceof']+'>'+self.change_dict['nid']
             #   node_label=self.change_dict['instanceof']+'>'+self.change_dict['nid']
             #   center=self.change_dict['instanceof']+'>'+self.change_dict['nid']
            node_name = self.change_dict['nid']
            node_tooltip=self.change_dict['nid']
            node_label=self.change_dict['nid']
            center=self.change_dict['nid']
        node_url = redirect_url%(lstssid[0],self.url)
        
        #print '------------------gnowsys_graph-------------------', gnowsys_graph
        if nodeT=='gbobjecttypes':

            print "GNOWSYS_GRAPH ATTRIBUTES : %s" % str(gnowsys_graph['ot_shape'])
            node_shape = gnowsys_graph['ot_shape']
            node_color = gnowsys_graph['ot_color']
            node_style = gnowsys_graph['ot_style']
        
        elif nodeT== 'gbusertypes':
            node_shape = gnowsys_graph['ot_shape']
            node_color = gnowsys_graph['ot_color']
            node_style = gnowsys_graph['ot_style']

        elif nodeT=='gbobjects':
            node_shape = gnowsys_graph['o_shape']
            node_color = gnowsys_graph['o_color']
            node_style = gnowsys_graph['o_style']
        

        elif nodeT=='gbrelationtypes':
            node_shape = gnowsys_graph['rt_shape']
            node_color = gnowsys_graph['rt_color']
            node_style = gnowsys_graph['rt_style']

        elif nodeT=='gbrelations':
            node_shape = gnowsys_graph['r_shape']
            node_color = gnowsys_graph['r_color']
            node_style = gnowsys_graph['r_style']

        elif nodeT == 'gbattributetypes':
            node_shape = gnowsys_graph['at_shape']
            node_color = gnowsys_graph['at_color']
            node_style = gnowsys_graph['at_style']
        
        elif nodeT == 'gbattributes':
            node_shape = gnowsys_graph['a_shape']
            node_color = gnowsys_graph['a_color']
            node_style = gnowsys_graph['a_style']
        
        elif nodeT == 'gbusers':
            node_shape = gnowsys_graph['o_shape']
            node_color = gnowsys_graph['o_color']
            node_style = gnowsys_graph['o_style']
            
        
        print "CENTRAL NODE"
        #print "----------------node_shape---------------------",node_shape
        central_node = pydot.Node(node_name, label=node_label, tooltip=node_tooltip, URL=node_url, shape=node_shape, color=node_color, style=node_style, fontsize="15" )
        print central_node
################# User and Contributor code ################################################
        
        dotschema.add_node(central_node)
        """
        node_name = 'author'
        node_label = 'contributor'
        node_tooltip = 'author'
        node_shape = gnowsys_graph['r_shape']
        node_color = gnowsys_graph['r_color']
        node_style = gnowsys_graph['r_style']
        node = pydot.Node(node_name, label=node_label, tooltip=node_tooltip, shape=node_shape, color=node_color, style=node_style)
        dotschema.add_node(node)
        edge = pydot.Edge('author',center,color = 'blue',arrowhead='none')
        dotschema.add_edge(edge)
        ############# USER############################
        node_name = user_name
        node_label = user_name
        node_tooltip = user_name
        node_shape = gnowsys_graph['u_shape']
        node_color = gnowsys_graph['u_color']
        node_style = gnowsys_graph['u_style']
        node_url = str(nodeinfo[0]['uid'])
        node = pydot.Node(node_name, label=node_label, tooltip=node_tooltip, shape=node_shape, color=node_color, style=node_style,URL=node_url)
        dotschema.add_node(node)
        edge = pydot.Edge(user_name,'author',color = 'blue',arrowhead='none')
        dotschema.add_edge(edge)
        """
        if nodeT in ['gbobjecttypes','gbusertypes']:
            if nodenetwork.has_key('attributetypes'):
                att_type = nodenetwork['attributetypes']
                node_name = 'has_attributetype'
                node_label = 'has attributetypes'
                node_tooltip = 'has attributetypes'
                #node_url = '"'+self.url+'/gnowql/genimage?=%s"'%i
                node_shape = gnowsys_graph['at_shape']
                node_style = gnowsys_graph['at_style']
                node_color = gnowsys_graph['at_color']
                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                dotschema.add_node(node)
                edge=pydot.Edge(center, 'has_attributetype' ,color='blue')
                dotschema.add_edge(edge)
                att_type_nid = obj.getnids(att_type,['gbattributetypes'])
                
                for i,j in att_type_nid.iteritems():
                    
                    #attypenid = obj.getnids([i])[i]
                    attypenid = j
                    #print " attributetype is",attypenid
                    node_name = attypenid
                    node_label = attypenid
                    node_tooltip = attypenid
                    
                    node_url = redirect_url%(i,self.url)
                    node_shape = gnowsys_graph['ot_shape']
                    node_style = gnowsys_graph['ot_style']
                    node_color = gnowsys_graph['ot_color']
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                    dotschema.add_node(node)
                    edge=pydot.Edge('has_attributetype', attypenid ,color='blue')
                    dotschema.add_edge(edge)
            else:
                pass
        

        if nodeT == 'gbattributetypes':
            at_nid = nid
            stid = []
            at_subjects = obj.getSubjecttypes(str(at_nid))
            if len(at_subjects)<>0:
                for i in at_subjects:
                    stid.append(i['stid'])


            node_name = 'has_Subjecttypes'
            node_label = 'has_Subjecttypes'
            node_tooltip = 'has_Subjecttypes'
                    
            #node_url = redirect_url%i
            node_shape = gnowsys_graph['rt_shape']
            node_style = gnowsys_graph['rt_style']
            node_color = gnowsys_graph['rt_color']
            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, )
            dotschema.add_node(node)
            edge=pydot.Edge(center, 'has_Subjecttypes',color='blue')
            dotschema.add_edge(edge)
            if len(stid)<>0:
                stid_nid = obj.getnids(stid,[])
                for j,k in stid_nid.iteritems():
                    subject_nid = k
                    node_name = subject_nid
                    node_tooltip = subject_nid
                    node_label = subject_nid
                    node_tooltip = subject_nid
                    
                    node_url = redirect_url%(j,self.url)
                    node_shape = gnowsys_graph['ot_shape']
                    node_style = gnowsys_graph['ot_style']
                    node_color = gnowsys_graph['ot_color']
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                    dotschema.add_node(node)
                    edge=pydot.Edge('has_Subjecttypes', subject_nid ,color='blue')
                    dotschema.add_edge(edge)
            
            

        if nodenetwork.has_key('attributes'):
            attributes=nodenetwork['attributes']
            at_list=attributes.keys()
            #print at_list
            at_values= attributes.values()
            #print at_values
            att_ssid_dict = obj.getlatestssids(at_list,'nid')
            for i,k in att_ssid_dict.iteritems():
                """for j in at_values:
                
                    #for k in j:
                
                    node_name = j[1]
                    node_tooltip = j[1]
                    node_label = j[1]
                    node_shape = gnowsys_graph['v_shape']
                    node_style = gnowsys_graph['v_style']
                    node_color = gnowsys_graph['v_color']
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                    dotschema.add_node(node)
                    edge=pydot.Edge(j[1],i ,color='blue',arrowhead = 'none')
                    dotschema.add_edge(edge)
                """
                
                att_ssid = k
                #print "attribute ssid is ",att_ssid

                if i in ['title','content','password']:
                    pass
                
                elif i in ['description']:
                    #print "Inside Description AT"
                    att_desc_value =nodenetwork['attributes'][str(i)][1]
                    if  isinstance(att_desc_value,list):
                        
                        print att_desc_value[0]
                        if att_desc_value[0] =='' or att_desc_value[0] == None:
                            pass
                        else:
                            #print "inside att_desc_value condition "
                            node_name = i
                            node_tooltip = i
                            node_label = i
                            node_shape = gnowsys_graph['at_shape']
                            node_style = gnowsys_graph['at_style']
                            node_color = gnowsys_graph['at_color']
                            node_url = str(att_ssid)
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                            dotschema.add_node(node)
                            edge=pydot.Edge(center, i ,color='blue')
                            dotschema.add_edge(edge)
                            node_name = att_desc_value[0]
                            node_tooltip = att_desc_value[0]
                            att_list =[]
                            att_value = ''
                            #node_name = att_desc_value[0]
                            #node_tooltip = att_desc_value[0]
                            for word in att_desc_value[0].split():
                                att_list.append(word)
                            if len(att_list)>= 6:
                                print " Inside att_list "
                                att_list1 = att_list[:5]
                                for word in att_list1:
                                    att_value = att_value + word + ' '



                                node_label = att_value+'...'
                                print " value of ATT_desc_value",att_value
                            else:
                                node_label = att_desc_value[0]
                            #node_label = att_desc_value[0]
                            node_shape = gnowsys_graph['a_shape']
                            node_style = gnowsys_graph['a_style']
                            node_color = gnowsys_graph['a_color']
                            #node_url = str(att)
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                            dotschema.add_node(node)
                            edge=pydot.Edge( i,att_desc_value[0] ,color='blue')
                    #edge=pydot.Edge(att_desc_value, i ,color='blue')                                                                                        
                            dotschema.add_edge(edge)
                    else:
                        if att_desc_value =='' or att_desc_value == None:
                            pass
                        else:
                            print "inside att_desc_value condition "
                            node_name = i
                            node_tooltip = i
                            node_label = i
                            node_shape = gnowsys_graph['at_shape']
                            node_style = gnowsys_graph['at_style']
                            node_color = gnowsys_graph['at_color']
                            node_url = str(att_ssid)
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                            dotschema.add_node(node)
                            edge=pydot.Edge(center, i ,color='blue')
                            dotschema.add_edge(edge)

                            node_name = att_desc_value
                            node_tooltip = att_desc_value
                            att_list =[]
                            att_value = ''
                            #node_name = att_desc_value[0]
                            #node_tooltip = att_desc_value[0]
                            for word in att_desc_value.split():
                                att_list.append(word)
                            if len(att_list)>= 6:
                                att_list1 = att_list[:5]
                                for word in att_list1:
                                    att_value = att_value + word + ' '



                                node_label = att_value+'...'
                                print " value of ATT_desc_value",att_value
                            else:
                                node_label = att_desc_value
                            #node_label = att_desc_value
                            node_shape = gnowsys_graph['a_shape']
                            node_style = gnowsys_graph['a_style']
                            node_color = gnowsys_graph['a_color']
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                            dotschema.add_node(node)
                            edge=pydot.Edge( i,att_desc_value ,color='blue')
                            dotschema.add_edge(edge)
                else:
                    
                    att_desc_value =nodenetwork['attributes'][str(i)][1]
                    if isinstance(att_desc_value,list):
                        
                        print att_desc_value[0]
                        if att_desc_value[0] =='' or att_desc_value[0] == None:
                            pass
                        else:
                            print "inside att_desc_value condition "
                            node_name = i
                            node_tooltip = i
                            node_label = i
                            node_shape = gnowsys_graph['at_shape']
                            node_style = gnowsys_graph['at_style']
                            node_color = gnowsys_graph['at_color']
                            node_url = str(att_ssid)
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                            dotschema.add_node(node)
                            edge=pydot.Edge(center, i ,color='blue')
                            dotschema.add_edge(edge)
                            att_list =[]
                            att_value = ''
                            node_name = att_desc_value[0]
                            node_tooltip = att_desc_value[0]
                            for word in att_desc_value[0].split():
                                att_list.append(word)
                            if len(att_list)>= 6:
                                print " Inside att_list"
                                att_list1 = att_list[:5]
                                for word in att_list1:
                                    att_value = att_value + word + ' '
                            
                            
                            
                                node_label = att_value+'...'
                                print " value of ATT_desc_value",att_value
                            else:
                                node_label = att_desc_value[0]
                            #node_label = att_desc_value[0]
                            node_shape = gnowsys_graph['a_shape']
                            node_style = gnowsys_graph['a_style']
                            node_color = gnowsys_graph['a_color']
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                            dotschema.add_node(node)
                            edge=pydot.Edge( i,att_desc_value[0] ,color='blue')
                    #edge=pydot.Edge(att_desc_value, i ,color='blue')  
                            dotschema.add_edge(edge)
                    else:
                        print att_desc_value
                        if att_desc_value =='' or att_desc_value == None:
                            pass
                        else:
                            print "inside att_desc_value condition "
                            node_name = i
                            node_tooltip = i
                            node_label = i
                            node_shape = gnowsys_graph['at_shape']
                            node_style = gnowsys_graph['at_style']
                            node_color = gnowsys_graph['at_color']
                            node_url = str(att_ssid)
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                            dotschema.add_node(node)
                            edge=pydot.Edge(center, i ,color='blue')
                            dotschema.add_edge(edge)
                            att_list =[]
                            att_value = ''
                            node_name = att_desc_value
                            node_tooltip = att_desc_value
                            for word in att_desc_value.split():
                                att_list.append(word)
                            if len(att_list)>= 6:
                                print " Inside att list "
                                for word in att_list[:5]:
                                    att_value = att_value + word + ' '



                                node_label = att_value+'...'
                            else:
                                node_label = att_desc_value
                            #node_name = att_desc_value
                            #node_tooltip = att_desc_value
                            #node_label = att_desc_value
                            node_shape = gnowsys_graph['a_shape']
                            node_style = gnowsys_graph['a_style']
                            node_color = gnowsys_graph['a_color']
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                            dotschema.add_node(node)
                            edge=pydot.Edge( i,att_desc_value ,color='blue')
                            dotschema.add_edge(edge)
                
 ############ Roles And Relationtypes #########################################       
        if nodeT == 'gbrelationtypes':
             rt_roles1=obj.getRoles(self.change_dict['nid'])
             print  " in gbrelationtypes",rt_roles1
             if rt_roles1[0]['subjecttype1'] == 0:
                 pass
             else:
                 sub1 = obj.getnids([str(rt_roles1[0]['subjecttype1'])],[])[str(rt_roles1[0]['subjecttype1'])]
                 sub2 = obj.getnids([str(rt_roles1[0]['subjecttype2'])],[])[str(rt_roles1[0]['subjecttype2'])]
             #print " in gbrelationtypes",sub1 ,sub2
             
                 node_name = sub1
                 node_tooltip = sub1
                 node_label = str(sub1)
                 node_shape = gnowsys_graph['ot_shape']
                 node_color = gnowsys_graph['ot_color']
                 node_style = gnowsys_graph['ot_style']
                 node_url = redirect_url%(rt_roles1[0]['subjecttype1'],self.url)
             
                 node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip,URL= node_url)
                 dotschema.add_node(node)
                 edge=pydot.Edge(sub1,center,color='blue',arrowhead='none')
                 dotschema.add_edge(edge)
             # subject 2 is added

                 node_name= str(sub2)
                 node_tooltip = str(sub2)
                 node_label= str(sub2)
                 node_shape= gnowsys_graph['ot_shape']
                 node_color= gnowsys_graph['ot_color']
                 node_style= gnowsys_graph['ot_style']
                 node_url =redirect_url%(rt_roles1[0]['subjecttype2'],self.url)
                 node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                 dotschema.add_node(node)
                 edge=pydot.Edge(center,sub2,color='blue')
                 dotschema.add_edge(edge)



        
            

        if nodenetwork.has_key('relationtypes'):
            r_type=nodenetwork['relationtypes']
            #print r_type
            rt_nid_dic = obj.getnids(r_type,['gbrelationtypes'])
            for i,k in rt_nid_dic.iteritems():
                rt_nids= k
                #print rt_nids
                """
                node_name = rt_nids
                node_tooltip = rt_nids
                node_label = rt_nids
                node_shape = gnowsys_graph['rt_shape']
                node_style = gnowsys_graph['rt_style']
                node_color = gnowsys_graph['rt_color']
                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                dotschema.add_node(node)
                edge=pydot.Edge(center, rt_nids,color='red')
                dotschema.add_edge(edge)
                """
                rt_roles=obj.getRoles(rt_nids)
                rt_roles1=rt_roles[0]
                #print rt_roles1
                #sub2 = ''
                #print rt_roles1['subjecttype1']
                #print rt_roles1['subjecttype2']
                #print self.change_dict['ssid']
                
                if str(rt_roles1['subjecttype1']) == str(self.change_dict['ssid']):
                    #print " Case1 match"
                    node_name = rt_nids
                    node_tooltip = rt_nids
                    node_label = rt_nids
                    node_shape = gnowsys_graph['rt_shape']
                    node_style = gnowsys_graph['rt_style']
                    node_color = gnowsys_graph['rt_color']
                    
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                    dotschema.add_node(node)
                    edge=pydot.Edge(center,rt_nids,color='blue')
                    dotschema.add_edge(edge)
                    
                    sub2 = obj.getnids([str(rt_roles1['subjecttype2'])],[])[str(rt_roles1['subjecttype2'])]
                    #print "subject2 is", sub2
                    
                    node_name = sub2
                    node_tooltip = sub2
                    node_label = sub2
                    #node_url = str(rt_roles1['subjecttype2'])+'.svg'
                    node_shape = gnowsys_graph['ot_shape']
                    node_style = gnowsys_graph['ot_style']
                    node_color = gnowsys_graph['ot_color']
                    node_url = redirect_url%(rt_roles1['subjecttype2'],self.url)
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip,URL=node_url)
                    dotschema.add_node(node)
                    #print 'first',rt_nids
                    #print 'second',sub2
                    edge=pydot.Edge(rt_nids, sub2, color='blue')
                    dotschema.add_edge(edge)
                    
                    
                elif str(rt_roles1['subjecttype2']) == str(self.change_dict['ssid']):
                    #print "case 2 match"
                    sub2 =obj.getnids([str(rt_roles1['subjecttype1'])],[])[str(rt_roles1['subjecttype1'])]
                    #print sub2
                    
                    node_name = rt_nids
                    node_tooltip = rt_nids
                    node_label = rt_nids
                    node_shape = gnowsys_graph['rt_shape']
                    node_style = gnowsys_graph['rt_style']
                    node_color = gnowsys_graph['rt_color']
                    node_url = redirect_url%(rt_roles1['subjecttype1'],self.url)
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip,URL=node_url)
                    dotschema.add_node(node)
                    edge=pydot.Edge(rt_nids,center,color='blue')
                    dotschema.add_edge(edge)
                    
                    node_name = sub2
                    node_tooltip = sub2
                    node_label = sub2
                    node_url = redirect_url%(rt_roles1['subjecttype1'],self.url)
                    node_shape = gnowsys_graph['ot_shape']
                    node_style = gnowsys_graph['ot_style']
                    node_color = gnowsys_graph['ot_color']
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                    dotschema.add_node(node)
                    edge=pydot.Edge(sub2,rt_nids,color='blue')
                    dotschema.add_edge(edge)

        print " length of instances node is ",str(instances_node_count)
        if nodeT in ['gbobjects','gbrelations','gbattributes']:
            pass
        else:
            if instances_node_count<>0 and instances_node_count <= 10:
                node_name ='has_member'
                node_tooltip = 'has members'
                node_label = 'has members'
                node_shape = gnowsys_graph['rt_shape']
                node_style = gnowsys_graph['rt_style']
                node_color = gnowsys_graph['rt_color']
                
                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                dotschema.add_node(node)
                edge = pydot.Edge(center,'has_member',color = 'blue')
                dotschema.add_edge(edge)
            #if len(instances_node)<= 5:
                instances_node = obj.getAllInstances(str(inid))
                for i in instances_node:
                    if nodeT =='gbrelationtypes':
                        instance_nid = obj.getnids([str(i)],[])[str(i)]
                        #print instance_nid
                        instance_ssid=instance_nid.split('_')
                        sub1 = obj.getnids([str(instance_ssid[0])],[])[str(instance_ssid[0])]
                        sub2 = obj.getnids([str(instance_ssid[1])],[])[str(instance_ssid[1])]
                        instance= str(sub1+'_'+center+'_'+sub2)
                        node_name = instance
                        node_tooltip = instance
                        node_label = instance
                        node_shape = gnowsys_graph['o_shape']
                        node_style = gnowsys_graph['o_style']
                        node_color = gnowsys_graph['o_color']
                        for k in instance_ssid:
                            node_url = redirect_url%(k,self.url)
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                        dotschema.add_node(node)
                        edge = pydot.Edge('has_member', instance, color = 'blue')
                        dotschema.add_edge(edge)

                    else:
                        instance_nid = obj.getnids([str(i)],[])[str(i)]
                        #print instance_nid
                        instance = instance_nid
                        node_name = instance
                        node_tooltip = instance
                        node_label = instance
                        node_shape = gnowsys_graph['o_shape']
                        node_style = gnowsys_graph['o_style']
                        node_color = gnowsys_graph['o_color']
                        #print self.url
                        node_url = redirect_url%(i,self.url)
                        #print " node url is ",node_url
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                        dotschema.add_node(node)
                        edge = pydot.Edge('has_member', instance, color = 'blue')
                        dotschema.add_edge(edge)
                        """
                        if os.path.exists(self.path+'/nbhimages/'+str(i)+'.svg'):
                            pass
                        else:
                            self.load_image(str(i))
                        """
                        
            elif instances_node_count<> 0 and instances_node_count >= 10:
                
            
                node_name ='has_member'
                node_tooltip = 'has members'
                node_label = 'has members'
                node_shape = gnowsys_graph['rt_shape']
                node_style = gnowsys_graph['rt_style']
                node_color = gnowsys_graph['rt_color']
                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                dotschema.add_node(node)
                edge = pydot.Edge(center,'has_member',color = 'blue')
                dotschema.add_edge(edge)
            #for i in instances_node:
                #if nodeT == 'gbobjecttypes':
                #    pass
                #else:
                #instance_nid = obj.getnids([str(i)])[str(i)]
                #print instance_nid
                #instance = instance_nid
                node_name = str(instances_node_count)
                #node_tooltip = str(len(instances_node))
                nid =''
                #instances_node = obj.getAllInstances(str(inid))
                #for id in instances_node:
                 #   instance_nid = obj.getnids([id])[id]
                 #   nid = nid+instance_nid+','
                #node_tooltip = 'it has'+str(instances_node_count)+' members'
                node_tooltip = str(instances_node_count)
                node_label = str(instances_node_count)+' members'
                node_shape = gnowsys_graph['o_shape']
                node_style = gnowsys_graph['o_style']
                node_color = gnowsys_graph['o_color']
                #node_url = redirect_url%
                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                dotschema.add_node(node)
                edge = pydot.Edge('has_member', str(instances_node_count), color = 'blue')
                dotschema.add_edge(edge)
                """
                if os.path.exists(self.path+'/nbhimages/'+str(i)+'.svg'):
                    pass
                else:
                    self.load_image(str(i))
                """
            else:
                pass
            
        
            
            
                
    
        if nodenetwork.has_key('relations'):
            sub_relations = nodenetwork['relations']
            print "sub_relation is ",sub_relations
            for i in sub_relations:
                if i == 'subtypeof':
                    """
                    node_name = 'type_of'
                    node_tooltip = 'type of'
                    node_label = 'type of'
                    node_shape = gnowsys_graph['rt_shape']
                    node_style = gnowsys_graph['rt_style']
                    node_color = gnowsys_graph['rt_color']
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                    dotschema.add_node(node)
                    edge = pydot.Edge(center, 'type_of', color = 'blue')
                    dotschema.add_edge(edge)
                    """
                    typeof = sub_relations['subtypeof']
                    #print " typeof is ",typeof
                    if typeof.has_key('leftroles'):
                        reverse_name = obj.getInverseName(i)
                        #print reverse_name
                        node_name = reverse_name
                        node_tooltip = reverse_name
                        node_label = reverse_name
                        node_shape = gnowsys_graph['rt_shape']
                        node_style = gnowsys_graph['rt_style']
                        node_color = gnowsys_graph['rt_color']
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                        dotschema.add_node(node)
                        edge = pydot.Edge(reverse_name, center, color = 'blue')
                        dotschema.add_edge(edge)

                        typenid = obj.getnids(typeof['leftroles'],[])[typeof['leftroles'][0]]
                        #print " type nid is ",typenid
                        node_name = typenid
                        node_tooltip = typenid
                        node_label = typenid
                        node_url = redirect_url%(typeof['leftroles'][0],self.url)
                        node_shape = gnowsys_graph['ot_shape']
                        node_style = gnowsys_graph['ot_style']
                        node_color = gnowsys_graph['ot_color']
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                        dotschema.add_node(node)
                        edge = pydot.Edge( typenid,reverse_name, color = 'blue')
                        dotschema.add_edge(edge)
                        """
                        if os.path.exists(self.path+'/nbhimages/'+str(typeof['leftroles'][0])+'.svg'):
                            pass
                        else:
                            self.load_image(str(typeof['leftroles'][0]))
                        """



                    elif typeof.has_key('rightroles'):
                        node_name = 'type_of'
                        node_tooltip = 'type of'
                        node_label = 'type of'
                        node_shape = gnowsys_graph['rt_shape']
                        node_style = gnowsys_graph['rt_style']
                        node_color = gnowsys_graph['rt_color']
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                        dotschema.add_node(node)
                        edge = pydot.Edge(center, 'type_of', color = 'blue')
                        dotschema.add_edge(edge)

                        typenid = obj.getnids(typeof['rightroles'],[])[typeof['rightroles'][0]]
                        #print " type nid is ",typenid
                        node_name = typenid
                        #print " node name is ",node_name
                        node_tooltip = typenid
                        node_label = typenid
                        node_url = redirect_url%(typeof['rightroles'][0],self.url)
                        #print " Node tooltip  in relation instanceof is", node_
                        node_shape = gnowsys_graph['ot_shape']
                        node_style = gnowsys_graph['ot_style']
                        node_color = gnowsys_graph['ot_color']
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                        dotschema.add_node(node)
                        edge = pydot.Edge( 'type_of',typenid, color = 'blue')
                        dotschema.add_edge(edge)
                        """
                        if os.path.exists(self.path+'/nbhimages/'+str(typeof['rightroles'][0])+'.svg'):
                            pass
                        else:
                            self.load_image(str(typeof['rightroles'][0]))
                        """

#############################################################FOR INSTANCE OF #################################################################
            
                elif i == 'instanceof':
                    pass
                    """
                    node_name = 'member_of'
                    node_tooltip = 'member_of'
                    node_label = 'member of'
                    node_shape = gnowsys_graph['rt_shape']
                    node_style = gnowsys_graph['rt_style']
                    node_color = gnowsys_graph['rt_color']
                    node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                    dotschema.add_node(node)
                    edge = pydot.Edge(center, 'member_of', color = 'blue')
                    dotschema.add_edge(edge)
                    """
                    memberof = sub_relations['instanceof']
                    #print " memberof is ",memberof
                    
                    if memberof.has_key('leftroles'):
                        """
                        node_name = 'has_member'
                        node_tooltip = 'has members'
                        node_label = 'has members'
                        node_shape = gnowsys_graph['rt_shape']
                        node_style = gnowsys_graph['rt_style']
                        node_color = gnowsys_graph['rt_color']
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                        dotschema.add_node(node)
                        edge = pydot.Edge(center, 'has_member', color = 'blue')
                        dotschema.add_edge(edge)
                        memberof = sub_relations['instanceof']
                        print " memberof is ",memberof
                        
                        print memberof['leftroles']
                        for i in memberof['leftroles']:
                            print i
                            typenid = obj.getnids([i])[i]
                            print " type nid is ",typenid
                            node_name = typenid
                            node_tooltip = typenid
                            node_label = typenid
                            node_url = redirect_url%i
                            node_shape = gnowsys_graph['o_shape']
                            node_style = gnowsys_graph['o_style']
                            node_color = gnowsys_graph['o_color']
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                            dotschema.add_node(node)
                            edge = pydot.Edge( 'has_member',typenid, color = 'blue')
                            dotschema.add_edge(edge)
                            
                            if os.path.exists(self.path+'/nbhimages/'+str(i)+'.svg'):
                                pass
                            else:
                                self.load_image(str(i))
                    
                           
                        """



                    elif memberof.has_key('rightroles'):
                        
                        node_name = 'member_of'
                        node_tooltip = 'member_of'
                        node_label = 'member of'
                        node_shape = gnowsys_graph['rt_shape']
                        node_style = gnowsys_graph['rt_style']
                        node_color = gnowsys_graph['rt_color']
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                        dotschema.add_node(node)
                        edge = pydot.Edge(center, 'member_of', color = 'blue')
                        dotschema.add_edge(edge)
                        memberof = sub_relations['instanceof']
                        

                        for i in memberof['rightroles']:
                            
                            typenid = obj.getnids([i],[])[i]
                            
                            node_name = typenid
                            
                            node_tooltip = typenid
                            node_label = typenid
                            node_url = redirect_url%(i,self.url)
                            node_shape = gnowsys_graph['ot_shape']
                            node_style = gnowsys_graph['ot_style']
                            node_color = gnowsys_graph['ot_color']
                            node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                            dotschema.add_node(node)
                            edge = pydot.Edge( 'member_of',typenid, color = 'blue')
                            dotschema.add_edge(edge)
                else:    
                    
                    relationof = sub_relations[i]
                    if relationof.has_key('rightroles'):
                      
                        node_name = i
                        node_tooltip = i
                        node_label = i
                        node_url = redirect_url%(i,self.url)
                        node_shape = gnowsys_graph['rt_shape']
                        node_style = gnowsys_graph['rt_style']
                        node_color = gnowsys_graph['rt_color']
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                        dotschema.add_node(node)
                        edge = pydot.Edge(center, i, color = 'blue')
                        dotschema.add_edge(edge)
                        for j in relationof['rightroles']:
                            rel_nodetype = obj.getNodetype(str(j))
                           
                            if rel_nodetype == 'gbobjects':
                                typenid = obj.getnids([j],[])[j]
                              
                                node_name = typenid
                              
                                node_tooltip = typenid
                                node_label = typenid
                                node_url = redirect_url%(j,self.url)
                                node_shape = gnowsys_graph['o_shape']
                                node_style = gnowsys_graph['o_style']
                                node_color = gnowsys_graph['o_color']
                                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                                dotschema.add_node(node)
                                edge = pydot.Edge( i, typenid, color = 'blue')
                                dotschema.add_edge(edge)
                               
                            else:
                                typenid = obj.getnids([j],[])[j]
                                
                                node_name = typenid
                                
                                node_tooltip = typenid
                                node_label = typenid
                                node_url = redirect_url%(j,self.url)
                                node_shape = gnowsys_graph['ot_shape']
                                node_style = gnowsys_graph['ot_style']
                                node_color = gnowsys_graph['ot_color']
                                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip, URL=node_url)
                                dotschema.add_node(node)
                                edge = pydot.Edge( i, typenid, color = 'blue')
                                dotschema.add_edge(edge)
                                """
                                if os.path.exists(self.path+'/nbhimages/'+str(j)+'.svg'):
                                    pass
                                else:
                                    self.load_image(str(j))
                                """

                    elif relationof.has_key('leftroles'):
                        
                        reverse_n = obj.getInverseName(i)
                        if reverse_n == '':
                            reverse_name = 'inverse_of_'+str(i)
                        else:
                            reverse_name = reverse_n 
                            
                        node_name = reverse_name
                        node_tooltip = reverse_name                           
                        node_label = reverse_name
                            
                        node_shape = gnowsys_graph['rt_shape']
                        node_style = gnowsys_graph['rt_style']
                        node_color = gnowsys_graph['rt_color']
                        node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip)
                        dotschema.add_node(node)
                        edge = pydot.Edge( center,reverse_name, color = 'blue')
                        dotschema.add_edge(edge)
                        for j in relationof['leftroles']:
                           
                            rel_nodetype = obj.getNodetype(str(j))
                          
                            if rel_nodetype == 'gbobjects':
                                typenid = obj.getnids([j],[])[j]
                                
                                node_name = typenid
                                
                                node_tooltip = typenid
                                node_label = typenid
                                node_url = redirect_url%(j,self.url)
                                node_shape = gnowsys_graph['o_shape']
                                node_style = gnowsys_graph['o_style']
                                node_color = gnowsys_graph['o_color']
                                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip,URL = node_url)
                                dotschema.add_node(node)
                                edge = pydot.Edge( reverse_name, typenid, color = 'blue')
                                dotschema.add_edge(edge)
                                
                            else:
                                
                                typenid = obj.getnids([j],[])[j]
                                print " type nid is ",typenid
                                node_name = typenid
                                print " node name is ",node_name
                                node_tooltip = typenid
                                node_label = typenid
                                node_url = redirect_url%j
                                node_shape = gnowsys_graph['ot_shape']
                                node_style = gnowsys_graph['ot_style']
                                node_color = gnowsys_graph['ot_color']
                                node = pydot.Node(node_name, label=node_label, shape=node_shape, style=node_style, color=node_color, tooltip=node_tooltip,URL=node_url)
                                dotschema.add_node(node)
                                edge = pydot.Edge( reverse_name, typenid, color = 'blue')
                                dotschema.add_edge(edge)
                                
                
                        
                
                    
                    
                
        
        else:
            pass
                
        #dot_path = self.path + '/nbhimages/' + str(lstssid[0])+'.xdot'
        #name_xdot=str(lstssid[0])+'.xdot'
        print 'dot_path is ',dot_path
        dotschema.write_xdot(dot_path, prog='dot')
        #os.system('dot '+dot_path+' -Tsvg -o '+img_path)
        dotschema.write_svg(img_path, prog='dot')
        #dotschema.write_svg('/tmp/54.svg', prog='dot')
        #os.system('dot'+ str(self.change_dict['ssid'])+'.xdot')
        #dotschema.write_xdot('writer.xdot', prog='circo')
        #dotschema.write_png(img_path, prog='dot')
        #dotschema.write_xdot('writer.xdot', prog='circo')
        return  'done'

    #def load_image(self,id):
        #obj = GetMethods( self.constring )
        #self.genGraph( [id] )
        #return true
if __name__=="__main__":
    g=GenGraph('dbname=experimental  user=rajiv  password=rajiv  host=localhost  port=5432','/tmp','http://localhost:8080/gnowsys')
    #g.depGraph('35')
    print g.genGraph(['54'])
    #g.genGraph(['2646519'])
