# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################


__author__ = """Rajiv Nair <rajivnair@gnu.org>"""
__author__ = """Jay Mehta <jay87.mehta@gmail.com>"""
__docformat__ = 'plaintext'



from GeneralMethods import *
from Object import *
import psycopg2
import cPickle
from base64 import b64encode, b64decode




def setAttributeType(self , dictionary , uid):
                """

                ATTRIBUTETYPES :

                Possible values for applicablenodetypes:
                1) types
                2) tokens
                3) metatypes

                EXAMPLE 1 :

 
                 
                dictParameters = 
                {
                'nid':'Languages', [mandatory field]
                'uid':'1',  [mandatory field]
                'status':status,
                'subtypeof':['23','54'], (list of ssids of attributetypes)
                'subjecttypes':['courses'],  (list of nids of types)    [mandatory field]
                'restrictiontype':0,     (0 indicates selectionlist) [mandatory field]
                'selectiontype':0,       (true:singleselection false:multipleselection) [mandatory field]
                'listid':'3',            (the id of the list that is already present in the gnowledge base) [mandatory field]
                'mandatoryprops':['subject','attributetype','value']
                }
                setnode( dictParameters )

                                
                 -- restrictiontype : 0
                 -- selectiontype : 0 or 1 (0 indicates singleselection  and 1 is multipleselection)
                 -- datatype : to be selected from the list of datatypes given (only single value selection allowed)
                 -- listid : ssid of the selection list


                 (OR)


                EXAMPLE 2 :

                 dictParameters = 
                 {
                'nid':'floatnum', [mandatory field]
                'uid':'1',  [mandatory field]
                'status':status,
                'subtypeof':['23','54'], (list of ssids of attributetypes)
                'subjecttypes':['Courses'],  (list of nids of types)    [mandatory field] 
                'restrictiontype':1,     (1 indicates valuerestriction) [mandatory field]
                'datatype':float8[],     (selected from a list of datatypes) [mandatory field]
                'regex':'\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\',  (a regular expression)
                'length':5,
                'range':'0-5',
                'precision':2 
                 }
                 setnode( dictParameters )


                 (OR)

                 dictParameters = 
                 {
                'nid':'floatnum', [mandatory field]
                'uid':'1',  [mandatory field]
                'status':status,
                'subtypeof':['23','54'], (list of ssids of attributetypes)
                'subjecttypes':['Courses'],  (list of nids of types)    [mandatory field] 
                'restrictiontype':1,     (1 indicates valuerestriction) [mandatory field]
                'datatype':float8[],     (selected from a list of datatypes) [mandatory field]
                'regexid':'23',          (the id of the regularexpression already present in the database)
                'length':5,
                'range':'0-5',
                'precision':2 
                 }
                 setnode( dictParameters )
                 


                 -- restrictiontype : 1
                 -- datatype : to be selected from the list of datatypes given (only single value selection allowed)
                 -- regularexpression : regular expression for the attributetype
                 -- length : length of the value
                 -- range : the range of the value
                 -- precision : precision of the value


                 CHECKS :
                 
                 1) nid, uid, subjecttypes, restrictiontype, datatype, listofvalues are mandatory if restrictiontype is 0.
                 2) nid, uid, subjecttypes, restrictiontype, datatype are mandatory if restrictiontype is 1.
                 3) Check the existence of nid,uid in the gnowledge base.
                 4) Check if the subjecttypes given are valid ie if the subjecttypes exist in the gnowledge base.
                 5) Check if the subjecttypes provided are types.
                 5) if subtypeof is provided then check if that list of values  exists in the database and also check if their nodetype is  attributetypes
                 

                 STEPS : 
                 
                 1)restrictiontype = 0
                 1.1. Create an object and add the listofvalues as its structure 
                 1.2. Make it an instance of objecttype gblist ie create a relation of the object with the objecttype (gblist)
                 1.3. insert the values of selectiontype , datatype and listid into the gbselectionlist table .
                      -- listid is the ssid of the object that was created and it stores the listofvalues
                 1.4. get the selid that was generated from the gbselectionlist table , it is the restrictionref
                 1.5. generate the ssid for the new attributetype and update the version fields , set the restrictiontype to 0 and the restrictionref to the value of selid recently generated.


                 2)restrictiontype = 1
                 2.1. if some regular expression has been provided add the expression in the gbregularexpressions table , generate a regexid.
                 2.2. if some regular expression has not been provided then consider the regexid to be 0
                 2.3. enter the regexid in the gbvaluerestrictions table and also enter the values length, range and precision if provided and finally generate a restrictionid 
                 2.3. generate the ssid for the new attributetype and update the version fields , set the restrictiontype to 1 and the restrictionref to the value of restrictionid recently generated. 
                 
                       
                 
                 """
                
                # IMPLEMENTING CHECK 1 AND 2

                try:
                    restrictiontype = dictionary['restrictiontype']
                except:
                    return 'RESTRICTIONTYPE IS MANDATORY'

                
                mandatory_fields_1 = ['nid','subjecttypes','applicablenodetypes']
                mandatory_fields_0 = ['nid','subjecttypes','listid','applicablenodetypes']
                

                
                supplied_fields = dictionary.keys()
                
                message = ''
                if restrictiontype == 0:
                    for field in mandatory_fields_0:
                        if  field not in supplied_fields  :
                            message = field + ' IS MANDATORY [MANDATORYFIELDS : nid,subjecttypes,listid,applicablenodetypes] '
                            return message

                if restrictiontype == 1:
                    for field in mandatory_fields_1:
                        if  field not in supplied_fields  :
                            message = field + ' IS MANDATORY [MANDATORYFIELDS : nid,subjecttypes,applicablenodetypes] '
                            return message


                       
                nid = dictionary['nid'] 

                try:
                        decision = dictionary['decision']
                except:
                        decision = 0

                nidexists = 0  
                if (id_exists('nid',nid,'gbnidssid',self.curs) == 1) :
                        if  (decision == 1):
                              nidexists = 1
                        elif (decision == 0):
                              return 'An attributetype with the same nid already exists. Please give a different nid'
                else:      
                        nidexists = 0
                  

                
                subjecttypes = dictionary['subjecttypes']

                
                if subjecttypes <> []:
                        subjecttypes = get_inid_from_nid( subjecttypes ,self.curs)
                else:
                        return 'SUBJECTTYPES LIST IS BLANK'


                dictionary.update({'subjecttypes':subjecttypes})

                
                #IMPLEMENTING CHECK 3
                    
                if nidexists == 0:
                    if ('datatype' not in supplied_fields) and ( restrictiontype == 1 ):
                        return 'DATATYPE IS MANDATORY'

                
                if 'status' not in supplied_fields:
                    status = 'Public'
                else: 
                    status = dictionary['status']

                
                noofchanges=2
                fieldschanged="{status,subjecttypes}"
                changetype="{1,1}"
                noofcommits=0
                noofchangesaftercommit=0
                history="{0}"
                rendered_nbh={}
                nbh={}

                new_subject1_ssid = 0

                flag_inherit = 0
                inherit_s2_list=[]

                if nidexists == 0:
                        new_subject1_ssid = get_next_sequence_value('ssid_seq',self.curs)#new ssid of the relationtype
                else:
                        query = "SELECT inid from gbattributetypes where nid = '%s';" %(nid)
                        execute_query( query , self.curs )
                        new_subject1_ssid = str(query_fetchall( self.curs )[0][0])

                new_subject1_ssid_list = [ new_subject1_ssid ]


                supertypeof_inid_list = []
                classof_inid_list = []

                    
                #IMPLEMENTATION CHECK 4    
                
                subjecttypes = dictionary['subjecttypes']

                subjecttypes_string = list2string( subjecttypes )

                sqlquery = "select ssid,nodetype from %s where ssid in %s;" %( 'gbnidssid' , subjecttypes_string )
                execute_query( sqlquery , self.curs )
                fetched_value = query_fetchall( self.curs )
                if fetched_value != None :
                    if len( fetched_value ) != len( subjecttypes ):
                        return ' PLEASE ENTER VALID SUBJECTTYPES , SOME OF THE SUBJECTTYPES YOU PROVIDED DONT SEEM TO EXIST IN THE GNOWLEDGE BASE'
                else:
                    return ' PLEASE ENTER VALID SUBJECTTYPES , THE SUBJECTTYPES YOU PROVIDED DONT SEEM TO EXIST IN THE GNOWLEDGE BASE '
                  

                # IMPLEMENTING CHECK 5
                  
                for inid_nodetype in fetched_value : 
                    if not istype(inid_nodetype[1]) : 
                        return ' IT IS MANDATORY FOR THE SUBJECTTYPES PROVIDED TO BE TYPES AND NOT TOKENS '

                
                inid_nodetype_dict = {}
                for inid_nodetype in fetched_value : 
                        inid_nodetype_dict[ str(inid_nodetype[0]) ] =  inid_nodetype[1]


                restrictiontype = dictionary['restrictiontype']
                try:
                    datatype = dictionary['datatype']
                except:
                    pass

                restrictionref = 0
                
                # IMPLEMENTING STEP 1
                if (restrictiontype == 0) and (nidexists == 0):

                    gblist_instance_ssid = 0
                    pickleddata = ''
                    
                    if 'listid' in supplied_fields : 
                        gblist_instance_ssid = dictionary[ 'listid' ]

                    sql="select value from datatypes_varchar where attribute_ssid=( select ssid from gbattributes where subjectid='%s');"%( gblist_instance_ssid )
                    execute_query(sql,self.curs)
		
                    datatype = query_fetchall(self.curs)[0][0]

                
                    # IMPLEMENTING STEP 1.3 
                
                    selectiontype = 0
                    if 'selectiontype' not in supplied_fields : 
                        selectiontype = 0
                    else:
                        selectiontype = dictionary['selectiontype']


                    #insert_gbselectionlist_query = "("+str(selectiontype)+",'"+datatype+"',"+str(gblist_instance_ssid)+")" 
                    insert_gbselectionlist_query = "("+str(get_next_sequence_value('gbselectionlist_selid_seq',self.curs))+","+str(selectiontype)+",'"+datatype+"',"+str(gblist_instance_ssid)+")"   
                    
                    execute_query( "insert into gbselectionlist (selid,selectiontype,datatype,listid) values %s" %( insert_gbselectionlist_query ) , self.curs)
                    restrictionref = get_current_sequence_value('gbselectionlist_selid_seq',self.curs)

                
                # IMPLEMENTING STEP 2
                if (restrictiontype == 1) and (nidexists == 0):
                    regexid = 0

                    if ('regexid' not in supplied_fields ) and ( 'regex' not in supplied_fields ):
                        #return 'regexid or regex is mandatory'
                        regexid = 0

                    if 'regexid' in supplied_fields : 
                        regexid = dictionary['regexid']
                    
                    
                    if 'regex' in supplied_fields : 
                        # IMPLEMENTING STEP 2.1 and 2.2 
                        regex = dictionary['regex']
                        insert_regex_query = "("+str(get_next_sequence_value('gbregularexpressions_regexid_seq',self.curs))+","+"'"+regex+"')"
                        execute_query( "insert into gbregularexpressions(regexid,expression) values %s" %( insert_regex_query ) , self.curs)
                        regexid = get_current_sequence_value('gbregularexpressions_regexid_seq',self.curs)
                    

                    # IMPLEMENTING STEP 2.3
                    query_parameters = "(restrictionid,datatype,regexid,"
                    value_parameters = "("+str(get_next_sequence_value('gbvaluerestrictions_restrictionid_seq',self.curs))+",'"+datatype+"',"+str(regexid)+","

                    if 'length' in supplied_fields : 
                        query_parameters = query_parameters + "length,"
                        length = dictionary['length']
                        value_parameters = value_parameters + str(length) + ","
                    if 'range' in supplied_fields : 
                        query_parameters = query_parameters + "range,"
                        Range = dictionary['range']
                        value_parameters = value_parameters + "'"+Range+"'" + ","
                    if 'precision' in supplied_fields : 
                        query_parameters = query_parameters + "precision,"
                        precision = dictionary['precision']
                        value_parameters = value_parameters + str(precision) + ","

                    query_parameters = query_parameters[:-1] + ")"
                    value_parameters = value_parameters[:-1] + ")"


                    insert_gbvaluerestrictions_query = execute_query( "insert into gbvaluerestrictions %s values %s ;" %(query_parameters,value_parameters) , self.curs)

                    restrictionref = get_current_sequence_value('gbvaluerestrictions_restrictionid_seq',self.curs)
                    
                


                input = dictionary




                if input.has_key('subtypeof'):
                    subtypeof=input['subtypeof']#subtypeof=['23','43','63']
                    if ssid_exists(subtypeof,"gbattributetypes" ,self.curs)==0:
                        return "invalid subtypeof ssids"
                    else:
                        subtypeof_relnobj=relations( self.constring ,uid )
                        relninput={'uid':uid,'status':input['status'],'relationtypes':'subtypeof','subject1':new_subject1_ssid_list,'subject2':input['subtypeof'],'nodetype1_list':['gbattributetypes']}  
                        supertypeof_inid_list = get_inid_from_ssid(relninput['subject2'],self.curs)                   
                        dic_from_Reln=subtypeof_relnobj.startchecks_n_callwrite(relninput,"3",new_subject1_ssid_list,relninput['subject2'],supertypeof_inid_list,0,0,0)
                        if dic_from_Reln==-1:
                            return -1

                        flag_inherit = 1
                        inherit_s2_list = inherit_s2_list + input['subtypeof']

                        subtypeof_relnssid_list=[]
                        subtypeof_relnssid_list=dic_from_Reln['subj1ssid_relnssidlist_dic'].values()[0]#all subtypeof relnssids.
                        if subtypeof_relnssid_list==-1:
                            return  "Problem occured while creating subtypeof relations."
                        else:
                            noofchanges=noofchanges+1
                            fieldschanged=fieldschanged.rstrip("}")+",subtypeof}"
                            changetype=changetype.rstrip("}")+",1}"
                            nbh['relations']=subtypeof_relnssid_list
                            rendered_nbh['relations']={}
                            rendered_nbh['relations']['subtypeof']={}
                            rendered_nbh['relations']['subtypeof']['rightroles']=relninput['subject2']
                                  
                if input.has_key('instanceof'):
                    instanceof=input['instanceof']#      'instanceof':['245','45','26'],
                    if ssid_exists(instanceof,"gbmetatypes" ,self.curs)==0:
                        print "invalid instanceof ssids"
                        return -1
                    else:
                        instanceof_relnobj=relations( self.constring , uid )
                        relninput={'uid':uid,'status':input['status'],'relationtypes':'instanceof','subject1':new_subject1_ssid_list,'subject2':input['instanceof'],'nodetype1_list':['gbattributetypes']}
                        classof_inid_list = get_inid_from_ssid(relninput['subject2'],self.curs)                       
                        dic_from_Reln=instanceof_relnobj.startchecks_n_callwrite(relninput,"2",new_subject1_ssid_list,relninput['subject2'],classof_inid_list,0,0,0)
                        if dic_from_Reln==-1:
                           return -1

                        flag_inherit = 1
                        inherit_s2_list = inherit_s2_list + input['instanceof']

                        instanceof_relnssid_list=dic_from_Reln['subj1ssid_relnssidlist_dic'].values()[0]# =all instanceof reln ssids

                        if instanceof_relnssid_list==-1:
                            return  "Problem occured while creating instanceof relations." 
                        else:
                            noofchanges=noofchanges+1
                            fieldschanged=fieldschanged.rstrip("}")+",instanceof}"
                            changetype=changetype.rstrip("}")+",1}"
                            if rendered_nbh.has_key('relations'):
                                pass
                            else:
                                nbh['relations']=[]
                                rendered_nbh['relations']={}
                            rendered_nbh['relations']['instanceof']={}
                            rendered_nbh['relations']['instanceof']['rightroles']=relninput['subject2']
                            for reln_ssid in instanceof_relnssid_list:
                                    nbh['relations'].append(reln_ssid)
                                    
                if input.has_key('attributes'):

                        gbattr_input={'nid':input['nid'],'uid':uid,'status':status,'instanceof':input['attributes'],'subject':new_subject1_ssid,'subject_inid':new_subject1_ssid,'language':input['language'],'nodetype':'gbattributetypes'}

                        attrobj=attribute( self.constring , uid)

                        new_attr_ssid_list=[]
                        for no_of_attrs in range(len(input['attributes'])):
                              new_attr_ssid_list.append(get_next_sequence_value('ssid_seq',attrobj.curs))

                        attrtype_nid_attrvalue_list = attrobj.create_newattr(gbattr_input,new_subject1_ssid_list[0],classof_inid_list,supertypeof_inid_list,1,0)
                        if attrtype_nid_attrvalue_list==-1:
                              return " Problem occured while creating attribute for this object."
                        else:
                              attrtype_nid_list =attrtype_nid_attrvalue_list [0]
                              attrvalue_list=attrtype_nid_attrvalue_list[1]
                              fieldschanged=fieldschanged.rstrip("}")
                              changetype=changetype.rstrip("}")
                              for attrtypenids in attrtype_nid_list:
                                    noofchanges=noofchanges+1
                                    fieldschanged=fieldschanged+","+attrtypenids
                                    changetype=changetype+ ",1"
                              fieldschanged=fieldschanged+"}"                           
                              changetype=changetype+ "}"
                              nbh['attribute']=new_attr_ssid_list
                              rendered_nbh['attributes']={}
                              for no_of_attr in range(len(attrtype_nid_list)):
                                  rendered_nbh['attributes'] [attrtype_nid_list[no_of_attr]] = (new_attr_ssid_list[no_of_attr],attrvalue_list[no_of_attr]) 

                
                if nidexists == 0:
                        rendered_nbh['subjecttypes'] =  subjecttypes
                else:
                        getall_query = "SELECT rendered_nbh from %s where ssid = %s" %('gbattributetypes' , new_subject1_ssid)
                        self.curs.execute( getall_query )
                        values  = self.curs.fetchall()[0]
                        rendered_nbh = cPickle.loads(  b64decode( values[0] ) )

                        try:
                            rendered_nbh['subjecttypes'] = rendered_nbh['subjecttypes'] + subjecttypes
                        except:
                            rendered_nbh['subjecttypes'] = subjecttypes
                        
                        update_query = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %('gbattributetypes' , b64encode( cPickle.dumps(rendered_nbh) )  , new_subject1_ssid )
                        self.curs.execute( update_query )

                # IMPLEMENTING STEPS 1.5 AND 2.3
                
                if nidexists == 0:
                    #  inheritance logic ---start  
                    if flag_inherit == 1:
                        from Inherit import *
                        inherit_obj = Inherit(self.constring,self.uid)
                        inherit_rendernbh_dic = inherit_obj.inherit( new_subject1_ssid_list ,new_subject1_ssid_list,'gbattributetypes', inherit_s2_list)
                        rendered_nbh['attributetypes'] = inherit_rendernbh_dic['attributetypes']
                        rendered_nbh['relationtypes'] = inherit_rendernbh_dic['relationtypes']
                    #end----

                    insert_attributetypes_query = "insert into gbattributetypes values (%s,'%s',%s,%s,'%s','%s','%s','%s','%s','%s','%s',now(),%s,%s,'%s','%s') " %( str(new_subject1_ssid ),nid,str( new_subject1_ssid ),uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,str(restrictiontype),str(restrictionref),b64encode( cPickle.dumps(rendered_nbh) ),b64encode( cPickle.dumps(nbh) ) )
                
                    execute_query( insert_attributetypes_query , self.curs)

                
                    attributetype_ssid = new_subject1_ssid
                    value_nid_vec="to_tsvector('"+str(nid)+"'::text)"
                    insert_gbnidssid_query = "insert into gbnidssid values ("+str(attributetype_ssid)+",'"+str(nid)+"',"+str(attributetype_ssid)+","+"'gbattributetypes',"+value_nid_vec+");"
                    insert_gbnidlatestssid = "insert into gbnid_latestssid values ("+str(attributetype_ssid)+",'"+nid+"');"

                
                    query = insert_gbnidssid_query + insert_gbnidlatestssid
                    execute_query( query , self.curs )            
                else:
                    query = "UPDATE gbattributetypes set nbh='%s' where ssid=%s"%(b64encode( cPickle.dumps(rendered_nbh) ),new_subject1_ssid)
                    execute_query( query , self.curs )            
                
                
                
                attributetype_ssid = new_subject1_ssid


                applicablenodetypes = dictionary['applicablenodetypes']
                

                
                insert_gbcatalogst_query = "insert into gbcatalogsubjecttypes (attributetypeid,subjecttypeid,applicablenodetypes) values "
                query_string = ""
                for subjecttype in subjecttypes :
                    query_string = query_string + "("+str(attributetype_ssid)+","+str(subjecttype)+ ",'" + applicablenodetypes +"'),"
                query_string = query_string[:-1]
                query_string = insert_gbcatalogst_query + query_string
                execute_query( query_string , self.curs )
                

                updateSubjectTypes ( self, inid_nodetype_dict , ['attributetypes'] , new_subject1_ssid  , uid , self.curs)
                
                commitclose( self.curs , self.conn )
                try:
                    commitclose(subtypeof_relnobj.curs,subtypeof_relnobj.conn)
                except:
                    #print "no subtypeof given as input "
                    pass
                try:
                    commitclose(instanceof_relnobj.curs,instanceof_relnobj.conn)
                except:
                    pass
                    #print "no instanceof given as input"
                
                try:
                    commitclose( inherit_obj.curs, inherit_obj.conn)
                except:
                    #print "no inherit for objecttype"                                                                                                   
                    pass
                return new_subject1_ssid


def setlist( dictionary , constring , uid):
    """
    Sets the selection list in the gnowledge base
    Structure of the dictionary :
    dictionary = {
                 'nid':'languages',
                 'status':'public',
                 'datatype':'varchar[]',
                 'structure':['english','hindi','marathi'],
                 'language':'english'
                 }
    """

    # Converting the input dictionary as required by the database.

    input = {}
    input['nid'] = dictionary['nid']
    input['nodetype'] = 'object'
    input['uid'] = uid
    input['status'] = dictionary['status']
    input['instanceof'] = ['4']
    input['attributes'] = [('listdatatype', dictionary['datatype'])]
    input['structure'] = dictionary['structure']
    input['language'] = dictionary['language']
    
    obj_ins = Objects( constring , uid)
    return obj_ins.create_object( input )
    return 'Selection List Added'
    
    
def setregex(dictionary , constring ):
    """
    """
    conn = psycopg2.connect( constring )
    curs = conn.cursor()

    description = dictionary['description']
    regex = dictionary['regex']

    insert_regex_query = "insert into gbregularexpressions values (%s,'%s','%s');" %( str(get_next_sequence_value('gbregularexpressions_regexid_seq',curs) ) , regex , description )
    curs.execute( insert_regex_query )

    conn.commit()
    curs.close()
    conn.close()
    return 'regularexpression added'




def updateSubjectTypes ( self , args , fieldschanged , attributetypeid , uid , curs):
      """
      The arguments are of the form:
      {'11':'gbobjecttypes','12':'gbobjecttypes}
      """

      for stid in args.keys():
           schema = get_schema( args[stid] )
           #newssid = get_next_sequence_value('ssid_seq',curs)
           snapshots_dict = {}
           getall_query = "SELECT rendered_nbh from %s where ssid = %s" %( args[stid] , stid)
           curs.execute( getall_query )
           values  = curs.fetchall()[0]
           rendered_nbh = values[0]
           
           rendernbh = {}
           if rendered_nbh != None:
               rendernbh = cPickle.loads(  b64decode( rendered_nbh ) )
               if rendernbh.has_key( fieldschanged[0] ):
                   if str(attributetypeid) not in rendernbh[fieldschanged[0]]:
                       rendernbh[fieldschanged[0]].append( str(attributetypeid) )
               else:
                  rendernbh[fieldschanged[0]] = [str(attributetypeid)]
           else:
               rendernbh[fieldschanged[0]] = [str(attributetypeid)]

           
           snapshots_dict['rendered_nbh'] =  b64encode( cPickle.dumps(rendernbh) )
           
           
           update_query = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %( args[stid] , snapshots_dict['rendered_nbh']  ,stid )
           curs.execute( update_query )

           
           
           

# def updateSubjectTypes ( self , args , fieldschanged , attributetypeid , uid , curs):
#       """
#       The arguments are of the form:
#       {'11':'gbobjecttypes','12':'gbobjecttypes}
#       """

#       for stid in args.keys():
#            schema = get_schema( args[stid] )
#            newssid = get_next_sequence_value('ssid_seq',curs)
#            snapshots_dict = {}
#            getall_query = "SELECT * from %s where ssid = %s" %( args[stid] , stid)
#            curs.execute( getall_query )
#            values  = curs.fetchall()[0]
#            snapshots_dict['nid'] = values[1]
#            snapshots_dict['inid'] = values[2]
#            snapshots_dict['uid'] = uid
#            snapshots_dict['status'] = 'public'
#            snapshots_dict['noofchanges'] = len( fieldschanged )

#            fields = values[6] + fieldschanged
#            a = "{"
#            for elem in fields:
#                  a = a + elem + ","
#            a=a.rstrip(",")+"}" 
#            snapshots_dict['fieldschanged'] = a

#            changetype = values[7] + [1L]
#            a = "{"
#            for elem in changetype:
#                  a = a + str(elem) + ","
#            a=a.rstrip(",")+"}" 
           
#            snapshots_dict['changetype'] = a

#            snapshots_dict['noofcommits'] =  values[8] + 1
#            snapshots_dict['noofchangesaftercommit'] =  values[9]

#            history = values[10] + [ long( newssid ) ]
#            a = "{"
#            for elem in history:
#                  a = a + str(elem) + ","
#            a=a.rstrip(",")+"}" 
           
#            snapshots_dict['history'] = a

#            rendernbh = cPickle.loads(  b64decode( values[schema.index('rendered_nbh')] ) )
#            if rendernbh.has_key( fieldschanged[0] ):
#                  rendernbh[fieldschanged[0]].append( str(attributetypeid) )
#            else:
#                  rendernbh[fieldschanged[0]] = [str(attributetypeid)]
                 
#            snapshots_dict['rendered_nbh'] =  b64encode( cPickle.dumps(rendernbh) )
           
#            snapshots_dict['nbh'] = values[schema.index('nbh')]

#            insert_query = "INSERT INTO %s (ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,gbtimestamp) values(%s,'%s',%s,'%s','%s',%s,'%s','%s',%s,%s,'%s',now());"%(args[stid], newssid , snapshots_dict['nid'],snapshots_dict['inid'] ,snapshots_dict['uid'],snapshots_dict['status'],snapshots_dict['noofchanges'],snapshots_dict['fieldschanged'],snapshots_dict['changetype'],snapshots_dict['noofcommits'],snapshots_dict['noofchangesaftercommit'],snapshots_dict['history'])
           
#            update_query1 = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %( args[stid] , snapshots_dict['rendered_nbh']  ,newssid )
#            curs.execute( insert_query + update_query1 )

#            try:
#                  update_query2 = "UPDATE %s set nbh='%s'  where ssid = %s;" %( args[stid] , snapshots_dict['nbh'] , newssid )
#                  curs.execute( update_query2  )
#            except:
#                  pass
           
#            bind_nidssid(newssid,snapshots_dict['nid'],snapshots_dict['inid'],args[stid],curs)
#            reset_ssid_2_latestssid(newssid,snapshots_dict['nid'],curs)


