# -*- coding: utf-8 -*- 

#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__author__ = """Jay Mehta <jay87.mehta@gmail.com>"""
__docformat__ = 'plaintext'
  


from GeneralMethods import *
from GetMethods import *
import md5
import cPickle
import  psycopg2
from base64 import b64encode, b64decode

class attribute:

  def __init__(self , constring ,uid):
          self.constring=constring
          self.conn = psycopg2.connect( constring )   
          self.curs = self.conn.cursor() 
          self.uid = uid
          self.supertypeof = []
          self.classof = []
          #self.conn = connobj
          #self.curs = cursobj

  def write_in_gbattributes(self,uid,status,subject_inid,new_attr_ssid_list,attrtype_nid_list,typename_list,attrtype_inid_list, rendernbh_list,nbh_list,subjectid):
      #rendernbh_list = list of new_attrtype_ssid= new_attrtype_ssidinid_list in case of creating new snapshot of the attribute type.
      #rendernbh_list = list of latest_attrtype_ssid in case of NOT creating new snapshot of the attribute type.
      #nbhlist= list of reln_ssid. each reln_ssid corresponds to new_attr_ssid from new_attr_ssid_list
      #subjectid is new ssid of the subject to which the attribute is about to get attached
      noofchanges=1
      fieldschanged='{status}'
      changetype='{1}'
      noofcommits=0
      noofchangesaftercommit=0
      history='{0}'

      rendernbh={}
      rendernbh['relations']={}
      rendernbh['relations']['instanceof']={}
      nbh={}
      partsql="("
      ##print 'type_name_list' ,typename_list
      ##print 'attributetypenidlist' , attrtype_nid_list
      for typeno in range(len(typename_list)):
          nid=str(subject_inid)+"_"+attrtype_nid_list[typeno]+"_"+str(new_attr_ssid_list[typeno])

          bind_nidssid(new_attr_ssid_list[typeno],nid,new_attr_ssid_list[typeno],"gbattributes",self.curs)#for new attr_ssid.     
          bind_nidlatestssid(new_attr_ssid_list[typeno],nid,self.curs)#for new attr_ssid
          
          #dynamically creating rendernbh and nbh for each attr_ssid
          
          rendernbh['relations']['instanceof']['rightroles']=[ rendernbh_list[typeno] ]
          nbh['relations']=nbh_list[typeno]
          ##print "rendernbh",rendernbh
          ##print "nbh",nbh
          
          partsql=partsql+str(new_attr_ssid_list[typeno])+",'" +str(nid)+"','"+str(new_attr_ssid_list[typeno])+"',"+str(uid)+",'"+status+"',"+str(noofchanges)+",'"+str(fieldschanged)+"','"+str(changetype)+"',0,0,'{0}',now(),"+str(attrtype_inid_list[typeno])+","+str( subjectid )+",'"+typename_list[typeno]+"','"+ b64encode( cPickle.dumps(rendernbh)) +"','"+   b64encode( cPickle.dumps(nbh) ) +"')"+",("
      partsql=partsql.rstrip(",(")
      ##print "partsql",partsql

      sql="INSERT INTO gbattributes values %s;"%partsql
      #print "**************************",sql
      execute_query(sql,self.curs)


  def derive_datatype(self,restrictionlist): #restrictionlist=[(restrictiontype1,restrctionref1),(restrictiontype2,restrctionref2), ...]
         #multiple selection needs to be done
         typename_list=[]
        
         for rl in range(len(restrictionlist)):
             if restrictionlist[rl][0]==0:
                sql="SELECT datatype FROM gbselectionlist WHERE selid=%s"%restrictionlist[rl][1]
             else:
               sql="SELECT datatype FROM gbvaluerestrictions WHERE restrictionid=%s;"%restrictionlist[rl][1]
             #print sql
             execute_query(sql,self.curs)
             typename=query_fetchall(self.curs)
             #print typename
             typename_list.append(typename[0][0])#for gbattributes table
         return typename_list

  def startchecks(self,uid,subject_ssid):
      if id_exists("inid",uid,"gbusers",self.curs)==1:#uid exists
          ##print "uid accepted"
          nodetype_list=get_nodetype_from_gbnidssid([subject_ssid],"ssid",self.curs)
          if nodetype_list==[]:
             #print "subject_ssid not found"
             return -1
          else:
             ##print "ssid exists"
             return nodetype_list

  def group_subjecttypeid_applnodetype_list(self,subjecttypeid_applnodetype_list):
      subjecttypeid_applnodetype_list.sort(lambda x,y:cmp(x[2],y[2]))#this will sort as per attrtypeid.
      ##print"after sorting ====", subjecttypeid_applnodetype_list
      final_list=[]
      temp_list=[]
      previousValue=subjecttypeid_applnodetype_list[0][2]
      for tuple in subjecttypeid_applnodetype_list:#this loop creates a list of lists, each for one attrtype, having subjecttypeid and applicablenodetypes only
          if tuple[2]!=previousValue:
             previousValue=tuple[2]
             final_list.append(temp_list)
             temp_list=[]
          temp_list.append( ( str(tuple[0]) ,tuple[1] ) )
      final_list.append(temp_list)
      ##print "final_list========",final_list
      return final_list
      

  def get_subject2_from_gbrelations(self,subject_inid,relationtype_id):
      #relationtype_id=2 for instanceof and =3 for subtypeof
      sql="SELECT subject2 FROM gbrelations WHERE subject1 =%s AND relationtype=%s;"%(subject_inid,relationtype_id)
      #print sql
      execute_query(sql,self.curs)
      subject2_list=query_fetchall(self.curs)#[(valueL,),(),(), ....]
      ##print "subj2_list===========",subject2_list
      #preprocessing  subject2_list as per req.
      final_list=[]
      for tuple in subject2_list:
        final_list.append(str (tuple[0] ))
      return final_list

  def get_supertypeof_n_instanceof(self,nodetype,subject_ssid):
      sql="SELECT rendered_nbh FROM %s WHERE ssid=%s;"%(nodetype,subject_ssid )
      execute_query(sql,self.curs)
      dic=query_fetchall(self.curs)[0][0]
      global supertypeof
      global classof
      if dic.has_key('relations'):
         if dic['relations'].has_key('subtypeof'):
            if dic['relations']['subtypeof'].has_key('rightroles'):
               supertypeof = dic['relations']['subtypeof']['rightroles']

         if dic['relations'].has_key('instanceof'):
            if dic['relations']['instanceof'].has_key('rightroles'):
               classof = dic['relations']['instanceof']['rightroles']
               

  #nodetype is tablename
  #subject_classof_list==0 when this file is run. ==[inid1,inid2,...]when file like User.py,UserType.py and ==[]for UserType.py when Usertype has no father 
  #subject_supertypeof_list==0 when this file is run. ==[inid1,inid2,...]when file like UserType.py and ==[]for User.py,UserType.py 
  def can_subject_have_attr(self,subject_ssid,attrtype_ssid_list,nodetype,subject_classof_list=0,subject_supertypeof_list=0):#
      #here subject_ssid=subject_ssid
      sql="SELECT subjecttypeid,applicablenodetypes,attributetypeid FROM gbcatalogsubjecttypes WHERE attributetypeid in %s;"%list2string(attrtype_ssid_list)
      #print sql
      execute_query(sql,self.curs)
      subjecttype_applnodetypes_attrtypeid_list=query_fetchall(self.curs)
      #print subjecttype_applnodetypes_attrtypeid_list
      #subjecttype_applnodetypes_attrtypeid_list=[ (subjecttypeid11,applnodetype11,attrtypeid1),(subjecttypeid12,applnodetype12,attrtypeid1), (subjecttypeid12,applnodetype12,attrtypeid2), ...]
      ##print "o/p of above query:",subjecttype_applnodetypes_attrtypeid_list

      subjecttypeid_applnodetype_listoflists=self.group_subjecttypeid_applnodetype_list(subjecttype_applnodetypes_attrtypeid_list)
      #print subjecttypeid_applnodetype_listoflists
      #subjecttypeid_applnodetype_listoflists=[ [(stypeid,appnodetype),(),() -->for attrtype1], [for attrtype2--> (),(),(), ...] , ...]

      if istype(nodetype):#passing nodetype of  subject_ssid 
         #print "subject_ssid is a type"
         for subjecttype_applnodetypes_list in subjecttypeid_applnodetype_listoflists:
             #print subjecttype_applnodetypes_list
             flag_attr_can_be_attached=0

             #when an Usertype is created and attribute is being attached to it the following for loop can be avoided.-----This is checked by checking the 
             #type of subject_classof_list. It is always 0 when called while this file runs. Else it is [] or [inid1,inid2 ,... ].
             if not isinstance(subject_classof_list ,list):             
                #check if subject_ssid is in subjecttype_applnodetypes_list ie for a single attributetype.
                for subjectids in subjecttype_applnodetypes_list:
                    #print "-----------------",subjectids
                    if subject_ssid==str(subjectids[0]):
                       if subjectids[1]== None:
                          #print "applnodetype is None and cant attach attriute to given type."
                          return -1
                       if istype(subjectids[1]):# given attrtypeid can be attached to type
                          #given attrtypeid can be attached to this subject_inid. check 4 the next attrtypeid
                          flag_attr_can_be_attached=1
                          break
                       else:
                          #print"subject_ssid is a token. Can't attach attribute to given subject_ssid"
                          return -1

             if flag_attr_can_be_attached==1:
                ##print"This attribte can be attached.Iterating for next attrtype check. "
                pass
             else:
                if subject_supertypeof_list==0: 
                   #supertypeof_subject_ssid_list=self.get_subject2_from_gbrelations(subject_inid,'3')
                   self.get_supertypeof_n_instanceof(nodetype,subject_ssid)
                   supertypeof_subject_ssid_list = self.supertypeof 
                else:#this comes from User, etc files. 
                   supertypeof_subject_ssid_list = subject_supertypeof_list
                if supertypeof_subject_ssid_list == []:#this case comes while adding user frm User.py, etc ., which may have its classof but no supertypeof.
                   ##print " supertypeof_subject_ssid_list is empty. going for instanceof checks ..."
                   pass
                else:   
                   for subjectids in subjecttype_applnodetypes_list:
                       if subjectids[0] in supertypeof_subject_ssid_list:
                          if subjectids[1]== None:
                             #print "applnodetype is None and cant attach attriute to given type."
                             return -1
                          if istype( subjectids[1] ):# given attrtypeid can be attached to type
                             #print "subjectids--- is type",subjectids
                             #given attrtypeid can be attached to this subject_inid. check 4 the next attrtypeid
                             flag_attr_can_be_attached=1
                             break
                          else:
                             #print"subject_ssid is a token. Can't attach attribute to given subject_ssid"
                             return -1

                if flag_attr_can_be_attached==1:
                   ##print"This attribte can be attached.Validation done at subtypeof stage.Iterating for next attrtype check. "
                   pass
                else:
                   if nodetype=='metatypes':#since metatypes dont have classof, avoid classof checkpart.        
                     #print "Cant attach attributes. Atleast for one of the attribute condititons dint satisfied."
                     return -1
                   if subject_classof_list==0: 
                      #classof_subject_ssid_list=self.get_subject2_from_gbrelations(subject_inid,'2')
                      classof_subject_ssid_list = self.classof
                   else:
                      classof_subject_ssid_list = subject_classof_list  
                   for subjectids in subjecttype_applnodetypes_list:
                       if subjectids[0] in classof_subject_ssid_list:
                          if subjectids[1]== None:
                             #print "applnodetype is None and cant attach attriute to given type."
                             return -1
                          if istype( subjectids[1] ):# given attrtypeid can be attached to type
                             #print "subjectids",subjectids
                             #given attrtypeid can be attached to this subject_inid. check 4 the next attrtypeid
                             flag_attr_can_be_attached=1
                             break
                          else:
                             #print"subject_ssid is a token. Can't attach attribute to given subject_ssid"
                             return -1
                   if flag_attr_can_be_attached==1:
                      ##print"This attribte can be attached.Validation done at instanceof stage.Iterating for next attrtype check. "
                      pass
                   else:
                       #print "Atleast One of the attribute cannot be attached. Not attaching any of the inputted attribute."
                       return -1 
      else:        
            #print "#subject_ssid is a token"
            for subjecttype_applnodetypes_list in subjecttypeid_applnodetype_listoflists:
                #print subjecttype_applnodetypes_list
                flag_attr_can_be_attached=0

                if subject_classof_list==0: 
                   #classof_subject_ssid_list=self.get_subject2_from_gbrelations(subject_inid,'2')
                   classof_subject_ssid_list = self.classof
                else:
                  classof_subject_ssid_list = subject_classof_list  

                #print "classof_subject_ssid_list",classof_subject_ssid_list
                for subjectids in subjecttype_applnodetypes_list:
                    if subjectids[0] in classof_subject_ssid_list:
                          #given attrtypeid can be attached to this subject_inid. check 4 the next attrtypeid
                          flag_attr_can_be_attached=1
                          break
                if flag_attr_can_be_attached==1:
                       #print"This attribte can be attached.Validation done at instanceof stage.Iterating for next attrtype check. "
                       pass 
                else:
                       #print "Atleast One of the attribute cannot be attached. Not attaching any of the inputted attribute."
                       return -1 
                  
      #if reached here, conclusion-->All attributes can be attached to given subject_ssid.
      return 1

  def create_newattr(self,input,new_subject_ssid,classof_subject_ssidlist=0,supertypeof_subject_ssidlist=0,dochecks=1,md5done=0):
      #classof_subject_ssidlist is a list of inids of all classoof of the given subject(whose entry is not in database) to whom attribute is about
      #  to get attached. Req for checks
      #it is optional value. It is kept for files like User.py .

      #flag dochecks is kept to avoid attrtype_nid existence checks and can_subj_have_attr() checks as it is already known that while updating attrvalue 
      #  that subject_can_have_attr. Value of flag dochecks==0  only in case of Update of attrvalue that comes from file UpdateMethods.py

      # md5done==1 when create_newattr() invoked from UpdateMethods. where attrvalue of password is to be updated/attached.
      # input has key 'attrtype_nid_list' only from UpdateMethods.py file.

      nochecks_4_attrtype=['11','12','13','15'] #11,12,13 is inid of title,description,content attributetype  which are provided by default.
      
      uid=input['uid']
      subject_ssid=input['subject']
      status=input['status']
      language=input['language']
      nodetype=input['nodetype']
      subject_inid=input['subject_inid']
      
      #attr_ssid_list_4_snapshot is a list of attr_ssid where each ssid corr to attr_ssid subject_attrtype_attrvalue if found in db else create newone 
      attr_ssid_list_4_snapshot = [] 

      original_attrtype_nid_list=[]
      original_attrvalue_list=[]
      #print input
      #check all attributetype_ssid at once
      for attr_no in input['instanceof']:      #input['instanceof']=[('attrtype1_nid','attr1 value'),('attrtype2_nid','attr2 value')]
             original_attrtype_nid_list.append(attr_no[0])
             original_attrvalue_list.append(attr_no[1])
      #print  original_attrtype_nid_list 
             
      #check all attributetype_nid at once,gets its inid
      original_attrtype_inid_latestssid_list = get_attrtype_inid_latest_ssid_from_nid(original_attrtype_nid_list, self.curs)
      #original_attrtype_inid_latestssid_list=[('inid','ssid','nid')]
      if original_attrtype_inid_latestssid_list == 0:
                  #print "invalid attrtype ssid"
                  return -1
      original_attrtype_inid_list=[]
      setdiff_list=[]
      for tuple in original_attrtype_inid_latestssid_list:
          temp_attrtypeInid = str(tuple[0])
          original_attrtype_inid_list.append( temp_attrtypeInid )
          #print original_attrtype_inid_list
          if temp_attrtypeInid not in nochecks_4_attrtype  :#no need to do checks 4 attrtype= content,title, description.
             setdiff_list.append( str(tuple[1]) )

      if dochecks==1:    
            #print "dochecks ==1"
            #print "setdiff_list",setdiff_list
            if setdiff_list!=[]:
               #After validating subject_ssid and attrtype_ssid_list, first check wether all attribute can be attached to the given subject. 
               # now passing subject_ssid instead of subject_inid for checks only. 
               if self.can_subject_have_attr(subject_ssid,setdiff_list,nodetype,classof_subject_ssidlist,supertypeof_subject_ssidlist)==-1:
                  return -1
      
      if input.has_key('new_attr_ssid_list'): #this is invoked from type/tokens file.

         attrtype_inid_list = original_attrtype_inid_list
         attrtype_nid_list  = original_attrtype_nid_list
         new_attr_ssid_list = input['new_attr_ssid_list']

         attrvalue_list = []
         tuple_list_4_md5sum = []
         sinid_ATinid_Avalue = str(subject_inid)

         for md5index in range(len( original_attrtype_inid_list )):
             #print original_attrtype_inid_list[md5index]
             #print original_attrvalue_list[md5index]

             sinid_ATinid_Avalue = sinid_ATinid_Avalue +"_"+str( original_attrtype_inid_list[md5index] )
             if isinstance( original_attrvalue_list[md5index], list ):
                for values in  original_attrvalue_list[md5index] :
                    sinid_ATinid_Avalue = sinid_ATinid_Avalue +"_"+str( values )
             else:   
                sinid_ATinid_Avalue = sinid_ATinid_Avalue +"_"+str( original_attrvalue_list[md5index] )
             if original_attrtype_nid_list[ md5index ] == 'password':
                   md5obj = md5.new()
                   md5obj.update( original_attrvalue_list[ md5index ] )
                   new_md5_password =  md5obj.hexdigest() 
                   attrvalue_list.append( new_md5_password )
                   original_attrvalue_list[ md5index ]= new_md5_password

             else:
                   attrvalue_list.append( original_attrvalue_list[md5index] )         
                   
             md5obj = md5.new()
             md5obj.update(  sinid_ATinid_Avalue )  
             md5sum_table_value = md5obj.hexdigest() 
             tuple_list_4_md5sum.append( (new_attr_ssid_list[md5index], md5sum_table_value) )

      else: #this part is invoked when nodetype='attribute'
         # check if for an attrtype this subject has already attached this attrvalue. We do this with help of md5sum table ---start--------
         attrtype_inid_list = []
         attrtype_nid_list = []
         attrvalue_list = []
         new_attr_ssid_list = []
         tuple_list_4_md5sum = []
      
         sinid_ATinid_Avalue = str(subject_inid)
         for md5index in range(len( original_attrtype_inid_list )):
             sinid_ATinid_Avalue = sinid_ATinid_Avalue +"_"+str( original_attrtype_inid_list[md5index] )
             if isinstance( original_attrvalue_list[md5index], list ):
                for values in  original_attrvalue_list[md5index] :
                    sinid_ATinid_Avalue = sinid_ATinid_Avalue +"_"+str( values )
             else:   
                sinid_ATinid_Avalue = sinid_ATinid_Avalue +"_"+str( original_attrvalue_list[md5index] )
             md5obj = md5.new()
             md5obj.update(  sinid_ATinid_Avalue )  
             attrvalue_in_md5 = md5obj.hexdigest() 
             md5sql = "select attributessid from md5sum where attrmd5sum='%s';"%( attrvalue_in_md5 )
             execute_query(md5sql,self.curs)
             md5fetched_value = query_fetchall(self.curs)
             if md5fetched_value == []:
                      attrtype_nid_list.append( original_attrtype_nid_list[md5index] )
                      attrtype_inid_list.append( original_attrtype_inid_list[md5index]  )

                      if original_attrtype_nid_list[md5index] == 'password':
                         #  we check if attrtype_nid_list has nid=password then we modify the attr_value =md5(input_attr_value) 
                         md5obj = md5.new()
                         md5obj.update( original_attrvalue_list[md5index] )
                         attrvalue_list.append( md5obj.hexdigest() )
                      else:
                         attrvalue_list.append( original_attrvalue_list[md5index] )
                      new_attr_ssid = get_next_sequence_value('ssid_seq',self.curs)
                      new_attr_ssid_list.append( new_attr_ssid )
                      attr_ssid_list_4_snapshot.append( new_attr_ssid )
                      tuple_list_4_md5sum.append( (new_attr_ssid, attrvalue_in_md5) )
             else:
                      attr_ssid_list_4_snapshot.append( md5fetched_value[0][0] )
      #      end--------------------

      if new_attr_ssid_list != []:   #there exists some new subject_attrtype_attrvalue pair.
         #calculate necessary details for wiriting in datatypes_* table and in gbattributes
         attrtype_inid_sql = list2string(attrtype_inid_list)
         # select of restrictiontype and restrictionref
         sql="SELECT restrictiontype,restrictionref,ssid from gbattributetypes WHERE ssid in %s ;"%attrtype_inid_sql
         #print sql
         execute_query(sql,self.curs)
         restrictionlist = query_fetchall(self.curs)
         #restrictionlist=[(restrictiontype1,restrctionref1,inid),(restrictiontype2,restrctionref2,inid), ...]

         #sorting restrictionlist as per attrtype_inid sequence-- start
         new_restrictionlist=[]
         for ATinid in attrtype_inid_list:
             for triple in restrictionlist:
                 if str(triple[2])== ATinid:
                    new_restrictionlist.append( ( str(triple[0]) , str(triple[1]) ) )
                    break

         restrictionlist = new_restrictionlist

         #--- sorting ends

         typename_list=self.derive_datatype(restrictionlist)
         #print typename_list
         tblname=[]
         for types in typename_list:  
             one_tblname="datatypes_"+str(types.replace('[]',''))#handling datatype_*[]
             tblname.append(one_tblname)
            
         #tblname=['datatypes_varchar','datatypes_int', ...]
         #print "tblname",tblname
         ##print

         #creating relation instanceof between the newly created attributessid=attributeinid and attributetypeinid.

         #writing instanceof relation between all newly attr_ssid_list and attrtype_inid_list in gbrelations.
         attr_instanceof_attrtype_relnssid_list=[]
         gbreln_value_sql=""
         #print "new_attr_ssid_list",new_attr_ssid_list
         #print "attrtype_inid_list",attrtype_inid_list
         #new_attrtype_ssidinid_list = [] #this is ssid=inid for the new snapshot of attrtype. newsnAT =1 -----------------------------------------
         for subj1_inid,subj2_inid in map(None,new_attr_ssid_list,attrtype_inid_list):
               single_nid=str(subj1_inid)+"_"+str(subj2_inid)  

               new_instanceofReln_ssid = get_next_sequence_value('ssid_seq',self.curs)                     
               attr_instanceof_attrtype_relnssid_list.append(new_instanceofReln_ssid)
               #new_attrtype_ssidinid_list.append( get_next_sequence_value('ssid_seq',self.curs) )# newsnAT =1

               #for all new relation that are created bind this ssid.
               bind_nidssid(new_instanceofReln_ssid,single_nid,new_instanceofReln_ssid,"gbrelations",self.curs)
               bind_nidlatestssid(new_instanceofReln_ssid,single_nid,self.curs)
               
               gbreln_value_sql = gbreln_value_sql+"(%s,'%s',%s,%s,'%s',4,'{status,relationtype,subject1,subject2}','{1,1,1,1}',0,0,'{0}',2,'%s','%s') "%(new_instanceofReln_ssid,single_nid,new_instanceofReln_ssid,uid,status,str(subj1_inid),str(subj2_inid))+","
               
         gbreln_value_sql = gbreln_value_sql.rstrip(",")
         sql="INSERT INTO gbrelations(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,relationtype,subject1,subject2) values %s;"%gbreln_value_sql
         #print sql
         execute_query(sql,self.curs)
         #at this point writing of instaceof reln (between new_attr_ssid and their corresponding attrtype_ssid) in gbrelations done.
         from GetMethods import *
         get_obj = GetMethods(self.constring)
         old_attrtype_ssid_dic = get_obj.getlatestssids( attrtype_inid_list, 'inid')

         """
         #start creating new snapshot of each attributetype-------------------------------newsnAT =1
         get_obj = GetMethods(self.constring)
         old_attrtype_ssid_dic = get_obj.getlatestssids( attrtype_inid_list, 'inid')
         for newATindex in range(len( attrtype_inid_list )):
             old_AT_ssid = str(  old_attrtype_ssid_dic[ attrtype_inid_list[newATindex] ] )
             #print new_attr_ssid_list
             rnbhData_list_4_newsnapshot = [ new_attr_ssid_list[newATindex] ]
             rnbhData_list_4_newsnapshot.append('leftroles'  )
             create_newsnapshot('relations',['gbattributetypes'],uid,[ old_AT_ssid ],[new_attrtype_ssidinid_list[newATindex]],['instanceof'],[[attr_instanceof_attrtype_relnssid_list[newATindex]]], rnbhData_list_4_newsnapshot, self.curs)

             #for all new attrtype ssid that are created, bind this ssid. 
             bind_nidssid( new_attrtype_ssidinid_list[newATindex], attrtype_nid_list[newATindex],                                                                                      new_attrtype_ssidinid_list[newATindex], "gbattributetypes",self.curs)
             bind_nidlatestssid( new_attrtype_ssidinid_list[newATindex], attrtype_nid_list[newATindex], self.curs)
               
         #end of creating newsnapshot of attributetype----------------------------------

         #---we have to add attrtype_ssid as rightrole in instanceof in renderednbh for this attribute.
         #writing in gbattributes table.
         self.write_in_gbattributes( uid, status, subject_inid, new_attr_ssid_list, attrtype_nid_list, typename_list, attrtype_inid_list,                                                        new_attrtype_ssidinid_list, attr_instanceof_attrtype_relnssid_list,   new_subject_ssid ) 
         #at this point rendernbh and nbh of attributes has their correct values.

         """
         #start revising fields of attributetype,   newsnAT = 0

         latest_attrtype_ssid_list = []
         for ATindex in range(len(attrtype_inid_list)):
             ATssid = old_attrtype_ssid_dic[attrtype_inid_list[ATindex]]
             latest_attrtype_ssid_list.append(ATssid)
             #rnbhData_list_4_revisefields = [ new_attr_ssid_list[ATindex] ]
             #rnbhData_list_4_revisefields.append('leftroles')                                              
             #revise_fields('relations',['gbattributetypes'],uid,[ATssid ],['instanceof'],[[attr_instanceof_attrtype_relnssid_list[ATindex]]],rnbhData_list_4_revisefields,self.curs)

         #end of revising fields of attributetype

         #---we have to add attrtype_ssid as rightrole in instanceof in renderednbh for this attribute.
         #writing in gbattributes table.
         self.write_in_gbattributes( uid, status, subject_inid, new_attr_ssid_list, attrtype_nid_list, typename_list, attrtype_inid_list,                                                        latest_attrtype_ssid_list, attr_instanceof_attrtype_relnssid_list,   new_subject_ssid ) 
         #at this point rendernbh and nbh of attributes has their correct values.


         #multiple inserts query generation for writing in datatypes_* table
         sql = ''
         sqlvalues=""
         #print typename_list

         for instances in range(len(attrtype_inid_list)):
              if (typename_list[instances].startswith('varchar')) or (typename_list[instances].startswith('text')):
                 if isinstance( attrvalue_list[instances],list):#this done to handle multiple attrvalue for an attrtype.
                    for single_attrvalue in attrvalue_list[instances]:
                        sqlvalues="("+str(subject_inid)+",'"+ str( single_attrvalue ) +"',"+str(new_attr_ssid_list[instances])+","+ str(attrtype_inid_list[instances] )+",'"+language+"',to_tsvector('"+ str(single_attrvalue)+"'::text))"
                        #print sqlvalues
                        sql=sql+"INSERT INTO %s(subject_inid,value,attribute_ssid,attributetype_inid,language,value_text_vec) values %s; "%(tblname[instances],sqlvalues)
                 else:
                        single_attrvalue = attrvalue_list[instances]
                        sqlvalues="("+str(subject_inid)+",'"+single_attrvalue +"',"+str(new_attr_ssid_list[instances])+","+ str(attrtype_inid_list[instances] )+",'"+language+"',to_tsvector('"+ single_attrvalue+"'::text))"
                        sql=sql+"INSERT INTO %s(subject_inid,value,attribute_ssid,attributetype_inid,language,value_text_vec) values %s; "%(tblname[instances],sqlvalues)

              else:#datatype is other than text and varchar.so no tsvector.
                 if isinstance( attrvalue_list[instances] ,list):#this done to handle multiple attrvalue for an attrtype.
                     for single_attrvalue in attrvalue_list[instances]:
                         sqlvalues="("+str(subject_inid)+",'"+ str(single_attrvalue ) +"',"+str(new_attr_ssid_list[instances])+","+ str(attrtype_inid_list[instances])+",'"+language+"')"
                         sql=sql+"INSERT INTO %s(subject_inid,value,attribute_ssid,attributetype_inid,language) values %s; "%(tblname[instances],sqlvalues)
                 else:
                         sqlvalues="("+str(subject_inid)+",'"+ str(attrvalue_list[instances]) +"',"+str(new_attr_ssid_list[instances])+","+ str(attrtype_inid_list[instances] )+",'"+language+"')"
                         sql=sql+"INSERT INTO %s(subject_inid,value,attribute_ssid,attributetype_inid,language) values %s; "%(tblname[instances],sqlvalues)

          
         #print sql
         execute_query(sql,self.curs)
         #print "sql executed"
         # end of writing in datatypes table
         #-------start writing in md5sum table------------------
         md5stmt="INSERT INTO md5sum values %s ;"

         md5sum_value_sql="" 
         for md5tuple in tuple_list_4_md5sum:
             md5sum_value_sql = md5sum_value_sql+ "("+ str( int (md5tuple[0] ) )+",'" + str( md5tuple[1] ) +"'),"

         sql=md5stmt % ( md5sum_value_sql.rstrip(",") )    
         #print sql
         execute_query(sql,self.curs)
         #----- end -----------------

      attrtype_nid_attrvalue_list=[]
      attrtype_nid_attrvalue_list.append( original_attrtype_nid_list )
      attrtype_nid_attrvalue_list.append( original_attrvalue_list )
      attrtype_nid_attrvalue_list.append( attr_ssid_list_4_snapshot )
         
      return attrtype_nid_attrvalue_list

if __name__=="__main__":

  constring="dbname=<postgres_databasename> user=<postgres_username> password=<postgres_password> host=localhost"
  uid=1
  obj=attribute(constring,uid)
  input = {
            'uid':'1',   
            'status':'Public',  
            'instanceof':[('title','Object2 '),('description','this is first object,an instanceof second objecttype. testing new attr file where checks r using rendered_nbh')],
            'subject':'456',
            'language':'english'
            }

  nodetype_list=obj.startchecks(input['uid'],input['subject'])
  #print "---------------",nodetype_list
  if nodetype_list!=-1:
     nid_inid_list= get_nidinid_from_ssid(input['subject'],obj.curs)
     subject_nid= nid_inid_list[0][0]
     subject_inid= str(nid_inid_list[0][1])
     input['subject_inid']=subject_inid  
     input['nodetype']=nodetype_list[0]

     new_subject_ssid= get_next_sequence_value('ssid_seq',obj.curs)
     #print "next seq value for new_subject_ssid=",new_subject_ssid
     attrtype_nid_attrvalue_list=obj.create_newattr(input,new_subject_ssid,0,0,1,0)

     if attrtype_nid_attrvalue_list!=-1:
        attrtype_nid_list = attrtype_nid_attrvalue_list [0]
        attrvalue_list = attrtype_nid_attrvalue_list[1]
        attr_ssid_list_4_snapshot = attrtype_nid_attrvalue_list[2]
        #print "create new snapshot of the subject and pass the new ssid of the subject to gbattributes and datatypes_* table"
        create_newsnapshot("attributes",nodetype_list,input['uid'],[input['subject']],[new_subject_ssid],attrtype_nid_list,[attr_ssid_list_4_snapshot],attrvalue_list,obj.curs)
        #print"updating old_ssid_of_subject=",input['subject']," to new_subject_ssid=",new_subject_ssid
        
        reset_ssid_2_latestssid(new_subject_ssid,subject_nid,obj.curs)#update subject's ssid
        bind_nidssid(new_subject_ssid,subject_nid,subject_inid,nodetype_list[0],obj.curs)#for new snapshot of subject   
        commitclose(obj.curs,obj.conn)

