#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'

nt_view_dict = { 'gbusers' : 'view_u', 'gbusertypes':'view_ut', 'gbobjects':'view_o', 'gbobjecttypes':'view_ot', 'gbattributes':'view_a', 'gbattributetypes':'view_at', 'gbrelations':'view_r', 'gbrelationtypes':'view_rt', 'gbmetatypes':'view_m' }

# the list of the nodetypes
nodetypelist = [ 'gbusers', 'gbusertypes', 'gbobject', 'gbobjecttyeps', 'gbattributes', 'gbattributetypes', 'gbrelations', 'gbrelationtypes', 'gbmetatypes' ]

# the list of the snapshot fields whose values are available from the ss table
snapshotfields = ['inid', 'ssid', 'uid', 'uri' ]

# the list of the version fields
#versionfields = ['noofmodifiedfields', 'fieldschanged', 'changetype', 'noofcommits', 'noofmodifications', 'history' ]
versionfields = ['noofchanges', 'fieldschanged', 'changetype', 'noofcommits', 'noofchangesaftercommit', 'history' ]



# ns_props - node specific properties
# nw_props - network properties

# node specific properties for types
ns_type_props_wo_ttl = [ 'description', 'status', 'uri' ]
ns_type_props_ttl_manprops = [ 'title', 'mandatoryprops', ]
ns_type_props = [ 'title', 'description', 'status', 'mandatoryprops', 'uri' ]

# network properties for types
nw_type_props = ['attributetypes', 'attributes', 'relationtypes', 'relations', 'subtypeof', 'subtypes', 'instanceof', 'instances' ]

# network properties for metatypes
nw_type_props_mt = ['attributetypes', 'attributes', 'relationtypes', 'relations', 'subtypeof', 'subtypes', 'instances', 'content' ]

# node specific properties for tokens
ns_token_props = ['title', 'description', 'status' ]

# network properties for tokens
nw_token_props = ['attributetypes', 'attributes', 'relationtypes', 'relations' ]



# node specific properties for objecttypes
ns_props_objecttypes = ns_type_props + [ 'content' ]

# network specific properties for objecttypes
nw_props_objecttypes = nw_type_props + [ 'structure' ]

# objecttypes properties
props_objecttypes = ns_props_objecttypes + nw_props_objecttypes


# node specific properties for attributetypes
ns_props_attributetypes = ns_type_props + [ 'datatype', 'restrictiontype', 'restrictionref' ]

# network specific properties for attributetypes
nw_props_attributetypes =  nw_type_props + [ 'subjecttypes' ]

# attributetypes properties
props_attributetypes = ns_props_attributetypes + nw_props_attributetypes


# node specific properties for metatypes
ns_props_metatypes = ns_type_props + [ 'content' ]

# network specific properties for metatypes
nw_props_metatypes = [ nw_type_props_mt ]

# metatypes properties
props_metatypes = ns_props_metatypes + nw_props_metatypes


# node specific properties for relationtypes
ns_props_relationtypes = ns_type_props + [ 'istransitive', 'isreflexive', 'issymmetrical' ]

# network specific properties for relationtypes
nw_props_relationtypes = nw_type_props + [ 'roletypes' ]

# relationtypes properties
props_relationtypes = ns_props_relationtypes + nw_props_relationtypes


# node specific properties for objects
ns_props_objects = ns_token_props + [ 'content' ]

# network specific properties for objects
nw_props_objects = nw_token_props + [ 'structure' ]

# objects properties
props_objects = ns_props_objects + nw_props_objects


# node specific properties for attributes
ns_props_attributes = ns_token_props + [ 'sentense' ]

# network specific properties for attributes
nw_props_attributes = nw_token_props + [ 'subject', 'value' ]

# attributes properties
props_attributes = ns_props_attributes + nw_props_attributes



# node specific properties for relations
ns_props_relations = ns_token_props + [ 'sentense' ]

# network specific properties for relations
nw_props_relations = nw_token_props + [ 'subject1', 'subject2']

# relations properties
props_relations = ns_props_relations + nw_props_relations


# node specific properties for users
ns_props_users = ns_token_props

# network specific properties for users
nw_props_users = nw_token_props + [ 'firstname', 'lastname', 'middlename', 'email', 'domain', 'password', 'content' ]

# users properties
props_users = ns_props_users + nw_props_users



# node specific properties for usertypes
ns_props_usertypes = [ ns_token_props ]

# network specific properties for usertypes
nw_props_usertypes = [ ns_token_props ]

# usertypes properties
props_usertypes = ns_props_usertypes + nw_props_usertypes

# select final properties as per give nodetype

nt_props_dict_new = { 'gbusers':props_users, 'gbusertypes':props_usertypes, 'gbobjects':props_objects, 'gbobjecttypes':props_objecttypes, 'gbattributes':props_attributes, 'gbattributetypes':props_attributetypes, 'gbrelations':props_relations, 'gbrelationtypes':props_relationtypes, 'gbmetatypes':props_metatypes }


""" dictionary for gbobjecttypes for set and update """

dictParametersot = {
	'status':'',
        'content':'',
        'inid': '', 
        'subtypes':[0],
        'ssid': '', 
        'noofcommits':'',
        'subtypeof':[0],
        'changetype':[0],
        'title':[''],
        'uri':'',
        'relations':[0],
        'noofchangesaftercommit':'',
        'instances':[0],
        'noofchanges':'',
        'description':'',
        'attributes':[0],
        'relationtypes':[0],
        'history':[0],
        'fieldschanged':[0],
        'attributetypes':[0],
        'uid':'',
        'instanceof':[0]
}


