#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the 
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, 
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330, 
#
######################################################################

__author__ = """Nagarjuna <nagarjun@gnowledge.org>"""
__docformat__ = 'plaintext'

from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.Archetypes.SQLStorage import *
from Products.gnowsysApp.config import *
import psycopg2
import psycopg2.extensions
import psycopg2.extras
from genericTable import *
from datetime import datetime

## code-section module-header #fill in your manual code here
## /code-section module-header

schema = Schema((

    StringField(
        name='id',
        widget=StringWidget(
            label='Id',
            label_msgid='gnowsysApp_label_id',
            i18n_domain='gnowsysApp',
        )
    ),

    StringField(
        name='title',
        widget=StringWidget(
            label='Title',
            label_msgid='gnowsysApp_label_title',
            i18n_domain='gnowsysApp',
        )
    ),

    StringField(
        name='description',
        widget=StringWidget(
            label='Description',
            label_msgid='gnowsys_label_description',
            i18n_domain='gnowsysApp',
        )
    ),

    StringField(
        name='status',
        widget=StringWidget(
            label='Status',
            label_msgid='gnowsysApp_label_status',
            i18n_domain='gnowsysApp',
        )
    ),

    StringField(
        name='relations',
        widget=StringWidget(
            label='Relations',
            label_msgid='gnowsysApp_label_relations',
            i18n_domain='gnowsysApp',
        )
    ),

),
)

##code-section after-local-schema #fill in your manual code here
##/code-section after-local-schema

gnowQL_schema = BaseSchema.copy() + \
    schema.copy()

##code-section after-schema #fill in your manual code here
##/code-section after-schema

class gnowQL(BaseContent):
#class gnowQL:
    """
    """
    security = ClassSecurityInfo()
    __implements__ = (getattr(BaseContent,'__implements__',()),)

    # This name appears in the 'add' box
    archetype_name = 'gnowQL'

    meta_type = 'gnowQL'
    portal_type = 'gnowQL'
    allowed_content_types = []
    filter_content_types = 0
    global_allow = 1
    content_icon = 'gnowQL.gif'
    immediate_view = 'base_view'
    default_view = 'base_view'
    suppl_views = ()
    typeDescription = "gnowQL"
    typeDescMsgId = 'description_edit_learningobject'

    _at_rename_after_creation = True

    schema = gnowQL_schema

    ##code-section class-header #fill in your manual code here
    ##/code-section class-header

    # global variables
    
   
    # Methods
    def manageDelRelation( self, ssid ):
        """
        Deletes the relation given the ssid of the relation
        """

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string


        # Aquiring Connection String from Databse Adapter
        conString = connection_string

        # get a cursor
        conn = psycopg2.connect(conString)
        cur = conn.cursor()        
        
        # Create instance of genericTable
        gt = genericTable( cur, 'gbobjecttypes' )
        nt = tbl_nodetype( cur )
        
        relInfo = gt.getFromView( 'djview_r', ssid )
        sub1 = relInfo[0]['subject1']
        sub2 = relInfo[0]['subject2']


        # assuming all subjects to be objects
        sub1Info = gt.getFromView( 'djview_o', sub1 )
        sub2Info = gt.getFromView( 'djview_o', sub2 )

        print "subject1 = %s, subject2 = %s" % ( sub1, sub2 )
        print "subject1 info = %s" % ( sub1Info )
        print "subject2 info = %s" % ( sub2Info )

        sub1Relations = sub1Info[0]['relations']
        sub2Relations = sub2Info[0]['relations']

        print "subject1 relations = %s" % ( sub1Relations )
        print "subject2 relations = %s" % ( sub2Relations )

        try:
            newRel1 = sub1Relations.remove( long(ssid) )
        except:
            print "ssid not in list"

        try:
            newRel2 = sub2Relations.remove( long(ssid) )
        except:
            print "ssid not in list"

        print "newRel1 = %s" % sub1Relations
        print "newRel2 = %s" % sub2Relations

        updateRel1 = 0
        updateRel2 = 0
        if sub1Relations != None:
            updateRel1 = len( sub1Relations )
            print "no rel1 "

        if sub2Relations != None:
            updateRel2 = len( sub2Relations )
            print "no rel2 "
        s = storageSpec()
        flddef = s.dictTNamesFDefs['gbobjects']['relations']

        obj = tbl_nodetype( cur )
        ntid = obj.getntid( 'gbobjects' )

        dtobj = tbl_datatypes( cur )
        dtid = dtobj.getdtid( flddef[1] )

        ft = tbl_field( cur, flddef )

        if updateRel1 == 0:
            fid1 = 'NULL'
        else:
            fid1 = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':sub1Relations } )
            
        if updateRel2 == 0:
            fid2 = 'NULL'
        else:
            fid2 = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':sub2Relations } )
            
        print "Fid generated was %s" % fid1
        print "Fid generated was %s" % fid2

        query1 = "UPDATE gbobjects SET relations=%s WHERE ssid = '%s';" % ( fid1, sub1 )
        query2 = "UPDATE gbobjects SET relations=%s WHERE ssid = '%s';" % ( fid2, sub2 )
        query3 = "DELETE FROM gbrelations WHERE ssid = %s;" % ( ssid )

        print "query1 = %s" % query1
        print "query2 = %s" % query2
        print "query2 = %s" % query3

        cur.execute( query1 )
        cur.execute( query2 )
        cur.execute( query3 )

        conn.commit()
        conn.close()
        
    def manageAddObjectType(self, dictParameters):

        """
        Adding ObjectType
        """

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbobjecttypes import gbobjecttypes       
        gbinstance = gbobjecttypes( connection_string )
        gbinstance.set( dictParameters, insname )


        msg = "Objecttype Added !"
        return msg

    def manageAddAttributeType(self, dictParameters):

        """
        Adding AttributeType
        """

        # get the instance name
        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])
        
        # Aquiring Connection String from Databse Adapter
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        from gbattributetypes import gbattributetypes       
        gbinstance = gbattributetypes( connection_string )
        gbinstance.set( dictParameters, insname )

        msg = "AttributeType Added !"
        return msg

    def manageAddAttribute(self, dictParameters):

        """
        Adding AttributeType
        """

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbattributes import gbattributes      
        gbinstance = gbattributes( connection_string )
        gbinstance.set( dictParameters, insname )
       
        msg = "Attribute Added !"
        return msg

    def manageAddRelationType(self, dictParameters):

        """
        Adding RelationTypes
        """

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbrelationtypes import gbrelationtypes
        gbinstance = gbrelationtypes( connection_string )
        gbinstance.set( dictParameters, insname )
        

        msg = "RelationType Added !"
        return msg

    def manageAddUserType(self, dictParameters):

        """
        Adding RelationTypes
        """

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbusertypes import gbusertypes
        gbinstance = gbusertypes( connection_string )
        gbinstance.set( dictParameters, insname )
        

        msg = "UserType Added !"
        return msg


    def manageAddRelation(self, dictParameters):

        """
        Adding Relations
        """

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbrelations import gbrelations
        gbinstance = gbrelations( connection_string )
        gbinstance.set( dictParameters, insname )
        
        msg = "Relations Added !"
        return msg

    
    def manageAddObject(self, dictParameters):

        """
        Adds an object to the database
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])

        # Adding To Database
        
        from gbobjects import gbobjects       
        gbinstance = gbobjects( connection_string )
        gbinstance.set( dictParameters, insname )


        msg = "Object Added !"
        return msg

    def manageAddUserType(self, dictParameters):

        """
        Adds an object to the database
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])

        # Adding To Database
        
        from gbusertypes import gbusertypes
        gbinstance = gbusertypes( connection_string )
        gbinstance.set( dictParameters, insname )


        msg = "UserType Added !"
        return msg


    def manageAddUser(self, dictParameters):

        """
        Adds an object to the database
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])

        # Adding To Database
        
        from gbusers import gbusers
        gbinstance = gbusers( connection_string )
        gbinstance.set( dictParameters, insname )


        msg = "User Added !"
        return msg

       

    def getObjectInfo(self, nid):
        
        """
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbobjects import gbobjects       
        gbinstance = gbobjects( connection_string )

        result = []
        result = gbinstance.getNeighbourhood( nid )
        
        return result
    
    def getO(self, nid):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbobjects import gbobjects       
        gbinstance = gbobjects( connection_string )

        result = []
        result = gbinstance.getNB( nid )
        
        return result

    def getOT(self, nid):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbobjecttypes import gbobjecttypes       
        gbinstance = gbobjecttypes( connection_string )

        result = []
        result = gbinstance.getNB( nid )
        
        return result

    def updateOT(self, dictParameters, cmt=0):
        """
        """

        # get the instance name

        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbobjecttypes import gbobjecttypes       
        gbinstance = gbobjecttypes( connection_string )

        gbinstance.update( dictParameters, insname, cmt  )
        
        return "Updated"

    def updateO(self, dictParameters, cmt=0):
        """
        """

        # getting Instance Name
        
        inspath = self.portal_url()
        splitpath = inspath.split('/')
        insname = str(splitpath[-1])
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # Adding To Database
        
        from gbobjects import gbobjects       
        gbinstance = gbobjects( connection_string )

        gbinstance.update( dictParameters, insname, cmt  )
        
        return "Updated"

    def getLatestSSIDFromNidNT( self, nid, nodetype ):
        """
        Get latest SSID from the NID and NODETYPE
        """
        # Aquiring Connection String from Databse Adapter
        connection_string = self.dbadapter.connection_string

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        res = gbinstance.getLatestSSIDFromNidNT( nid, nodetype )
        return res

    def getAllLatestSSIDsFromNids( self, lstNid ):
        """
        Get latest SSIDs from the list of NIDs
        """
        # Aquiring Connection String from Databse Adapter
        connection_string = self.dbadapter.connection_string

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        res = gbinstance.getAllLatestSSIDsFromNids( lstNid )
        return res
        

    def getAllSSIDs( self, lstssid, nodetype ):
        """
        Get info of all SSIDs in the lstssid
        """

        # Aquiring Connection String from Databse Adapter
        connection_string = self.dbadapter.connection_string

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        title = gbinstance.getAllSSIDs( lstssid, nodetype )
        return title

    def getAllSSIDCols( self, lstssid, lstcols, nodetype ):
        """
        Gets all SSIDs but only the columns that you require
        """

        # Aquiring Connection String from Databse Adapter
        connection_string = self.dbadapter.connection_string

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        res = gbinstance.getAllSSIDCols( lstssid, lstcols, nodetype )
        return res


    def getTitleFromSSID(self, ssid, nodetype):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting title from pg

        uname = ''
        
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        title = gbinstance.getTitleFromSSID( ssid, nodetype )
        return title
    
    def getUserIdfromUsername(self, username):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting uid from database

        uname = ''
        
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        uid = gbinstance.getUserIdfromUsername( username )
        return uid

    def getUsernamefromUserId(self, uid):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting username from database

        uname = ''
        
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        username = gbinstance.getUsernamefromUserId( uid )
        return username

    def strValidate(self, valueStr):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        vstr = gbinstance.strValidate( valueStr )
        
        return vstr

    def getAll(self, nodeType):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        viewresult = gbinstance.getAll( nodeType )
        if viewresult <> {}:
            return viewresult
        else:
            return "Invalid Node Type"

    def xGetAll( self, nodeType ):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        viewresult = gbinstance.xGetAll( nodeType )
        if viewresult <> {}:
            return viewresult
        else:
            return "Invalid Node Type"

    def getlatestVersion(self, nid):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        ssidresult = gbinstance.getlatestVersion( nid )
        return ssidresult

    def getnidfromssid(self, ssid, nodetype):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        nidresult = gbinstance.getnidfromssid( ssid, nodetype )
        return nidresult

    def geturifromssid(self, ssid, nodetype):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        uriresult = gbinstance.geturifromSSID( ssid, nodetype )
        return uriresult
    

    def getlatestSSIDs( self, lstSSIDs , nodetype):
        """
        Gets the latest ssid's of ssid's passed
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.getlatestSSIDs( lstSSIDs , nodetype)

        return sresult

    def getinfoFromSSID(self, ssid, nodeType):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        inforesult = gbinstance.getinfoFromSSID(ssid, nodeType)
        return inforesult[0]
    
    def getSubjects(self, ssid, relationType):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        subresult = gbinstance.getSubjects(ssid, relationType)
        return subresult

    def getVersiontree(self, ssid):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        subresult = gbinstance.getVersiontree(ssid)
        return subresult
    
    def getAllCommitedVersions(self, ssid):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        subresult = gbinstance.getAllCommitedVersions(ssid)
        return subresult

    def getAllsnapshots(self, ssid, nodeType):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.getAllsnapshots(ssid, nodeType)
        return sresult
   
    def isnidExists(self, nidStr):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.isnidExists(nidStr)
        return sresult

    def getAllAttributeValues(self, lst_attribute_ssids):
        """
        Given a list of ssid'd of attributes the function returns
        their corresponding values.
        """

        connection_string = self.dbadapter.connection_string
        from gbattributes import gbattributes
        gbinstance = gbattributes( connection_string )

        sresult = gbinstance.getAllAttributeValues( lst_attribute_ssids )
        return sresult

    def updateSSIDStatus( self, ssid, status ):
        """
        update status property of given ssid
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.updateSSIDStatus( ssid, status )

        return "success"

    def getAllResourcesofUser( self, uid ):

        """
        update status property of given ssid
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.getAllResourcesofUser( uid )

        return sresult


    def getNodetype( self, ssid ):

        """
        get node type
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.getNodetype( ssid )

        return sresult

    def searchMaterial( self, searchstr):

        """
        search objects
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.searchMaterial( searchstr )

        return sresult
    
    def searchResources( self, searchstr):

        """
        search resources
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.searchResources( searchstr )

        return sresult

    def globalsearchMaterial( self, searchstr):

        """
        search objects
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.globalsearchMaterial( searchstr )

        return sresult
    

    def getSubscribers( self, objssid):

        """
        get all Subscriber
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.getSubscribers(objssid)

        return sresult

    
    def getRelationSSID( self, sub1, sub2):

        """
        get relation's ssid
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.getRelationSSID(sub1, sub2)

        return sresult

    def compare_changes(self, nodeid):

        """
        search resources
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.compare_changes(nodeid)

        return sresult



    def isTag(self, x):

        """
        search resources
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.isTag(x)

        return sresult


    def html2list(self, x, b=0):

        """
        search resources
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.html2list(x, b=0)

        return sresult



    def textDiff(self, a, b):

        """
        search resources
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.textDiff(a, b)

        return sresult

    def updateSSIDSubtypeOf( self, ssid, subtypeof ):

        """                                                                                                                                                  
        Updates Content the given ssid                                                                                                                       
        """

        # Aquiring Connection String from Databse Adapter                                                                                                    
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database                                                                                                  
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.updateSSIDSubtypeOf( ssid, subtypeof )

        return "success"

    def updateRelations( self, ssid, rellist ):

        """                                                                                                                                                  
        Updates Content the given ssid                                                                                                                       
        """

        # Aquiring Connection String from Databse Adapter                                                                                                    
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database                                                                                                  
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.updateRelations( ssid, rellist )

        return "success"

    def updateSSIDStructure( self, ssid, structure ):

        """
        Update structure property of the given ssid
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.updateSSIDStructure( ssid, structure )

        return "success"

    def updateSSIDTitle( self ,ssid, title ):

        """
        Updates Title of the given ssid
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.updateSSIDTitle( ssid, title )

        return "success"

    def updateSSIDDescription( self ,ssid, description ):

        """
        Updates description of the given ssid
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.updateSSIDDescription( ssid, description )

        return "success"

    def updateSSIDContent( self ,ssid, content ):

        """
        Updates Content the given ssid
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.updateSSIDContent( ssid, content )

        return "success"
    
    def getAllPossibleAT( self, otssid ):
        """
        get all the possible attributes for given object
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

                
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.getAllPossibleAT( otssid )

        return sresult


    def getDatatypeNameFromAT( self, ssid ):
        """
        Gets the datatype name of attribute type
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.getDatatypeNameFromAT( ssid )

        return sresult

    def updateDatatype( self, ssid, newDatatypeName ):

        """
        changing the datatype of attribute type
        """
        
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.updateDatatype( ssid, newDatatypeName )

        return sresult
    
    def searchMaterial_new( self, searchstr, langcode):
        """
        Modified Search Material
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.searchMaterial_new( searchstr, langcode )
        
        return sresult

    def searchResources_new( self, searchstr, langcode ):
        """
        Modified Search for Resources
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.searchResources_new( searchstr, langcode )
        
        return sresult
    
    def globalsearchMaterial_new( self, searchstr, langcode ):
        """
        Modified global Search 
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        sresult = gbinstance.globalsearchMaterial_new( searchstr, langcode )
        
        return sresult

    def getlanguagefromcode( self ):
        """
        get language from code
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )
        
        langcode = self.REQUEST['HTTP_ACCEPT_LANGUAGE'].split(',')[0]

        sresult = gbinstance.getlanguagefromcode( langcode )
        
        return sresult

    def getpercentofac( self, uid ):
        """
        get percentile of author's contribution 
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )
        
        sresult = gbinstance.getpercentofac( uid )
        
        return sresult

    def getAuthorLO(self, uid):
        """
        get percentile of author's contribution 
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )
        
        sresult = gbinstance.getAuthorLO( uid )
        
        return sresult

    def sitestats(self):
        """
        get Site Statistics
        """
        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting valid string for setting it into database

        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )
        
        sresult = gbinstance.sitestats()
        
        return sresult

    def getRoles(self, rtid):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting uid from database

        #uname = ''
        
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        roles = gbinstance.getRoles( rtid )
        return roles

    def getAllRoles(self, rtid):
        """
        """

        # Aquiring Connection String from Databse Adapter
        
        connection_string = self.dbadapter.connection_string

        # getting uid from database

        #uname = ''
        
        from commonMethods import gbMethods
        gbinstance = gbMethods( connection_string )

        roles = gbinstance.getAllRoles( rtid )
        return roles


registerType(gnowQL, PROJECTNAME)
# end of class gnowQL

##code-section module-footer #fill in your manual code here
##/code-section module-footer

# if __name__ == "__main__":
#     gql = gnowQL()
#     gql.manageDelRelation( 362 )
