#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'

from genericTable import *
from set_checks import *
from gbcontent import *

class gbusertypes:
        def __init__( self, conString ):

                self.conn = psycopg2.connect(conString)
                self.cur = self.conn.cursor()
                self.nodetype = 'gbusertypes'

        def set( self, dictParameters, insname ):
		cur = self.cur
		nt = self.nodetype

		try:
			nid = dictParameters['nid']
		except:
			return "Please enter nid"
		
		try:
			title = dictParameters['title']
		except:
			title = nid

		try:
			uid = dictParameters['uid']
		except:
			return "Please enter User Id"


		try:
			status = dictParameters['status']
		except:
			status = "Private"

		try:
			content = dictParameters['content']
		except:
			content = ''

		try:
			instanceof = dictParameters['instanceof']
		except:
			instanceof = []

		try:
			subtypeof = dictParameters['subtypeof']
		except:
			return "Please enter Value for subtypeof Property"

		try:
			description = dictParameters['description']
		except:
			description = ''


		subtypes = []
		noofcommits = '0'
		relations = []
		noofchangesaftercommit = '0'
		instances = []

		attributes = []
		relationtypes = []
		history = [0]
		attributetypes = []


		# Checks before insertion
		
		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
			inid = nidtbl.getinid( nid, nt )
	
		inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )

		""" uid and uri field is mandatory for objecttypes """
                
                """
		mandatory_fields = ({'uid':uid})
		
		chk_ssid = ({'subtypes':subtypes, 'subtypeof':subtypeof, 'instanceof':instanceof, 'attributes':attributes, 'attributetypes':attributetypes, 'relations':relations, 'relationtypes':relationtypes, 'history':history})
	        """
		obj = def_set_checks()
		
		#obj.manflds_chk(mandatory_fields)
                

		status = obj.status(status)
		title = obj.title(title, nid)
		# obj.is_ssid_valid(chk_ssid, cur)


		# aquring ssid from nid

		subtyps = []
		if subtypes <> []:
			for x in subtypes:
				sid = int(str(obj.get_ssid_from_nid(y, cur)[-1]))
				print sid
				subtyps.append(sid)
		subtypes = subtyps
		print "Reinitialized subtypes :", subtypes

		subtypof = []
		if subtypeof <> []:
			for y in subtypeof:
				try:
					sofid = int(str(obj.get_ssid_from_nid(y, cur)[-1]))
					print sofid
					subtypof.append(sofid)
				except:
					print nid
			
		subtypeof = subtypof
		print "Reinitialized subtypeof :", subtypeof

		instof = []
		if instanceof <> []:
			for z in instanceof:
				insid = int(str(obj.get_ssid_from_nid(z, cur)[-1]))
				instof.append(insid)
		instanceof = instof
		print "Reinitialized instanceof :", instanceof

		# Calculating URI

		preuri = makeURI(nid, inid, nt, insname)
		print preuri

		insertionDict = {
		'status':status,
		'content':content,
		'inid': inid, 
		'subtypes':subtypes,
		'ssid': ssid, 
		'noofcommits':noofcommits,
		'subtypeof':subtypeof,
		'title':title,
		'uri':preuri,
		'relations':relations,
		'noofchangesaftercommit':noofchangesaftercommit,
		'instances':instances,
		'description':description,
		'attributes':attributes,
		'relationtypes':relationtypes,
		'history':history,
		'attributetypes':attributetypes,
		'uid':uid,
		'instanceof':instanceof
		}
	
		insertionDict = obj.insertionDict(insertionDict)

		""" to calculate fieldschanged, noofchangesaftercommit, changetype """
		"""
		fieldschanged = obj.fldschd(insertionDict, nt, nid, cur)
		"""
		fieldschanged=['status','content','title','description']
		modifications = obj.mod(fieldschanged)
		changetypes = obj.chgtyp(modifications)
	
		insertionDict.update({'fieldschanged':fieldschanged, 'noofchanges':modifications, 'changetype':changetypes})
	

		
		# do checking here of ssid, inid, nid, uid...
		
		s = storageSpec()
		gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
		gt.insert( insertionDict )

		# creating snapshot at filesystem
		createURI(preuri, inid, ssid)

		self.conn.commit()
		self.conn.close()
 
