#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'

from genericTable import *
from set_checks import *
from gbcontent import *

class gbobjects:
	def __init__( self, conString ):

		self.conn = psycopg2.connect(conString)
		self.cur = self.conn.cursor()
		self.nodetype = 'gbobjects'
		self.conString = conString

	def set( self, dictParameters, insname ):
		"""
		"""

		cur = self.cur
		nt=self.nodetype

		try:
			nid = dictParameters['nid']
			s = nid
			s = s.strip()
			print s
			wordlist = s.split()
			nid = ' '.join(wordlist)
			print nid
			
		except:
			return "Please enter nid"
		
		try:
			title = dictParameters['title']
		except:
			title = nid

		try:
			uid = dictParameters['uid']
		except:
			return "Please enter User Id"


		try:
			status = dictParameters['status']
		except:
			status = "Public"

		try:
			content = dictParameters['content']
		except:
			content = ''

		try:
			instanceof = dictParameters['instanceof']
		except:
			return "Please enter Value for instanceof Property"

		try:
			subtypeof = dictParameters['subtypeof']
		except:
			subtypeof = []

		try:
			description = dictParameters['description']
		except:
			description = ''

		try:
			structure = dictParameters['structure']
		except:
			structure = [0]

# 		subtypes =dictParameters['subtypes']
# 		noofcommits =dictParameters['noofcommits']
# 		relations =dictParameters['relations']
# 		noofchangesaftercommit = dictParameters['noofchangesaftercommit']
# 		instances =dictParameters['instances']
# 		attributes = dictParameters['attributes']
# 		relationtypes = dictParameters['relationtypes']
# 		history = dictParameters['history']
# 		attributetypes =dictParameters['attributetypes']

		subtypes = []
		noofcommits = '0'
		relations = []
		noofchangesaftercommit = '0'
		instances = []
		attributes = []
		relationtypes = []
		history = [0]
		attributetypes = []
		
                
                #Checks before insertion
		
		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
		       inid = nidtbl.getinid( nid, nt )
	
	        inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )


	        """ uid and uri field is mandatory for objecttypes """
		mandatory_fields = ({'uid':uid, 'instanceof':instanceof})
		chk_ssid = ({'subtypes':subtypes, 'subtypeof':subtypeof, 'instanceof':instanceof, 'relations':relations, 'instances':instances, 'attributes':attributes, 'relationtypes':relationtypes, 'history':history, 'attributetypes':attributetypes})
	
		obj = def_set_checks()
		obj.manflds_chk(mandatory_fields)
		status = obj.status(status)
		title = obj.title(title, nid)

		# aquring ssid from nid

		subtyps = []
		if subtypes <> []:
			for x in subtypes:
				sid = int(str(obj.get_ssid_from_nid(y, cur)[-1]))
				print sid
				subtyps.append(sid)
		subtypes = subtyps
		print "Reinitialized subtypes :", subtypes

		subtypof = []
		if subtypeof <> []:
			for y in subtypeof:
				try:
					sofid = int(str(obj.get_ssid_from_nid(y, cur)[-1]))
					print sofid
					subtypof.append(sofid)
				except:
					print nid
			
		subtypeof = subtypof
		print "Reinitialized subtypeof :", subtypeof

		instof = []
		if instanceof <> []:
			for z in instanceof:
				insid = int(str(obj.get_ssid_from_nid(z, cur)[-1]))
				instof.append(insid)
		instanceof = instof
		print "Reinitialized instanceof :", instanceof


		#creating list of networkfield

		listofnbhfield = []
		
		if relations <> []:
			listofnbhfield.append('relations')
		if relationtypes <> []:
			listofnbhfield.append('relationtypes')
		if attributes <> []:
			listofnbhfield.append('attributes')
		if attributetypes <> []:
			listofnbhfield.append('relations')
		if instanceof <> []:
			listofnbhfield.append('instanceof')
		if instances <> []:
			listofnbhfield.append('instances')
		if subtypeof <> []:
			listofnbhfield.append('subtypeof')
		if subtypes <> []:
			listofnbhfield.append('subtypes')
		
		# Calculating URI

		preuri = makeURI(nid, inid, nt, insname)
		print preuri
	
		insertionDict = {
		  'status':status,
		  'content':content,
		  'inid': inid, 
		  'subtypes':subtypes,
		  'ssid': ssid, 
		  'noofcommits':noofcommits,
		  'subtypeof':subtypeof,
		  'title':title,
		  'uri':preuri,
		  'relations':relations,
		  'noofchangesaftercommit':noofchangesaftercommit,
		  'instances':instances,
		  'description':description,
		  'attributes':attributes,
		  'relationtypes':relationtypes,
		  'history':history,
		  'attributetypes':attributetypes,
		  'uid':uid,
		  'instanceof':instanceof,
		  'structure':structure
		  }
	
		insertionDict = obj.insertionDict(insertionDict)

		""" to calculate fieldschanged, noofchangesaftercommit, changetype """
		fieldschanged = obj.fldschd(insertionDict, nt, nid, cur)
		modifications = obj.mod(fieldschanged)
		changetypes = obj.chgtyp(modifications)
	
		insertionDict.update({'fieldschanged':fieldschanged, 'noofchanges':modifications, 'changetype':changetypes})

		print "gbObjects: insertion dict"
		print insertionDict

		# do checking here of ssid, inid, nid, uid...
		
		s = storageSpec()
		gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
		gt.insert( insertionDict )

		# creating snapshot at filesystem
		createURI(preuri, inid, ssid)

	
		# Setting NBH Props in respective nodes
		
		obj.set_nbh(ssid, listofnbhfield, cur)


		# creating a pickle using the ssid
		
		dict=self.getNeighbourhood(nid,ssid)
		finaldict=dict[0]
		pickleobject(preuri,ssid,finaldict)
		
                self.conn.commit()
		self.conn.close()
	
	def getNeighbourhood( self, nid, ssid=0 ):
		"""
		"""
		
		sid = []
		queryResult = []
		cur = self.cur
		listofver = []
		dictofsnaps = {}
		listoffields=['ssid','inid','uid','noofchanges','fieldschanged','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','status','uri','title','description','attributetypes','attributes','relationtypes','relations','instanceof','structure','content']
		
		obj = def_set_checks()

		if ssid == 0:
		   sid = obj.get_ssid_from_nid(nid, cur)
		else:
		   sid=[ssid]
		
		for x in sid:
			i = 0
			dictofsnaps = {}
			queryResult = cur.execute("select * from view_o where ssid = " + str(x) + ";")
			queryResult = cur.fetchall()
			for y in listoffields:
			    dictofsnaps.update({y:queryResult[0][i]})
			    i=i+1

			print dictofsnaps
			listofver.append(dictofsnaps)

		return listofver

	def getNB( self, nid ):
		"""
		"""
		sid = []
		queryResult = []
		cur = self.cur
		listofver = []
		dictofsnaps = {}
		listoffields=['ssid','inid','uid','noofchanges','fieldschanged','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','status','uri','title','description','attributetypes','attributes','relationtypes','relations','instanceof','structure','content']
		
		obj = def_set_checks()
		sid = obj.get_ssid_from_nid(nid, cur)
		
		for x in sid:
			i = 0
			dictofsnaps = {}
			queryResult = cur.execute("select * from view_o where ssid = " + str(x) + ";")
			queryResult = cur.fetchall()
			for y in listoffields:
				if y <> 'gbtimestamp':
					dictofsnaps.update({y:queryResult[0][i]})
				i=i+1

			print dictofsnaps
			listofver.append(dictofsnaps)

		return listofver
	
	def update( self, dictParameters, insname, cmt ):
		"""
		"""

		cur = self.cur
		nt = self.nodetype

		nid = dictParameters['nid']
		ssid = dictParameters['ssid']
		from commonMethods import *
	        obj1 = gbMethods(self.conString)
		infodict = obj1.getinfoFromSSID(ssid, 'gbobjects')[0]

		try:
		    title = dictParameters['title']
		except:
		    title = infodict['title']
		    dictParameters['title'] = title

		try:
		    description = dictParameters['description']
		except:
		    description = infodict['description']
		    if description <> None:
			    dictParameters['description'] = description

		try:
		    content = dictParameters['content']
		except:
		    content = infodict['content']
		    if content <> None:
			    dictParameters['content'] = content

		try:
		    relations = dictParameters['relations']
		except:
		    relations = infodict['relations']
		    if relations <> None:
			    dictParameters['relations'] = relations

		try:
		    attributes = dictParameters['attributes']
		except:
		    attributes = infodict['attributes']
		    if attributes <> None:
			    dictParameters['attributes'] = attributes

		try:
		    instanceof = dictParameters['instanceof']
		except:
		    instanceof = infodict['instanceof']
		    if instanceof <> None:
			    dictParameters['instanceof'] = instanceof

		try:
		    structure = dictParameters['structure']
		except:
		    structure = infodict['structure']
		    dictParameters['structure'] = structure

		obj = def_set_checks()
		versiondict = obj.update_versionfields(dictParameters, 'gbobjects', cmt, cur)

		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
			inid = nidtbl.getinid( nid, nt )
	
		inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )


		dictParameters.update({'inid':inid, 'ssid':ssid})

		if versiondict['fieldschanged'] == []:
			versiondict['fieldschanged'] = [""]
			 
		if versiondict['changetype'] == []:
			versiondict['changetype'] = [2]
			
		dictParameters.update(versiondict)

		print "**********************************************"
		print "Version Dict is:",versiondict
		print "*********************************************"
		 
		print "Final Dict is :", dictParameters
		
		s = storageSpec()
		gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
		gt.insert( dictParameters )
		
		# creating snapshot at filesystem

		preuri = dictParameters['uri']
		print preuri

		# creating a pickle using the ssid
		dict=self.getNeighbourhood(nid,ssid)
		finaldict=dict[0]

		pickleobject(preuri,ssid,finaldict)
		
		self.conn.commit()
		self.conn.close()

		print "Updated"

		return ssid
