## Script (Python) "add_course"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=title,description,categoryid,languageid,username
##title=Adds Course to a collection
##

"""
	Calculating nodeid
"""

courses_ssid = context.gnowql.getlatestVersion('Courses')

Courses_info_dict = context.gnowql.getinfoFromSSID(courses_ssid,'gbobjecttypes')
no_of_courses = Courses_info_dict['instances']

if no_of_courses == None:
   counter = 2
else:
   counter = len(no_of_courses) + 2

course_nodeid='course' + str(counter)


"""
	Getting userid from the username
"""

uid = context.gnowql.getUserIdfromUsername(username)


"""
        Setting Default value if no value has been specified for the
        title,description
"""

if title == '':
   context.REQUEST.RESPONSE.redirect( context.portal_url() + '/'+ 'add_course_form?cat_ssid='+ categoryid +'&'+'msg='+'1' )
   return
   
if description == ' ':
   description = "<b"+">"+"No Description has been added to this Course."+"<b"+" />"


"""
	Preparing the dictionary for adding
	the course as an object
"""

dictParameters = {
		'nid':course_nodeid,
		'uid':uid,
		'status':'Public',
		'content':"",
		'title':[title],
		'description':description,
		'instanceof':['Courses']
		}

context.gnowql.manageAddObject( dictParameters )

"""
	Getting the latest ssid of the object(Course)
	created.
"""

course_ssid = context.gnowql.getlatestVersion( course_nodeid )
 

"""
	Creating a file at the file system
	for the new course
"""

data=[[ str( course_ssid ) ,'0']]
context.pickleCourse( course_ssid ,  data )


"""
  	Preparing a dictionary of parameters for creating
        a relation between a course and the language it
 	is in.
"""

dictParameters = {
		'uid':uid,
		'status':'Public',
		'subject1':course_ssid,
		'subject2':languageid,
		'relationtypes':'encodedin'
		 }

context.gnowql.manageAddRelation( dictParameters )


"""
	Preparing a dictionary of parameters for creating
        a relation between a course and the coursecategory it
 	belongs to.
"""

dictParameters = {
                'uid':uid,
                'status':'Public',
                'subject1':course_ssid,
                'subject2':categoryid,
                'relationtypes':'belongsto'
                 }

context.gnowql.manageAddRelation( dictParameters )


context.REQUEST.RESPONSE.redirect( context.portal_url() + '/viewCat?ssid=' + categoryid )

