# -*- coding: utf-8 -*-

#  SELF Platform: A distributed web application for collaborative
#  production of learning materials employing open standards.

#  Copyright (C) 2007, 2008 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of SELF Platform is the Free Software Foundation
#  Europe (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__docformat__ = 'plaintext'

from genericTable import *
from set_checks import *
from gbroletypes import *
from gbcontent import *

class gbrelations:
	
	def __init__( self, conString ):
		
		self.conn = psycopg2.connect(conString)
		self.cur = self.conn.cursor()
		self.nodetype = 'gbrelations'

	def set( self, dictParameters, insname ):
		cur = self.cur
		nt=self.nodetype

	        uid = dictParameters['uid']
	        
		instanceof = []
		instances = []
		relations = []
		attributes = []
		attributetypes = []
		relationtypes = ''

		try:
			status = dictParameters['status']
		except:
			status = 'Public'

		
		""" uid and uri field is mandatory for objecttypes """
		mandatory_fields = ({'uid':uid})
		
		chk_ssid = ({'instanceof':instanceof, 'instances':instances, 'attributes':attributes, 'relationtypes':relationtypes, 'relations':relations, 'attributetypes':attributetypes})
	
		obj = def_set_checks()
		obj.manflds_chk(mandatory_fields)
		status = obj.status(status)


		subject1 = dictParameters['subject1']
		subject2 = dictParameters['subject2']
		
		try:
			relationtypes = dictParameters['relationtypes']
			rtssid = []
			rtssid.append(int(str(obj.get_ssid_from_nid(relationtypes, cur)[-1])))
		except:
			return "Please Provide RelationType"

		
		# calculating sentense

		reqDict = {}
		reqDict.update({'subject1':subject1})
		reqDict.update({'subject2':subject2})
		print reqDict
		
		snt = self.sentence(reqDict, relationtypes, cur)

		# generating ssid from given nid 

		nid = str(subject1) + '_' + str(subject2)
		
		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
			inid = nidtbl.getinid( nid, nt )
	
		inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )

		# creating list of networkfield

		listofnbhfield = []
		
		listofnbhfield.append('subject1')
		listofnbhfield.append('subject2')

		# Calculating URI

		preuri = makeURI(nid, inid, nt, insname)
		print preuri

		# Checking for relation validity
		
		validatnFlag1 = obj.chk_relation(subject1, rtssid, cur)
		validatnFlag2 = obj.chk_relation(subject1, rtssid, cur)

		if validatnFlag2 == 1 or validatnFlag1 == 1:
			return "Invalid Relation"
		
		
		insertionDict = {
		'status':status,
		'inid': inid, 
		'ssid': ssid, 
		'uri':preuri,
		'relations':relations,
		'instances':instances,
		'attributes':attributes,
		'relationtypes':rtssid,
		'attributetypes':attributetypes,
		'uid':uid,
		'instanceof':instanceof,
		'subject1':subject1,
		'subject2':subject2,
		'sentence':snt,

		}

		insertionDict = obj.insertionDict(insertionDict)

			
		# do checking here of ssid, inid, nid, uid...

		print insertionDict
		
		s = storageSpec()

		gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
		gt.insert( insertionDict )

		# Setting NBH Props in respective nodes

		obj.set_nbh(ssid, listofnbhfield, cur)
		
		# creating snapshot at filesystem
		createURI(preuri, inid, ssid)

		print "Relation Added"
		self.conn.commit()
		self.conn.close()
	

	def sentence( self, dict, relationtype_nid, cur ):

		cur = self.cur
		
		subject1 = dict['subject1']
		print "subject1 one ssid", subject1
		
		subject2 = dict['subject2']
		print "subject2 one ssid", subject2
		
		if str(subject1) == '':
			return "subject1 cannot be blank."

		if str(subject2) == '':
			return "subject2 cannot be blank."

		obj = def_set_checks()
		chk_ssid = {'subject1':subject1, 'subject2':subject2}

		#obj.is_ssid_valid(chk_ssid, cur)
			
		nid1 = obj.get_nid_from_ssid(subject1, cur)
		nid2 = obj.get_nid_from_ssid(subject2, cur)

		print nid1
		print nid2
		
		sentence = str(nid1) + ' ' + str(relationtype_nid) + ' ' +str(nid2)
		
		return sentence


	def update( self, dictParameters, insname, cmt ):
		"""
		"""

		cur = self.cur
		nt = self.nodetype

		nid = dictParameters['nid']

		obj = def_set_checks()
		versiondict = obj.update_versionfields(dictParameters, 'gbrelations', cmt, cur)

		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
			inid = nidtbl.getinid( nid, nt )
	
		inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )


		dictParameters.update({'inid':inid, 'ssid':ssid})
                """
		if versiondict['fieldschanged'] == []:
			versiondict['fieldschanged'] = [""]
			 
		if versiondict['changetype'] == []:
			versiondict['changetype'] = [2]
	        """		
		dictParameters.update(versiondict)

		print "**********************************************"
		print "Version Dict is:",versiondict
		print "*********************************************"
		 
		print "Final Dict is :", dictParameters
		
		s = storageSpec()
		gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
		gt.insert( dictParameters )

		
		self.conn.commit()
		self.conn.close()

		print "Updated"
