# -*- coding: utf-8 -*-

#  parsing.py, Parsing the xml document

#  Copyright (C) 2007 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of <Program Name> is the Free Software Foundation Europe
#  (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__author__ = """Divya <divyas15@gmail.com>"""
__docformat__ = 'plaintext'

#! /usr/bin/env python

from xml.sax import make_parser
from xml.sax.handler import ContentHandler
import string,re


LOM_elements = ['general','identifier','catalog','entry','title','language','description','keyword','coverage','structure','aggregationLevel','lifeCycle','version','status','contribute','role','entity','date','metaMetadata','metadataSchema','technical','format','size','location','requirement','orComposite','type','name','minimumVersion','maximumVersion','installationRemark','otherPlatformRequirements','duration','educational','interactivityType','learningResourceType','interactivityLevel','semanticDensity','intendedEndUserRole','context','typicalAgeRange','difficulty','typicalLearningTime','rights','cost','copyrightAndOtherRestrictions','relation','kind','resource','annotation','classification','purpose','taxonPath','source','taxon','id']

LOM_category = ['general','lifeCycle','metaMetadata','technical','educational','rights','relation','annotation','classification']

general_element = ['identifier','title','language','description','keyword','coverage','structure','aggregationLevel']

lifeCycle_element = ['version','status','contribute','role','entity','date']

metaMetadata_element = ['metadataSchema']

technical_element = ['format','size','location','requirement','orComposite','type','name','minimumVersion','maximumVersion','installationRemark','otherPlatformRequirements','duration']

educational_element = ['interactivityType','learningResourceType','interactivityLevel','semanticDensity','intendedEndUserRole','context','typicalAgeRange','difficulty','typicalLearningTime']

rights_element = ['cost','copyrightAndOtherRestrictions']

relation_element = ['kind','resource']

annotation_element = []

classification_element = ['purpose','taxonPath','source','taxon','id']

lom = {}
general = {}
lifeCycle ={}
metaMetadata = {}
technical = {}
educational = {}
rights = {}
relation = {}
annotation = {}
classification = {}

identifier_dict = {}
contribute_dict = {}


identifier = []
title = []
language = []
description = []
keyword = []
coverage = []
structure = []
aggregationLevel = []
version = []
status = []
contribute = []
entity = []
metadataSchema = []
format = []
size = []
location = []
requirement = []
installationRemarks = []
otherPlatformRequirements = []
duration = []
interactivityType = []
learningResourceType = []
interactivityLevel = []
semanticDensity = []
intendedEndUserRole = []
context = []
typicalAgeRange = []
difficulty = []
typicalLearningTime = []
language = []
cost = []
copyrightAndOtherRestrictions = []
kind = []
resource = []
date = []
purpose = []
taxonPath = []


class LOMparse(ContentHandler):
    """
    Parse the LOM section of the manifest file and collects all the given info
    """

    def __init__(self):
        """
        Initialize flags for LOM elements of SCORM 
        """
        
        self.isOrganization = 0
        self.isMetadata = 0
        self.meta_count = 0

        self.islom = 0
        self.isGeneral = 0
        self.isIdentifier = 0
        self.isCatalog = 0
        self.isEntry = 0
        self.isTitle = 0
        self.isLangstr = 0
        self.isLanguage = 0
        self.isDescription = 0
        self.isKeyword = 0
        self.isCoverage = 0
        self.isStructure = 0
        self.isValue = 0
        self.isAggregationLevel = 0
        self.isLifeCycle = 0
        self.isVersion = 0
        self.isStatus = 0
        self.isContribute = 0
        self.isRole = 0
        self.isEntity = 0
        self.isDate = 0
        self.isDateTime = 0
        self.isMetaMetadata = 0
        self.isMetadataSchema = 0
        self.isTechnical = 0
        self.isFormat = 0
        self.isSize = 0
        self.isLocation = 0
        self.isRequirement = 0
        self.isOrComposite = 0
        self.isType = 0
        self.isName = 0
        self.isMinimumVersion = 0
        self.isMaximumVersion = 0
        self.isInstallationRemark = 0
        self.isOtherPlatformRequirements = 0
        self.isDuration = 0
        self.isEducational = 0
        self.isInteractivityType = 0
        self.isLearningResourceType = 0
        self.isInteractivityLevel = 0
        self.isSemanticDensity = 0
        self.isIntendedEndUserRole = 0
        self.isContext = 0
        self.isTypicalAgeRange = 0
        self.isDifficulty = 0
        self.isTypicalLearningTime = 0
        self.isRights = 0
        self.isCost = 0
        self.isCopyrightAndOtherRestrictions = 0
        self.isRelation = 0
        self.isKind = 0
        self.isResource = 0
        self.isAnnotation = 0
        self.isClassification = 0
        self.isPurpose = 0
        self.isTaxonPath = 0
        self.isSource = 0
        self.isTaxon = 0
        self.isId = 0

    
    def startElement(self, name, attrs):
        """
        Check for start elements of the manifest file & switch on LOM flags
	"""
        data= name.split(':')
        print "open : "+data[-1]

        if data[-1] == 'metadata':
            self.isMetadata = 1
            self.meta_count += 1

        if data[-1] == 'lom':
            self.islom = 1

#         If data[-1] in LOM_elements:
#             lom_var = 'is' + data[-1]
#             self.lom_var = 1
#             if data[-1] in ['general','lifeCycle','metaMetadata','technical','educational','rights','relation','annotation','classification','identifier','contribute','requirement','orComposite','resource','taxonPath','taxon']:
#                 pass
#             else:
#                 self.data[-1] = ""

        if data[-1] == 'general' and self.islom:
            self.isGeneral = 1
            identifier.append([])
            title.append([])
            language.append([])
            description.append([])
            keyword.append([])
            coverage.append([])
            structure.append([])
            aggregationLevel.append([])

        if data[-1] == 'identifier' and self.islom:
            self.isIdentifier = 1

        if data[-1] == 'catalog' and self.islom:
            self.isCatalog = 1
            self.catalog = ""

        if data[-1] == 'entry' and self.islom:
            self.isEntry = 1
            self.entry = ""

        if data[-1] == 'title' and self.islom:
            self.isTitle = 1
            self.title = ""

        if data[-1] == 'langstring' or data[-1] == 'string' and self.islom:
            self.isLangstr = 1

        if data[-1] == 'description' and self.islom:
            self.isDescription = 1
            self.description = ""

        if data[-1] == 'keyword' and self.islom:
            self.isKeyword = 1
            self.keyword = ""

        if data[-1] == 'coverage' and self.islom:
            self.isCoverage = 1
            self.coverage = ""

        if data[-1] == 'structure' and self.islom:
            self.isStructure = 1
            self.structure = ""

        if data[-1] == 'value' and self.islom:
            self.isValue = 1

        if data[-1] == 'aggregationLevel' and self.islom:
            self.isAggregationLevel = 1
            self.aggregationLevel = ""

        if data[-1] in ['lifeCycle','lifecycle'] and self.islom:
            self.isLifeCycle = 1
            version.append([])
            status.append([])
            contribute.append([])
            entity.append([])

        if data[-1] == 'version' and self.islom:
            self.isVersion = 1
            self.version = ""

        if data[-1] == 'status' and self.islom:
            self.isStatus = 1
            self.status = ""

        if data[-1] == 'contribute' and self.islom:
            self.isContribute = 1

        if data[-1] == 'role' and self.islom:
            self.isRole = 1
            self.role = ""

        if data[-1] == 'entity' and self.islom:
            self.isEntity = 1
            self.entity = ""
            
        if data[-1] == 'date' and self.islom:
            self.isDate = 1

        if data[-1] == 'dateTime' and self.islom:
            self.isDateTime = 1
            self.dateTime = ""

        if data[-1] == 'metaMetadata' and self.islom:
            self.isMetaMetadata = 1
            identifier.append([])
            contribute.append([])
            entity.append([])
            metadataSchema.append([])
            language.append([])

        if data[-1] == 'metadataSchema' and self.islom:
            self.isMetadataSchema = 1
            self.metadataSchema = ""

        if data[-1] == 'language' and self.islom:
            self.isLanguage = 1
            self.language = ""

        if data[-1] == 'technical' and self.islom:
            self.isTechnical = 1
            format.append([])
            size.append([])
            location.append([])
            requirement.append([])
            installationRemarks.append([])
            otherPlatformRequirements.append([])
            duration.append([])

        if data[-1] == 'format' and self.islom:
            self.isFormat = 1
            self.format = ""

        if data[-1] == 'size' and self.islom:
            self.isSize = 1
            self.size = ""

        if data[-1] == 'location' and self.islom:
            self.isLocation = 1
            self.location = ""

        if data[-1] == 'requirement' and self.islom:
            self.isRequirement = 1
            
        if data[-1] == 'orComposite' and self.islom:
            self.isOrComposite = 1
            
        if data[-1] == 'type' and self.islom:
            self.isType = 1
            self.type = ""
            
        if data[-1] == 'name' and self.islom:
            self.isName = 1
            self.name = ""
            
        if data[-1] == 'minimumVersion' and self.islom:
            self.isMinimumVersion = 1
            self.minimumVersion = ""
            
        if data[-1] == 'maximumVersion' and self.islom:
            self.isMaximumVersion = 1
            self.maximumVersion = ""
            
        if data[-1] == 'installationRemark' and self.islom:
            self.isIinstallationRemark = 1
            self.installationRemark = ""
            
        if data[-1] == 'otherPlatformRequirements' and self.islom:
            self.isOtherPlatformRequirements = 1
            self.otherPlatformRequirements = ""
            
        if data[-1] == 'duration' and self.islom:
            self.isDuration = 1
            self.duration = ""
            
        if data[-1] == 'educational' and self.islom:
            self.isEducational = 1
            interactivityType.append([])
            learningResourceType.append([])
            interactivityLevel.append([])
            semanticDensity.append([])
            intendedEndUserRole.append([])
            context.append([])
            typicalAgeRange.append([])
            difficulty.append([])
            typicalLearningTime.append([])
            duration.append([])
            language.append([])
            
        if data[-1] in ['interactivityType','interactivitytype'] and self.islom:
            self.isInteractivityType = 1
            self.interactivityType = ""
            
        if data[-1] in ['learningResourceType','learningresourcetype'] and self.islom:
            self.isLearningResourceType = 1
            self.learningResourceType = ""
            
        if data[-1] in ['interactivityLevel','interactivitylevel'] and self.islom:
            self.isInteractivityLevel = 1
            self.interactivityLevel = ""
            
        if data[-1] in ['semanticDensity','semanticdensity'] and self.islom:
            self.isSemanticDensity = 1
            self.semanticDensity = ""
            
        if data[-1] in ['intendedEndUserRole','intendedenduserrole'] and self.islom:
            self.isIntendedEndUserRole = 1
            self.intendedEndUserRole = ""
            
        if data[-1] == 'context' and self.islom:
            self.isContext = 1
            self.context = ""
            
        if data[-1] in ['typicalAgeRange','typicalagerange'] and self.islom:
            self.isTypicalAgeRange = 1
            self.typicalAgeRange = ""
            
        if data[-1] == 'difficulty' and self.islom:
            self.isDifficulty = 1
            self.difficulty = ""
            
        if data[-1] in ['typicalLearningTime','typicallearningtime'] and self.islom:
            self.isTypicalLearningTime = 1
            self.typicalLearningTime = ""
            
        if data[-1] == 'rights' and self.islom:
            self.isRights = 1
            cost.append([])
            copyrightAndOtherRestrictions.append([])
            description.append([])
            
        if data[-1] == 'cost' and self.islom:
            self.isCost = 1
            self.cost = ""
            
        if data[-1] in ['copyrightAndOtherRestrictions','copyrightandotherrestrictions'] and self.islom:
            self.isCopyrightAndOtherRestrictions = 1
            self.copyrightAndOtherRestrictions = ""
            
        if data[-1] == 'relation' and self.islom:
            self.isRelation = 1
            kind.append([])
            resource.append([])
            
            
        if data[-1] == 'kind' and self.islom:
            self.isKind = 1
            self.kind = ""
            
        if data[-1] == 'resource' and self.islom:
            self.isResource = 1
            identifier.append([])
            description.append([])
            
        if data[-1] == 'annotation' and self.islom:
            self.isAnnotation = 1
            entity.append([])
            date.append([])
            description.append([])
        
        if data[-1] == 'classification' and self.islom:
            self.isClassification = 1
            purpose.append([])
            taxonPath.append([])
            description.append([])
            keyword.append([])
            
        if data[-1] == 'purpose' and self.islom:
            self.isPurpose = 1
            self.purpose = ""
            
        if data[-1] == 'taxonPath' and self.islom:
            self.isTaxonPath = 1
            
        if data[-1] == 'source' and self.islom:
            self.isSource = 1
            self.source = ""
            
        if data[-1] =='taxon' and self.islom:
            self.isTaxon = 1
            
        if data[-1] == 'id' and self.islom:
            self.isId = 1
            self.id = ""

    def characters(self, ch):
        """
        Collects the Element's Character Set
	"""

        if self.islom and self.isGeneral:
            if self.isIdentifier:
                if self.isCatalog:
                    self.catalog += ch
                elif self.isEntry:
                    self.entry += ch
            elif self.isTitle and self.isLangstr:
                self.title += ch
            elif self.isLanguage:
                self.language += ch
            elif self.isDescription and self.isLangstr:
                self.description += ch
            elif self.isKeyword and self.isLangstr:
                self.keyword += ch
            elif self.isCoverage and self.isLangstr:
                self.coverage += ch
            elif self.isStructure and self.isValue:
                self.structure += ch
            elif self.isAggregationLevel and self.isValue:
                self.aggregationLevel += ch

        if self.islom and self.isLifeCycle:
            if self.isVersion and self.isLangstr:
                self.version += ch
            elif self.isStatus and self.isValue:
                self.status += ch
            elif self.isContribute:
                if self.isRole and self.isValue:
                    self.role += ch
                elif self.isEntity:
                    self.entity += ch
                elif self.isDate and self.isDateTime:
                    self.date += ch

        if self.islom and self.isMetaMetadata:
            if self.isIdentifier:
                if self.isCatalog:
                    self.catalog += ch
                elif self.isEntry:
                    self.entry += ch
            elif self.isContribute:
                if self.isRole and self.isValue:
                    self.role += ch
                elif self.isEntity:
                    self.entity += ch
                elif self.isDate and self.isDateTime:
                    self.date += ch
            elif self.isMetadataSchema:
                self.metadataSchema += ch
            elif self.isLanguage:
                self.language += ch

        if self.islom and self.isTechnical:
            if self.isFormat:
                self.format += ch
            elif self.isSize:
                self.size += ch
            elif self.isLocation:
                self.location += ch
            elif self.isRequirement and self.isOrComposite and self.isType and self.isValue:
                self.type += ch
            elif self.isRequirement and self.isOrComposite and self.isName and self.isValue:
                self.name += ch
            elif self.isRequirement and self.isOrComposite and self.isMinimumVersion:
                self.minimumVersion += ch
            elif self.isRequirement and self.isOrComposite and self.isMaximumVersion:
                self.maximumVersion += ch
            elif self.isInstallationRemarks and self.isLangstr:
                self.installationRemarks += ch
            elif self.isOtherPlatformRequirements and self.Langstr:
                self.otherPlatformRequirements += ch
            elif self.isDuration and self.isDuration:
                self.duration += ch

        if self.islom and self.isEducational:
            if self.isInteractivityType and self.isValue:
                self.interactivityType += ch
            elif self.isLearningResourceType and self.isValue:
                self.learningResourceType += ch
            elif self.isInteractivityLevel and self.isValue:
                self.interactivityLevel += ch
            elif self.isSemanticDensity and self.isValue:
                self.semanticDensity += ch
            elif self.isIntendedEndUserRole and self.isValue:
                self.intendedEndUserRole += ch
            elif self.isContext and self.isValue:
                self.context += ch
            elif self.isTypicalAgeRange and self.isLangstr:
                self.typicalAgeRange += ch
            elif self.isDifficulty and self.isValue:
                self.difficulty += ch
            elif self.isTypicalLearningTime and self.isDuration:
                self.typicalLearningTime += ch
            elif self.isLanguage:
                self.language += ch

        if self.islom and self.isRights:
            if self.isCost and self.isValue:
                self.cost += ch
            elif self.isCopyrightAndOtherRestrictions and self.isValue:
                self.copyrightAndOtherRestrictions += ch
            elif self.isDescription and self.isLangstr:
                self.description += ch

        if self.islom and self.isRelation:
            if self.isKind and self.isValue:
                self.kind += ch
            elif self.isResource:
                if self.isIdentifier:
                    if self.isCatalog:
                        self.catalog += ch
                    elif self.isEntry:
                        self.entry += ch
                elif self.isDescription and self.isLangstr:
                    self.description += ch

        if self.islom and self.isAnnotation:
            if self.isEntity:
                self.entity += ch
            elif self.isDate and self.isDateTime:
                self.date += ch
            elif self.isDescription and (not self.isDate):
                self.description += ch

        if self.islom and self.isClassification:
            if self.isPurpose and self.isValue:
                self.purpose += ""
            elif self.isTaxonPath:
                if self.isSource and self.isLangstr:
                    self.source += ch
                elif self.isTaxon :
                    if self.isId:
                        self.id += ch
                    elif self.isEntry and self.isLangstr:
                        self.entry += ch
            elif self.isDescription and self.isLangstr:
                self.description += ch
            elif self.isKeyword and self.isLangstr:
                self.keyword += ch

#         if self.isLom and self.isGeneral and self.isIdentifier and self.isCatalog:
#             self.catalog = self.catalog + ch

#         if self.osLom and self.isGeneral and self.isIdentifier and self.isEntry:
#             self.entry = self.entry + ch

#         if self.isLom and self.isGeneral and self.isTitle and self.isLangstr:
#             self.title = self.title + ch

#         if self.isLom and self.isGeneral and self.isDescription and self.isLangstr:
#             self.description = self.description + ch

#         if self.isLom and self.isGeneral and self.isKeyword and self.isLangstr:
#             self.keyword = self.keyword + ch

#         if self.isLom and self.isGeneral and self.isCoverage and self.isLangstr:
#             self.coverage = self.coverage + ch

#         if self.isLom and self.isGeneral and self.isStructure and self.isValue:
#             self.structure = self.structure + ch

#         if self.isLom and self.isGeneral and self.isAggregationLevel and self.isValue:
#             self.aggregationLevel = ch

#         if self.isLom and self.isLifeCycle and self.isVersion and self.isLangstr:
#             self.version = self.version + ch

#         if self.isLom and self.isLifeCycle and self.isStatus and self.isValue:
#             self.status = self.status + ch

#         if self.isLom and self.isLifeCycle and self.isContribute and self.isRole and self.isValue:
#             self.role = self.role + ch

#         if self.isLom and self.isLifeCycle and self.isContribute and self.isEntity:
#             self.entity = self.entity + ch

#         if self.isLom and self.isLifeCycle and self.isContribute and self.isDate and self.isDateTime:
#             self.dateTime = self.dateTime + ch

#         if self.isLom and self.isMetaMetadata and self.isIdentifier and self.isCatalog:
#             self.catalog = self.catalog + ch

#         if self.isLom and self.isMetaMetadata and self.isIdentifier and self.isEntry:
#             self.entry = self.entry + ch

#         if self.isLom and self.isMetaMetadata and self.isContribute and self.isRole and self.isValue:
#             self.role = self.role + ch

#         if self.isLom and self.isMetaMetadata and self.isContribute and self.isEntity:
#             self.entity = self.entity + ch

#         if self.isLom and self.isMetaMetadata and self.isContribute and self.isDate and self.isDateTime:
#             self.dateTime = self.dateTime + ch

#         if self.isLom and self.isMetaMetadata and self.isMetadataSchema:
#             self.metadataSchema = self.metadataSchema + ch

#         if self.isLom and self.isMetaMetadata and self.isLanguage:
#             self.language += ch

#         if self.isLom and self.isTechnical and self.isFormat:
#             self.format += ch

#         if self.isLom and self.isTechnical and self.isSize:
#             self.size += ch

#         if self.isLom and self.isTechnical and self.isLocation:
#             self.location += ch
            

    def endElement(self, name):
        """
        Check for end elements of the manifest file & switch off their respective flags
	"""

        data = name.split(':')
        print "close : "+data[-1]

#         if data[-1] in LOM_elements:
#             lom_var = 'is' + data[-1]
#             self.lom_var = 0

        
#            if data[-1] in LOM_category:
#                pass
#            elif data[-1] in ['identifier','language','description','keyword','coverage','contribute','entity','metadataSchema','format','location','requirement','orComposite','educational','learningResourceType','intendedEndUserRole','context','typicalAgeRange','relation','resource','annotation','classification','taxonPath','taxon']:
                

        if data[-1] == 'identifier' and self.islom:
            self.isIdentifier = 0

        if data[-1] == 'catalog' and self.islom:
            self.isCatalog = 0
            identifier[-1].append({'catalog':self.catalog})

        if data[-1] == 'entry' and self.islom:
            self.isEntry = 0
            identifier[-1][-1]['entry'] = self.entry

        if (data[-1] == 'langstring' or data[-1] == 'string') and self.islom:
            self.isLangstr = 0

        if data[-1] == 'title' and self.islom:
            self.isTitle = 0
            title[-1].append(self.title)

        if data[-1] == 'language'and self.islom:
            self.isLanguage = 0
            language[-1].append(self.language)

        if data[-1] == 'description' and self.islom:
            self.isDescription = 0
            description[-1].append(self.description)

        if data[-1] == 'keyword' and self.islom:
            self.isKeyword = 0
            keyword[-1].append(self.keyword)
            
        if data[-1] == 'coverage' and self.islom:
            self.isCoverage = 0
            coverage[-1].append(self.coverage)

        if data[-1] == 'structure' and self.islom:
            self.isStructure = 0
            structure[-1].append(self.structure)

        if data[-1] == 'value' and self.islom:
            self.isValue = 0

        if data[-1] in ['aggregationLevel','aggregationlevel'] and self.islom:
            self.isAggregationLevel = 0
            aggregationLevel[-1].append(self.aggregationLevel)

        if data[-1] == 'general' and self.islom:
            self.isGeneral = 0
            general['identifier'] = identifier[-1]
            general['title'] = title[-1]
            general['language'] = language[-1]
            general['description'] = description[-1]
            general['keyword'] = keyword[-1]
            general['coverage'] = coverage[-1]
            general['structure'] = structure[-1]
            general['aggregationLevel'] = aggregationLevel[-1]
            print general

        if data[-1] == 'version' and self.islom:
            self.isVersion = 0
            version[-1].append(self.version)

        if data[-1] == 'status' and self.islom:
            self.isStatus = 0
            status[-1].append(self.status)

        if data[-1] == 'contribute' and self.islom:
            self.isContribute = 0
            contribute[-1][-1]['entity'] = entity[-1]

        if data[-1] == 'role' and self.islom:
            self.isRole = 0
            print self.role
            print contribute
            contribute[-1].append({'role':self.role})

        if data[-1] == 'entity' and self.islom:
            self.isEntity = 0
            entity[-1].append(self.entity)

        if data[-1] == 'date' and self.islom:
            self.isDate = 0
            contribute[-1][-1]['date'] = self.date

        if data[-1] == 'dateTime' and self.islom:
            self.dateTime = 0

        if data[-1] in ['lifeCycle','lifecycle'] and self.islom:
            self.isLifeCycle = 0
            lifeCycle['version'] = version[-1]
            lifeCycle['status'] = status[-1]
            lifeCycle['contribute']= contribute[-1]

        if data[-1] == 'metadataSchema' and self.islom:
            self.isMetadataSchema = 0
            metadataSchema[-1].append(self.metadataSchema)

        
 
        if data[-1] == 'metaMetadata' and self.islom:
            self.isMetaMetadata = 0
            metaMetadata['identifier'] = identifier[-1]
            metaMetadata['contribute'] = contribute[-1]
            metaMetadata['metadataSchema'] = metadataSchema[-1]
            metaMetadata['language'] = language[-1]

        if data[-1] == 'format' and self.islom:
            self.isFormat = 0
            format[-1].append(self.format)

        if data[-1] == 'size' and self.islom:
            self.isSize = 0
            size[-1].append(self.size)

        if data[-1] == 'location' and self.islom:
            self.isLocation = 0
            location[-1].append(self.location)

        if data[-1] == 'requirement' and self.islom:
            self.isRequirement = 0
            
        if data[-1] == 'orComposite' and self.islom:
            self.isOrComposite = 0
            
        if data[-1] == 'type' and self.islom:
            self.isType = 0
            requirement[-1].append({'type':self.type})
            
        if data[-1] == 'name' and self.islom:
            self.isName = 0
            requirement[-1][-1]['name'] = self.name
            
        if data[-1] == 'minimumVersion' and self.islom:
            self.isMinimumVersion = 0
            requirement[-1][-1]['minimumVersion'] = self.minimumVersion
            
        if data[-1] == 'maximumVersion' and self.islom:
            self.isMaximumVersion = 0
            requirement[-1][-1]['maximumVersion'] = self.maximumVersion
            
        if data[-1] == 'installationRemark' and self.islom:
            self.isInstallationRemark = 0
            installationRemarks[-1].append(self.installationRemarks)
            
        if data[-1] == 'otherPlatformRequirements' and self.islom:
            self.isOtherPlatformRequirements = 0
            otherPlatformRequirements[-1].append(self.otherPlatformRequirements)
            
        if data[-1] == 'duration' and self.islom:
            self.isDuration = 0
            duration[-1].append(self.duration)

        if data[-1] == 'technical' and self.islom:
            self.isTechnical = 0
            technical['format'] = format[-1]
            technical['size'] = size[-1]
            technical['location'] = location[-1]
            technical['requirement'] = requirement[-1]
            technical['installationRemarks'] = installationRemarks[-1]
            technical['otherPlatformRequirements'] = otherPlatformRequirements[-1]
            technical['duration'] = duration[-1]
            
        if data[-1] == 'educational' and self.islom:
            self.isEducational = 0
            educational['interactivityType'] = interactivityType[-1]
            educational['learningResourceType'] = learningResourceType[-1]
            educational['interactivityLevel'] = interactivityLevel[-1]
            educational['semanticDensity'] = semanticDensity[-1]
            educational['intendedEndUserRole'] = intendedEndUserRole[-1]
            educational['context'] = context[-1]
            educational['typicalAgeRange'] = typicalAgeRange[-1]
            educational['difficulty'] = difficulty[-1]
            educational['typicalLearningTime'] = typicalLearningTime[-1]
            educational['description'] = description[-1]
            educational['language'] = language[-1]
            
        if data[-1] in ['interactivityType','interactivitytype'] and self.islom:
            self.isInteractivityType = 0
            interactivityType[-1].append(self.interactivityType)
                        
        if data[-1] in ['learningResourceType','learningresourcetype'] and self.islom:
            self.isLearningResourceType = 0
            learningResourceType[-1].append(self.learningResourceType)
            
        if data[-1] in ['interactivityLevel','interactivitylevel'] and self.islom:
            self.isInteractivityLevel = 0
            interactivityLevel[-1].append(self.interactivityLevel)
            
        if data[-1] in ['semanticDensity','semanticdensity'] and self.islom:
            self.isSemanticDensity = 0
            semanticDensity[-1].append(self.semanticDensity)
            
        if data[-1] in ['intendedEndUserRole','intendedenduserrole'] and self.islom:
            self.isIntendedEndUserRole = 0
            intendedEndUserRole[-1].append(self.intendedEndUserRole)
            
        if data[-1] == 'context' and self.islom:
            self.isContext = 0
            context[-1].append(self.context)
            
        if data[-1] in ['typicalAgeRange','typicalrgerange'] and self.islom:
            self.isTypicalAgeRange = 0
            typicalAgeRange[-1].append(self.typicalAgeRange)
            
        if data[-1] == 'difficulty' and self.islom:
            self.isDifficulty = 0
            difficulty[-1].append(self.difficulty)
            
        if data[-1] in ['typicalLearningTime','typicallearningtime'] and self.islom:
            self.isTypicalLearningTime = 0
            typicalLearningTime[-1].append(self.typicalLearningTime)
            
        if data[-1] == 'rights' and self.islom:
            self.isRights = 0
            rights['cost'] = cost[-1]
            rights['copyrightAndOtherRestrictions'] = copyrightAndOtherRestrictions[-1]
            rights['description'] = description[-1]
            
        if data[-1] == 'cost' and self.islom:
            self.isCost = 0
            cost[-1].append(self.cost)
            
        if data[-1] in ['copyrightAndOtherRestrictions','copyrightandotherrestrictions'] and self.islom:
            self.isCopyrightAndOtherRestrictions = 0
            copyrightAndOtherRestrictions[-1].append(self.copyrightAndOtherRestrictions)
            
        if data[-1] == 'relation' and self.islom:
            self.isRelation = 0
            relation['kind'] = kind[-1]
            relation['resource'] = resource[-1]
            
        if data[-1] == 'kind' and self.islom:
            self.isKind = 0
            kind[-1].append(self.kind)
            
        if data[-1] == 'resource' and self.islom:
            self.isResource = 0
            resource[-1].append({'identifier':identifier[-1]})
            resource[-1][-1]['description'] = description[-1]
            
        if data[-1] == 'annotation' and self.islom:
            self.isAnnotation = 0
            annotation['entity'] = entity[-1]
            annotation['date'] = date[-1]
            annotation['description'] = description[-1]
            
        if data[-1] == 'classification' and self.islom:
            self.isClassification = 0
            classification['purpose'] = purpose[-1]
            classification['taxonPath'] = taxonPath[-1]
            classification['description'] = description[-1]
            classification['keyword'] = keyword[-1]
            
        if data[-1] == 'purpose' and self.islom:
            self.isPurpose = 0
            purpose[-1].append(self.purpose)
            
        if data[-1] == 'taxonPath' and self.islom:
            self.isTaxonPath = 0
                        
        if data[-1] == 'source' and self.isTaxonPath and self.islom:
            self.isSource = 0
            taxonPath[-1].append({'source':self.source})
            
        if data[-1] == 'taxon' and self.islom:
            self.isTaxon = 0
            taxonPath[-1][-1]['taxonId'] = self.id
            taxonPath[-1][-1]['taxonEntry'] = self.entry
            
        if data[-1] == 'id' and self.islom:
            self.isId = 0

        if data[-1] == 'lom':
            self.islom = 0
            lom['general'] = general
            lom['lifeCycle'] = lifeCycle
            lom['metaMetadata'] = metaMetadata
            lom['tachnical'] = technical
            lom['educational'] = educational
            lom['rights'] = rights
            lom['relation'] = relation
            lom['annotation'] = annotation
            lom['classification'] = classification

    def LOMCollection(self):
            return lom
      
