# -*- coding: utf-8 -*-

#  SELF Platform: A distributed web application for collaborative
#  production of learning materials employing open standards.

#  Copyright (C) 2007, 2008 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of SELF Platform is the Free Software Foundation
#  Europe (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.


__author__ = """Nagarjuna <nagarjun@gnowledge.org>"""
__docformat__ = 'plaintext'

import os.path
import sys
import cPickle
from StringIO import StringIO
from sets import Set
from App.Common import package_home
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.utils import manage_addTool
from Products.ExternalMethod.ExternalMethod import ExternalMethod
from zExceptions import NotFound, BadRequest

from Products.Archetypes.Extensions.utils import installTypes
from Products.Archetypes.Extensions.utils import install_subskin
from Products.Archetypes.config import TOOL_NAME as ARCHETYPETOOLNAME
from Products.Archetypes.atapi import listTypes
from Products.selfApp.config import PROJECTNAME
from Products.selfApp.config import product_globals as GLOBALS

def install(self, reinstall=False):
    """ External Method to install selfApp """
    out = StringIO()
    print >> out, "Installation log of %s:" % PROJECTNAME

    # If the config contains a list of dependencies, try to install
    # them.  Add a list called DEPENDENCIES to your custom
    # AppConfig.py (imported by config.py) to use it.
    try:
        from Products.selfApp.config import DEPENDENCIES
    except:
        DEPENDENCIES = []
    portal = getToolByName(self,'portal_url').getPortalObject()
    quickinstaller = portal.portal_quickinstaller
    for dependency in DEPENDENCIES:
        print >> out, "Installing dependency %s:" % dependency
        quickinstaller.installProduct(dependency)
        get_transaction().commit(1)

    classes = listTypes(PROJECTNAME)
    installTypes(self, out,
                 classes,
                 PROJECTNAME)
    install_subskin(self, out, GLOBALS)


    # try to call a workflow install method
    # in 'InstallWorkflows.py' method 'installWorkflows'
    try:
        installWorkflows = ExternalMethod('temp', 'temp',
                                          PROJECTNAME+'.InstallWorkflows',
                                          'installWorkflows').__of__(self)
    except NotFound:
        installWorkflows = None

    if installWorkflows:
        print >>out,'Workflow Install:'
        res = installWorkflows(self,out)
        print >>out,res or 'no output'
    else:
        print >>out,'no workflow install'




    from Products.selfApp.config import STYLESHEETS
    try:
        portal_css = getToolByName(portal, 'portal_css')
        for stylesheet in STYLESHEETS:
            try:
                portal_css.unregisterResource(stylesheet['id'])
            except:
                pass
            defaults = {'id': '',
            'media': 'all',
            'enabled': True}
            defaults.update(stylesheet)
            portal_css.registerStylesheet(**defaults)
    except:
        # No portal_css registry
        pass
    from Products.selfApp.config import JAVASCRIPTS
    try:
        portal_javascripts = getToolByName(portal, 'portal_javascripts')
        for javascript in JAVASCRIPTS:
            try:
                portal_javascripts.unregisterResource(javascript['id'])
            except:
                pass
            defaults = {'id': ''}
            defaults.update(javascript)
            portal_javascripts.registerScript(**defaults)
    except:
        # No portal_javascripts registry
        pass

    # try to call a custom install method
    # in 'AppInstall.py' method 'install'
    try:
        install = ExternalMethod('temp', 'temp',
                                 PROJECTNAME+'.AppInstall', 'install')
    except NotFound:
        install = None

    if install:
        print >>out,'Custom Install:'
        try:
            res = install(self, reinstall)
        except TypeError:
            res = install(self)
        if res:
            print >>out,res
        else:
            print >>out,'no output'
    else:
        print >>out,'no custom install'

    inspath = self.portal_url()
    splitpath = inspath.split('/')

    insname = str(splitpath[-1])
    
    Gno_data_path = CLIENT_HOME + "/GB/" + insname  + "/"
    subdirs = ["gbnidinidtable","gbmetatypes","gbobjecttypes","gbobjects","gbrelations","gbrelationtypes","gbattributes","gbattributetypes","gbprocess","gbprocesstypes","gbsystem","gbsystemtypes","gbfunctiontypes","gbclasstypes","gbclass","gbflowtypes","gbflows", "gbusers", "gbusertypes"]
    for each in subdirs:
        if not(os.path.exists(Gno_data_path + each)):
            os.makedirs(Gno_data_path + each)
    
    self.manage_addProduct['LocalFS'].manage_addLocalFS('Data', '', Gno_data_path)
    self.manage_addProduct['ZTinyMCE'].manage_addZTinyMCE('TinyMCE', title='TinyMCE TextEditor')
    
    self.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection('dbadapter', 'Connection to PG', '', zdatetime=None, tilevel=2, check=None, REQUEST=None)
    

    os.system('cp /opt/Plone-2.5.2/zeocluster/Products/selfApp/Extensions/DB_connectionString.txt /tmp/')
    fp = open('/tmp/DB_connectionString.txt')
    conparam = []
    for line in fp.readlines():
        conparam = line.split(':')

    conString = conparam[0]+' '+conparam[1]+' '+conparam[2]+' '+conparam[3]+' '+conparam[4]
    
    print conString
    self.dbadapter.connection_string = conString
    self.dbadapter.encoding = 'UTF-8'

    self.dbadapter.manage_open_connection()

    self.invokeFactory('gnowQL', 'gnowql')
    

    """
    Creating ObjectTypes For SELF-Platform
    """
    os.system('cp /opt/Plone-2.5.2/zeocluster/Products/selfApp/Extensions/SCORMTables.txt /tmp/')
    file = open('/tmp/SCORMTables.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')

            # Creating Dict
            
            nid = array[0].replace(' ','')
            title=array[0]
            alttitle=array[1]            
            description=array[2]
            instanceOf=array[4]
            subTypeOf=array[5]

            instanceof = []
            
            if nid == 'SCO' or nid == 'Bookshelf':
                dictParameters = {
                    'nid':nid,
                    'uid':'1',
                    'status':'Public',
                    'content':'',
                    'subtypes':[],
                    'noofcommits':'0',
                    'subtypeof':[],
                    'title':[title,alttitle],
                    'instanceof':[],
                    'relations':[],
                    'noofchangesaftercommit':'0',
                    'instances':[],
                    'description':description,
                    'attributes':[],
                    'relationtypes':[],
                    'history':[0],
                    'attributetypes':[]
                    
                    }

            else:
                dictParameters = {
                    'nid':nid,
                    'uid':'1',
                    'status':'Public',
                    'content':'',
                    'subtypes':[],
                    'noofcommits':'0',
                    'subtypeof':[subTypeOf],
                    'title':[title,alttitle],
                    'instanceof':instanceof,
                    'relations':[],
                    'noofchangesaftercommit':'0',
                    'instances':[],
                    'description':description,
                    'attributes':[],
                    'relationtypes':[],
                    'history':[0],
                    'attributetypes':[]
                    
                    }
            
            self.gnowql.manageAddObjectType( dictParameters )
            print "Added ---", nid

    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /opt/Plone-2.5.2/zeocluster/Products/selfApp/Extensions/SCORMAttributeTypes.txt /tmp/')
    file = open('/tmp/SCORMAttributeTypes.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')
            print array
            
            # Creating Dict
            
            nid = array[0].replace(' ','')
            title=array[0]
            description=array[1]
            status = array[2]
            datatype=array[3]
            subjecttypes=array[4]

            lstofsubtype = []
            lstofsubtype = subjecttypes.split('~')
            
            print "RECORD ::: ",nid, "--", title, "---", description, "---", datatype, "---", lstofsubtype
            
            print subjecttypes
            
            subTypeOf=[]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'subtypeof':[],
                'title':[title],
                'description':description,
                'datatype':datatype,
                'subjecttypes':lstofsubtype
                }

            print dictParameters
            self.gnowql.manageAddAttributeType( dictParameters )
            print "Added ---", nid

    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /opt/Plone-2.5.2/zeocluster/Products/selfApp/Extensions/SCORMLOMMetadata.txt /tmp/')
    file = open('/tmp/SCORMLOMMetadata.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')
            print array
            
            # Creating Dict
            
            nid = array[0]
            title=array[1]
            alttitle=array[2]
            description=array[3]
            status = array[4]
            datatype=array[5]
            subjecttypes=array[6]
            print "RECORD ::: ",nid, "--", title, "---", description, "---", datatype, "---", subjecttypes
            
            print subjecttypes
            
            subTypeOf=[]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'subtypeof':[],
                'title':[title,alttitle],
                'description':description,
                'datatype':datatype,
                'subjecttypes':[subjecttypes]
                }

            print dictParameters
            self.gnowql.manageAddAttributeType( dictParameters )
            print "Added ---", nid

    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /opt/Plone-2.5.2/zeocluster/Products/selfApp/Extensions/SCORMSEQMetadata.txt /tmp/')
    file = open('/tmp/SCORMSEQMetadata.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')
            print array
            
            # Creating Dict
            
            nid = array[0]
            title=array[1]
            alttitle=array[2]
            description=array[3]
            status = array[4]
            datatype=array[5]
            subjecttypes=array[6]
            print "RECORD ::: ",nid, "--", title, "---", description, "---", datatype, "---", subjecttypes
            
            print subjecttypes
            
            subTypeOf=[]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'subtypeof':[],
                'title':[title,alttitle],
                'description':description,
                'datatype':datatype,
                'subjecttypes':[subjecttypes]
                }

            print dictParameters
            self.gnowql.manageAddAttributeType( dictParameters )
            print "Added ---", nid

    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /opt/Plone-2.5.2/zeocluster/Products/selfApp/Extensions/SCORMManifest.txt /tmp/')
    file = open('/tmp/SCORMManifest.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')
            print array
            
            # Creating Dict
            
            nid = array[0]
            title=array[1]
            alttitle = array[2]
            description=array[3]
            status = array[4]
            datatype=array[5]
            subjecttypes=array[6]

            print "RECORD ::: ",nid, "--", title, "---", description, "---", datatype, "---", subjecttypes
            
            print subjecttypes
            
            subTypeOf=[]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'subtypeof':[],
                'title':[title,alttitle],
                'description':description,
                'datatype':datatype,
                'subjecttypes':[subjecttypes]
                }

            print dictParameters
            self.gnowql.manageAddAttributeType( dictParameters )
            print "Added ---", nid


    """
    Adding All UserTypes in the SELF-Platform
    """
    
    listofUT = ['selfusers','peer','Manager','Anonymous','userType']

    for x in listofUT:

        dictParameters = {
            'nid':x,
            'uid':'1',
            'status':'Public',
            'content':"<p align=justify><b>User Types </b></p>",
            'subtypeof':[],
            'title':[x],
            'description':'<b>UserType For SELF</b>'
            }
        
        self.gnowql.manageAddUserType( dictParameters )
        print "Added ---:", x



    """
    Creating RelationTypes For SELF-Platform
    """
    os.system('cp /opt/Plone-2.5.2/zeocluster/Products/selfApp/Extensions/SCORMRelationTypes.txt /tmp/')
    file = open('/tmp/SCORMRelationTypes.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')

            # Creating Dict
            
            nid = array[0]
            uid = '1'         
            title=array[1]
            inversename=array[2]
            description=array[3]
            status = array[4]
            role1=array[5]
            role2=array[6]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'title':[title],
                'inversename':[inversename],
                'description':description,
                'role1':[role1],
                'role2':[role2]
                }

            print dictParameters
            self.gnowql.manageAddRelationType( dictParameters )
            print "Added ---", nid



    """
    Adding Languages to SELF-Platform
    """

    os.system('cp /opt/Plone-2.5.2/zeocluster/Products/selfApp/Extensions/Languages.txt /tmp/')
    file = open('/tmp/Languages.txt')
    for line in file.readlines():
        if len(line.split(' '))>2:
            id = line.split(' ')[0].lower() + line.split(' ')[1].lower()
            title = line.split(' ')[0] + ' ' + line.split(' ')[1]
            shortname = line.split(' ')[2]
        else:
            id = line.split(' ')[0].lower()
            title = line.split(' ')[0]
            shortname = line.split(' ')[1]

        dictParameters = {
            'nid':id,
            'uid':'1',
            'status':'Public',
            'content':"",
            'title':[title,shortname],
            'description':'',
            'instanceof':['Languages']
            }
        self.gnowql.manageAddObject( dictParameters )
        print "Added Language is -->  ", title
    
    # Code to create an External Method inside gnowsys for displaying tree structure.

    extMethod = ExternalMethod('displaytree','Tree Structure Logic','selfApp.DisplayTree','drive')
    self._setObject('displaytree',extMethod)

    extMethod = ExternalMethod('pickleCatStruct','Pickling CategoryStructure','selfApp.addData','pickleCatStruct')
    self._setObject('pickleCatStruct',extMethod)

    extMethod = ExternalMethod('pickleCourse','Pickling Course Structure','selfApp.addData','pickleCourse')
    self._setObject('pickleCourse',extMethod)

    extMethod = ExternalMethod('picklecoursecat','Pickling child-parent category pair','selfApp.addData','picklecoursecat')
    self._setObject('picklecoursecat',extMethod)

    extMethod = ExternalMethod('testmd5sum','Generating md5sum of user password','selfApp.addData','passenc')
    self._setObject('testmd5sum',extMethod)

    extMethod = ExternalMethod('unpickleCourse','unpickling course structure','selfApp.addData','unpickleCourse')
    self._setObject('unpickleCourse',extMethod)

    extMethod = ExternalMethod('unpklcat','Unpickling Course Category','selfApp.addData','unpklcat')
    self._setObject('unpklcat',extMethod)
    
    extMethod = ExternalMethod('createFile','Creating Files at FileSystem','selfApp.addData','createFile')
    self._setObject('createFile',extMethod)

    extMethod = ExternalMethod('getFileInfo','Unpickling Course Category','selfApp.addData','getFileInfo')
    self._setObject('getFileInfo',extMethod)

    extMethod = ExternalMethod('importCrs','Imports the courses','selfApp.import','importFromArchive')
    self._setObject('importCrs',extMethod)

    extMethod = ExternalMethod('testhtmlexport','External method for html export','selfApp.htmlExport','test2')
    self._setObject('testhtmlexport',extMethod)

    extMethod = ExternalMethod('chkExistence','checks the existence of pickle for links,glossary,faq,test','selfApp.addData','chkExistence')
    self._setObject('chkExistence',extMethod)

    extMethod = ExternalMethod('pickleComponent','pickles a course component','selfApp.addData','pickleComponent')
    self._setObject('pickleComponent',extMethod)

    extMethod = ExternalMethod('unpickleComponent','unpickles the course component','selfApp.addData','unpickleComponent')
    self._setObject('unpickleComponent',extMethod)

    


    # creating CourseCategory Pickle at File System
    
    ssid = self.gnowql.getlatestVersion('CourseCategory')
    
    lstdata = [[str(ssid),'0']]

    print "ssid of coursecategory", ssid
    
    preuri = self.gnowql.geturifromssid(ssid,'gbobjecttypes')

    print "preuri of coursecategory", preuri
    
    finaluri=preuri+'/coursecategorystruct'

    print "final uri --- >", finaluri
    
    FILE=open(finaluri,'w')
    
    cPickle.dump(lstdata,FILE)
    FILE.close()

    # Creating the custom portal_tabs

    actionsTool = getToolByName(self, 'portal_actions')
    actionsTool.addAction('CourseCategory',
                          name='Material',
                          action='string:${globals_view/navigationRootUrl}/collectionview/',
                          condition='',
                          permission='View',
                          category='portal_tabs',
                          visible=1,
                          )

    actionsTool = getToolByName(self, 'portal_actions')
    actionsTool.addAction('FileManager',
                          name='FileManager',
                          action='string:${globals_view/navigationRootUrl}/filemanager/',
                          condition='',
                          permission='View',
                          category='portal_tabs',
                          visible=1,
                          )

    
    return out.getvalue()

def uninstall(self, reinstall=False):
    out = StringIO()



    # try to call a workflow uninstall method
    # in 'InstallWorkflows.py' method 'uninstallWorkflows'
    try:
        uninstallWorkflows = ExternalMethod('temp', 'temp',
                                            PROJECTNAME+'.InstallWorkflows',
                                            'uninstallWorkflows').__of__(self)
    except NotFound:
        uninstallWorkflows = None

    if uninstallWorkflows:
        print >>out, 'Workflow Uninstall:'
        res = uninstallWorkflows(self, out)
        print >>out, res or 'no output'
    else:
        print >>out,'no workflow uninstall'

    # try to call a custom uninstall method
    # in 'AppInstall.py' method 'uninstall'
    try:
        uninstall = ExternalMethod('temp', 'temp',
                                   PROJECTNAME+'.AppInstall', 'uninstall')
    except:
        uninstall = None

    if uninstall:
        print >>out,'Custom Uninstall:'
        try:
            res = uninstall(self, reinstall)
        except TypeError:
            res = uninstall(self)
        if res:
            print >>out,res
        else:
            print >>out,'no output'
    else:
        print >>out,'no custom uninstall'

    return out.getvalue()

def beforeUninstall(self, reinstall, product, cascade):
    """ try to call a custom beforeUninstall method in 'AppInstall.py'
        method 'beforeUninstall'
    """
    out = StringIO()
    try:
        beforeuninstall = ExternalMethod('temp', 'temp',
                                   PROJECTNAME+'.AppInstall', 'beforeUninstall')
    except:
        beforeuninstall = []

    if beforeuninstall:
        print >>out, 'Custom beforeUninstall:'
        res = beforeuninstall(self, reinstall=reinstall
                                  , product=product
                                  , cascade=cascade)
        if res:
            print >>out, res
        else:
            print >>out, 'no output'
    else:
        print >>out, 'no custom beforeUninstall'
    return (out,cascade)

def afterInstall(self, reinstall, product):
    """ try to call a custom afterInstall method in 'AppInstall.py' method
        'afterInstall'
    """
    out = StringIO()
    try:
        afterinstall = ExternalMethod('temp', 'temp',
                                   PROJECTNAME+'.AppInstall', 'afterInstall')
    except:
        afterinstall = None

    if afterinstall:
        print >>out, 'Custom afterInstall:'
        res = afterinstall(self, product=None
                               , reinstall=None)
        if res:
            print >>out, res
        else:
            print >>out, 'no output'
    else:
        print >>out, 'no custom afterInstall'
    return out
