#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################
# Contributor: "Dinesh Joshi" <dinesh.joshi@yahoo.com>

import pickle
import psycopg2

class dbConnector:
    """
    Connects to the given database using the pickle file passed to it
    """
    def __init__( self, connName='hbcse', dbName='aaa', pickleFileName='connInfo.pyPickle' ): 
        """
        the defaults for filename, connection name, db name are indicated
        """

        # open the pickle file
        fp = open( "./" + pickleFileName )

        # load the pickle file
        connInfo = pickle.load( fp )

        # which connection to use?
        curConnInfo = connInfo[connName]
        
        # construct the connection dict
        dictConn = { 
            'dbname':dbName, 
            'username':curConnInfo['username'], 
            'password':curConnInfo['password'], 
            'host':curConnInfo['host'], 
            }

        # connect to the database
        self.conn = psycopg2.connect( "dbname=%(dbname)s user=%(username)s password=%(password)s host=%(host)s" % dictConn )

    def getConnObj( self ):
        """
        return the connection object conn
        """
        return self.conn

       


# some test code

if __name__ == '__main__':
    dbObj = dbConnector( 'other', 'djtest16' )
    conn = dbObj.getConnObj()

    print conn
