#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
import Products.PythonScripts
from Products.ZCatalog.ZCatalog import ZCatalog
from Products.PythonScripts.PythonScript import manage_addPythonScript
import cgi,os,sys,string
from time import time
import math

class gno(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
           ZCatalog):
    """gno Folder object implementation.

    gno Folder objects are folders that can contain subobjects
    and other supporting objects.  They provide properties to all
    Topics and other Topic Types in them.  They also provide
    support methods for displaying Topics and Topic Types.
    """

    meta_type = "Gno Folder"
   
    _properties = (
        {'id':'title', 'type': 'string', 'mode': 'w'},
        ) 

    manage_options = (
        (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': ''}
        )+
        PropertyManager.manage_options
        )

    allowedmetatypes = ('Gno Folder','Image','DTML Document','DTML Method','File','GNOWSYS','External Method','Folder','Mail Host','TinyTablePlus','Script (Python)','ZCatalog','Association','Association Type','Facet Type','Occurrence Type','Object','Object Type','Transparent Folder')

    def all_meta_types(self):
        
        if hasattr(self, 'allowedmetatypes'):
            result = []
            import Products
            for metaType in Products.meta_types:
                if metaType['name'] in self.allowedmetatypes:
                    result.append(metaType)
            return result
        else:
            return Products.meta_types
   
    def __init__(self, id, title):
        self.__version__ = '1.0'
        self.id = id
        self.title = title

     
    def processor(self,id1,REQUEST=None):
        """
	   This script processes the rule selected by the user
	   """
        
        apinit=id1
        ap11=string.replace(apinit,"{","")
	ap1=string.replace(ap11,"}","")
	ap2=string.replace(ap1,"'sobj'","")
	ap3=string.replace(ap2,"'pobj'","")
	ap4=string.replace(ap3,"'assoc'","")
	ap5=string.replace(ap4,"'oper'","")
	ap6=string.replace(ap5,":","")
	j=string.split(ap6,"], ")

        x=0
	a={}
	k={}
	while x<=3:
	 
          yinit=j[x]
	  y1=string.replace(yinit,"['","")
	  y2=string.replace(y1,"']","")
	  y3=string.replace(y2,"', '",",")
	  y4=string.replace(y3,"'","")
	  y5=string.split(y4,",")
	  k[x]=y5
	  x=x+1

        a['sobj']=k[0]
        a['assoc']=k[1]
        a['pobj']=k[2]
        a['oper']=k[3]

        #Script for processing rules
        flag1=[]
        toper1=a['oper']
        toper=toper1.index('Then')
        listlen=len(a['oper'])
        j1=0
        tc1=1

        while j1<toper:
          ts=string.strip(a['sobj'][j1])
          ta=string.strip(a['assoc'][j1])
          tp=string.strip(a['pobj'][j1])
          tflag=0
          #from here if subject is Anything
          if(ts=='Anything'):
     		for temp1 in self.Data.Associations.objectValues():
	  		st2=repr(temp1.AssociationType)
		       	st3=repr(temp1.RObjects)
         	       	if(string.find(st2,ta)>0) and (string.find(st3,tp)>0):
		            tflag=1
            		    tc2=tc1
                            tc1=tflag
		            if j1>0:
               			if a['oper'][j1]=='Or':
		                  tc1=tc1 or tc2
               			if a['oper'][j1]=='And':
		                  tc1=tc1 and tc2
    
          #from here if predicate is Anything
  	  elif(tp=='Anything'):
		for temp1 in self.Data.Associations.objectValues():
		        st1=repr(temp1.LObjects)
		        st2=repr(temp1.AssociationType)
		        if(string.find(st1,ts)>0) and (string.find(st2,ta)>0):
		            tflag=1
		            tc2=tc1
            		    tc1=tflag
            		    if j1>0:
               			if a['oper'][j1]=='Or':
                  		  tc1=tc1 or tc2
               			if a['oper'][j1]=='And':
		                  tc1=tc1 and tc2
           
          #from here in the normal case
  	  else:
                for temp1 in self.Data.Associations.objectValues():
           	        st1=repr(temp1.LObjects)
           	        st2=repr(temp1.AssociationType)
           	        st3=repr(temp1.RObjects)

           	        if(string.find(st1,ts)>0) and (string.find(st2,ta)>0) and (string.find(st3,tp)>0):
             		    tflag=1
                            tc2=tc1
		            tc1=tflag
		            if j1>0:
               			if a['oper'][j1]=='Or':
			          tc1=tc1 or tc2
               			if a['oper'][j1]=='And':
		                  tc1=tc1 and tc2
          j1=j1+1
     
       #end of while
        
        r=toper
	rc1=0
	rc2=0
	if tc1==1:
         
	 while r<listlen:
	    rs=string.strip(a['sobj'][r])
	    ra=string.strip(a['assoc'][r])
	    rp=string.strip(a['pobj'][r])
	    rflag=0
            
	    for temp2 in self.Data.Associations.objectValues():
	      rst1=repr(temp2.LObjects)
	      rst2=repr(temp2.AssociationType)
	      rst3=repr(temp2.RObjects)
             
	      if(string.find(rst1,rs)>0) and (string.find(rst2,ra)>0) and (string.find(rst3,rp)>0):
                  rflag=1
            
	    if rflag==0:
	      a_id=repr(int(time())+r)
              rsfin=[]
              rsfin.append(rs)
              rpfin=[]
              rpfin.append(rp)
              rafin=[]
              rafin.append(ra)  
              self.REQUEST.set('BaseNameA',a_id)
	      self.REQUEST.set('LObjects',rsfin)
	      self.REQUEST.set('RObjects',rpfin)
	      self.REQUEST.set('AssociationType',rafin)
             
              self.manage_addProduct['GNOWSYS'].manage_addnewAssoc(a_id,REQUEST)    
            
  	    if rflag==1:
	      return "Error adding an association:Specified association already exists"
	    r=r+1
           
    def percent(self,x,y):
        """ """
        z=float(x)/float(y)*100
        zn=round(z,2)
        print zn
        return zn

    def first(self,t,w,x,y,z,m,k):
        """ """
        s=w+x+y+z+m
        s=s+k
        r=float(w)/float(s)*100
        rn=round(r,2)
        q=float(x)/float(s)*100
        qn=round(q,2)
        p=float(y)/float(s)*100
        pn=round(p,2)
        u=float(z)/float(s)*100
        un=round(u,2)
        v=float(m)/float(s)*100
        vn=round(v,2)
        l=float(k)/float(s)*100
        ln=round(l,2)
        i='There are  '+'<strong>'+ repr(s)+ '</strong>'+ '  element/s in the system.' +'<br>'

        i=i+'There are  '+'<strong>'+ repr(t)+ '</strong>' + '   object/s acting as roles in Association Types.'+'<br>'+'<br>'

        i=i+'<table>'+'<tr>'+'<th>'+'No. of elements'+'</th>'+'<td>'+'</td>'+'<th>'+' Percentage'+'</th>'+'</tr>'+'<tr>'+'<td>'+'<strong>'+ repr(w)+'</strong>'+' Object/s'+'</td>'+'<td>'+'</td>'+'<td>'+'<strong>'+repr(rn)+ '</strong>'+'%'+'</td>'+'</tr>'

        i=i+'<tr>'+'<td>'+'<strong>'+repr(x)+'</strong>'+' Object Type/s'+'</td>'+'<td>'+'</td>'+'<td>'+'<strong>'+repr(qn)+'</strong>'+'%'+'</td>'+'</tr>'

        i=i+'<tr>'+'<td>'+'<strong>'+ repr(y)+'</strong>'+' Association/s'+'</td>'+'<td>'+'</td>'+'<td>'+'<strong>'+repr(pn)+'</strong>'+'%'+'</td>'+'</tr>'

        i=i+'<tr>'+'<td>'+'<strong>'+ repr(z)+'</strong>'+' Association Type/s'+'</td>'+'<td>'+'</td>'+'<td>'+'<strong>'+repr(un)+'</strong>'+'%'+'</td>'+'</tr>'
        i=i+'<tr>'+'<td>'+'<strong>'+ repr(m)+'</strong>'+' Facet Type/s'+'</td>'+'<td>'+'</td>'+'<td>'+'<strong>'+repr(vn)+ '</strong>'+'%'+'</td>'+'</tr>' 
  
        i=i+'<tr>'+'<td>'+'<strong>'+ repr(k)+'</strong>'+' Occurrence Type/s'+'</td>'+'<td>'+'</td>'+'<td>'+'<strong>'+repr(ln)+ '</strong>'+'%'+'</td>'+'</tr>'+'</table>' 


        return i 
  
       
                  
    def strconv(self,temp):
        """
        """   
        b=string.join(temp)
        return b    
        
 
    def newproc(self,obj):
        """
        """
        file=open(obj,'r')
        done=0
        while not done:
		al=file.readline()
                if al != "":
			print al
		else:
			done=1
        file.close()
	return	    

    def addscr(self,REQUEST):
        """
        This script adds a new Rule and stores the rule as dictionary in a Python File in the Rules folder in Data folder 
        """
        j=0
        #oper is a list that stores all the operators in the rule
	oper=[]
        #sobj is a list that stores all the subject objects in the rule
 	sobj=[]
        #assoc is a list that stores all the association types in the rule
	assoc=[]
        #pobj is a list that stores all the predicate objects in the rule
	pobj=[]
	while j<=9:
	  toper=REQUEST['oper'+repr(j)]
	  tsobj=REQUEST['sobj'+repr(j)]
	  tassoc=REQUEST['assoc'+repr(j)]
	  tpobj=REQUEST['pobj'+repr(j)]
          if(tsobj=='Anything' and tpobj=='Anything'):
		return 'Anything cannot be selected as both subject and predicate'

	  oper.append(toper)
	  sobj.append(tsobj)
	  assoc.append(tassoc)
	  pobj.append(tpobj)
	  j=j+1

	l=sobj.index('Select Object')
	del oper[l:]
	del sobj[l:]
	del assoc[l:]
	del pobj[l:]

	#operator list
	opinit=repr(oper)
	opfin='\'oper\':'+opinit+','
	#sobject list
	sobinit=repr(sobj)
	sobfin='\'sobj\':'+sobinit+','
	#association list
	asoinit=repr(assoc)
	asofin='\'assoc\':'+asoinit+','
	#pobject list
	pobinit=repr(pobj)
	pobfin='\'pobj\':'+pobinit+''

	rul='return {'+opfin+sobfin+asofin+pobfin+'}'
	method_id=repr(int(time()))
	params='REQUEST=None'
	self.Data.Rules.manage_addProduct['PythonScripts'].manage_addPythonScript(method_id)
	t=self.Data.Rules[method_id]
	t.ZPythonScript_edit(params, rul)
	self.REQUEST.RESPONSE.redirect('bkbdocadd')
  
    def interscript(self,REQUEST,RESPONSE):
	"""
	"""
	nm=[]
	i=REQUEST['firstno']
	i1=REQUEST['secondno']
	j=[]
	j=REQUEST['idlist']
	a=int(i)
	a=a-1
	b=int(i1)
	b=b-1
	temp=j[a]
	j[a]=j[b]
	j[b]=temp
	nm=j
	abinit=[]
	abinit=nm

	leng=len(abinit)
	i=0
	while i<leng :
	   abinit[i]=string.replace(abinit[i],"['","")
	   i=i+1
	
	b2=abinit
	
	
	i=0
	while i<leng :
	   b2[i]=string.replace(b2[i],"']","")
	   i=i+1

	b3=b2

	
	i=0
	while i<leng :
	   b3[i]=string.replace(b3[i],"','"," ")
	   i=i+1

	b4=b3
	bfin=[]
	bfin=b4
	nm1=[]
	nm1=bfin

	ur=self.absolute_url()
	self.dtmlholder.manage_changeProperties(list=nm1,)
        #elf.REQUEST.RESPONSE.redirect(ur+'/newlistobject')
        self.REQUEST.RESPONSE.redirect('newlistobject')

    def newstore(self,REQUEST):
        """
	"""
        newid = self.REQUEST['id']  
	self.Data.Views.manage_addDTMLDocument(newid)
	self.Data.Views[newid].manage_addProperty("sellist","",'tokens',REQUEST=None)
	self.Data.Views[newid].manage_edit('<dtml-let sum="getProperty('"'sellist'"')"><dtml-in sum>  <dtml-let sit=sequence-item>   <dtml-in expr="Data.Objects.objectValues()">     <dtml-let cbase=BaseName>        <dtml-if "sit==cbase" >          <dtml-var index_html>        </dtml-if>      </dtml-let>    </dtml-in>    <dtml-in expr="Data.ObjectType.objectValues()">      <dtml-let cbase=BaseName>        <dtml-if "sit==cbase" >          <dtml-var index_html>        </dtml-if>      </dtml-let></dtml-in></dtml-let></dtml-in></dtml-let>',REQUEST['id'])

	j=[]
	j=self.REQUEST['storelist']
	objTTlist=[]
	objTTlist=j
	nm=j
	abinit=[]
	abinit=nm
	
	leng=len(abinit)
	i=0
	while i<leng :
	   abinit[i]=string.replace(abinit[i],"['","")
	   i=i+1
	
	b2=abinit

	i=0
	while i<leng :
	   b2[i]=string.replace(b2[i],"']","")
	   i=i+1

	b3=b2
	i=0
	while i<leng :
	   b3[i]=string.replace(b3[i],"','"," ")
	   i=i+1

	b4=b3
	bfin=[]
	bfin=b4
	nm1=[]
	nm1=bfin

	ur=self.absolute_url()
	self.Data.Views[newid].manage_changeProperties(sellist=nm1,)
	self.REQUEST.RESPONSE.redirect('newlistobject')
    
    def printrule(self,j):
        """
        This script reads the Python Script containing the rule and returns a meaningful string in the form operator sobj associationtype pobj
        """
        k={}
        x=''
        k=j
        ctr=0
        l=len(k['oper'])
        while ctr<l:
           x=x+' '+k['oper'][ctr]+' '+k['sobj'][ctr]+' '+k['assoc'][ctr]+' '+k['pobj'][ctr]
           ctr=ctr+1
        print '<br>'
        return x+'<br>' 

   

	
#
# Factory methods
#

manage_addgnoFolderForm = DTMLFile('dtml/addgnofolderform', globals())

def manage_addgnoFolder(self, id, title, REQUEST=None):
    """
    """
    
    dest = self.Destination()
    dest._setObject(id, gno(id, title))
    
    if REQUEST is not None:
        try:    url=DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect('%s/manage_main' % url)
    return id
   
InitializeClass(gno)
