#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile

class occurrencetype(ObjectManager,PropertyManager,RoleManager,Item,FindSupport):
   
    meta_type = "Occurrence Type"
   
    _properties = (
        {'id':'Identity', 'type': 'string', 'mode': 'w'},
#        {'id':'Basename', 'type': 'string', 'mode': 'w'},
        {'id':'DisplayName', 'type': 'string', 'mode': 'w'},
        {'id':'SortName', 'type': 'string', 'mode': 'w'},
        {'id':'Description', 'type': 'text', 'mode': 'w'},
        {'id':'Path', 'type': 'string', 'mode': 'w'},

      )


# removed Basename from constructor - 21-11-2002

    def __init__(self,id,Identity,DisplayName,SortName,Description,Path):
         self.id=id
         self.Identity=Identity
        # self.Basename=Basename
         self.DisplayName=DisplayName
         self.SortName=SortName
         self.Description=Description
         self.Path=Path


    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        ) + PropertyManager.manage_options \

security=ClassSecurityInfo()

# Factory methods

manage_addnewoccurrencetypeForm = DTMLFile('dtml/addnewoccurrencetypeform', globals())

def manage_addnewoccurrencetype(dispatcher,id,REQUEST=None):
    """Add New Occurrence Type object"""
    dest = dispatcher.Destination()
    ur=dest.absolute_url()

#    Path=ur+'/Data/OccurrenceTypes/'+REQUEST['id'] 

    title = REQUEST['id'] 	

# removed Basename from setobject - 21-11-2002

    dest.Data.OccurrenceTypes._setObject(id,occurrencetype(id,REQUEST['Identity'],REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['Description'],'')) 
    
    temp=REQUEST['id']
    nm="OccurenceType"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)
    
    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+'/replyadd?newid=%s&newnm=%s' % (temp,nm))
    return id

InitializeClass(occurrencetype)




