#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.PropertySheets import PropertySheet
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.ZCatalog.CatalogAwareness import CatalogAware
import Products.PythonScripts, Globals
import string

file_path = Globals.package_home(globals())

class ObjectType(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):

    """Object type object implementation.

    Object Type objects are folders that can contain Object TYpe objects
    and other supporting objects.  They provide properties to all
    Objects and Object types in them.  They also provide
    support methods for displaying Object Types.
    """

    meta_type = "Object Type"

    # added a new property title, and set its value of BaseName (by Nagarjuna)

    _properties = (

        {'id':'Identity', 'type': 'string', 'mode': 'w'}, 
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'BaseName', 'type': 'string', 'mode': 'w'},
        {'id':'DisplayName', 'type': 'string', 'mode': 'w'}, 
        {'id':'SortName', 'type': 'string', 'mode': 'w'}, 
        {'id':'TTList', 'type': 'lines', 'mode': 'w'},
        {'id':'Scope', 'type': 'lines', 'mode': 'w'},
        {'id':'Description', 'type': 'text', 'mode': 'w'}, 
        {'id':'keywords','type':'lines','mode':'w'},
        {'id':'Status','type':'string','mode':'w'},
	{'id':'Local','type':'lines','mode':'w'},
        {'id':'Path','type':'string','mode':'w'},

#       {'id':'Occurrences','type':'lines','mode':'w'},
# 	Occurrences are changed to Local & WWW on 20-11-2002
#       {'id':'FacetValue','type':'lines','mode':'w'},
#	{'id':'WWW','type':'lines','mode':'w'},

     )

    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'Facets', 'action': 'manage_FacetForm'},
        ) + PropertyManager.manage_options \
          + Item.manage_options         

    def __init__(self,id,title,Identity,BaseName,DisplayName,SortName,TTList,Scope,keywords,Description,ls,name='NAME',name1='NAME1'):
        self.id=id
        self.title=title
        self.Identity=Identity
        self.BaseName=BaseName
        self.DisplayName=DisplayName
        self.SortName=SortName
        self.TTList=TTList
        self.Scope=Scope
        self.keywords=keywords
        self.Path=[]
        self.Path.append(ls)
        self.Description=Description
        self.Status='Public'

        self.Local=[]
        self.Local.append(ls)
        addDTML(self,'index_html',BaseName,'dtml/objtype_index_html')
        self.manage_addDocument('content_dtml',BaseName)          

        #self.index_html.manage_edit(' ',BaseName,'index_html')
	
    def appOT(self,REQUEST):
      """ 
	 This script is used for updating the Occurrences
	 of a particular instance with the edited values
	 This script is called from the DTML Method occuredit
      """
      # changes are made on 29-11-2002

      #t=[]
      #t=self.Local
      #tr4=[]
      #tz=[]

      # tz stores the list that will finally be updated as Occurrences
      # property in the instance

      #tz.append(t[0])
      #tr=REQUEST['Occur']
      #tr1=repr(tr)

      # repr function converts tr to a string format.
      # This is necessary because the first entry in Occurrences i.e.Occurrences:..
      # should not be edited as it stores the path of the instance.Only other
      # occurrences should be allowed to be edited.Converting to a string 
      # helps in parsing.

      #tr2=string.replace(tr1,"['","")
      #tr3=string.replace(tr2,"\\r\\n']","")
      #tr4=string.split(tr3,"\\r\\n")

      # Each line in occurrences usually ends in a \r\n which need to be 
      # removed before being passed to a list

      #tz=tz+tr4

      # Add the Occurrences element to the rest of the edited list
      #self._updateProperty('Local',tz)

      avlocctypes = self.Data.OccurrenceTypes.objectIds()
      propertyids = self.propertyIds()
      for x in avlocctypes:
	if x in propertyids:
		NewValues = REQUEST[x]
		self._updateProperty(x,NewValues)

       
    def intermedOT(self,RESPONSE,URL1,URL2,REQUEST=None):
        """ """ 
        temp=REQUEST['BaseName']
        self.manage_changeProperties(REQUEST)
        self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Object Type'])
        nm="ObjectType"
        REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
	ur=self.absolute_url()
	REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (temp,nm))
        return


    def facetadd(self, REQUEST=None):
        """
	Edited on 18/11/2002 function changed so that now facets
	will be added as Properties only. - Shashank
        
	This script is used for adding Facets
        to a particular instance. 
        This script is called from the DTML Method manage_Facetmainform
        """
	if self.hasProperty(REQUEST['ft'])>0:
                return "<dtml-var standard_html_header>" + "This facet is already defined on the Object Type." + "<dtml-var standard_html_footer>"
		#self.manage_changeProperty(facetval=REQUEST['facetval'])
		# self.REQUEST.RESPONSE.redirect('replyObjTypeUpdateFacet')
	else:
	        self.manage_addProperty(REQUEST['ft'],REQUEST['facetval'],'string' )
        self.REQUEST.RESPONSE.redirect('manage_Facetmainform')

    def removefacet(self,REQUEST):
        """ """
        a=REQUEST['facetlist']
        b=self.FacetValue
        fac1=filter(lambda x,a=REQUEST['facetlist']: x not in a,b)
        # self._updateProperty('FacetValue',fac1)
	self.manage_delProperties(REQUEST['ft'])
        REQUEST.RESPONSE.redirect('delfacets')

    def facetscript(self,REQUEST):
        """
        This script is used for updating the Facets
        of a particular instance with the edited values
        This script is called from the DTML Method facetedit
        """
        t=[]
        t=self.FacetValue
        tr4=[]
        tz=[]

        # tz stores the list that will  finally be updated as FacetValue property
        # in the instance

        tz.append(t[0])
        tr=REQUEST['fact']
        tr1=repr(tr)

        # repr function converts tr to a string format.

        tr2=string.replace(tr1,"['","")
        tr3=string.replace(tr2,"']","")
        tr4=string.split(tr3,"\\r\\n")

        # Each line in facets usually ends in a \r\n which need to be removed 
        # before being passed to a list

        tz=tr4

        # Add the Occurrences element to the rest of the edited list

        self._updateProperty('FacetValue',tz)
        self.REQUEST.RESPONSE.redirect('manage_facetedit')


    def ocadd(self,REQUEST=None):
	# need to chang from ocadd to ocaddOT ?
	# edited & changes are made on 26-11-02
	# now occurrences will be added as new property

        """ """
        OccType=REQUEST['ot']
        OccValue=REQUEST['oval']

	#occ=ot1+':'+oval1
	
	if self.hasProperty(OccType):
		exsistingoccurrences = []
		exsistingoccurrences = self.getProperty(OccType)
		exsistingoccurrences.append(OccValue)
		self._updateProperty(OccType,exsistingoccurrences)
	else:
		self.manage_addProperty(OccType,OccValue,'lines',REQUEST=None)
	#l1=[]
	#l1=self.Local
	#l1.append(occ)
	#self._updateProperty('Local',l1)
	
	REQUEST.RESPONSE.redirect('OToccurmain')
 
   
    def remoccur(self,REQUEST=None):
        """
        This script removes the specified occurrences of a topic.
        occlist contains the list of Occurrences to be deleted
        """
        a=REQUEST['occlist']
        b=self.Local
        occ=filter(lambda x,a=REQUEST['occlist']: x not in a,b)

        #After subtracting the selected values of Occurrences to be deleted from the # original list, update the values in the Propertysheet

        self._updateProperty('Local',occ)
        REQUEST.RESPONSE.redirect('occurdel')
       

    def OTremovelist(self,ul,objTT,REQUEST=None):
        """ """
        itbinit=ul
	itb2=string.replace(itbinit,"['","")
	itb3=string.replace(itb2,"']","")
	itb4=string.replace(itb3,"', '"," ")
	itbfin=[]
	itbfin=string.split(itb4," ")
	itafin=objTT
	nTT=filter(lambda x,itafin=objTT: x not in itafin,itbfin)
	self._updateProperty('TTList',nTT)
	self.REQUEST.RESPONSE.redirect('OTmembership')

    def ttdel(self,REQUEST,RESPONSE,URL1,URL2):
        """Deletes the requested object """
	
        temp=REQUEST['BaseName']
	self.Data.ObjectType.manage_delObjects(REQUEST['id2'])
        self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Object Type'])
        nm="ObjectType"
 	REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
        REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid='+temp+'&newnm='+nm)
 
    def OTupdateunsel(self,REQUEST):

         """ """
         list_of_ids=[]
         list_of_ids = self.Data.ObjectType.objectIds()
         b=[]
         b=self.TTList
         a=list_of_ids
         oTT=filter(lambda x,b=self.TTList: x not in b,a)
         return oTT 
    
#
# Factory methods
#

manage_addnewObjecttypeForm = DTMLFile('dtml/addnewObjecttypeform', globals())

def manage_addnewObjecttype(dispatcher, id, REQUEST=None):
    """Add New Object type object"""
    dest = dispatcher.Destination()
    title=REQUEST['BaseName']
    idt=dest.absolute_url() 
    u=idt+'/Data/ObjectType/'+REQUEST['id']
    idt=idt+'/Data/ObjectType/'+id
    Path=u
    ls=idt
    dest.Data.ObjectType._setObject(id, ObjectType(id,title,REQUEST['Identity'],REQUEST['BaseName'],REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['TTList'],REQUEST['Scope'],REQUEST['keywords'],REQUEST['Description'],Path))
   
    dest.Data.ObjectType[id].reindex_object()

    temp=REQUEST['id']
    nm="Object Type"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)        
    
    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+'/replyaddObjectType?newid=%s' % (temp))

    return id

def addDTML(obj,id,title,file):
	f=open(file_path+'/'+file+'.dtml')
	file=f.read()
	f.close()
	obj.manage_addDTMLMethod(id,title,file)
	return getattr(obj,id)

InitializeClass(ObjectType)











