#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from string import replace, split
from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.PythonScripts.standard import url_quote
from Products.ZCatalog.CatalogAwareness import CatalogAware
from Products.ZCatalog.Catalog import Catalog

import string, Globals 

file_path = Globals.package_home(globals())

class Object(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware,
                  Catalog):
    """Object implementation.

    Object are container objects that can contain Objects
    and other supporting objects.  They also provide
    support methods for displaying Objects.
    """

    meta_type = "Object"

   # Added a new property called title, and BaseName value set to title, by Nagarjuna
    _properties = (
      {'id':'title','type':'string','mode':'w'}, 
      {'id':'Identity','type':'string','mode':'w'},
      {'id':'BaseName','type':'string','mode':'w'},
      {'id':'DisplayName','type':'string','mode':'w'},
      {'id':'SortName','type':'string','mode':'w'},
      {'id':'ObjectTypes','type':'lines','mode':'w'},
      {'id':'Scope','type':'string','mode':'w'},
      {'id':'Description','type':'text','mode':'w'},
      {'id':'keywords','type':'string','mode':'w'},
# Local added on 20-11-02
      {'id':'Local','type':'lines','mode':'w'},
      {'id':'Status','type':'string','mode':'w'}, 

#      {'id':'Occurrences','type':'lines','mode':'w'},
#      {'id':'FacetValue','type':'lines','mode':'w'},     
      {'id':'Path','type':'string','mode':'w'},     
     ) 
     
    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': 'manage_deltopic'},
        {'label': 'Properties', 'action': 'manage_propertiesForm'},         
              
        ) 
          
          
    __ac_permissions__=(
        ('Manage Properties',('manage_addProperty',
                              'manage_editProperties',
                              'manage_delProperties',
                              'manage_changeProperties',
			      'Access content information')),
#         ('Delete Objects',('manage_delObjects)),
         )



    def __init__(self,id,title,Identity,BaseName,DisplayName,SortName,ObjectTypes,Scope,Description,keywords,Path,ls):
      self.id=id
      self.title=title
      self.Identity=Identity
      self.BaseName=BaseName
      self.DisplayName=DisplayName
      self.SortName=SortName
      self.ObjectTypes=ObjectTypes
      self.Scope=Scope
      self.Description=Description
      self.keywords=keywords
      self.Path=Path
      self.Status='Public'
      self.Local=[]
      self.Local.append(ls)
      self.FacetValue=[]
      addDTML(self,'index_html',BaseName,'dtml/obj_index_html')
      self.manage_addDocument('content_dtml',BaseName)
      self.content_dtml.manage_edit(' ',BaseName,'content_dtml')

    def statadd(self,a,b):
        """
        """
        c=a+b
        print c
        return c
  
    def rlist(self,ul,objTT):
	"""
        This script is used for updating the values of the ObjectTypes after editing.
        """   
        #ul contains the list of the ObjectTypes to which the instance belongs

        abinit=ul
	b2=string.replace(abinit,"['","")
        b3=string.replace(b2,"']","")
	b4=string.replace(b3,"', '"," ")
	bfin=[]
	bfin=string.split(b4," ")

        #objTT contains the list of those ObjectTypes that have to be removed from the list of ObjectTypes to which the Object belongs.

	afin=[]
	afin=objTT
	nTT=filter(lambda x,afin=objTT: x not in afin,bfin)
	self._updateProperty('ObjectTypes',nTT)
	return      

       
    def Objectdel1(self,REQUEST,RESPONSE,URL1,URL2):
       """Deletes the requested object """

       temp=REQUEST['BaseName']
       self.Data.Objects.manage_delObjects(REQUEST['id1'])
                   
       self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Object'])
       nm="Object"
       REQUEST.set('newnm',nm)
       REQUEST.set('newid',temp)
       REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid=%s&newnm=%s' % (temp,nm))

   
    def intermed(self,REQUEST,RESPONSE,URL1,URL2):
       """Edits the requested object """

       temp=REQUEST['BaseName']
       self.manage_changeProperties(REQUEST)

       self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Object'])
       nm="Object"
       REQUEST.set('newnm',nm)
       REQUEST.set('newid',temp)
       ur=self.absolute_url()
       REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (temp,nm))
 

    def app(self,REQUEST):
      """ 
         This script is used for updating the Occurrences
	 of a particular instance with the edited values
	 This script is called from the DTML Method occuredit
	"""
      # chnges are made on 28-11-2002

      #t=[]
      #t=self.Local
      #tr4=[]
      #tz=[]

      # tz stores the list that will finally be updated as Occurrences
      # property in the instance

      #tz.append(t[0])
      #r=REQUEST['Occur']
      #tr1=repr(tr)

      # repr function converts tr to a string format.
      # This is necessary because the first entry in Occurrences i.e.Local:..
      # should not be edited as it stores the path of the instance.Only other
      # occurrences should be allowed to be edited.Converting to a string 
      # helps in parsing.

      #tr2=string.replace(tr1,"['","")
      #tr3=string.replace(tr2,"\\r\\n']","")
      #tr4=string.split(tr3,"\\r\\n")

      # Each line in occurrences usually ends in a \r\n which need to be 
      # removed before being passed to a list

      #tz=tz+tr4

      # Add the Local element to the rest of the edited list

      #self._updateProperty('Local',tz)
   
      # avlocctypes  -- available occurrence types
      # objoccurrences -- occurrences of this object      

      avlocctypes = self.Data.OccurrenceTypes.objectIds()
      propertyids = self.propertyIds()
      for x in avlocctypes:
	if x in propertyids:
		NewValues = REQUEST[x]
		self._updateProperty(x,NewValues)

      #p = REQUEST['Library']
      #q = REQUEST['Book-Stalls']
      #self._updateProperty('Library',p)
      #self._updateProperty('Book-Stalls',q)

      self.REQUEST.RESPONSE.redirect('manage_occuredit')  
    
    def facetadd(self,REQUEST):
      """
      This script is used for adding Facets
      to a particular instance. 
      This script is called from the DTML Method manage_Facetmainform

      Script was modified on 19/11/2002 facets now are added as properties
      to the object. - Shashank
      """
      #Modified on 15/11/2002 
      #self._updateProperty('FacetValue',f1)
      if self.hasProperty(REQUEST['ft'])>0:
             self._updateProperty(REQUEST['ft'],REQUEST['facetval'])	
      else:
             self.manage_addProperty(REQUEST['ft'],REQUEST['facetval'],REQUEST['datatype'],REQUEST=None)
      self.REQUEST.RESPONSE.redirect('manage_Facetmainform')
      #self.REQUEST.RESPONSE.redirect(ur+'/replyadd?newid='+temp+'&newnm='+nm)

    def facetscript(self,REQUEST):
      """
      This script is used for updating the Facets
      of a particular instance with the edited values
      This script is called from the DTML Method facetedit
      """
      t=[]
      t=self.FacetValue
      tr4=[]
      tz=[]

      # tz stores the list that will  finally be updated as FacetValue property
      # in the instance

      tz.append(t[0])
      tr=REQUEST['fact']
      tr1=repr(tr)

      # repr function converts tr to a string format.

      tr2=string.replace(tr1,"['","")
      tr3=string.replace(tr2,"']","")
      tr4=string.split(tr3,"\\r\\n")

      # Each line in facets usually ends in a \r\n which need to be removed 
      # before being passed to a list

      tz=tr4

      # Add the Local element to the rest of the edited list

      self._updateProperty('FacetValue',tz)
      self.REQUEST.RESPONSE.redirect('manage_facetedit')

    def ocadd(self,REQUEST):
      """
      Edited & changes made on 25-11-2002, now occurrences will be added as ne	    w property of that object.  	
      This script is used for adding occurrences to a particular instance. 
      This script is called from the manage_occurmain method
      """

      OccType=REQUEST['ot']
      # ot contains the Occurrence Type

      OccValue=REQUEST['oval']
      # oval contains the Occurrence value

      #occ=ot1+':'+oval1
      # The value is stored as OccurrenceType:Occurrence value

      if self.hasProperty(OccType):
	exsistingoccurrences = []
	exsistingoccurrences = self.getProperty(OccType)
	exsistingoccurrences.append(OccValue)
	self._updateProperty(OccType,exsistingoccurrences)
      else:
	 self.manage_addProperty(OccType,OccValue,'lines',REQUEST=None)	

      #l1=[]
      #l1=self.Local
      #l1.append(occ)
      #self._updateProperty('Local',l1)

      self.REQUEST.RESPONSE.redirect('manage_occurmain')


    def remoccur(self,REQUEST):
      """
      This script removes the specified occurrences of a topic.
      occlist contains the list of Occurrences to be deleted
      """
      a=REQUEST['occlist']
      b=self.Local
      occ=filter(lambda x,a=REQUEST['occlist']: x not in a,b)

      #After subtracting the selected values of Occurrences to be deleted from
      #the original list, update the values in the Propertysheet

      self._updateProperty('Local',occ)
      REQUEST.RESPONSE.redirect('occurdel')

    def removefacet(self,REQUEST):
      """ """
      a=REQUEST['facetlist']
      b=self.FacetValue
      fac1=filter(lambda x,a=REQUEST['facetlist']: x not in a,b)
      #self._updateProperty('FacetValue',fac1)
      self.manage_delProperty(REQUEST['facetlist'])
      REQUEST.RESPONSE.redirect('delfacets')
      
    def updateunsel(self,REQUEST):
      """ 
      This script returns the list of ObjectTypes which are not a part of the 
      object types of the selected Object
      """
      list_of_ids=[]
      list_of_ids = self.Data.ObjectType.objectIds()
      b=[]
      b=self.ObjectTypes
      a=list_of_ids
      oTT=filter(lambda x,b=self.ObjectTypes: x not in b,list_of_ids)
      return oTT
       
# Factory methods

manage_addnewObjectForm = DTMLFile('dtml/addnewObjectform', globals())

manage_deltopic = DTMLFile('dtml/delObject',globals())

def manage_addnewObject( dispatcher,id,REQUEST,RESPONSE,URL1,URL2):
    """Add New Object object"""
    
    dest = dispatcher.Destination()
    idt=dest.absolute_url()
    title=REQUEST['BaseName']
    ur=dest.absolute_url()
    u=ur+'/Data/Objects/'+REQUEST['id']
    Path=u
    ls = u 
    li=dest.Data.ObjectType.objectIds()

    dest.Data.Objects._setObject(id, Object(id,title,REQUEST['Identity'],REQUEST['BaseName'],REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['ObjectTypes'],REQUEST['Scope'],REQUEST['Description'],REQUEST['keywords'],Path, ls))

    dest.Data.Objects[id].reindex_object()
    temp=REQUEST['id']
    nm="Object"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)

    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
	REQUEST.RESPONSE.redirect(url+'/replyaddObject?newid=%s&newnm=%s' % (temp,nm))
        

    return id


def addDTML(obj,id,title,file):     
    f=open(file_path+'/'+file+'.dtml')     
    file=f.read()
    f.close()     
    obj.manage_addDTMLMethod(id,title,file)     
    return getattr(obj,id)     

InitializeClass(Object)

