#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.ZCatalog.CatalogAwareness import CatalogAware

class facettype(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):
    """Facet Type implementation
    """

    meta_type = "Facet Type"


    _properties = (
        {'id':'Identity', 'type': 'string', 'mode': 'w'},
        {'id':'facettype', 'type': 'string', 'mode': 'w'},
        {'id':'datatype', 'type': 'string', 'mode':'w'},
        {'id':'DisplayName', 'type': 'string', 'mode': 'w'},
        {'id':'SortName', 'type': 'string', 'mode': 'w'},
        {'id':'Description', 'type': 'text', 'mode': 'w'},
        {'id':'Path', 'type': 'string', 'mode': 'w'},

      )

    def __init__(self,id,Identity,facettype,datatype,DisplayName,SortName,Description,Path):
         self.id=id
         self.Identity=Identity
         self.facettype=facettype
         self.datatype=datatype
         self.DisplayName=DisplayName
         self.SortName=SortName
         self.Description=Description
         self.Path=Path

      
    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        ) + PropertyManager.manage_options \
        

#
# Factory methods
#

manage_addnewfacettypeForm = DTMLFile('dtml/addnewfacettypeform', globals())

def manage_addnewfacettype(dispatcher, id, REQUEST=None):
    """Add New Facet type object"""
    dest = dispatcher.Destination()
    type = ['lines','string','tokens','text','boolean','date','int','long','float','selection','multiple selection']
    dtype = ''
    dtype = REQUEST['datatype'][0]
    if  dtype in type:
       dest.Data.FacetTypes._setObject(id,facettype(id,REQUEST['Identity'],REQUEST['facettype'],dtype,REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['Description'],'')) 
# 18/11/2002 Last argument of _setObject fn is 'Path' It has been set to an empty string.
    else:
       return "Invalid Datatype. Please go back and choose a valid Data Type", "Data Type Selected ->",REQUEST['datatype'][0]
    temp=REQUEST['id']
    nm="FacetType"        
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)
    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+'/replyadd?newid=%s&newnm=%s' % (temp,nm))
    return id

InitializeClass(facettype)

