#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.ZCatalog.CatalogAwareness import CatalogAware
import string


class AssocT(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):
    """Association Type impelementation

    """

    meta_type = "Association Type"

# 2 new properties Symmetric & Transitive are added by harsh on 2-12
   
    _properties = (
        {'id':'Identity', 'type': 'string', 'mode': 'rw'},
        {'id':'DisplayName', 'type': 'string', 'mode': 'rw'},
        {'id':'SortName', 'type': 'string', 'mode': 'rw'},
        {'id':'LRoles', 'type': 'tokens', 'mode': 'rw'},
        {'id':'RRoles', 'type': 'tokens', 'mode': 'rw'},
	{'id':'Transitive','type':'boolean','mode':'rw'},
	{'id':'Symmetric','type':'boolean','mode':'rw'},
        {'id':'BaseNameA', 'type': 'string', 'mode': 'rw'},
        {'id':'title', 'type': 'string', 'mode': 'rw'},
        {'id':'Path', 'type': 'string', 'mode': 'rw'},
      ) 

    def __init__(self,id,title,Identity,DisplayName,SortName,LRoles,RRoles,Transitive,Symmetric,BaseNameA,Path):
        self.id=id
        self.Identity=Identity
        self.DisplayName=DisplayName
        self.SortName=SortName
        self.LRoles=LRoles
        self.RRoles=RRoles
	self.Transitive = Transitive
	self.Symmetric = Symmetric
        self.BaseNameA=BaseNameA  
        self.Path=Path
     
    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        ) + PropertyManager.manage_options \
    
    
    def Intermed(self,REQUEST,RESPONSE,URL1,URL2):
        """Edits the object requested """
        temp=REQUEST['BaseNameA']
	self.manage_changeProperties(REQUEST)
	self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL1,['Association Type'])
        nm="AssociationType"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
	ur=self.absolute_url()
	REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (temp,nm))


    def DelAssot(self,REQUEST,RESPONSE,URL1,URL2):
        """Deletes the requested association """
        temp=REQUEST['BaseNameA']
	self.Data.AssociationTypes.manage_delObjects(REQUEST['id2'])
	self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL1,['Association Type'])
        nm="AssociationType"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
	REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid=%s&newnm=%s' % (temp,nm))
 
    def strconv(self,temp):
        """Converts tokens to strings """
        a=string.join(temp)
        return a

# Factory methods

manage_addnewAssocTForm = DTMLFile('dtml/addnewassoctform', globals())

def manage_addnewAssocT(dispatcher, id, REQUEST=None):
    """Add New AssociationType object"""

    dest = dispatcher.Destination()
    ur=dest.absolute_url()
    Path=ur+'/Data/AssociationTypes/'+id

    relation = REQUEST['Relation']

    if relation == 'None':
	Transitive = 0
	Symmetric = 0
    elif relation == 'Transitive':
	Transitive = 1
	Symmetric = 0
    else:
	Transitive = 0
	Symmetric = 1
	
    id = string.replace(str(id),' ','_')	

    dest.Data.AssociationTypes._setObject(id, AssocT(id,REQUEST['BaseNameA'],REQUEST['Identity'],REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['LRoles'],REQUEST['RRoles'],Transitive,Symmetric,REQUEST['BaseNameA'],Path))

    dest.Data.AssociationTypes[id].reindex_object()

    temp=REQUEST['BaseNameA']
    nm="AssociationType"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)
       
    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+'/replyadd?newid=%s&newnm=%s' % (temp,nm))

InitializeClass(AssocT)
