#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.ZCatalog.CatalogAwareness import CatalogAware
import string

class Assoc(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):
    """Association object implementation.
    """

    meta_type = "Association"

   
    _properties = (
        {'id':'LObjects', 'type': 'tokens', 'mode': 'w'},
# AssociationType changed from tokens to string 
        {'id':'AssociationType', 'type': 'tokens', 'mode': 'w'},
        {'id':'RObjects', 'type': 'tokens', 'mode': 'w'},
        {'id':'BaseNameA', 'type': 'string', 'mode': 'w'},
        {'id':'Path', 'type': 'string', 'mode':'w'},  
        ) 

       # commented by harsh 2-12-02	
       # {'id':'Symmetric', 'type': 'boolean', 'mode':'w'},       	
       # {'id':'Transitive', 'type': 'boolean', 'mode':'w'}, 
    

    def __init__(self,id,LObjects,AssociationType,RObjects,BaseNameA,Path):
     	self.id=id
	self.LObjects=LObjects
        self.AssociationType=AssociationType
        self.RObjects=RObjects
        self.BaseNameA=BaseNameA
        self.Path=Path

 #       self.Symmetric=0 
 #       self.Transitive=0

    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        ) + PropertyManager.manage_options \

    def DelAsso(self,REQUEST,RESPONSE,URL1,URL2):
        """Deletes the object requested """

        temp=REQUEST['BaseNameA']
        self.Data.Associations.manage_delObjects(REQUEST['id1'])
        self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Association'])
        nm="Association"
        REQUEST.set('newnm',nm)
        REQUEST.set('newid',temp)
        REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid=%s&newnm=%s' % (temp,nm))
  

# changes are made on 9-12-2002 harsh

    def Intermed(self,REQUEST,RESPONSE,URL1,URL2):
        """Edits the object requested """

        #temp=REQUEST['BaseNameA']
	#self.manage_changeProperties(REQUEST)

	#dest = dispatcher.Destination()
	#ur=dest.absolute_url()

	lobj=[]
	temp11=repr(REQUEST['LObjects'])
	temp12=string.replace(temp11,"*","")
	temp13=string.replace(temp12,"['","")
	temp14=string.replace(temp13,"']","") 
	lobj.append(temp14)

	robj=[]
	temp21=repr(REQUEST['RObjects'])
	temp22=string.replace(temp21,"*","")
	temp23=string.replace(temp22,"['","")
	temp24=string.replace(temp23,"']","")
	robj.append(temp24)

	asstype = REQUEST['AssType']
	basename = temp14 +'_'+ asstype+'_'+ temp24
	id = string.strip(basename)    
	
	#tmpPath = self.Path
	#oldid = self.id
	#string.replace(tmpPath,oldid,id)
	#Path=ur+'/Data/Associations/'+id
	#Path = tmpPath

	#self._updateProperty('id',id)
	self._updateProperty('LObjects',lobj)
	self._updateProperty('AssociationType',asstype)
	self._updateProperty('RObjects',robj)
	self._updateProperty('BaseNameA',basename)
	#self._updateProperty('Path',Path)

	self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Association'])
	nm="Association"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',basename)
	ur=self.absolute_url()

	REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (basename,nm))


  
    def strconv(self,temp):
       """Converts tokens to strings """
       a=string.join(temp)
       return a

#
# Factory methods
#

manage_addnewAssocForm = DTMLFile('dtml/addnewassocform', globals())

# id parameter is removed on 3-12-02

def manage_addnewAssoc(dispatcher,REQUEST=None):
    """
    Add New Association object
    """
    dest = dispatcher.Destination()
    ur=dest.absolute_url()

    lobj=[]
    temp11=repr(REQUEST['LObjects'])
    temp12=string.replace(temp11,"*","")
    temp13=string.replace(temp12,"['","")
    temp14=string.replace(temp13,"']","") 
    lobj.append(temp14)

    robj=[]
    temp21=repr(REQUEST['RObjects'])
    temp22=string.replace(temp21,"*","")
    temp23=string.replace(temp22,"['","")
    temp24=string.replace(temp23,"']","")
    robj.append(temp24)

    at=[]
    temp31=repr(REQUEST['AssType'])
    temp32=string.replace(temp31,"['","")
    temp33=string.replace(temp32,"']","")
    at.append(temp33)

    asstype = REQUEST['AssType']    
    basename = temp14 +'_'+temp33+'_'+ temp24
    id = string.strip(basename)    
    Path=ur+'/Data/Associations/'+id

#basename = REQUEST['LObjects'] + asstype + REQUEST['RObjects']
# commented by harsh on 2-12
#    dest.Data.Associations._setObject(id,Assoc(id,lobj,REQUEST['AssociationTyp# e'],robj,REQUEST['BaseNameA'],Path))

    dest.Data.Associations._setObject(id,Assoc(id,lobj,at,robj,basename,Path))

    dest.Data.Associations[id].reindex_object()

    # temp=REQUEST['BaseNameA']

    temp = basename
    nm="Association"

    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)

    if REQUEST is not None:
	try: url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+'/replyadd?newid=%s&newnm=%s' % (temp,nm))

InitializeClass(Assoc)






