#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

import umath

def equal(x,y):
	 "equal(x,y) is array of 1's where x == y, 0 otherwise."

def arccosh(x):
	"arccosh(x) returns array of elementwise inverse hyperbolic cosines."

def less_equal(x,y):
	"less_equal(x,y) is array of 1's where x <= y, 0 otherwise." 

def arccos(x):
	"arccos(x) returns array of elementwise inverse cosines."

def exp(x):
	"exp(x) returns array of elementwise e**x."

def logical_or(x,y):
	"logical_or(x,y) returns array of 1's where x or y or both are true."

def maximum(x,y):
	"maximum(x,y) returns maximum of x and y taken elementwise."

def left_shift(n,m):
	"left_shift(n, m) is n << m elementwise."

def true_divide(x,y):
	'True divide the arguments elementwise.'

def tanh(x):
	'tanh(x) returns array of elementwise hyperbolic tangents.'

def greater_equal(x,y):
	"greater_equal(x,y) is array of 1's where x>=y, 0 otherwise."

def logical_not(x):
	"logical_not(x) returns array of 1's where x is false, 0 otherwise."

def not_equal(x,y):	
	"not_equal(x,y) is array of 0's where x == y, 1 otherwise."

def cos(x):
	'cos(x) returns array of elementwise cosines.'

def divide(x,y):
	'Divide the arguments elementwise.'

def subtract(x,y):
	'Subtract the arguments elementwise.'

def multiply(x,y):
	'Multiply the arguments elementwise.'

def sinh(x):
	"sinh(x) returns array of elementwise hyperbolic sines."

def remainder(x,y):
	"returns remainder of division elementwise"

def arctanh(x):
	'arctanh(x) returns array of elementwise inverse hyperbolic tangents.'

def hypot(x,y):
	"hypot(x,y) = sqrt(x**2 + y**2), elementwise."

def ceil(x):
	'ceil(x) returns array of elementwise least whole number >= x.'	

def logical_and(x,y):
	"logical_and(x,y) returns array of 1's where x and y both true."

def arcsin(x):
	'arcsin(x) returns array of elementwise inverse sines.'

def power(x,y):
	'power(x,y) = x**y elementwise.'

def greater(x,y):
	"greater(x,y) is array of 1's where x > y, 0 otherwise."

def divide_safe(x,y):
	'Divide elementwise, ZeroDivision exception thrown if necessary.'

def log10(x):
	'log10(x) returns array of elementwise base-10 logarithms.'

def floor_divide(x,y):
	'Floor divide the arguments elementwise.'

def right_shift(n,m):
	'right_shift(n, m) is n >> m elementwise.'

def sin(x):
	'sin(x) returns array of elementwise sines.'

def add(x,y):
	'Add the arguments elementwise.'

def arctan(x):
	'arctan(x) returns array of elementwise inverse tangents.'

def sqrt(x):
	'sqrt(x) returns array of elementwise square roots.'

def negative(x):
	'negative(x) == -x elementwise.'

def invert(n): 
	'invert(n) returns array of bit inversion elementwise.'

def floor(x): 
	"floor(x) returns array of elementwise least whole number <= x."

def fabs(x): 
	'fabs(x) returns array of elementwise absolute values, 32 bit if x is.'

def log(x):
	'log(x) returns array of elementwise natural logarithms.'

def logical_xor(x,y):
	"logical_xor(x,y) returns array of 1's where exactly one of x or y is true."

def absolute(x):
	'returns absolute value of each element'

def tan(x):
	"tan(x) returns array of elementwise tangents."

def conjugate(x):
	'returns conjugate of each element'

def bitwise_and(x,y): 
	'bitwise_and(x,y) returns array of bitwise-and of respective elements.'

def minimum(x,y):
	'minimum(x,y) returns minimum of x and y taken elementwise.'

def bitwise_or(x,y):
	'bitwise_or(x,y) returns array of bitwise-or of respective elements.'

def cosh(x):
	'cosh(x) returns array of elementwise hyberbolic cosines.'

def arctan2(x,y): 
	'arctan2(x,y) is a safe and correct tan(x/y).'

def bitwise_xor(x,y): 
	'bitwise_xor(x,y) returns array of bitwise exclusive or of respective elements.'

def less(x,y):
	"less(x,y) is array of 1's where x < y, 0 otherwise."

def fmod(x,y):
	'fmod(x,y) is remainder(x,y)'

def arcsinh(x):
	'arcsinh(x) returns array of elementwise inverse hyperbolic sines.'
